/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;

public class FormulaEditHelper {
    private static final String[] Operaters = new String[]{"+", "-", "*", "/", "!=", "<>", "<=", ">=", "=", "<", ">"};
    private static final String CURSOR_INDEX = "cursorIndex";
    private static final String CTRL_KEY = "ctrlKey";
    private static final String SET_TEXTAREA_CURSOR_POSITION = "setTextareaCursorPosition";

    public static void insertExpression(IFormView view, String buttonKey, String textFieldKey, String str) {
        int pos = FormulaEditHelper.getCursorIndex(view, buttonKey, textFieldKey);
        String expression = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = pos;
        if (StringUtils.isBlank((CharSequence)expression)) {
            expression = str;
            cursorIndex = expression.length();
        } else {
            String insertStr = " " + str + " ";
            expression = FormulaEditHelper.insertCharacter(expression, insertStr, pos);
            cursorIndex = pos + insertStr.length();
        }
        view.getModel().setValue(textFieldKey, (Object)expression);
        HashMap<String, Object> cursorMap = new HashMap<String, Object>();
        cursorMap.put(CURSOR_INDEX, cursorIndex);
        cursorMap.put(CTRL_KEY, textFieldKey);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction(SET_TEXTAREA_CURSOR_POSITION, cursorMap);
    }

    public static void backSpaceExpression(IFormView view, String buttonKey, String textFieldKey) {
        String expression = (String)view.getModel().getValue(textFieldKey);
        if (StringUtils.isBlank((CharSequence)expression)) {
            return;
        }
        int cursorIndex = FormulaEditHelper.getCursorIndex(view, buttonKey, textFieldKey);
        String part1 = expression.substring(0, cursorIndex);
        String part2 = expression.substring(cursorIndex);
        String partDel = part1;
        for (String str : Operaters) {
            int lastIndex = partDel.lastIndexOf(str);
            if (lastIndex <= 0 || !"".equals((partDel = partDel.substring(lastIndex + str.length())).trim())) continue;
            partDel = str;
            break;
        }
        String[] fieldList = partDel.split(" ");
        for (int i = fieldList.length - 1; i >= 0; --i) {
            if ("".equals(fieldList[i].trim())) continue;
            partDel = fieldList[i];
            break;
        }
        expression = part1.substring(0, part1.lastIndexOf(partDel)) + part2;
        cursorIndex = part1.substring(0, part1.lastIndexOf(partDel)).length();
        view.getModel().setValue(textFieldKey, (Object)expression);
        HashMap<String, Object> cursorMap = new HashMap<String, Object>();
        cursorMap.put(CURSOR_INDEX, cursorIndex);
        cursorMap.put(CTRL_KEY, textFieldKey);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction(SET_TEXTAREA_CURSOR_POSITION, cursorMap);
    }

    public static String insertCharacter(String pStr, String str, int pos) {
        int i;
        if (pStr.length() < pos) {
            pos = pStr.length();
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < pos; ++i) {
            sb.append(pStr.charAt(i));
        }
        sb.append(str);
        for (i = pos; i < pStr.length(); ++i) {
            sb.append(pStr.charAt(i));
        }
        return sb.toString();
    }

    public static int getCursorIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = StringUtils.isBlank((CharSequence)textValue) ? 0 : textValue.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(buttonKey);
        if (listPostData instanceof Map) {
            Map map = (Map)listPostData;
            if (map.get("focus") != null) {
                Map focus = (Map)map.get("focus");
                if (focus.get(textFieldKey) != null) {
                    cursorIndex = (Integer)focus.get(textFieldKey);
                }
            } else if (map.get(textFieldKey) != null) {
                cursorIndex = (Integer)map.get(textFieldKey);
            }
        }
        return cursorIndex;
    }

    public static void setCursorIndex(IFormView view, String textFieldKey, int focusIndex) {
        HashMap<String, Object> cursorMap = new HashMap<String, Object>();
        cursorMap.put(CTRL_KEY, textFieldKey);
        cursorMap.put(CURSOR_INDEX, focusIndex);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction(SET_TEXTAREA_CURSOR_POSITION, cursorMap);
    }
}

