/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PrintInteFormatPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String INTE_NUMBER = "number";
    private static final String INTE_NAME = "name";
    private static final String INTE_ID = "id";
    private static final String INTE_ENTRY = "inteformatentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        int selIndex = this.getModel().getEntryCurrentRowIndex(INTE_ENTRY);
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        HashMap<String, Object> value = new HashMap<String, Object>();
        Object id = this.getModel().getValue(INTE_ID, selIndex);
        Object name = this.getModel().getValue(INTE_NAME, selIndex);
        value.put(INTE_ID, id);
        value.put(INTE_NAME, name);
        String valueInfo = SerializationUtils.toJsonString(value);
        para.put("value", valueInfo);
        para.put("alias", name);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<Object, DynamicObject> inteFormats = this.getInteFormats();
        for (DynamicObject inteFormat : inteFormats.values()) {
            int i = this.getModel().createNewEntryRow(INTE_ENTRY);
            this.getModel().setValue(INTE_ID, inteFormat.get(INTE_ID), i);
            this.getModel().setValue(INTE_NUMBER, inteFormat.get(INTE_NUMBER), i);
            this.getModel().setValue(INTE_NAME, inteFormat.get(INTE_NAME), i);
        }
    }

    private Map<Object, DynamicObject> getInteFormats() {
        return BusinessDataServiceHelper.loadFromCache((String)"inte_programme", (String)"id,number,name", null);
    }
}

