/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.page.plugin;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;

public class BizPageCopyPrintTemplate
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(BizPageCopyPrintTemplate.class);
    private static final String KEY_PRINTTPL = "bizentity";
    private static final String ISV_KINGDEE = "kingdee";
    private static final String KEY_NUMBER = "number";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void initialize() {
        this.addClickListeners(new String[]{"btncancel", "btnok"});
        BasedataEdit bsdPrintTpl = (BasedataEdit)this.getView().getControl(KEY_PRINTTPL);
        if (bsdPrintTpl != null) {
            bsdPrintTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map configinfo = this.getView().getFormShowParameter().getCustomParams();
        if (configinfo != null) {
            String bizentity = (String)configinfo.get(KEY_PRINTTPL);
            String number = (String)configinfo.get(KEY_NUMBER);
            if (!StringUtils.isEmpty((CharSequence)bizentity)) {
                number = this.createNewNumber(number);
            }
            this.getModel().setValue(KEY_PRINTTPL, (Object)bizentity);
            this.getModel().setValue(KEY_NUMBER, (Object)number);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                this.finish();
                break;
            }
        }
    }

    private void finish() {
        Map<String, Object> result;
        boolean isSuccess;
        String isvName = ISVService.getISVInfo().getName();
        if (isvName == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_11", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        ILocaleString objName = (ILocaleString)this.getModel().getValue("name");
        LocaleString name = new LocaleString();
        if (objName != null) {
            name = LocaleString.fromMap((Map)objName);
        }
        String number = (String)this.getModel().getValue(KEY_NUMBER);
        DynamicObject printEntity = (DynamicObject)this.getModel().getValue(KEY_PRINTTPL);
        if (printEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PrintCopyTpl_1", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        String errorMsg = this.validateNameAndNumber(number, (ILocaleString)name);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return;
        }
        Map configinfo = this.getView().getFormShowParameter().getCustomParams();
        String bizUnitId = (String)configinfo.get("bizunitid");
        String bizAppId = (String)configinfo.get("bizappid");
        String isv = ISVService.getISVInfo().getId();
        if (!(ISV_KINGDEE.equalsIgnoreCase(isv) || BizAppServiceHelp.getAppIsvByAppId((String)bizAppId).equals(isv) || this.isExtendedAPP(bizAppId, "bos_devportal_bizapp"))) {
            String extappid = this.sourceHasExtendedAPP(bizAppId, "bos_devportal_bizapp");
            if (StringUtils.isEmpty((CharSequence)extappid)) {
                Map extAppInfo = BizAppServiceHelp.createExtAppMetadata((String)bizAppId, (String)"");
                if (extAppInfo != null) {
                    bizAppId = (String)extAppInfo.get("extappid");
                }
            } else {
                bizAppId = extappid;
            }
        }
        if (!(isSuccess = ((Boolean)(result = PrintServiceHelper.copyPrintMetadata(printEntity.getPkValue().toString(), bizAppId, bizUnitId, number, name)).get("success")).booleanValue())) {
            this.getView().showTipNotification(result.get("message").toString());
        } else {
            try {
                OpLogAppInfo appLogInfo = new OpLogAppInfo();
                appLogInfo.setUserID(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
                appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
                appLogInfo.setClientIP(RequestContext.get().getLoginIP());
                appLogInfo.setOpTime(new Date());
                DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter(KEY_NUMBER, "=", (Object)this.getView().getFormShowParameter().getAppId())});
                appLogInfo.setBizAppID(String.valueOf(bizApp.getPkValue()));
                DynamicObject bizObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter(KEY_NUMBER, "=", (Object)"bas_manageprinttpl")});
                appLogInfo.setBizObjID(String.valueOf(bizObj.getPkValue()));
                appLogInfo.setClientType(RequestContext.get().getClient());
                appLogInfo.setOpName("donothing_copy", ResManager.loadKDString((String)"\u590d\u5236", (String)"BizPageCopyPrintTemplate_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                appLogInfo.setKeyWord(number);
                appLogInfo.setOpDescription(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u590d\u5236\u6210\u529f", (String)"BizPageCopyPrintTemplate_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), number));
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            }
            catch (Exception e) {
                log.warn("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff1a", (Throwable)e);
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }

    private String validateNameAndNumber(String number, ILocaleString name) {
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        StringBuilder buffer = new StringBuilder();
        String regex = "[a-z0-9_]+";
        if (StringUtils.isBlank((CharSequence)number)) {
            buffer.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002\r\n", (String)"BizPageCopyPrintTemplate_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (number.endsWith("_devportal")) {
            buffer.append(ResManager.loadKDString((String)"\u4e3a\u4e86\u533a\u5206svn\u811a\u672c\u6587\u4ef6\u547d\u540d\uff0c\u7f16\u7801\u4e0d\u80fd\u4ee5\"_devportal\u7ed3\u5c3e\u3002\"\r\n", (String)"BizPageCopyPrintTemplate_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (!Pattern.matches(regex, number)) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002\r\n", (String)"BizPageCopyPrintTemplate_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (number.startsWith("_") || number.endsWith("_")) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002\r\n", (String)"BizPageCopyPrintTemplate_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (number.length() > 36) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc736\u4e2a\u5b57\u7b26\u3002\r\n", (String)"PrintCopyTpl_2", (String)"bos-noteprint", (Object[])new Object[0]));
        } else if (metaDataUtil.checkNumber(number)) {
            buffer.append(ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002\r\n", (String)"BizPageCopyPrintTemplate_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)name)) {
            buffer.append(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002\r\n", (String)"BizPageCopyPrintTemplate_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (metaDataUtil.checkName(name.getLocaleValue())) {
            buffer.append(ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002\r\n", (String)"BizPageCopyPrintTemplate_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        return buffer.toString();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        String number = null;
        if (KEY_PRINTTPL.equals(property)) {
            DynamicObject bizentity = (DynamicObject)this.getModel().getValue(KEY_PRINTTPL);
            if (!ObjectUtils.isEmpty((Object)bizentity)) {
                number = (String)bizentity.get(KEY_NUMBER);
                number = this.createNewNumber(number);
            }
            this.getModel().setValue(KEY_NUMBER, (Object)number);
        }
    }

    public String createNewNumber(String number) {
        String accountIsv = ISVService.getISVInfo().getId();
        if (ISV_KINGDEE.equals(accountIsv)) {
            if (number.endsWith("_prt")) {
                number = number + "_s";
            } else if (!number.endsWith("_s")) {
                number = number + "_prt_s";
            }
        } else if (!number.endsWith("_prt")) {
            number = number + "_prt";
        } else if (number.endsWith("_s")) {
            number = number.substring(0, number.length() - 2);
        }
        return number;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        FormShowParameter showParameter = arg0.getFormShowParameter();
        if (showParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            QFilter f = new QFilter("modeltype", "=", (Object)"printmodel");
            listShowParameter.getListFilterParameter().setFilter(f);
        }
    }

    private QFilter[] sourceBeloneToIsv(String sourceId) {
        String currentIsv = ISVService.getISVInfo().getId();
        QFilter q = new QFilter("parentid", "=", (Object)sourceId);
        q.and(new QFilter("type", "=", (Object)"2"));
        QFilter qIsv = new QFilter("isv", "=", (Object)currentIsv);
        if (ISV_KINGDEE.equalsIgnoreCase(currentIsv)) {
            QFilter qIsvNull = new QFilter("isv", "is null", (Object)Boolean.TRUE);
            qIsvNull = qIsvNull.or(new QFilter("isv", "=", (Object)" "));
            qIsv = qIsv.or(qIsvNull);
        }
        QFilter[] filters = new QFilter[]{q, qIsv};
        return filters;
    }

    private String sourceHasExtendedAPP(String sourceId, String entityname) {
        String extappid = null;
        QFilter[] filters = this.sourceBeloneToIsv(sourceId);
        DynamicObject extAppInfo = QueryServiceHelper.queryOne((String)entityname, (String)"id", (QFilter[])filters);
        if (extAppInfo != null) {
            extappid = (String)extAppInfo.get("id");
        }
        return extappid;
    }

    private boolean isExtendedAPP(String sourceId, String entityname) {
        boolean isExtapp = false;
        String currentIsv = ISVService.getISVInfo().getId();
        QFilter qId = new QFilter("id", "=", (Object)sourceId);
        QFilter q = new QFilter("type", "=", (Object)"2");
        QFilter qIsv = new QFilter("isv", "=", (Object)currentIsv);
        if (ISV_KINGDEE.equalsIgnoreCase(currentIsv)) {
            QFilter qIsvNull = new QFilter("isv", "is null", (Object)Boolean.TRUE);
            qIsvNull = qIsvNull.or(new QFilter("isv", "=", (Object)" "));
            qIsv = qIsv.or(qIsvNull);
        }
        QFilter[] filters = new QFilter[]{q, qIsv, qId};
        isExtapp = QueryServiceHelper.exists((String)entityname, (QFilter[])filters);
        return isExtapp;
    }
}

