/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.page.plugin;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import org.apache.commons.beanutils.MethodUtils;

public class BizPageNewPrintTemplate
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    public static final String BTN_LAST = "btnlast";
    public static final String BTN_OK = "btnok";
    public static final String BIZ_ENTITY = "bizentity";
    public static final String BIZ_APPID = "bizappid";
    public static final String BIZ_UNITID = "bizunitid";
    public static final String NAME = "name";
    public static final String NUMBER = "number";
    public static final String ISV_KINGDEE = "kingdee";
    private static final String MODELTYPE = "modeltype";
    private static final Log log = LogFactory.getLog(BizPageNewPrintTemplate.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_LAST, BTN_OK});
        BasedataEdit bsdPrintTpl = (BasedataEdit)this.getView().getControl(BIZ_ENTITY);
        bsdPrintTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String bizAppId = configInfo.get(BIZ_APPID).toString();
        ILocaleString name = (ILocaleString)configInfo.get(NAME);
        String number = (String)configInfo.get(NUMBER);
        String bizentity = (String)configInfo.get(BIZ_ENTITY);
        String modelType = (String)configInfo.get(MODELTYPE);
        Object isPrintTemplate = configInfo.get("isprinttemplate");
        if ("PrintModel".equals(modelType)) {
            number = bizentity;
            if (!StringUtils.isEmpty((CharSequence)bizentity)) {
                number = this.CreateNewNumber(number);
            }
        }
        this.getModel().setValue(NAME, (Object)name);
        this.getModel().setValue(NUMBER, (Object)number);
        this.getModel().setValue(BIZ_ENTITY, (Object)bizentity);
        if (!ObjectUtils.isEmpty(isPrintTemplate)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_LAST});
        } else if (!this.checkResourceBelongsToCurDeveloper(bizAppId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK});
        }
    }

    public String CreateNewNumber(String number) {
        String accountIsv = ISVService.getISVInfo().getId();
        if (ISV_KINGDEE.equalsIgnoreCase(accountIsv)) {
            if (number.endsWith("_prt")) {
                return number + "_s";
            }
            if (number.endsWith("_s")) {
                return number;
            }
            return number + "_prt_s";
        }
        if (number.endsWith("_prt")) {
            return number;
        }
        if (number.endsWith("_s")) {
            return number.substring(0, number.length() - 2);
        }
        return number + "_prt";
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (key.equals(BTN_OK)) {
            this.finish();
        }
    }

    private void finish() {
        DynamicObject layoutEntity;
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainPlugin_8", (String)"bos-designer-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        ILocaleString name = (ILocaleString)this.getModel().getValue(NAME);
        String number = (String)this.getModel().getValue(NUMBER);
        String modelType = (String)configInfo.get(MODELTYPE);
        boolean isPrintTemplate = false;
        if (StringUtils.isNotBlank((CharSequence)modelType) && "PrintModel".equalsIgnoreCase(modelType)) {
            isPrintTemplate = true;
        }
        if ((layoutEntity = (DynamicObject)this.getModel().getValue(BIZ_ENTITY)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u5b9e\u4f53\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BizPageNewPrintTemplate_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        String layoutEntityId = (String)layoutEntity.get("dentityid");
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)layoutEntityId, (MetaCategory)MetaCategory.Form);
        String bizAppId = formMeta.getBizappId();
        String bizUnitId = this.getUnitId(layoutEntityId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entityId", layoutEntityId);
        map.put("id", number);
        map.put(NAME, name);
        map.put(BIZ_APPID, bizAppId);
        map.put(BIZ_UNITID, bizUnitId);
        map.put("isprint", Boolean.TRUE);
        map.put("modelType", modelType);
        Map<String, Object> message = this.buildNewPage(map, bizAppId, bizUnitId, this.getView(), isPrintTemplate);
        if (StringUtils.isNotBlank((Object)message.get("success")) && ((Boolean)message.get("success")).booleanValue()) {
            try {
                OpLogAppInfo appLogInfo = new OpLogAppInfo();
                appLogInfo.setUserID(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
                appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
                appLogInfo.setClientIP(RequestContext.get().getLoginIP());
                appLogInfo.setOpTime(new Date());
                DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)this.getView().getFormShowParameter().getAppId())});
                appLogInfo.setBizAppID(String.valueOf(bizApp.getPkValue()));
                DynamicObject bizObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)"bas_manageprinttpl")});
                appLogInfo.setBizObjID(String.valueOf(bizObj.getPkValue()));
                appLogInfo.setClientType(RequestContext.get().getClient());
                appLogInfo.setOpName("new", ResManager.loadKDString((String)"\u65b0\u589e", (String)"BizPageNewPrintTemplate_1", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                appLogInfo.setKeyWord(number);
                appLogInfo.setOpDescription(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u65b0\u589e\u6210\u529f", (String)"BizPageNewPrintTemplate_2", (String)"bos-devportal-plugin", (Object[])new Object[0]), number));
                appLogInfo.setStatus("1");
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((Object)message.get("isvcheckresult"))) {
            this.getView().returnDataToParent(message);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        String number = null;
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String modelType = (String)configInfo.get(MODELTYPE);
        if (BIZ_ENTITY.equals(property)) {
            if ("PrintModel".equals(modelType)) {
                DynamicObject bizentity = (DynamicObject)this.getModel().getValue(BIZ_ENTITY);
                if (bizentity == null) {
                    return;
                }
                number = (String)bizentity.get(NUMBER);
                if (!ObjectUtils.isEmpty((Object)bizentity)) {
                    number = this.CreateNewNumber(number);
                }
            }
            this.getModel().setValue(NUMBER, number);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        FormShowParameter showParameter = arg0.getFormShowParameter();
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String currentNodeId = (String)configInfo.get("currentNodeId");
        if (showParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            listShowParameter.setCustomParam("currentNodeId", (Object)currentNodeId);
            String curNodeId = currentNodeId.replace("app_", "");
            curNodeId = curNodeId.replace("cloud_", "");
            listShowParameter.setCustomParam("treeRootNodeId", (Object)curNodeId);
        }
    }

    private String getUnitId(String fromId) {
        QFilter qFormId = new QFilter("form", "=", (Object)fromId);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
        if (StringUtils.isBlank((Object)pageRelInfo)) {
            return "";
        }
        String unitId = pageRelInfo.getString("bizunit");
        return unitId;
    }

    private Map<String, Object> buildNewPage(Map<String, Object> map, String bizAppId, String bizUnitId, IFormView view, boolean isPrintTemplate) {
        String className = "kd.bos.devportal.util.DevportalUtil";
        try {
            Class factory = TypesContainer.getOrRegister((String)className);
            Object[] params = new Object[]{map, bizAppId, bizUnitId, view, isPrintTemplate};
            return (Map)MethodUtils.invokeStaticMethod((Class)factory, (String)"buildNewPage", (Object[])params);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Collections.emptyMap();
        }
    }

    private boolean checkResourceBelongsToCurDeveloper(String bizAppId) {
        return StringUtils.isBlank((CharSequence)bizAppId) ? false : this.getIsvByAppId(bizAppId).equals(BizPageNewPrintTemplate.getDeveloperInfo());
    }

    private String getIsvByAppId(String bizAppId) {
        return AppMetaServiceHelper.getIsvByAppId((String)bizAppId);
    }

    private static String getDeveloperInfo() {
        return ISVService.getISVInfo().getId();
    }
}

