/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.printop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.condition.PrintConditionUtils;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.operate.OpFieldValueReader;
import kd.bos.form.operate.printop.Print;
import kd.bos.form.operate.printop.PrintPreview;
import kd.bos.form.operate.printop.PrintTypes;
import kd.bos.form.operate.printop.XlsPrint;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.facade.IPrintServiceFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.print.api.facade.param.PrintLogParam;
import kd.bos.print.api.facade.param.ShowMsg;
import kd.bos.print.api.facade.param.ShowMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.print.matchtpl.TplMatcherParam;
import kd.bos.print.matchtpl.TplMatcherResult;
import kd.bos.print.matchtpl.TplMatcherUtil;
import kd.bos.report.IReportView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.template.orgctrl.utils.ParamUtils;

public abstract class AbstractPrint
extends DefaultDynamicFormOperate {
    private static final Log log = LogFactory.getLog(AbstractPrint.class);
    private static final String AUDIT = "C";
    private static final String FORMID_PRINTLOG = "bos_print_logs";
    private static final String FORMID_BILLTYPE = "bos_billtype";
    private static final String CFG_SUFFIX = "_printsetting";
    protected Map<Long, DynamicObject> billTypeObjCache = new HashMap<Long, DynamicObject>();
    protected Map<Object, Long> billidToBillTypeId = new HashMap<Object, Long>();
    protected StringBuilder errorMsg = new StringBuilder();
    protected PrintTypes printTypes;
    protected Object dPrinter;
    protected boolean showSelectPrintForm = false;
    protected boolean turnOffPaging = false;
    protected boolean removeMargin = false;
    private List<Object> otherIds = new ArrayList<Object>();
    Map<String, Set<String>> billTypeErrMsgMap = new HashMap<String, Set<String>>(10);
    private Map<String, String> hasPermTemplateMap = new HashMap<String, String>(16);
    protected static final String PRINTERID = "printerid";
    private static final String TEMPLATEID = "templateid";
    private static final String BOS_NOTEPRINT = "bos-noteprint";
    private static final String TEMPLATE = "template";
    private static final String ENABLE = "enable";
    private static final String PRINTTPLIDID = "printtplid.id";
    private static final String BAS_MANAGEPRINTTPL = "bos_manageprinttpl";
    protected Object dTemplateId;
    private Map<String, Object> myPrintSetting = new HashMap<String, Object>(16);
    private List<PrintJob> printJobs;
    Set<String> unEnableBillType = new HashSet<String>(10);

    protected OperationResult invokeOperation() {
        return super.invokeOperation();
    }

    protected void afterOperationClose(OperationResult opResult) {
        super.afterOperationClose(opResult);
    }

    public List<Object> getOtherId() {
        return this.otherIds;
    }

    public void setOtherId(List<Object> otherIds) {
        this.otherIds = otherIds;
    }

    public void initialize(Map<String, Object> opMeta) {
        this.getParameter().put("logenable_logEnable", String.valueOf(opMeta.get("logEnable")));
        opMeta.put("logEnable", false);
        super.initialize(opMeta);
        Map parameters = (Map)opMeta.get("parameter");
        if (parameters != null) {
            if (parameters.containsKey("showSelectPrintForm")) {
                this.showSelectPrintForm = (Boolean)parameters.get("showSelectPrintForm");
            }
            if (parameters.containsKey("turnoffpaging")) {
                this.turnOffPaging = (Boolean)parameters.get("turnoffpaging");
            }
            if (parameters.containsKey("removemargin")) {
                this.removeMargin = (Boolean)parameters.get("removemargin");
            }
        }
    }

    protected Map<String, Object> getExtParamMap() {
        Object extParam;
        HashMap<String, Object> extParamMap = new HashMap<String, Object>(16);
        extParamMap.put("turnoffpaging", this.turnOffPaging);
        extParamMap.put("removemargin", this.removeMargin);
        if (this.getOption().containsVariable("calculateTotalPage")) {
            extParamMap.put("calculateTotalPage", Boolean.parseBoolean(this.getOption().getVariableValue("calculateTotalPage")));
        }
        if ((extParam = this.getParameter().get("extParam")) instanceof Map && !((Map)extParam).isEmpty()) {
            extParamMap = (Map)extParam;
        }
        Map<String, Object> extParamFromOption = this.getExtParamFromOption();
        extParamMap.putAll(extParamFromOption);
        return extParamMap;
    }

    protected Map<String, Object> getExtParamFromOption() {
        HashMap<String, Object> extParam = new HashMap<String, Object>(0);
        OperateOption option = this.getOption();
        if (option == null) {
            return extParam;
        }
        boolean containsVariable = option.containsVariable("extParam");
        if (!containsVariable) {
            return extParam;
        }
        String param = option.getVariableValue("extParam");
        if (StringUtils.isBlank((CharSequence)param)) {
            return extParam;
        }
        return (Map)SerializationUtils.fromJsonString((String)param, Map.class);
    }

    protected Object getDefaultPrinter() {
        Map<String, Object> printSetting = this.getPrintSetting();
        if (!printSetting.isEmpty()) {
            this.dPrinter = printSetting.get(PRINTERID);
        }
        return this.dPrinter;
    }

    protected Object getDefaultTemplateId() {
        DynamicObject preferenceScheme;
        Map<String, Object> printSetting = this.getPrintSetting();
        if (!printSetting.isEmpty()) {
            this.dTemplateId = printSetting.get(TEMPLATEID);
        }
        if (ObjectUtils.isEmpty((Object)this.dTemplateId) && (preferenceScheme = this.getEnableScheme()) != null) {
            this.dTemplateId = preferenceScheme.get("defaulttemplate");
        }
        if (ObjectUtils.isEmpty((Object)this.dTemplateId)) {
            this.dTemplateId = this.getDefaulttplInManangeTool(this.getEntityTypeId());
        }
        return this.dTemplateId;
    }

    protected Map<String, Object> getPrintSetting() {
        if (this.myPrintSetting.isEmpty()) {
            String configKey = TplMatcherUtil.getEntityTypeId(this.getView()) + CFG_SUFFIX;
            String userId = RequestContext.get().getUserId();
            String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)configKey);
            if (StringUtils.isNotBlank((CharSequence)settingData)) {
                this.myPrintSetting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
            }
        }
        return this.myPrintSetting;
    }

    protected List<PrintJob> getPrintJobs() {
        return this.printJobs;
    }

    private void showSelectPrintFormMethod(List<Object> unMatchBillIds, Set<String> matchFilterTemplateId, List<String> invisibleFilterTemplateId) {
        this.showSelectPrintFormMethod(false, unMatchBillIds, matchFilterTemplateId, invisibleFilterTemplateId);
    }

    private void showSelectPrintFormMethod(boolean isShowPrintType, List<Object> unMatchBillIds, Set<String> matchFilterTemplateId, List<String> invisibleFilterTemplateId) {
        PrintLogParam logParam;
        String entityId = this.getEntityTypeId();
        List<Object> pkids = this.getPKIds();
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bos_selecttemplate");
        param.setCustomParam("formid", (Object)entityId);
        param.setCustomParam("sortPkids", pkids);
        param.setCustomParam("extParam", (Object)SerializationUtils.toJsonString(this.getExtParamMap()));
        if (this.getOption().containsVariable("showprogressrowcount")) {
            param.setCustomParam("showprogressrowcount", (Object)this.getOption().getVariableValue("showprogressrowcount"));
        }
        String caption = "";
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        param.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        FormConfig fc = formShowParameter.getFormConfig();
        if (fc != null && fc.getCaption() != null) {
            caption = fc.getCaption().getLocaleValue();
        }
        param.setCustomParam("jobname", (Object)caption);
        if (!unMatchBillIds.isEmpty()) {
            pkids = unMatchBillIds;
            this.setPrintJob(param);
            String text = "";
            text = this.getPKIds().size() == 1 ? ResManager.loadKDString((String)"\u7531\u4e8e\u6253\u5370\u6761\u4ef6\u672a\u5339\u914d\u6210\u529f\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u53ef\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"AbstractPrint_2", (String)BOS_NOTEPRINT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5370\u65f6\uff0c\u5b58\u5728\u4e0d\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u53ef\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"AbstractPrint_7", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
            param.setCustomParam("text", (Object)text);
        }
        param.setCustomParam("invisibleFilterTemplateId", (Object)SerializationUtils.toJsonString(invisibleFilterTemplateId));
        param.setCustomParam("pkids", pkids);
        AppLogInfo appLogInfo = this.getAppLogInfo();
        if (appLogInfo != null) {
            param.setCustomParam("appLogInfo", (Object)SerializationUtils.toJsonString((Object)appLogInfo));
        }
        if ((logParam = this.getPrintLogParam()) != null) {
            param.setCustomParam("printLogParam", (Object)SerializationUtils.toJsonString((Object)logParam));
        }
        if ("printexportexcel".equals(this.getType())) {
            param.setCustomParam("type", (Object)"printexportexcel");
        } else if ("print".equals(this.getType())) {
            param.setCustomParam("type", (Object)"print");
            param.setCustomParam("showSelectPrintForm", (Object)this.showSelectPrintForm);
        } else if (PrintWork.EXP_TYPE.EXP_CLIENTPREVIEW.getCode().equals(this.getType())) {
            param.setCustomParam("type", (Object)PrintWork.EXP_TYPE.EXP_CLIENTPREVIEW.getCode());
        } else {
            param.setCustomParam("type", (Object)"printpreview");
        }
        param.setCustomParam("isShowPrintType", (Object)isShowPrintType);
        if (isShowPrintType) {
            this.setPrintJob(param);
            String text = ResManager.loadKDString((String)"\u7531\u4e8e\u6253\u5370\u6761\u4ef6\u5339\u914d\u591a\u4e2a\u6a21\u677f\uff0c\u8bf7\u9009\u62e9\u6253\u5370\u65b9\u5f0f\u3002", (String)"AbstractPrint_38", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
            param.setCustomParam("text", (Object)text);
            param.setCustomParam("matchFilterTemplateId", (Object)SerializationUtils.toJsonString(matchFilterTemplateId));
        }
        this.getView().showForm(param);
    }

    private void setPrintJob(FormShowParameter param) {
        if (this.printJobs != null && !this.printJobs.isEmpty()) {
            List<PrintJob> newPrintJobs;
            Map<String, List<PrintJob>> classifyPrintJob = this.classifyPrintJob(this.printJobs);
            List<PrintJob> oldPrintJobs = classifyPrintJob.get("oldPrintJobs");
            if (!oldPrintJobs.isEmpty()) {
                param.setCustomParam("oldPrintJobs", (Object)SerializationUtils.toJsonString(oldPrintJobs));
            }
            if (!(newPrintJobs = classifyPrintJob.get("newPrintJobs")).isEmpty()) {
                param.setCustomParam("newPrintJobs", (Object)SerializationUtils.toJsonString(newPrintJobs));
            }
        }
    }

    protected Map<String, List<PrintJob>> classifySortPrintJob(List<PrintJob> printJobs) {
        printJobs = PrintOperationHelper.sortAndMergeJobs(this.getPKIds(), printJobs);
        return this.classifyPrintJob(printJobs);
    }

    protected Map<String, List<PrintJob>> classifyPrintJob(List<PrintJob> printJobs) {
        return PrintOperationHelper.classifyPrintJob(printJobs);
    }

    private void viewShowMsg(List<ShowMsg> showMsgList) {
        showMsgList.stream().collect(Collectors.groupingBy(ShowMsg::getType, Collectors.mapping(ShowMsg::getMsg, Collectors.joining("\n")))).forEach((type, msg) -> {
            if (ShowMsgEnum.SUCCESS == type) {
                this.getView().showSuccessNotification(msg);
            } else if (ShowMsgEnum.ERROR == type) {
                this.getView().showErrorNotification(msg);
            } else {
                this.getView().showTipNotification(msg);
            }
        });
    }

    private void resultMsgHandle(Map<String, Object> param) {
        List showMsgList;
        Object showMsg = param.get("showMsg");
        if (showMsg != null && (showMsgList = (List)showMsg).size() > 0) {
            this.viewShowMsg(showMsgList);
        }
    }

    protected boolean beforeInvokeOperation(OperationResult opResult) {
        boolean hasEmptyPrinter;
        String billParameterCondition;
        boolean isNoPrintData;
        boolean baseResult = super.beforeInvokeOperation(opResult);
        if (!baseResult) {
            return baseResult;
        }
        if (this instanceof PrintPreview) {
            ArrayList<ShowMsg> showMsgs = new ArrayList<ShowMsg>(8);
            for (IPrintServiceFacade facade : PrtFacadeFactory.getAllPrtServiceFacades()) {
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                param.put("pkIds", this.getPKIds());
                param.put("option", this.getOption());
                param.put("view", this.getView());
                param.put("parameter", this.getParameter());
                param.put("listSelectedData", this.getListSelectedData());
                param.put("entityTypeId", this.getEntityTypeId());
                param.put("entityId", this.getEntityId());
                param.put("operateKey", this.getOperateKey());
                param.put("showMsg", new ArrayList(8));
                if (!facade.beforeDoOperate(param)) {
                    log.info("IPrintServiceFacade \u6267\u884c\u5931\u8d25\uff0cclass={},param={}", facade.getClass(), param);
                    this.resultMsgHandle(param);
                    return false;
                }
                showMsgs.addAll((Collection)param.get("showMsg"));
            }
            this.viewShowMsg(showMsgs);
        }
        if (this.isDynamicForm() && !(this instanceof Print)) {
            return true;
        }
        TplMatcherUtil tplMatcherUtil = new TplMatcherUtil(new TplMatcherParam());
        TplMatcherParam param = tplMatcherUtil.getParam();
        param.setOption(this.getOption());
        tplMatcherUtil.resolveView(this.getView());
        if (this.showSelectPrintForm) {
            this.showSelectPrintFormMethod(new ArrayList<Object>(0), new HashSet<String>(0), new ArrayList<String>(0));
            return true;
        }
        List<Object> pkIds = param.getPkIds();
        if (pkIds.size() > 50000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5370\u6700\u5927\u652f\u63015\u4e07\u5f20\u5355\u636e\u3002", (String)"AbstractPrint_41", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return false;
        }
        boolean isPrintReport = this.isPrintReport();
        boolean bl = isNoPrintData = !isPrintReport && pkIds.size() == 0;
        if (isNoPrintData) {
            opResult.setSuccess(false);
            opResult.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u9700\u8981\u6253\u5370\u3002", (String)"AbstractPrint_8", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u9700\u8981\u6253\u5370\u3002", (String)"AbstractPrint_8", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return false;
        }
        boolean isConfirm = "MessageCallBackType".equals(this.getParameter().get("sourceName"));
        if (!isConfirm) {
            boolean isNeedCofirm;
            boolean bl2 = isNeedCofirm = !isPrintReport && this.printTypes == PrintTypes.Preview && pkIds.size() > 100;
            if (isNeedCofirm) {
                String confirmTip = ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5355\u636e\u5df2\u7ecf\u8d85\u8fc7100\u5f20\uff0c\u6253\u5370\u53ef\u80fd\u4f1a\u6709\u8f83\u957f\u65f6\u95f4\u7b49\u5f85\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AbstractPrint_9", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", (AbstractOperate)this);
                HashMap<String, String> operateOption = new HashMap<String, String>();
                operateOption.put("CallBackType", "NotForCondition");
                confirmCallBacks.setOperateOption(operateOption);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, this.getConfirmTypes(), confirmCallBacks);
                return false;
            }
        }
        String callBackType = "";
        if (this.getOption().getVariables().containsKey("CallBackType")) {
            callBackType = this.getOption().getVariableValue("CallBackType");
        }
        String entityId = this.getEntityTypeId();
        if (!isConfirm || "NotForCondition".equals(callBackType)) {
            DynamicObject obj = tplMatcherUtil.getContext().getBillParameter();
            String printcondition = null;
            String printconditionname = null;
            if (obj != null) {
                printcondition = obj.getString("printconditionvalue");
                printconditionname = obj.getString("printcondition");
            }
            if (StringUtils.isNotBlank(printcondition)) {
                List<Object> filterPKIds = tplMatcherUtil.filterByBillParameterCondition(printcondition);
                if (filterPKIds.isEmpty()) {
                    String errMsg = String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u7b26\u5408%s\u6253\u5370\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u6253\u5370\u3002", (String)"AbstractPrint_28", (String)BOS_NOTEPRINT, (Object[])new Object[0]), printconditionname);
                    opResult.setSuccess(false);
                    opResult.setMessage(errMsg);
                    this.getView().showTipNotification(errMsg);
                    return false;
                }
                if (pkIds.size() > filterPKIds.size()) {
                    String confirmTip = ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5370\u65f6\uff0c\u6240\u9009\u6570\u636e\u4e2d\u5b58\u5728\u90e8\u5206\u6570\u636e\u4e0d\u6ee1\u8db3\u6253\u5370\u6761\u4ef6\uff0c\u5c06\u53ea\u6253\u5370\u6ee1\u8db3\u6253\u5370\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u6253\u5370", (String)"AbstractPrint_29", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", (AbstractOperate)this);
                    HashMap<String, String> operateOption = new HashMap<String, String>();
                    operateOption.put("CallBackType", "ForCondition");
                    confirmCallBacks.setOperateOption(operateOption);
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, this.getConfirmTypes(), confirmCallBacks);
                    return false;
                }
                pkIds = filterPKIds;
            }
        }
        if ("ForCondition".equals(callBackType) && StringUtils.isNotBlank((CharSequence)(billParameterCondition = tplMatcherUtil.getBillParameterCondition()))) {
            pkIds = tplMatcherUtil.filterByBillParameterCondition(billParameterCondition);
        }
        if (this.getOption().containsVariable("showprogressrowcount")) {
            this.getView().getFormShowParameter().setCustomParam("showprogressrowcount", (Object)this.getOption().getVariableValue("showprogressrowcount"));
        }
        TplMatcherResult matcherResult = tplMatcherUtil.runTplMatcher();
        this.printJobs = matcherResult.getMatchPrintJob();
        int endMatchLevel = matcherResult.getEndMatchLevel();
        List<Object> unMatchBillIds = matcherResult.getUnMatchBillIds();
        if (1 == endMatchLevel) {
            String defaultPrinter = tplMatcherUtil.getContext().getDefaultPrinter();
            if ("print".equals(this.getType()) && (defaultPrinter == null || StringUtils.isBlank((CharSequence)defaultPrinter))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u673a\uff0c\u8bf7\u5728\u201c\u6253\u5370\u201d->\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AbstractPrint_6", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                return false;
            }
            List<String> unUseTempIds = matcherResult.getUnUseTempIds();
            IFormView view = this.getView();
            String printType = this.getType();
            view.getFormShowParameter().setCustomParam("extParam", (Object)SerializationUtils.toJsonString(this.getExtParamMap()));
            if (!CollectionUtils.isEmpty(unMatchBillIds)) {
                PrintConditionUtils.showSelectPrintNew(view, entityId, printType, this.printJobs, unMatchBillIds, unUseTempIds, new LinkedHashSet<String>(0), false, this.showSelectPrintForm, pkIds);
                return false;
            }
            if (!CollectionUtils.isEmpty(pkIds) && pkIds.size() == 1 && !CollectionUtils.isEmpty(this.printJobs) && this.printJobs.size() > 1) {
                LinkedHashSet<String> matchIds = new LinkedHashSet<String>(16);
                for (PrintJob job : this.printJobs) {
                    matchIds.add(String.valueOf(job.getTemplateId()));
                }
                PrintConditionUtils.showSelectPrintNew(view, entityId, printType, this.printJobs, unMatchBillIds, unUseTempIds, matchIds, true, this.showSelectPrintForm, pkIds);
                return false;
            }
            if (null != matcherResult.getErrorMsg() && matcherResult.getErrorMsg().length() > 0) {
                this.getView().showTipNotification(matcherResult.getErrorMsg().toString());
                return false;
            }
            return true;
        }
        if (!unMatchBillIds.isEmpty()) {
            this.showSelectPrintForm = true;
            this.showSelectPrintFormMethod(unMatchBillIds, matcherResult.getMatchFilterTemplateId(), matcherResult.getInvisibleFilterTemplateId());
            return false;
        }
        StringBuilder errorMsg = matcherResult.getErrorMsg();
        boolean hasEmptyTemplate = this.printJobs.stream().anyMatch(p -> StringUtils.isBlank((Object)p.getTemplateId()));
        if (errorMsg.length() == 0 && (hasEmptyTemplate || this.printJobs.isEmpty())) {
            if (this.existAnyTplInManageTool(this.getEntityTypeId())) {
                if (this.getView() instanceof IMobileView) {
                    errorMsg.append(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u901a\u8fc7\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u8bbe\u7f6e\u3002", (String)"AbstractPrint_3", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                } else {
                    errorMsg.append(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u5728\u201c\u6253\u5370\u201d->\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AbstractPrint_4", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                }
            } else {
                errorMsg.append(ResManager.loadKDString((String)"\u65e0\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u3010\u7ef4\u62a4\u6253\u5370\u6a21\u677f\u3011\u65b0\u589e\u6a21\u677f\u3002", (String)"AbstractPrint_43", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            }
        }
        if (errorMsg.length() == 0) {
            List tpls = this.printJobs.stream().map(pj -> pj.getTemplateId()).collect(Collectors.toList());
            HashSet hash = new HashSet(tpls);
            Iterator it = hash.iterator();
            while (it.hasNext()) {
                boolean isExist = this.isExistTplInManangeTool(it.next());
                if (isExist) continue;
                errorMsg.append(ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5728\u201c\u6253\u5370\u201d->\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u4e2d\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AbstractPrint_5", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                break;
            }
        }
        if (errorMsg.length() == 0 && this.printTypes == PrintTypes.Print && (hasEmptyPrinter = this.printJobs.stream().anyMatch(p -> StringUtils.isBlank((Object)p.getPrinterId())))) {
            errorMsg.append(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u673a\uff0c\u8bf7\u5728\u201c\u6253\u5370\u201d->\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AbstractPrint_6", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
        }
        if (errorMsg.length() > 0) {
            opResult.setSuccess(false);
            opResult.setMessage(errorMsg.toString());
            this.getView().showTipNotification(errorMsg.toString());
            return false;
        }
        if (pkIds.size() == 1 && (this instanceof Print || this instanceof PrintPreview || this instanceof XlsPrint) && matcherResult.getMatchFilterTemplateId().size() > 1) {
            this.showSelectPrintFormMethod(true, matcherResult.getUnMatchBillIds(), matcherResult.getMatchFilterTemplateId(), matcherResult.getInvisibleFilterTemplateId());
            return false;
        }
        if (!opResult.isSuccess()) {
            this.doFailCheckRight(opResult);
            opResult.setSuccess(false);
            this.getOperateLog().info("FormOperate.beforeInvokeOperation: no right return");
            return false;
        }
        return true;
    }

    private boolean isPrintReport() {
        boolean isPrintReport = false;
        if (this.getView() instanceof IReportView) {
            isPrintReport = true;
        }
        return isPrintReport;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        if (opResult.isSuccess() && !this.showSelectPrintForm) {
            boolean isContainBillType = this.isContainBillType();
            if (isContainBillType) {
                this.writePrintLog(this.printJobs);
            }
            this.addLog();
        }
        super.afterInvokeOperation(opResult);
    }

    private boolean logEnable() {
        return "true".equals(this.getParameter().get("logenable_logEnable"));
    }

    protected void addLog() {
        if (!this.logEnable()) {
            return;
        }
        PrintLogParam logParam = this.getPrintLogParam();
        AppLogInfo appLogInfo = this.getAppLogInfo();
        PrintOpLogUtils.addOpLog((PrintLogParam)logParam, (AppLogInfo)appLogInfo);
    }

    private AppLogInfo getAppLogInfo() {
        if (PrintOpLogUtils.cancelOpLog()) {
            return null;
        }
        String billNo = this.getBillNo();
        String desc = "";
        desc = StringUtils.isNotBlank((CharSequence)billNo) ? String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f\u3002", (String)"AbstractPrint_44", (String)BOS_NOTEPRINT, (Object[])new Object[0]), billNo, String.valueOf(this.getOperateName())) : String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"AbstractPrint_39", (String)BOS_NOTEPRINT, (Object[])new Object[0]), String.valueOf(this.getOperateName()));
        AppLogInfo appLogInfo = PrintOpLogUtils.buildLogInfo((IFormView)this.getView(), (String)String.valueOf(this.getOperateKey()), (String)String.valueOf(this.getOperateName() == null ? "" : this.getOperateName().getLocaleValue_zh_CN()), (String)billNo);
        return appLogInfo;
    }

    private String getBillNo() {
        String billNo = "";
        try {
            OpFieldValueReader fieldValueReader = OpFieldValueReader.get((IFormView)this.getView());
            if (this.getView() instanceof IListView) {
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                if (selectedRows.size() == 1) {
                    billNo = selectedRows.get(0).getBillNo();
                }
            } else {
                billNo = fieldValueReader.getBillNo(null);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
        return billNo;
    }

    private PrintLogParam getPrintLogParam() {
        if (!PrintOpLogUtils.cancelOpLog()) {
            return null;
        }
        PrintLogParam logParam = new PrintLogParam();
        logParam.setEntityId(this.getFormId());
        logParam.setOpName(String.valueOf(this.getOperateName()));
        logParam.setPkBillNoMap(this.getPKIdBillNoMap());
        return logParam;
    }

    private boolean isDynamicForm() {
        boolean isDynamicForm = false;
        isDynamicForm = this.getView() instanceof IListView ? false : (this.getView() instanceof IReportView ? false : (this.getView() instanceof IMobileView ? this.getView() instanceof MobileFormView : !(this.getView() instanceof IBillView)));
        return isDynamicForm;
    }

    protected String getFormId() {
        String id = this.getView().getFormShowParameter().getFormId();
        if (this.getView() instanceof IMobileView) {
            MobileBillShowParameter mo = (MobileBillShowParameter)this.getView().getFormShowParameter();
            id = mo.getFormConfig().getEntityTypeId();
        } else if (this.getView() instanceof IListView) {
            id = ((ListView)this.getView()).getBillFormId();
        }
        return id;
    }

    protected String getEntityTypeId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityTypeId = formShowParameter.getFormConfig().getEntityTypeId();
        if (this.getView() instanceof IMobileView) {
            entityTypeId = formShowParameter.getFormConfig().getEntityTypeId();
        } else if (this.getView() instanceof IListView) {
            entityTypeId = ((ListView)this.getView()).getEntityTypeId();
        }
        return entityTypeId;
    }

    protected void updatePrintCountField(List<PrintJob> jobs) {
        if (jobs == null) {
            return;
        }
        String formId = this.getEntityTypeId();
        HashSet<Object> billIds = new HashSet<Object>(16);
        for (PrintJob job : jobs) {
            billIds.addAll(job.getBillIds());
        }
        PrintOperationHelper.updatePrintCountField(formId, billIds.stream().collect(Collectors.toList()));
    }

    protected boolean isContainBillType() {
        IFormView view = this.getView();
        BillEntityType billDT = null;
        if (view instanceof IListView) {
            String billFormId = ((ListView)view).getEntityTypeId();
            billDT = (BillEntityType)EntityMetadataCache.getDataEntityType((String)billFormId);
            return StringUtils.isNotBlank((CharSequence)billDT.getBillType());
        }
        if (view instanceof IBillView) {
            billDT = (BillEntityType)view.getModel().getDataEntityType();
            return StringUtils.isNotBlank((CharSequence)billDT.getBillType());
        }
        return false;
    }

    @Deprecated
    protected List<Object> getPrintenablePKIds() {
        IFormView view = this.getView();
        List<Object> printEnableIds = new ArrayList();
        String entityTypeId = this.getEntityTypeId();
        BillEntityType billDT = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityTypeId);
        String billTypeFieldKey = billDT.getBillType();
        String billStatusFieldKey = billDT.getBillStatus();
        DynamicObject obj = ParameterReader.getBillParameter((String)entityTypeId);
        String printcondition = null;
        if (obj != null) {
            printcondition = obj.getString("printconditionvalue");
        }
        if (StringUtils.isNotBlank(printcondition)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)printcondition, FilterCondition.class);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityTypeId);
            FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
            filterBuilder.buildFilter(true);
            QFilter qfFormBillParameter = filterBuilder.getQFilter();
            if (qfFormBillParameter != null) {
                QFilter[] filters = new QFilter[]{qfFormBillParameter, new QFilter(dt.getPrimaryKey().getName(), "in", this.getPKIds())};
                Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)entityTypeId, (QFilter[])filters);
                printEnableIds = filterObjs.values().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                for (Map.Entry it : filterObjs.entrySet()) {
                    DynamicObject billType;
                    Object key = it.getKey();
                    DynamicObject dynamicObject = (DynamicObject)it.getValue();
                    if (!StringUtils.isNotBlank((CharSequence)billTypeFieldKey) || (billType = dynamicObject.getDynamicObject(billTypeFieldKey)) == null) continue;
                    this.billidToBillTypeId.put(key, Long.parseLong(billType.getPkValue().toString()));
                }
                return printEnableIds;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)billStatusFieldKey) && StringUtils.isNotBlank((CharSequence)billTypeFieldKey)) {
            if (view instanceof IListView) {
                Map<Object, String> pkStatusMap = this.getBillPkAndStatusMap(billStatusFieldKey);
                ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
                HashSet<String> billNos = new HashSet<String>();
                HashSet<Object> pks = new HashSet<Object>();
                for (ListSelectedRow listSelectedRow : selectedRows) {
                    Object pkValue = listSelectedRow.getPrimaryKeyValue();
                    Long billTypeId = listSelectedRow.getBillTypeID();
                    String billStatus = pkStatusMap.get(pkValue);
                    String billNo = listSelectedRow.getBillNo();
                    if (pks.contains(pkValue)) continue;
                    pks.add(pkValue);
                    if ((billTypeId == null || this.isBillPrintenable(billTypeId, billStatus, pkValue, billNo)) && !printEnableIds.contains(pkValue)) {
                        printEnableIds.add(pkValue);
                    }
                    billNos.add(billNo);
                }
                this.addUnEnableBillTypeTips();
                this.buildBillTypeErrorMsg();
            } else if (view instanceof IBillView) {
                DynamicObject billTypeObj;
                String billStatus = "";
                String billNo = "";
                if (StringUtils.isNotBlank((CharSequence)billStatusFieldKey)) {
                    billStatus = (String)view.getModel().getValue(billStatusFieldKey);
                    billNo = (String)view.getModel().getValue(billDT.getBillNo());
                }
                if ((billTypeObj = (DynamicObject)view.getModel().getValue(billTypeFieldKey)) == null || StringUtils.isBlank((CharSequence)billStatus) || this.isBillPrintenable((Long)billTypeObj.getPkValue(), billStatus, view.getModel().getDataEntity().getPkValue(), billNo)) {
                    printEnableIds.add(view.getModel().getDataEntity().getPkValue());
                }
                this.addUnEnableBillTypeTips();
                this.buildBillTypeErrorMsg();
            }
        } else {
            printEnableIds = this.getPKIds();
        }
        return printEnableIds;
    }

    private void addUnEnableBillTypeTips() {
        if (!this.unEnableBillType.isEmpty()) {
            this.errorMsg.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b%s\u5df2\u7ecf\u88ab\u7981\u7528\u3002", (String)"AbstractPrint_42", (String)BOS_NOTEPRINT, (Object[])new Object[0]), StringUtils.join((Object[])this.unEnableBillType.toArray(), (String)"\uff0c")));
        }
    }

    private void buildBillTypeErrorMsg() {
        if (!CollectionUtils.isEmpty(this.billTypeErrMsgMap)) {
            String msg;
            Set<String> billType = this.billTypeErrMsgMap.get("billType");
            Set<String> billNo = this.billTypeErrMsgMap.get("billNo");
            String billTypeS = "";
            String billNoS = "";
            if (!CollectionUtils.isEmpty(billType)) {
                msg = ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"AbstractPrint_46", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
                billTypeS = billType.stream().map(e -> "[" + msg + e + "]").collect(Collectors.joining());
            }
            if (!CollectionUtils.isEmpty(billNo)) {
                msg = ResManager.loadKDString((String)"\u5355\u636e", (String)"AbstractPrint_47", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
                billNoS = billNo.stream().map(e -> "[" + msg + e + "]").collect(Collectors.joining());
            }
            String str = String.format(ResManager.loadKDString((String)"%1$s\u8bbe\u7f6e\u4e86\u201c\u5ba1\u6838\u540e\u6253\u5370\u201d\uff0c\u800c%2$s\u672a\u5ba1\u6838\u3002", (String)"AbstractPrint_18", (String)BOS_NOTEPRINT, (Object[])new Object[0]), billTypeS, billNoS);
            if (this.errorMsg.toString().contains(str)) {
                return;
            }
            this.errorMsg.append(str);
        }
    }

    @Deprecated
    protected Map<Object, Long> getBillPKidsAndBillType(IFormView view) {
        HashMap<Object, Long> billTypeAndPkids = new HashMap<Object, Long>(135);
        if (view instanceof IListView) {
            ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
            for (ListSelectedRow listSelectedRow : selectedRows) {
                billTypeAndPkids.put(listSelectedRow.getPrimaryKeyValue(), listSelectedRow.getBillTypeID());
            }
        } else if (view instanceof IBillView) {
            DynamicObject billTypeObj;
            BillEntityType billDT = (BillEntityType)view.getModel().getDataEntityType();
            String billTypeFieldKey = billDT.getBillType();
            Long billTypeId = null;
            if (StringUtils.isNotBlank((CharSequence)billTypeFieldKey) && (billTypeObj = (DynamicObject)view.getModel().getValue(billTypeFieldKey)) != null) {
                billTypeId = (Long)billTypeObj.getPkValue();
            }
            billTypeAndPkids.put(view.getModel().getDataEntity().getPkValue(), billTypeId);
        }
        return billTypeAndPkids;
    }

    private Map<Object, String> getBillPkAndStatusMap(String billStatusFieldKey) {
        HashMap<Object, String> mp = new HashMap<Object, String>(135);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", this.getPKIds())};
        String entityTypeId = this.getEntityTypeId();
        Map cacheDatas = BusinessDataServiceHelper.loadFromCache((String)entityTypeId, (String)("id," + billStatusFieldKey), (QFilter[])qFilters);
        if (!cacheDatas.isEmpty()) {
            for (Map.Entry cacheData : cacheDatas.entrySet()) {
                Object id = cacheData.getKey();
                DynamicObject obj = (DynamicObject)cacheData.getValue();
                Object statusObj = obj.get(billStatusFieldKey);
                if (!StringUtils.isNotBlank((Object)statusObj)) continue;
                mp.put(id, statusObj.toString());
            }
        }
        return mp;
    }

    @Deprecated
    protected boolean isBillPrintenable(Long billTypeId, String billStatus, Object pkid, String billNo) {
        Object[] ids = new Long[]{billTypeId};
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)FORMID_BILLTYPE);
        Map cacheData = BusinessDataReader.loadFromCache((Object[])ids, (DynamicObjectType)dt);
        DynamicObject billTypeObj = (DynamicObject)cacheData.get(billTypeId);
        if (billTypeObj == null) {
            log.debug("\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\uff01 \u4e3b\u952e\uff1a" + billTypeId + " \u5bf9\u5e94\u7684\u5355\u636e\u7c7b\u578b\u5bf9\u8c61\u4e0d\u5b58\u5728");
            return true;
        }
        Long billTypePKId = (Long)billTypeObj.getPkValue();
        if ("0".equals(billTypeObj.get(ENABLE))) {
            this.unEnableBillType.add(billTypeObj.get("name").toString());
        }
        this.billTypeObjCache.put(billTypePKId, billTypeObj);
        this.billidToBillTypeId.put(pkid, billTypePKId);
        if (StringUtils.isBlank((CharSequence)billStatus)) {
            return true;
        }
        boolean printAfterAudit = billTypeObj.getBoolean("printafteraudit");
        boolean controlPrintCount = billTypeObj.getBoolean("controlprintcount");
        int maxPrintCount = billTypeObj.getInt("maxprintcount");
        OperateOption option = this.getOption();
        String bosAuditOpencustomCheckAudit = option.getVariableValue("BOS_AUDIT_OPENCUSTOMCHECKAUDIT", "0");
        if ("0".equals(bosAuditOpencustomCheckAudit) && printAfterAudit) {
            boolean match;
            String customAuditValue = option.getVariableValue("BOS_AUDIT_CUSTOMAUDITVALUE", AUDIT);
            if (AUDIT.equalsIgnoreCase(customAuditValue)) {
                match = customAuditValue.equals(billStatus);
            } else {
                String[] customAuditArr = customAuditValue.split(",");
                match = AbstractPrint.isContainInCustomAuditArr(customAuditArr, billStatus);
            }
            if (!match) {
                Set<String> typeSet = this.billTypeErrMsgMap.get("billType");
                if (CollectionUtils.isEmpty(typeSet)) {
                    typeSet = new HashSet<String>(10);
                    typeSet.add(billTypeObj.getLocaleString("name").getLocaleValue());
                    this.billTypeErrMsgMap.put("billType", typeSet);
                } else {
                    typeSet.add(billTypeObj.getLocaleString("name").getLocaleValue());
                }
                Set<String> billNoSet = this.billTypeErrMsgMap.get("billNo");
                if (CollectionUtils.isEmpty(billNoSet)) {
                    billNoSet = new HashSet<String>(10);
                    billNoSet.add(billNo);
                    this.billTypeErrMsgMap.put("billNo", billNoSet);
                } else {
                    billNoSet.add(billNo);
                }
                return false;
            }
        }
        if (controlPrintCount && maxPrintCount <= this.currentPrintCount(pkid)) {
            this.errorMsg.append(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"AbstractPrint_17", (String)BOS_NOTEPRINT, (Object[])new Object[0])).append('\u201c').append(billTypeObj.getLocaleString("name").getLocaleValue()).append('\u201d').append(ResManager.loadKDString((String)"\u4e2d\u8bbe\u7f6e\u4e86\u201c\u6700\u5927\u6253\u5370\u6b21\u6570\u201d", (String)"AbstractPrint_20", (String)BOS_NOTEPRINT, (Object[])new Object[0])).append(maxPrintCount).append(ResManager.loadKDString((String)"\u6b21\uff0c\u5f53\u524d\u5355\u636e", (String)"AbstractPrint_26", (String)BOS_NOTEPRINT, (Object[])new Object[0])).append("\u201c").append(billNo).append("\u201d").append(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u6700\u5927\u6253\u5370\u6b21\u6570\u3002", (String)"AbstractPrint_27", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean isContainInCustomAuditArr(String[] arr, String billStatus) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (billStatus != null && billStatus.equals(arr[i])) {
                return true;
            }
            if (arr[i] != null) continue;
            return true;
        }
        return false;
    }

    protected List<Object> getPKIds() {
        PKFieldProp pkProp;
        Object pkValue;
        String printPkIds;
        if (this.getOption().containsVariable("printPkIds") && StringUtils.isNotBlank((CharSequence)(printPkIds = this.getOption().getVariableValue("printPkIds")))) {
            try {
                return SerializationUtils.fromJsonStringToList((String)printPkIds, Object.class);
            }
            catch (Exception e) {
                log.error("printPkIds\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)e);
            }
        }
        LinkedHashSet<Object> pkIdSet = new LinkedHashSet<Object>(16);
        if (this.getView() instanceof IMobileView) {
            if (!(this.getView() instanceof IMobileListView) && !(this.getView() instanceof MobileFormView)) {
                Object pkValue2 = this.getView().getModel().getDataEntity().getPkValue();
                PKFieldProp pkProp2 = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey();
                if (!pkProp2.getValueComparator().compareValue(pkValue2)) {
                    pkIdSet.add(pkValue2);
                }
            }
        } else if (this.getView() instanceof IListView) {
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            if (!listSelectedRowCollection.isEmpty()) {
                for (ListSelectedRow listSelectedRowValue : listSelectedRowCollection) {
                    Object pkv = listSelectedRowValue.getPrimaryKeyValue();
                    pkIdSet.add(pkv);
                }
            }
        } else if (!(this.getView() instanceof IReportView) && (pkValue = this.getView().getModel().getDataEntity().getPkValue()) != null && !(pkProp = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey()).getValueComparator().compareValue(pkValue)) {
            pkIdSet.add(pkValue);
        }
        return new ArrayList<Object>(pkIdSet);
    }

    private String getBillNoPropName(String entityId) {
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (dataEntityType instanceof BillEntityType) {
                BillEntityType billEntityType = (BillEntityType)dataEntityType;
                return billEntityType.getBillNo();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
        return "";
    }

    private Map<Object, String> getPKIdBillNoMap() {
        PKFieldProp pkProp;
        String printPkIds;
        HashMap<Object, String> res = new HashMap<Object, String>(16);
        String entityId = this.getFormId();
        String billNoPropName = this.getBillNoPropName(entityId);
        if (StringUtils.isBlank((CharSequence)billNoPropName)) {
            List<Object> pkIds = this.getPKIds();
            for (Object pkId : pkIds) {
                res.put(pkId, null);
            }
            return res;
        }
        if (this.getOption().containsVariable("printPkIds") && StringUtils.isNotBlank((CharSequence)(printPkIds = this.getOption().getVariableValue("printPkIds")))) {
            try {
                PKFieldProp pkProp2;
                List pkIds = SerializationUtils.fromJsonStringToList((String)printPkIds, Object.class);
                if (CollectionUtils.isEmpty((Collection)pkIds)) {
                    return new HashMap<Object, String>(0);
                }
                HashSet pkIdSet = new HashSet(pkIds);
                if (this.getView() instanceof IListView) {
                    ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
                    if (listSelectedRowCollection.isEmpty()) {
                        return new HashMap<Object, String>(0);
                    }
                    for (ListSelectedRow selectedRow : listSelectedRowCollection) {
                        Object pkv = selectedRow.getPrimaryKeyValue();
                        if (!pkIdSet.contains(pkv)) continue;
                        res.put(pkv, selectedRow.getBillNo());
                    }
                    return res;
                }
                DynamicObject dataEntity = this.getView().getModel().getDataEntity();
                if (dataEntity == null) {
                    return new HashMap<Object, String>(0);
                }
                Object pkValue = dataEntity.getPkValue();
                if (pkIdSet.contains(pkValue) && !(pkProp2 = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey()).getValueComparator().compareValue(pkValue)) {
                    res.put(pkValue, dataEntity.getString(billNoPropName));
                }
                return res;
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (this.getView() instanceof IMobileView) {
            if (this.getView() instanceof IMobileListView) {
                return res;
            }
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            Object pkValue = dataEntity.getPkValue();
            PKFieldProp pkProp3 = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey();
            if (!pkProp3.getValueComparator().compareValue(pkValue)) {
                res.put(pkValue, dataEntity.getString(billNoPropName));
            }
            return res;
        }
        if (this.getView() instanceof IListView) {
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            if (!listSelectedRowCollection.isEmpty()) {
                for (ListSelectedRow selectedRow : listSelectedRowCollection) {
                    Object pkv = selectedRow.getPrimaryKeyValue();
                    res.put(pkv, selectedRow.getBillNo());
                }
            }
            return res;
        }
        if (this.getView() instanceof IReportView) {
            return res;
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (pkValue != null && !(pkProp = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey()).getValueComparator().compareValue(pkValue)) {
            res.put(pkValue, dataEntity.getString(billNoPropName));
        }
        return res;
    }

    protected void writePrintLog(List<PrintJob> jobs) {
        if (jobs == null) {
            return;
        }
        String formId = this.getEntityTypeId();
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
        MainEntityType printLog = EntityMetadataCache.getDataEntityType((String)FORMID_PRINTLOG);
        for (int i = 0; i < jobs.size(); ++i) {
            PrintJob current = jobs.get(i);
            for (Object billid : current.getBillIds()) {
                DynamicObject printLogObj = (DynamicObject)printLog.createInstance();
                printLogObj.set("formId", (Object)formId);
                Long billtypeId = this.billidToBillTypeId.get(billid);
                printLogObj.set("billtype", (Object)billtypeId);
                printLogObj.set("createtime", (Object)new Date());
                printLogObj.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
                printLogObj.set(TEMPLATE, current.getTemplateId());
                printLogObj.set("bizobjid", billid);
                printLogObj.set("operationtype", (Object)((Object)((Object)this)).getClass().getSimpleName());
                objs.add(printLogObj);
            }
        }
        try {
            DynamicObject[] objArray = objs.toArray(new DynamicObject[objs.size()]);
            SaveServiceHelper.save((DynamicObject[])objArray);
        }
        catch (Exception e) {
            log.warn("\u8bb0\u5f55\u6253\u5370\u65e5\u5fd7\u65f6\u53d1\u751f\u9519\u8bef" + e.getCause());
        }
    }

    protected Map<String, Integer> getPrintCount() {
        LinkedHashMap<String, Integer> jsonData = null;
        String userId = RequestContext.get().getUserId();
        String suffix = "_printcount";
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)suffix);
        jsonData = StringUtils.isNotBlank((CharSequence)settingData) ? (LinkedHashMap<String, Integer>)SerializationUtils.fromJsonString((String)settingData, Map.class) : new LinkedHashMap<String, Integer>(0);
        return jsonData;
    }

    protected int currentPrintCount(Object pkid) {
        QFilter[] qFilters = new QFilter[]{new QFilter("bizobjid", "=", (Object)pkid.toString())};
        DynamicObjectCollection printCount = QueryServiceHelper.query((String)FORMID_PRINTLOG, (String)"id", (QFilter[])qFilters);
        return printCount != null ? printCount.size() : 0;
    }

    protected String getDefaulttplInManangeTool(String formId) {
        String tplId = "";
        QFilter[] qFilters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)BAS_MANAGEPRINTTPL, (String)PRINTTPLIDID, (QFilter[])qFilters);
        if (defaultObj != null) {
            tplId = (String)defaultObj.get(PRINTTPLIDID);
        }
        return tplId;
    }

    private boolean existAnyTplInManageTool(String formId) {
        return QueryServiceHelper.exists((String)BAS_MANAGEPRINTTPL, (QFilter[])new QFilter("billformid", "=", (Object)formId).toArray());
    }

    protected int getTtplInManangeToolisenable(String tplId) {
        int result = 0;
        QFilter[] qFilters = new QFilter[]{new QFilter(PRINTTPLIDID, "=", (Object)tplId)};
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)BAS_MANAGEPRINTTPL, (String)ENABLE, (QFilter[])qFilters);
        if (defaultObj != null) {
            String enable = (String)defaultObj.get(ENABLE);
            if (enable.equals("1") || enable.equals("")) {
                boolean havePerm;
                result = 1;
                if (ParamUtils.isTemplateOrgIsolated() && !(havePerm = this.checkUserHaveTemplate(tplId))) {
                    result = 3;
                }
            } else {
                result = 2;
            }
        }
        return result;
    }

    private boolean checkUserHaveTemplate(String templateId) {
        if (CollectionUtils.isEmpty(this.hasPermTemplateMap)) {
            this.hasPermTemplateMap = PrintTemplateServiceFactory.getService().getUserPermPrintTemplateMap(this.getEntityTypeId(), this.getView().getFormShowParameter().getAppId());
        }
        return this.hasPermTemplateMap.containsKey(templateId);
    }

    private boolean isExistTplInManangeTool(Object tplId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("printtplid", "=", tplId)};
        boolean isExist = QueryServiceHelper.exists((String)BAS_MANAGEPRINTTPL, (QFilter[])qFilters);
        return isExist;
    }

    private DynamicObject getEnableScheme() {
        Optional firstScheme;
        DynamicObject scheme = null;
        String formId = this.getEntityTypeId();
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("ispreference", "=", (Object)Boolean.TRUE), new QFilter(ENABLE, "=", (Object)"1")};
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)"bos_printingscheme", (QFilter[])filters);
        if (!schemes.isEmpty() && (firstScheme = schemes.values().stream().findFirst()).isPresent()) {
            scheme = (DynamicObject)firstScheme.get();
        }
        return scheme;
    }
}

