/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.printop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IMobileView;
import kd.bos.form.operate.printop.AbstractPrint;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintWork;
import kd.bos.print.matchtpl.TplMatcherUtil;
import kd.bos.print.service.util.PrintClientUtil;

public class ClientPreview
extends AbstractPrint {
    public static final String SPECIFY_TEMPLATE = "SPECIFY_TEMPLATE";
    public static final String SPECIFY_SETTING_TPL = "SPECIFY_SETTING_TPL";
    public static final String SPECIFY_PKID = "SPECIFY_PKID";
    public static final String SKIP_VALIDATE = "SKIP_VALIDATE";
    private PrintJob specifyJob;

    private boolean isSkipValidate() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam(SKIP_VALIDATE);
        return "true".equals(customParam);
    }

    @Override
    protected boolean beforeInvokeOperation(OperationResult opResult) {
        if (this.isSkipValidate()) {
            Object specifyTemplate = null;
            Object useDefaultTpl = this.getView().getFormShowParameter().getCustomParam(SPECIFY_SETTING_TPL);
            if (useDefaultTpl != null && Boolean.parseBoolean(useDefaultTpl.toString())) {
                Map<String, Object> printSetting = this.getPrintSetting();
                if (printSetting != null) {
                    specifyTemplate = printSetting.get("templateid");
                }
            } else {
                specifyTemplate = this.getView().getFormShowParameter().getCustomParam(SPECIFY_TEMPLATE);
            }
            Object specifyPkId = this.getView().getFormShowParameter().getCustomParam(SPECIFY_PKID);
            if (specifyTemplate != null && specifyPkId != null) {
                this.specifyJob = new PrintJob(this.getView().getPageId(), TplMatcherUtil.getEntityTypeId(this.getView()));
                ArrayList<Object> pkIds = new ArrayList<Object>(1);
                pkIds.add(specifyPkId);
                this.specifyJob.setBillIds(pkIds);
                this.specifyJob.setTemplateId(specifyTemplate);
                return true;
            }
            return false;
        }
        LicenseCheckResult licenseCheckResult = PrintClientUtil.checkCloudPrintLicense();
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            this.getView().showTipNotification(licenseCheckResult.getMsg());
            return false;
        }
        if (this.getView() instanceof IMobileView) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u4e0d\u652f\u6301\u6253\u5370\u9884\u89c8\u3002", (String)"ClientPreview_2", (String)"bos-noteprint", (Object[])new Object[0]));
            return false;
        }
        if (!PrintClientUtil.existNewService()) {
            PrintOperationHelper.clientInstallTips(this.getView());
            return false;
        }
        if (!PrintClientUtil.existOnlineNewService()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u5ba2\u6237\u7aef\u4e0d\u5728\u7ebf\u3002", (String)"ClientPreview_3", (String)"bos-noteprint", (Object[])new Object[0]));
            return false;
        }
        return super.beforeInvokeOperation(opResult);
    }

    @Override
    protected OperationResult invokeOperation() {
        List<PrintJob> newPrintJobs;
        List<PrintJob> printjobs;
        OperationResult result = super.invokeOperation();
        if (this.specifyJob == null) {
            printjobs = this.getPrintJobs();
            if (printjobs == null || printjobs.isEmpty()) {
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u9700\u8981\u6253\u5370\u3002", (String)"AbstractPrint_8", (String)"bos-noteprint", (Object[])new Object[0]));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u9700\u8981\u6253\u5370\u3002", (String)"AbstractPrint_8", (String)"bos-noteprint", (Object[])new Object[0]));
                return result;
            }
            Map<String, List<PrintJob>> classifyPrintJob = this.classifySortPrintJob(printjobs);
            newPrintJobs = classifyPrintJob.get("newPrintJobs");
            List<PrintJob> oldPrintJobs = classifyPrintJob.get("oldPrintJobs");
            if (oldPrintJobs.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u5ba2\u6237\u7aef\u6253\u5370\uff0c\u8bf7\u5347\u7ea7\u4e3a\u65b0\u6a21\u677f\u540e\u4f7f\u7528\u3002", (String)"Print_6", (String)"bos-noteprint", (Object[])new Object[0]));
                if (newPrintJobs.size() <= 0) {
                    return result;
                }
            }
        } else {
            printjobs = new ArrayList<PrintJob>(1);
            printjobs.add(this.specifyJob);
            newPrintJobs = printjobs;
        }
        String printLangStr = (String)this.getPrintSetting().get("printlang");
        if (printLangStr == null) {
            printLangStr = RequestContext.get().getLang().toString();
        }
        String printTaskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
        HashMap<String, String> customData = new HashMap<String, String>(1);
        customData.put("taskId", printTaskId);
        result.setCustomData(customData);
        PrintOperationHelper.PrintOperateParam newPrintParam = new PrintOperationHelper.PrintOperateParam(this.getPageId(), this.getFormId(), printTaskId, "", this.getDefaultTemplateId().toString(), printLangStr, new ArrayList<Object>(0), newPrintJobs, this.getExtParamMap());
        if (this.getView() instanceof IMobileView) {
            newPrintParam.setExpType(PrintWork.EXP_TYPE.EXP_MOBILEPREVIEW);
        } else {
            newPrintParam.setExpType(PrintWork.EXP_TYPE.EXP_CLIENTPREVIEW);
        }
        PrintOperationHelper.printNewTpl(newPrintParam);
        if (StringUtils.isNotBlank((CharSequence)printTaskId) && !(this.getView() instanceof IMobileView)) {
            Map<Object, Object> extParam = new HashMap(0);
            if (!CollectionUtils.isEmpty(newPrintParam.getExtParam())) {
                extParam = newPrintParam.getExtParam();
            }
            this.getView().getPageCache().put("extParam", SerializationUtils.toJsonString(extParam));
            PrintOperationHelper.clientPreview(this.getView(), this.getView(), printTaskId, this.getPKIds(), SerializationUtils.toJsonString(printjobs));
        }
        return result;
    }
}

