/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.printop;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.operate.printop.AbstractPrint;
import kd.bos.form.operate.printop.PrintPreview;
import kd.bos.form.operate.printop.XlsPrint;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintWork;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;

public class OpPrintUtil {
    private static final Log log = LogFactory.getLog(OpPrintUtil.class);
    public static final String OP_EXT_KEY = "showprogressrowcount";
    private static IParameterReaderService readerService = new ParameterReaderServiceImpl();

    public static boolean checkToShowProgress(OperateOption option, String formId, int selectNum) {
        DynamicObject billParameter;
        String realBillFormId = PrintServiceHelper.getRealBillFormId(formId);
        if (option.containsVariable(OP_EXT_KEY)) {
            return OpPrintUtil.checkToShowProgress(option, selectNum);
        }
        MainEntityType dataEntityType = null;
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)realBillFormId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (dataEntityType instanceof BillEntityType && (billParameter = readerService.getBillParameter(realBillFormId)) != null && billParameter.containsProperty(OP_EXT_KEY)) {
            int limitCount = billParameter.getInt(OP_EXT_KEY);
            if (limitCount == 0) {
                return true;
            }
            return limitCount < selectNum;
        }
        return true;
    }

    public static boolean checkToShowProgress(OperateOption option, int selectNum) {
        int showprogressrowcount = 0;
        try {
            showprogressrowcount = Integer.parseInt(option.getVariableValue(OP_EXT_KEY, "0"));
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
        return showprogressrowcount < selectNum;
    }

    private static TaskParam resolveOpObj(DefaultDynamicFormOperate formOperate, List<PrintJob> printJobs, String printDataProviderType, String pkIdsJson, int selectRows) {
        TaskParam taskParam = new TaskParam();
        if (formOperate instanceof AbstractPrint) {
            AbstractPrint abstractPrint = (AbstractPrint)formOperate;
            Map<String, Object> printSetting = abstractPrint.getPrintSetting();
            String formId = abstractPrint.getFormId();
            String entityTypeId = abstractPrint.getEntityTypeId();
            String defaultTempId = abstractPrint.getDefaultTemplateId().toString();
            Map<String, List<PrintJob>> classifyPrintJob = abstractPrint.classifySortPrintJob(printJobs);
            String operateKey = abstractPrint.getOperateKey();
            Map<String, Object> extParamMap = abstractPrint.getExtParamMap();
            taskParam.setClassifyPrintJob(classifyPrintJob);
            taskParam.setView(abstractPrint.getView());
            taskParam.setDefaultTempId(defaultTempId);
            taskParam.setEntityTypeId(entityTypeId);
            taskParam.setExtParamMap(extParamMap);
            taskParam.setFormId(formId);
            taskParam.setOpKey(operateKey);
            taskParam.setPrintSetting(printSetting);
            taskParam.setPkIdsJson(pkIdsJson);
            taskParam.setPrintDataProviderType(printDataProviderType);
            taskParam.setSelectRows(selectRows);
            taskParam.setFormOperate(abstractPrint);
            if (formOperate instanceof XlsPrint) {
                taskParam.setExpType(PrintWork.EXP_TYPE.EXP_XLS);
            }
        }
        return taskParam;
    }

    static void showProgressForm(DefaultDynamicFormOperate formOperate, List<PrintJob> printJobs, String printDataProviderType, String pkIdsJson, int selectRows) {
        TaskParam taskParam = OpPrintUtil.resolveOpObj(formOperate, printJobs, printDataProviderType, pkIdsJson, selectRows);
        OpPrintUtil.showProgressForm(taskParam);
    }

    public static void showProgressForm(TaskParam taskParam) {
        List<PrintJob> newPrintJobs;
        IFormView view = taskParam.getView();
        Map<String, Object> printSetting = taskParam.getPrintSetting();
        String printDataProviderType = taskParam.getPrintDataProviderType();
        String formId = taskParam.getFormId();
        String entityTypeId = taskParam.getEntityTypeId();
        String defaultTempId = taskParam.getDefaultTempId();
        String pkIdsJson = taskParam.getPkIdsJson();
        Map<String, List<PrintJob>> classifyPrintJob = taskParam.getClassifyPrintJob();
        Map<String, Object> extParamMap = taskParam.getExtParamMap();
        String opKey = taskParam.getOpKey();
        int selectRows = taskParam.getSelectRows();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_printing");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        String caption = "";
        FormShowParameter formShowParameter = view.getFormShowParameter();
        FormConfig fc = formShowParameter.getFormConfig();
        if (fc != null && fc.getCaption() != null) {
            caption = fc.getCaption().toString();
            showParameter.getCustomParams().put("entitynameL", fc.getCaption());
        }
        showParameter.getCustomParams().put("entityname", caption);
        String printLangStr = (String)printSetting.get("printlang");
        if (StringUtils.isBlank((CharSequence)printLangStr)) {
            printLangStr = RequestContext.get().getLang().toString();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("lang", printLangStr);
        param.put("printdataprovidertype", printDataProviderType);
        param.put("pageid", view.getPageId());
        param.put("formid", formId);
        param.put("entityTypeId", entityTypeId);
        param.put("defaulttemplateid", defaultTempId);
        param.put("pkids", pkIdsJson);
        String previewType = (String)printSetting.get("previewtype");
        List<PrintJob> oldPrintJobs = classifyPrintJob.get("oldPrintJobs");
        if (!CollectionUtils.isEmpty(oldPrintJobs)) {
            param.put("oldPrintJobs", SerializationUtils.toJsonString(oldPrintJobs));
        }
        if (!CollectionUtils.isEmpty(newPrintJobs = classifyPrintJob.get("newPrintJobs"))) {
            param.put("newPrintJobs", SerializationUtils.toJsonString(newPrintJobs));
        }
        if (OpPrintUtil.isNewTpl(defaultTempId)) {
            param.put("newDefaultTplId", defaultTempId);
        } else {
            param.put("oldDefaultTplId", defaultTempId);
        }
        param.put("extParam", extParamMap);
        if ("1".equals(previewType) && taskParam.getFormOperate() instanceof PrintPreview) {
            param.put("previewtype", previewType);
            param.put("nlocalpreview", printSetting.get("nlocalpreview"));
            if (!CollectionUtils.isEmpty(oldPrintJobs) || StringUtils.isNotBlank(param.get("oldDefaultTplId")) && ("report".equals(printDataProviderType) || "dynamic".equals(printDataProviderType) || "querylist".equals(printDataProviderType))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u672c\u5730\u6253\u5370\uff0c\u8bf7\u5347\u7ea7\u4e3a\u65b0\u6a21\u677f\u540e\u4f7f\u7528\u3002", (String)"PrintPreviewClientCallback_4", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
        }
        if (taskParam.getExpType() != null) {
            param.put("expType", taskParam.getExpType().name());
        }
        showParameter.getCustomParams().put("printParam", param);
        showParameter.getCustomParams().put("operateKey", opKey);
        showParameter.getCustomParams().put("selectrows", selectRows);
        showParameter.setShowTitle(Boolean.FALSE.booleanValue());
        view.showForm(showParameter);
    }

    private static boolean isNewTpl(String tplId) {
        if (StringUtils.isBlank((CharSequence)tplId)) {
            return false;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_manageprinttpl", (String)"id,type,printtplid_id", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "=", (Object)tplId)});
        if (dynamicObject == null) {
            return false;
        }
        String type = dynamicObject.getString("type");
        return "B".equals(type);
    }

    public static class TaskParam {
        DefaultDynamicFormOperate formOperate;
        IFormView view;
        String opKey;
        Map<String, Object> printSetting;
        Map<String, Object> extParamMap;
        String formId;
        String entityTypeId;
        String defaultTempId;
        Map<String, List<PrintJob>> classifyPrintJob;
        String printDataProviderType;
        String pkIdsJson;
        PrintWork.EXP_TYPE expType;
        int selectRows;

        public DefaultDynamicFormOperate getFormOperate() {
            return this.formOperate;
        }

        public void setFormOperate(DefaultDynamicFormOperate formOperate) {
            this.formOperate = formOperate;
        }

        public IFormView getView() {
            return this.view;
        }

        public void setView(IFormView view) {
            this.view = view;
        }

        public String getOpKey() {
            return this.opKey;
        }

        public void setOpKey(String opKey) {
            this.opKey = opKey;
        }

        public Map<String, Object> getPrintSetting() {
            return this.printSetting;
        }

        public void setPrintSetting(Map<String, Object> printSetting) {
            this.printSetting = printSetting;
        }

        public Map<String, Object> getExtParamMap() {
            return this.extParamMap;
        }

        public void setExtParamMap(Map<String, Object> extParamMap) {
            this.extParamMap = extParamMap;
        }

        public String getFormId() {
            return this.formId;
        }

        public void setFormId(String formId) {
            this.formId = formId;
        }

        public String getEntityTypeId() {
            return this.entityTypeId;
        }

        public void setEntityTypeId(String entityTypeId) {
            this.entityTypeId = entityTypeId;
        }

        public String getDefaultTempId() {
            return this.defaultTempId;
        }

        public void setDefaultTempId(String defaultTempId) {
            this.defaultTempId = defaultTempId;
        }

        public Map<String, List<PrintJob>> getClassifyPrintJob() {
            return this.classifyPrintJob;
        }

        public void setClassifyPrintJob(Map<String, List<PrintJob>> classifyPrintJob) {
            this.classifyPrintJob = classifyPrintJob;
        }

        public String getPrintDataProviderType() {
            return this.printDataProviderType;
        }

        public void setPrintDataProviderType(String printDataProviderType) {
            this.printDataProviderType = printDataProviderType;
        }

        public String getPkIdsJson() {
            return this.pkIdsJson;
        }

        public void setPkIdsJson(String pkIdsJson) {
            this.pkIdsJson = pkIdsJson;
        }

        public int getSelectRows() {
            return this.selectRows;
        }

        public void setSelectRows(int selectRows) {
            this.selectRows = selectRows;
        }

        public PrintWork.EXP_TYPE getExpType() {
            return this.expType;
        }

        public void setExpType(PrintWork.EXP_TYPE expType) {
            this.expType = expType;
        }
    }
}

