/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.printop;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IMobileView;
import kd.bos.form.operate.printop.AbstractPrint;
import kd.bos.form.operate.printop.PrintTypes;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintWork;
import kd.bos.print.service.util.PrintClientUtil;

public class Print
extends AbstractPrint {
    public static final String BIZ_FORM_ID = "bizFormId";
    private String serviceType;

    private boolean isBluetoothPrint() {
        return this.getView() instanceof MobileBillView && "1".equals(this.getPrintSetting().getOrDefault("printmodel", "0"));
    }

    @Override
    protected boolean beforeInvokeOperation(OperationResult opResult) {
        if (this.isBluetoothPrint()) {
            OperateOption option = this.getOption();
            if (!option.containsVariable("AllowBlueMobilePrint")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u4e2d\u9009\u62e9\u201c\u4e91\u6253\u5370\u201d\u65b9\u5f0f\uff0c\u5e76\u6dfb\u52a0\u6253\u5370\u673a\u3002", (String)"Print_13", (String)"bos-noteprint", (Object[])new Object[0]));
                return false;
            }
            return super.beforeInvokeOperation(opResult);
        }
        LicenseCheckResult licenseCheckResult = PrintClientUtil.checkCloudPrintLicense();
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            this.getView().showTipNotification(licenseCheckResult.getMsg());
            return false;
        }
        this.printTypes = PrintTypes.Print;
        if (!PrintClientUtil.existPrinter()) {
            if (this.getView() instanceof IMobileView) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u7f51\u9875\u7aef\u5b89\u88c5\u6253\u5370\u5ba2\u6237\u7aef\u5e76\u6dfb\u52a0\u4e91\u6253\u5370\u673a\u3002", (String)"Print_10", (String)"bos-noteprint", (Object[])new Object[0]));
            } else {
                PrintOperationHelper.clientInstallTips(this.getView());
            }
            return false;
        }
        Object printerId = this.getDefaultPrinter();
        if (StringUtils.isBlank((Object)printerId)) {
            if (this.getView() instanceof IMobileView) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u673a\uff0c\u8bf7\u901a\u8fc7\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u8bbe\u7f6e\u3002", (String)"Print_11", (String)"bos-noteprint", (Object[])new Object[0]));
            } else {
                PrintOperationHelper.printerSettingTips(this.getView());
            }
            return false;
        }
        PrintClientUtil.CloudPrinter cloudPrint = PrintClientUtil.getCloudPrinter((long)Long.parseLong(printerId.toString()));
        if (cloudPrint == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u673a\u3002", (String)"Print_9", (String)"bos-noteprint", (Object[])new Object[0]));
            return false;
        }
        this.serviceType = cloudPrint.getServiceType();
        if ("B".equals(cloudPrint.getServiceType())) {
            PrintClientUtil.PrinterStatus printerStatus = PrintClientUtil.printerStatus((String)cloudPrint.getServiceN(), (String)cloudPrint.getPrinterName(), (String)cloudPrint.getServiceType());
            if (printerStatus == PrintClientUtil.PrinterStatus.offline) {
                if (this.getView() instanceof IMobileView) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u4e0d\u5728\u7ebf\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u7f51\u9875\u7aef\u5b89\u88c5\u6253\u5370\u5ba2\u6237\u7aef\u3002", (String)"Print_12", (String)"bos-noteprint", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u5ba2\u6237\u7aef\u4e0d\u5728\u7ebf\u3002", (String)"ClientPreview_3", (String)"bos-noteprint", (Object[])new Object[0]));
                }
                return false;
            }
            if (printerStatus == PrintClientUtil.PrinterStatus.busy) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6253\u5370\u673a\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ClientPreview_9", (String)"bos-noteprint", (Object[])new Object[0]));
                return false;
            }
        }
        return super.beforeInvokeOperation(opResult);
    }

    @Override
    protected OperationResult invokeOperation() {
        Object printer;
        OperationResult result = new OperationResult();
        if (this.showSelectPrintForm) {
            return result;
        }
        PrintOperationHelper.PrintOperateParam param = new PrintOperationHelper.PrintOperateParam();
        String curLang = RequestContext.get().getLang().toString();
        String printLangStr = (String)this.getPrintSetting().get("printlang");
        if (StringUtils.isNotBlank((CharSequence)printLangStr)) {
            curLang = printLangStr;
        }
        param.setLang(curLang);
        param.setPrintJobs(this.getPrintJobs());
        param.setPkIds(this.getPKIds());
        param.setServiceType(this.serviceType);
        param.setFormId(this.getFormId());
        param.setCopyNum(1);
        param.setExtParam(this.getExtParamMap());
        if (this.isBluetoothPrint() && (printer = this.getPrintSetting().get("escprinter")) != null) {
            param.setBtPrinter(printer.toString());
        } else {
            printer = this.getDefaultPrinter();
            if (printer != null) {
                param.setPrinterId(Long.valueOf(printer.toString()));
            }
        }
        param.setOperateKey("print");
        if (this.isBluetoothPrint()) {
            param.setExpType(PrintWork.EXP_TYPE.EXP_ESCPOS_O);
            result = PrintOperationHelper.doNewPrintOperation(this.getView(), param);
        } else {
            result = PrintOperationHelper.doPrintOperation(this.getView(), param);
        }
        return result;
    }

    @Override
    protected void afterInvokeOperation(OperationResult opResult) {
        if (opResult.isSuccess() && !this.showSelectPrintForm) {
            if (this.getPrintJobs() == null) {
                return;
            }
            String formId = this.getEntityTypeId();
            HashSet<Object> billIds = new HashSet<Object>(16);
            for (PrintJob job : this.getPrintJobs()) {
                if (job.getBillIds() == null) continue;
                billIds.addAll(job.getBillIds());
            }
            PrintOperationHelper.updatePrintCountField(formId, new ArrayList<Object>(billIds));
            this.addLog();
        }
    }
}

