/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.printop;

import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ClientCallbackListener;
import kd.bos.form.IMobileView;
import kd.bos.form.operate.printop.AbstractPrint;
import kd.bos.form.operate.printop.OpPrintUtil;
import kd.bos.form.operate.printop.PrintPreviewClientCallback;
import kd.bos.form.operate.printop.PrintTypes;
import kd.bos.form.plugin.print.OldPrintOperationHelper;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListModel;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.facade.IPrintServiceFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.print.business.utils.PrintParamUtils;
import kd.bos.print.service.provider.ClientScptServiceProvider;
import kd.bos.report.IReportView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;

public class PrintPreview
extends AbstractPrint {
    private static final String BOS_NOTEPRINT = "bos-noteprint";
    private static final Log log = LogFactory.getLog(PrintPreview.class);
    private static final int MAX_NO_TASK_ROW_NUM = 100;

    @Override
    protected boolean beforeInvokeOperation(OperationResult opResult) {
        this.printTypes = PrintTypes.Preview;
        opResult.setShowMessage(false);
        Map<String, Object> printSetting = this.getPrintSetting();
        int maxZipFileNum = PrintParamUtils.getMaxBillNoCreateFileNum();
        List<Object> pkIds = this.getPKIds();
        Object previewType = printSetting.get("previewtype");
        if ("0".equals(previewType) && "2".equals(printSetting.get("fileCreateType")) && pkIds != null && pkIds.size() > maxZipFileNum) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6309\u4e0d\u540c\u5355\u636e\u751f\u6210\u591a\u4e2aPDF\uff0c\u6279\u91cf\u6253\u5370\u6700\u5927\u652f\u6301%s\u5f20\u5355\u636e\u3002", (String)"AbstractPrint_48", (String)BOS_NOTEPRINT, (Object[])new Object[]{maxZipFileNum}));
            return false;
        }
        if (!"1".equals(previewType)) {
            return super.beforeInvokeOperation(opResult);
        }
        String lspInstall = this.getOption().getVariableValue("lspInstall", null);
        if (StringUtils.isBlank((CharSequence)lspInstall)) {
            lspInstall = this.getView().getPageCache().get("lspInstall");
        }
        if (!"1".equals(lspInstall)) {
            ClientCallbackListener listener = new ClientCallbackListener();
            ArrayList<PrintPreviewClientCallback> list = new ArrayList<PrintPreviewClientCallback>();
            list.add(new PrintPreviewClientCallback());
            listener.setOptionVariables(this.getOption().getVariables());
            listener.setListCallBack(list);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("url", ClientScptServiceProvider.getClientLocalServerUrl() + "/version");
            this.getView().executeClientMethodCallback("lspInstall", args, listener);
            return false;
        }
        return super.beforeInvokeOperation(opResult);
    }

    @Override
    protected OperationResult invokeOperation() {
        OperationResult result = new OperationResult();
        if (this.showSelectPrintForm) {
            return result;
        }
        result = this.doPreview();
        return result;
    }

    private void showProgressFormOrDirectPrint(List<PrintJob> printjobs, String printdataprovidertype, String pkids, int selectRows) {
        if ("querylist".equals(printdataprovidertype) || this.getView() instanceof ReportView) {
            if (!this.getOption().containsVariable("showprogressrowcount") || OpPrintUtil.checkToShowProgress(this.getOption(), selectRows)) {
                OpPrintUtil.showProgressForm(this, printjobs, printdataprovidertype, pkids, selectRows);
            } else {
                this.noTaskPrint();
            }
            return;
        }
        if (this.getView() instanceof IListView) {
            if (OpPrintUtil.checkToShowProgress(this.getOption(), this.getFormId(), selectRows)) {
                OpPrintUtil.showProgressForm(this, printjobs, printdataprovidertype, pkids, selectRows);
            } else {
                this.noTaskPrint();
            }
            return;
        }
        OpPrintUtil.showProgressForm(this, printjobs, printdataprovidertype, pkids, selectRows);
    }

    private OperationResult doPreview() {
        OperationResult result;
        block19: {
            result = new OperationResult();
            try {
                if (this.getView() instanceof IReportView) {
                    ReportView rptFormView = (ReportView)this.getView();
                    ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
                    int rowCount = listModel.getRowCount();
                    if (rowCount > 0) {
                        this.showProgressFormOrDirectPrint(null, "report", "", rowCount);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u6253\u5370\u6570\u636e\u3002", (String)"Print_2", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                    }
                    break block19;
                }
                if (this.getView() instanceof IListView) {
                    FormView formView = (FormView)this.getView();
                    ListView listformView = (ListView)formView;
                    ListModel listModel = (ListModel)listformView.getListModel();
                    MainEntityType entityType = (MainEntityType)listModel.getDataEntityType();
                    if (entityType instanceof QueryEntityType) {
                        BillList billList = (BillList)this.getView().getControl("billlistap");
                        List selectDataList = (List)billList.getEntryState().get("selDatas");
                        Object[] pkArray = new Object[selectDataList.size()];
                        int size = selectDataList.size();
                        for (int i = 0; i < size; ++i) {
                            ArrayList selectPkList = (ArrayList)selectDataList.get(i);
                            pkArray[i] = selectPkList.get(0);
                        }
                        List<Object> pkIds = Arrays.asList(pkArray);
                        this.showProgressFormOrDirectPrint(this.getPrintJobs(), "querylist", SerializationUtils.toJsonString(pkIds), selectDataList.size());
                    } else {
                        this.showProgressFormOrDirectPrint(this.getPrintJobs(), "", "", ((IListView)this.getView()).getSelectedRows().size());
                    }
                    break block19;
                }
                if (this.getPKIds() == null || this.getPKIds().isEmpty()) {
                    if (StringUtils.isNotBlank((CharSequence)this.getDefaultTemplateId().toString())) {
                        this.showProgressFormOrDirectPrint(null, "dynamic", "", 0);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u5728\u201c\u6253\u5370\u201d->\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AbstractPrint_4", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                    }
                    break block19;
                }
                if (this.getView() instanceof BillView) {
                    String noTaskRowNumParam;
                    int noTaskRowNum = 100;
                    if (this.getOption().containsVariable("noTaskRowNum") && StringUtils.isNotBlank((CharSequence)(noTaskRowNumParam = this.getOption().getVariableValue("noTaskRowNum")))) {
                        try {
                            noTaskRowNum = Integer.parseInt(noTaskRowNumParam);
                        }
                        catch (Exception ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    int finalNoTaskRowNum = noTaskRowNum;
                    DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
                    Optional<DynamicObjectCollection> bigEntryOp = this.getView().getModel().getDataEntityType().getProperties().getCollectionProperties(true).stream().filter(f -> !(f instanceof LinkEntryProp)).map(m -> {
                        try {
                            return (DynamicObjectCollection)m.getValueFast((Object)dataEntity);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }).filter(f -> f != null && f.size() > finalNoTaskRowNum).findAny();
                    if (bigEntryOp.isPresent()) {
                        this.showProgressFormOrDirectPrint(this.getPrintJobs(), "", "", this.getPKIds().size());
                    } else {
                        this.noTaskPrint();
                    }
                    break block19;
                }
                this.showProgressFormOrDirectPrint(this.getPrintJobs(), "", "", this.getPKIds().size());
            }
            catch (Exception e) {
                result.setSuccess(false);
                log.error("\u6253\u5370\u9884\u89c8\u62a5\u9519: ", (Throwable)e);
                if (e instanceof KDException) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)e.getMessage(), (String)"PrintPreview_0", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                }
                throw new KDException(e.getCause(), BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u6253\u5370\u9884\u89c8\u5931\u8d25\u3002", (String)"PrintPreview_0", (String)BOS_NOTEPRINT, (Object[])new Object[0])});
            }
        }
        return result;
    }

    private void noTaskPrint() {
        List<PrintJob> printjobs = this.getPrintJobs();
        if (printjobs != null && !printjobs.isEmpty()) {
            Map<String, List<PrintJob>> classifyPrintJob = this.classifySortPrintJob(printjobs);
            List<PrintJob> newPrintJobs = classifyPrintJob.get("newPrintJobs");
            List<PrintJob> oldPrintJobs = classifyPrintJob.get("oldPrintJobs");
            String defaultTempId = this.getDefaultTemplateId().toString();
            boolean isNewDefaultTpl = this.isNewTpl(defaultTempId);
            boolean isOldDefaultTpl = !isNewDefaultTpl && StringUtils.isNotBlank((CharSequence)defaultTempId);
            Map<String, Object> printSetting = this.getPrintSetting();
            String printLangStr = (String)printSetting.get("printlang");
            if (StringUtils.isBlank((CharSequence)printLangStr)) {
                printLangStr = RequestContext.get().getLang().toString();
            }
            String printTaskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
            Set<Object> billIds = PrintOperationHelper.recordPkIds(this.getEntityTypeId(), newPrintJobs, oldPrintJobs);
            PrintOperationHelper.PrintOperateParam newPrintParam = new PrintOperationHelper.PrintOperateParam(this.getPageId(), this.getFormId(), printTaskId, "", isNewDefaultTpl ? defaultTempId : "", printLangStr, new ArrayList<Object>(0), newPrintJobs, this.getExtParamMap());
            Object previewType = printSetting.get("previewtype");
            Object hideLocalPreview = printSetting.get("nlocalpreview");
            if ("1".equals(previewType)) {
                newPrintParam.setExpType(PrintWork.EXP_TYPE.EXP_SCPT);
                if (!CollectionUtils.isEmpty(oldPrintJobs) || isOldDefaultTpl) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u672c\u5730\u6253\u5370\uff0c\u8bf7\u5347\u7ea7\u4e3a\u65b0\u6a21\u677f\u540e\u4f7f\u7528\u3002", (String)"PrintPreviewClientCallback_4", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                    return;
                }
            }
            PrintOperationHelper.printNewTpl(newPrintParam);
            PrintOperationHelper.PrintOperateParam oldPrintParam = new PrintOperationHelper.PrintOperateParam(this.getPageId(), this.getFormId(), printTaskId, "", isOldDefaultTpl ? defaultTempId : "", new ArrayList<Object>(0), oldPrintJobs);
            oldPrintParam.setExtParam(this.getExtParamMap());
            OldPrintOperationHelper.printOldTpl(oldPrintParam);
            boolean doNext = true;
            for (IPrintServiceFacade prtService : PrtFacadeFactory.getAllPrtServiceFacades()) {
                HashMap<String, Object> params = new HashMap<String, Object>(3);
                params.put("iFormView", this.getView());
                params.put("parentView", this.getView());
                params.put("result", printTaskId);
                if (prtService.afterDoOperate(params)) continue;
                doNext = false;
                break;
            }
            if (!doNext) {
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            data.put("taskId", printTaskId);
            data.put("success", Boolean.TRUE.toString());
            doNext = PrintOperationHelper.fireAfterDoPrint(this.getView(), this.getView(), this.getOperateKey(), data);
            if (!doNext) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)printTaskId)) {
                PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)printTaskId);
                if (PrintWork.EXP_TYPE.EXP_SCPT.getCode().equals(taskResult.getExtType())) {
                    PrintOperationHelper.clientLocalPrint(this.getView(), this.getView(), taskResult, !Boolean.parseBoolean(String.valueOf(hideLocalPreview)));
                } else {
                    List attachList = taskResult.getAttach();
                    String isOpenMobPreview = SystemPropertyUtils.getProptyByTenant((String)"PRT_MOBILE_PREVIEW", (String)RequestContext.get().getTenantId());
                    if (this.getView() instanceof IMobileView && (StringUtils.isBlank((CharSequence)isOpenMobPreview) || StringUtils.isNotBlank((CharSequence)isOpenMobPreview) && Boolean.parseBoolean(isOpenMobPreview))) {
                        PrintOperationHelper.mobilePreview(this.getView(), this.getView(), printTaskId, attachList);
                    } else {
                        PrintOperationHelper.preview(this.getView(), this.getView(), printTaskId, attachList);
                    }
                }
            }
            PrintOperationHelper.updatePrintCountField(this.getEntityTypeId(), new ArrayList<Object>(billIds));
        }
    }

    private boolean isNewTpl(String tplId) {
        if (StringUtils.isBlank((CharSequence)tplId)) {
            return false;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_manageprinttpl", (String)"id,type,printtplid_id", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "=", (Object)tplId)});
        if (dynamicObject == null) {
            return false;
        }
        String type = dynamicObject.getString("type");
        return "B".equals(type);
    }

    public IPrintDataProvider createDataProvider(String type, String pageId, MainEntityType entityType, PrintMetadata printMeta) {
        return OldPrintOperationHelper.createDataProvider(type, pageId, entityType, printMeta);
    }
}

