/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.printop;

import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.report.IReportView;

public class PrintSetting
extends FormOperate {
    private static Log log = LogFactory.getLog(PrintSetting.class);

    public boolean needSelectData() {
        return false;
    }

    protected OperationResult invokeOperation() {
        OperationResult result = new OperationResult();
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String formId = formShowParameter.getFormConfig().getEntityTypeId();
        if (view instanceof IMobileView) {
            if (view instanceof IMobileListView) {
                BillList billList = (BillList)view.getControl("billlistap");
                if (billList == null) {
                    return result;
                }
                String entityId = billList.getEntityId();
                formId = billList.getBillFormId();
                this.showMobilePrintSetting(formId, entityId);
                return result;
            }
            String entityId = formShowParameter.getFormConfig().getEntityTypeId();
            this.showMobilePrintSetting(formId, entityId);
            return result;
        }
        String type = "";
        if (view instanceof IListView) {
            formId = ((ListView)view).getEntityTypeId();
            type = IListView.class.getSimpleName();
        } else {
            type = view instanceof IReportView ? IReportView.class.getSimpleName() : IFormView.class.getSimpleName();
        }
        this.showPrintSetting(formId, type);
        return result;
    }

    private void showPrintSetting(String formId, Object type) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bos_printsetting");
        param.setCustomParam("formid", (Object)formId);
        param.setCustomParam("formtype", type);
        param.setCustomParam("PrintSettingOpParam", (Object)this.getParameter());
        this.getView().showForm(param);
    }

    private void showMobilePrintSetting(String formId, String entityId) {
        MobileFormShowParameter param = new MobileFormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Floating);
        param.setFormId("bos_mobileprintsetting");
        param.setCustomParam("formid", (Object)formId);
        param.setCustomParam("entityid", (Object)entityId);
        param.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
        this.getView().getFormShowParameter().setCustomParam("SKIP_VALIDATE", (Object)"true");
        try {
            Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
            this.getView().getFormShowParameter().setCustomParam("SPECIFY_PKID", pkValue);
            this.getView().getFormShowParameter().setCustomParam("SPECIFY_SETTING_TPL", (Object)true);
            OperationResult operationResult = this.getView().invokeOperation("clientpreview");
            param.setCustomParam("taskId", operationResult.getCustomData().get("taskId"));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        this.getView().showForm((FormShowParameter)param);
    }
}

