/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.printop;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PrintTemplateMatcher {
    Map<String, Object> printSetting;
    Map<Long, DynamicObject> billTypeObjCache;
    Map<Object, Long> billidToBillTypeId;
    boolean isContainBillType;

    public PrintTemplateMatcher(Map<String, Object> printSetting, Map<Long, DynamicObject> billTypeObjCache, Map<Object, Long> billidToBillTypeId, boolean isContainBillType) {
        this.printSetting = printSetting;
        this.billidToBillTypeId = billidToBillTypeId;
        this.billTypeObjCache = billTypeObjCache;
        this.isContainBillType = isContainBillType;
    }

    public String getTemplateByDefault(Object currentPKid) {
        String templateId = null;
        Long billTypeId = this.billidToBillTypeId.get(currentPKid);
        DynamicObject billTypeObj = this.billTypeObjCache.get(billTypeId);
        if (billTypeObj != null) {
            String templateNumber = billTypeObj.getString("defprinttemplate");
            if (StringUtils.isBlank((CharSequence)templateNumber)) {
                return "";
            }
            String idByNumber = MetadataDao.getIdByNumber((String)templateNumber, (MetaCategory)MetaCategory.Form);
            if (StringUtils.isNotBlank((CharSequence)idByNumber)) {
                templateId = idByNumber;
            }
        }
        return templateId;
    }

    public String getTemplateBySetting(Object currentPKid) {
        if (this.printSetting == null) {
            return "";
        }
        List billTypePrintControls = (List)this.printSetting.get("basesetting");
        if (billTypePrintControls == null) {
            return "";
        }
        for (Map billTypePrintControl : billTypePrintControls) {
            String billtypeid = (String)billTypePrintControl.get("billtypeid");
            String templateid = (String)billTypePrintControl.get("templateid");
            Long billtypeidInCache = this.billidToBillTypeId.get(currentPKid);
            if (billtypeidInCache == null || !StringUtils.isNotBlank((CharSequence)templateid) || !Objects.equals(billtypeid, billtypeidInCache.toString())) continue;
            return templateid;
        }
        return "";
    }

    public String getDefaultTemplateBySetting() {
        Object defaultTemplate = this.printSetting.get("template");
        Object defaultTemplateId = this.printSetting.get("templateid");
        Object selectTpl = this.printSetting.get("selecttpl");
        if (StringUtils.isBlank((Object)defaultTemplateId)) {
            if (StringUtils.isBlank((Object)defaultTemplate)) {
                defaultTemplate = selectTpl;
            }
            if (StringUtils.isNotBlank((Object)defaultTemplate)) {
                String templateId = MetadataDao.getIdByNumber((String)defaultTemplate.toString(), (MetaCategory)MetaCategory.Form);
                defaultTemplateId = templateId;
            }
        }
        return StringUtils.isNotBlank((Object)defaultTemplateId) ? defaultTemplateId.toString() : "";
    }

    public String findMatchedPrintTemplate(Object pkid) {
        String template = "";
        if (this.isContainBillType) {
            template = this.getTemplateBySetting(pkid);
            if (StringUtils.isNotBlank((CharSequence)template)) {
                return template;
            }
            template = this.getTemplateByDefault(pkid);
            if (StringUtils.isNotBlank((CharSequence)template)) {
                return template;
            }
            template = this.getDefaultTemplateBySetting();
        } else {
            template = this.getDefaultTemplateBySetting();
        }
        return template;
    }
}

