/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.printop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.operate.OpFieldValueReader;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.print.api.facade.param.PrintLogParam;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.report.IReportView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;

public class SelectTplPrint
extends DefaultDynamicFormOperate {
    private static final String BOS_NOTEPRINT = "bos-noteprint";
    private static final Log log = LogFactory.getLog(SelectTplPrint.class);

    public void initialize(Map<String, Object> opMeta) {
        this.getParameter().put("logenable_logEnable", String.valueOf(opMeta.get("logEnable")));
        opMeta.put("logEnable", false);
        super.initialize(opMeta);
    }

    protected OperationResult invokeOperation() {
        OperationResult result = new OperationResult();
        this.showSelectPrintForm();
        return result;
    }

    private Map<String, Object> getExtParamFromOption() {
        boolean containsVariable;
        HashMap<String, Object> extParam = new HashMap<String, Object>(0);
        OperateOption option = this.getOption();
        if (option == null) {
            return extParam;
        }
        if (this.getOption().containsVariable("calculateTotalPage")) {
            extParam.put("calculateTotalPage", Boolean.parseBoolean(this.getOption().getVariableValue("calculateTotalPage")));
        }
        if (!(containsVariable = option.containsVariable("extParam"))) {
            return extParam;
        }
        String param = option.getVariableValue("extParam");
        if (StringUtils.isBlank((CharSequence)param)) {
            return extParam;
        }
        return (Map)SerializationUtils.fromJsonString((String)param, Map.class);
    }

    private void showSelectPrintForm() {
        PrintLogParam logParam;
        AppLogInfo appLogInfo;
        String formId = this.getView().getFormShowParameter().getFormId();
        if (this.getView() instanceof IListView) {
            formId = ((ListView)this.getView()).getEntityTypeId();
        }
        if (this.getView() instanceof IMobileView) {
            FormConfig fc = this.getView().getFormShowParameter().getFormConfig();
            formId = fc.getEntityTypeId();
        }
        formId = PrintServiceHelper.getRealBillFormId(formId);
        List<Object> pkids = this.getPKIds();
        boolean isConfirm = "MessageCallBackType".equals(this.getParameter().get("sourceName"));
        DynamicObject obj = ParameterReader.getBillParameter((String)formId);
        String printcondition = null;
        String printconditionname = null;
        if (obj != null) {
            printcondition = obj.getString("printconditionvalue");
            printconditionname = obj.getString("printcondition");
        }
        if (StringUtils.isNotBlank(printcondition)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)printcondition, FilterCondition.class);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
            FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
            filterBuilder.buildFilter(true);
            QFilter qfFormBillParameter = filterBuilder.getQFilter();
            if (qfFormBillParameter != null) {
                QFilter[] filters = new QFilter[]{qfFormBillParameter, new QFilter(dt.getPrimaryKey().getName(), "in", pkids)};
                Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])filters);
                if (!isConfirm) {
                    if (filterObjs.isEmpty()) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u7b26\u5408%s\u6253\u5370\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u6253\u5370\u3002", (String)"AbstractPrint_28", (String)BOS_NOTEPRINT, (Object[])new Object[0]), printconditionname));
                        return;
                    }
                    if (pkids.size() > filterObjs.size()) {
                        String confirmTip = ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5370\u65f6\uff0c\u6240\u9009\u6570\u636e\u4e2d\u5b58\u5728\u90e8\u5206\u6570\u636e\u4e0d\u6ee1\u8db3\u6253\u5370\u6761\u4ef6\uff0c\u5c06\u53ea\u6253\u5370\u6ee1\u8db3\u6253\u5370\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u6253\u5370", (String)"AbstractPrint_29", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", (AbstractOperate)this);
                        this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, this.getConfirmTypes(), confirmCallBacks);
                        return;
                    }
                } else {
                    pkids = filterObjs.values().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                }
            }
        }
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bos_selecttemplate");
        param.setCustomParam("formid", (Object)formId);
        param.setCustomParam("pkids", pkids);
        param.setCustomParam("type", (Object)"selectTpl");
        param.setCustomParam("extParam", (Object)SerializationUtils.toJsonString(this.getExtParamFromOption()));
        param.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
        if (this.getOption().containsVariable("showprogressrowcount")) {
            param.setCustomParam("showprogressrowcount", (Object)this.getOption().getVariableValue("showprogressrowcount"));
        }
        if ((appLogInfo = this.getAppLogInfo()) != null) {
            param.setCustomParam("appLogInfo", (Object)SerializationUtils.toJsonString((Object)appLogInfo));
        }
        if ((logParam = this.getPrintLogParam(formId)) != null) {
            param.setCustomParam("printLogParam", (Object)SerializationUtils.toJsonString((Object)logParam));
        }
        this.getView().showForm(param);
    }

    private boolean logEnable() {
        return "true".equals(this.getParameter().get("logenable_logEnable"));
    }

    private AppLogInfo getAppLogInfo() {
        if (!this.logEnable()) {
            return null;
        }
        if (PrintOpLogUtils.cancelOpLog()) {
            return null;
        }
        String billNo = this.getBillNo();
        String desc = "";
        desc = StringUtils.isNotBlank((CharSequence)billNo) ? String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f\u3002", (String)"AbstractPrint_44", (String)BOS_NOTEPRINT, (Object[])new Object[0]), billNo, String.valueOf(this.getOperateName())) : String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"AbstractPrint_39", (String)BOS_NOTEPRINT, (Object[])new Object[0]), String.valueOf(this.getOperateName()));
        AppLogInfo appLogInfo = PrintOpLogUtils.buildLogInfo((IFormView)this.getView(), (String)String.valueOf(this.getOperateKey()), (String)String.valueOf(this.getOperateName() == null ? "" : this.getOperateName().getLocaleValue_zh_CN()), (String)billNo);
        return appLogInfo;
    }

    private String getBillNo() {
        String billNo = "";
        try {
            OpFieldValueReader fieldValueReader = OpFieldValueReader.get((IFormView)this.getView());
            if (this.getView() instanceof IListView) {
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                if (selectedRows.size() == 1) {
                    billNo = selectedRows.get(0).getBillNo();
                }
            } else {
                billNo = fieldValueReader.getBillNo(null);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
        return billNo;
    }

    private PrintLogParam getPrintLogParam(String formId) {
        if (!this.logEnable()) {
            return null;
        }
        if (!PrintOpLogUtils.cancelOpLog()) {
            return null;
        }
        PrintLogParam logParam = new PrintLogParam();
        logParam.setEntityId(formId);
        logParam.setOpName(String.valueOf(this.getOperateName()));
        logParam.setPkBillNoMap(this.getPKIdBillNoMap(formId));
        return logParam;
    }

    private String getBillNoPropName(String entityId) {
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (dataEntityType instanceof BillEntityType) {
                BillEntityType billEntityType = (BillEntityType)dataEntityType;
                return billEntityType.getBillNo();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
        return "";
    }

    private Map<Object, String> getPKIdBillNoMap(String entityId) {
        PKFieldProp pkProp;
        String printPkIds;
        HashMap<Object, String> res = new HashMap<Object, String>(16);
        String billNoPropName = this.getBillNoPropName(entityId);
        if (StringUtils.isBlank((CharSequence)billNoPropName)) {
            List<Object> pkIds = this.getPKIds();
            for (Object pkId : pkIds) {
                res.put(pkId, null);
            }
            return res;
        }
        if (this.getOption().containsVariable("printPkIds") && StringUtils.isNotBlank((CharSequence)(printPkIds = this.getOption().getVariableValue("printPkIds")))) {
            try {
                List pkIds = SerializationUtils.fromJsonStringToList((String)printPkIds, Object.class);
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                Map billOBjMap = BusinessDataServiceHelper.loadFromCache((Object[])pkIds.toArray(), (DynamicObjectType)dataEntityType);
                for (Map.Entry entry : billOBjMap.entrySet()) {
                    res.put(entry.getKey(), ((DynamicObject)entry.getValue()).getString(billNoPropName));
                }
                return res;
            }
            catch (Exception e) {
                log.error("printPkIds\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)e);
            }
        }
        if (this.getView() instanceof IMobileView) {
            if (this.getView() instanceof IMobileListView) {
                return res;
            }
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            Object pkValue = dataEntity.getPkValue();
            PKFieldProp pkProp2 = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey();
            if (!pkProp2.getValueComparator().compareValue(pkValue)) {
                res.put(pkValue, dataEntity.getString(billNoPropName));
            }
            return res;
        }
        if (this.getView() instanceof IListView) {
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            if (!listSelectedRowCollection.isEmpty()) {
                for (ListSelectedRow selectedRow : listSelectedRowCollection) {
                    Object pkv = selectedRow.getPrimaryKeyValue();
                    res.put(pkv, selectedRow.getBillNo());
                }
            }
            return res;
        }
        if (this.getView() instanceof IReportView) {
            return res;
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (pkValue != null && !(pkProp = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey()).getValueComparator().compareValue(pkValue)) {
            res.put(pkValue, dataEntity.getString(billNoPropName));
        }
        return res;
    }

    private List<Object> getPKIds() {
        ArrayList<Object> pkids = new ArrayList<Object>();
        if (this.getView() instanceof IMobileView) {
            if (this.getView() instanceof MobileBillView) {
                DynamicObject obj = this.getView().getModel().getDataEntity();
                Object pkValue = this.getView().getModel().getDataEntityType().getPrimaryKey().getValue((Object)obj);
                String defaultPk = "0";
                if (pkValue != null && !defaultPk.equals(pkValue)) {
                    pkids.add(pkValue);
                }
            }
        } else if (this.getView() instanceof IListView) {
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            if (!listSelectedRowCollection.isEmpty()) {
                for (ListSelectedRow listSelectedRowValue : listSelectedRowCollection) {
                    Object pkv = listSelectedRowValue.getPrimaryKeyValue();
                    if (pkids.contains(pkv)) continue;
                    pkids.add(pkv);
                }
            }
        } else if (!(this.getView() instanceof IReportView)) {
            Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
            PKFieldProp pkProp = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey();
            if (pkProp != null && !pkProp.getValueComparator().compareValue(pkValue)) {
                pkids.add(pkValue);
            }
        }
        return pkids;
    }
}

