/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.printop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.operate.printop.AbstractPrint;
import kd.bos.form.operate.printop.OpPrintUtil;
import kd.bos.form.operate.printop.PrintTypes;
import kd.bos.form.plugin.print.OldPrintOperationHelper;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.print.BosPrintBusinessService;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.mvc.list.ListModel;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintParam;
import kd.bos.print.api.PrintTask;
import kd.bos.report.IReportView;
import kd.bos.service.ServiceFactory;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;

public class XlsPrint
extends AbstractPrint {
    private static final Log log = LogFactory.getLog(XlsPrint.class);

    @Override
    protected boolean beforeInvokeOperation(OperationResult opResult) {
        this.printTypes = PrintTypes.Preview;
        if (this.isDynamicForm()) {
            return true;
        }
        return super.beforeInvokeOperation(opResult);
    }

    @Override
    protected OperationResult invokeOperation() {
        OperationResult result = new OperationResult();
        if (this.showSelectPrintForm) {
            return result;
        }
        int selectRows = 0;
        String pkIdsJson = "";
        List<PrintJob> printJobs = this.getPrintJobs();
        String printdataprovidertype = "";
        if (this.getView() instanceof IReportView) {
            printdataprovidertype = "report";
            ReportView rptFormView = (ReportView)this.getView();
            ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
            selectRows = listModel.getRowCount();
        } else if (this.getView() instanceof IListView) {
            FormView formView = (FormView)this.getView();
            ListView listformView = (ListView)formView;
            ListModel listModel = (ListModel)listformView.getListModel();
            MainEntityType entityType = (MainEntityType)listModel.getDataEntityType();
            if (entityType instanceof QueryEntityType) {
                printdataprovidertype = "querylist";
                BillList billList = (BillList)this.getView().getControl("billlistap");
                List selectDataList = (List)billList.getEntryState().get("selDatas");
                Object[] pkArray = new Object[selectDataList.size()];
                int size = selectDataList.size();
                for (int i = 0; i < size; ++i) {
                    ArrayList selectPkList = (ArrayList)selectDataList.get(i);
                    pkArray[i] = selectPkList.get(0);
                }
                List<Object> pkIds = Arrays.asList(pkArray);
                pkIdsJson = SerializationUtils.toJsonString(pkIds);
                selectRows = selectDataList.size();
            } else {
                selectRows = ((IListView)this.getView()).getSelectedRows().size();
            }
        } else {
            List<Object> pkIds = this.getPKIds();
            if (pkIds == null || pkIds.isEmpty()) {
                if (StringUtils.isNotBlank((CharSequence)this.getDefaultTemplateId().toString())) {
                    printdataprovidertype = "dynamic";
                }
            } else {
                selectRows = pkIds.size();
            }
        }
        if (!OpPrintUtil.checkToShowProgress(this.getOption(), this.getFormId(), selectRows)) {
            result = this.downloadXls();
            return result;
        }
        OpPrintUtil.showProgressForm(this, this.getView() instanceof ReportView ? null : printJobs, printdataprovidertype, pkIdsJson, selectRows);
        return result;
    }

    @Override
    protected void afterInvokeOperation(OperationResult opResult) {
        if (opResult.isSuccess() && !this.showSelectPrintForm) {
            if (this.getPrintJobs() == null) {
                return;
            }
            this.addLog();
        }
    }

    private OperationResult downloadXls() {
        OperationResult result = new OperationResult();
        IFormView formview = this.getView();
        try {
            List<PrintJob> oldPrintJobs;
            Map<String, Object> extParamMap = this.getExtParamMap();
            List<PrintJob> printJobs = this.getPrintJobs();
            Map<String, List<PrintJob>> classifyPrintJob = this.classifySortPrintJob(printJobs);
            Lang curLang = RequestContext.get().getLang();
            String printLangStr = (String)this.getPrintSetting().get("printlang");
            if (StringUtils.isNotBlank((CharSequence)printLangStr)) {
                RequestContext.get().setLang(Lang.from((String)printLangStr));
            }
            String printTaskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
            List<PrintJob> newPrintJobs = classifyPrintJob.get("newPrintJobs");
            if (!CollectionUtils.isEmpty(newPrintJobs)) {
                PrintParam printParam = this.buildNewPrintWork(newPrintJobs);
                printParam.setPrintLang(printLangStr);
                printParam.setExtParam(extParamMap);
                BosPrintBusinessService service = (BosPrintBusinessService)ServiceFactory.getService(BosPrintBusinessService.class);
                service.doPrint(printTaskId, (Object)printParam);
            }
            if (!CollectionUtils.isEmpty(oldPrintJobs = classifyPrintJob.get("oldPrintJobs"))) {
                OldPrintOperationHelper.doPrint(printTaskId, "xls", oldPrintJobs, extParamMap);
            }
            RequestContext.get().setLang(curLang);
            PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)printTaskId);
            if (taskResult == null || taskResult.getAttach().isEmpty()) {
                result.setSuccess(false);
                return result;
            }
            String downloadUrl = "api/print/download.do?taskId=%s&attachId=%s";
            for (PrtTaskResult.Attach attach : taskResult.getAttach()) {
                this.getView().download(String.format(downloadUrl, printTaskId, attach.getAttachId()));
            }
        }
        catch (KDException e) {
            result.setSuccess(false);
            log.error("\u6253\u5370\u9884\u89c8\u62a5\u9519: ", (Throwable)e);
            if (e instanceof KDBizException) {
                formview.showTipNotification(e.getMessage());
            } else {
                formview.showErrMessage(e.getMessage(), "");
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.error("\u6253\u5370\u9884\u89c8\u62a5\u9519: ", (Throwable)e);
            throw e;
        }
        return result;
    }

    private PrintParam buildNewPrintWork(List<PrintJob> newPrintJobs) {
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(10);
        for (PrintJob job : newPrintJobs) {
            PrintTask task = new PrintTask();
            task.setPkIds(job.getBillIds());
            task.setFormId(job.getFormId());
            task.setPageId(job.getPageId());
            task.setTplId(String.valueOf(job.getTemplateId()));
            task.setPrintType("billForm");
            taskList.add(task);
        }
        PrintParam param = new PrintParam();
        param.setPageId(((PrintTask)taskList.get(0)).getPageId());
        param.setBillFormId(this.getFormId());
        param.setExpType("xls");
        param.setTaskList(taskList);
        return param;
    }

    private boolean isDynamicForm() {
        boolean isDynamicForm = false;
        isDynamicForm = this.getView() instanceof IListView ? false : (this.getView() instanceof IReportView ? false : (this.getView() instanceof IMobileView ? this.getView() instanceof MobileFormView : !(this.getView() instanceof IBillView)));
        return isDynamicForm;
    }
}

