/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.IUserService;
import kd.bos.print.core.utils.FilterUtil;
import kd.bos.service.ITimeService;
import kd.bos.service.ServiceFactory;

public class FilterEdit
extends AbstractFormPlugin {
    private static final String BOS_NOTEPRINT = "bos-noteprint";
    private static final String KEY_FFILTERGRID = "filtergridap";
    private static final String FORMID = "formid";
    private static final IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
    private static final Set<String> HIDE_FIELD_SET = new HashSet<String>(2);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isGridFilter()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"name"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object entityNumber = this.getView().getFormShowParameter().getCustomParams().get(FORMID);
        if (StringUtils.isNotBlank(entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber.toString());
            EntityTypeUtil helper = new EntityTypeUtil();
            boolean isGridFilter = this.isGridFilter();
            List cols = this.getFilterColumns((IDataEntityType)entityType, !isGridFilter);
            cols = this.hideFieldWhenExtUser(cols);
            if (isGridFilter) {
                String filterEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("filterEntityNumber");
                cols = FilterUtil.hideFieldWhenDataLayOutFilter((String)filterEntityNumber, (MainEntityType)entityType, cols);
                Set<String> timeFieldSet = this.getTimeFieldSet(cols);
                this.getPageCache().put("timeFieldSet", SerializationUtils.toJsonString(timeFieldSet));
            }
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FFILTERGRID);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(entityNumber.toString());
        }
        Object name = this.getView().getFormShowParameter().getCustomParams().get("name");
        this.getModel().setValue("name", name);
    }

    private List<Map<String, Object>> getFilterColumns(IDataEntityType dataEntityType, boolean isOnlyMainEntityField) {
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>(10);
        MainEntityType mainType = (MainEntityType)dataEntityType;
        List<FilterField> filterFields = this.getFilterFields((IDataEntityType)mainType, isOnlyMainEntityField);
        for (FilterField filterField : filterFields) {
            Map filterColumn = filterField.createFilterColumn();
            filterColumns.add(filterColumn);
        }
        return filterColumns;
    }

    private List<FilterField> getFilterFields(IDataEntityType dataEntityType, boolean isOnlyMainEntityField) {
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter(dataEntityType);
        getFilterFieldsParameter.setbCompatibleProductMode(false);
        getFilterFieldsParameter.setOnlyMainEntityField(isOnlyMainEntityField);
        getFilterFieldsParameter.setNeedMulBasedataField(true);
        EntityTypeUtil helper = new EntityTypeUtil();
        return EntityTypeUtil.getFilterFields((GetFilterFieldsParameter)getFilterFieldsParameter);
    }

    private Set<String> getTimeFieldSet(List<Map<String, Object>> cols) {
        HashSet<String> timeFieldSet = new HashSet<String>(16);
        for (Map<String, Object> map : cols) {
            if (!"time".equals(map.get("type"))) continue;
            timeFieldSet.add(String.valueOf(map.get("fieldName")));
        }
        return timeFieldSet;
    }

    private boolean isGridFilter() {
        return this.getView().getFormShowParameter().getCustomParams().containsKey("filterEntityNumber");
    }

    private List<Map<String, Object>> hideFieldWhenExtUser(List<Map<String, Object>> cols) {
        if (this.isInnerUser()) {
            return cols;
        }
        ArrayList<Map<String, Object>> newCols = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> colMap : cols) {
            String entityId = String.valueOf(colMap.get("entityId"));
            if (HIDE_FIELD_SET.contains(entityId)) continue;
            newCols.add(colMap);
        }
        return newCols;
    }

    private boolean isInnerUser() {
        ArrayList<Long> userId = new ArrayList<Long>(1);
        long currUserId = RequestContext.get().getCurrUserId();
        userId.add(currUserId);
        Map userBaseTypeByIds = userService.getUserBaseTypeByIds(userId);
        Integer type = (Integer)userBaseTypeByIds.get(currUserId);
        boolean isInnerUser = "100".equals(String.valueOf(type)) || "300".equals(String.valueOf(type));
        return isInnerUser;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FFILTERGRID);
        FilterCondition filterCondition = this.loadFilter();
        if (filterCondition == null) {
            return;
        }
        FilterCondition toBuildFilterCondition = this.getFilterCondition(filterCondition);
        filterGrid.SetValue(filterCondition);
        Object formid = this.getView().getFormShowParameter().getCustomParams().get(FORMID);
        if (!ObjectUtils.isEmpty(formid)) {
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)((String)formid));
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterBuilder filterBuilder = new FilterBuilder(dataType, toBuildFilterCondition, false);
            filterBuilder.setTimeService((ITimeService)this.getView().getService(ITimeService.class));
            filterBuilder.setUserService((kd.bos.service.IUserService)this.getView().getService(kd.bos.service.IUserService.class));
            try {
                filterBuilder.buildFilter(false);
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            this.getModel().setValue("description", (Object)filterBuilder.getFilterString());
            this.getView().updateView("description");
        }
    }

    private FilterCondition getFilterCondition(FilterCondition filterCondition) {
        if (filterCondition == null) {
            return null;
        }
        if (this.isGridFilter()) {
            String timeFieldSetJson = this.getPageCache().get("timeFieldSet");
            Set timeFieldSet = (Set)SerializationUtils.fromJsonString((String)timeFieldSetJson, Set.class);
            if (CollectionUtils.isEmpty((Collection)timeFieldSet)) {
                return filterCondition;
            }
            List filterRow = filterCondition.getFilterRow();
            ArrayList<SimpleFilterRow> newFilterRow = new ArrayList<SimpleFilterRow>(filterRow.size());
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                SimpleFilterRow clone = simpleFilterRow.clone();
                if (timeFieldSet.contains(clone.getFieldName())) {
                    List valueList = clone.getValue();
                    ArrayList<FilterValue> newValueList = new ArrayList<FilterValue>(valueList.size());
                    for (FilterValue filterValue : valueList) {
                        FilterValue newValue = new FilterValue();
                        newValue.setId(filterValue.getId());
                        newValue.setValue((Object)"0");
                        newValueList.add(newValue);
                    }
                    clone.setValue(newValueList);
                }
                newFilterRow.add(clone);
            }
            FilterCondition condition = new FilterCondition();
            condition.setFilterRow(newFilterRow);
            return condition;
        }
        return filterCondition;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.getDefault())) {
            case "btnok": {
                FilterCondition filterCondition = this.getFilter();
                if (this.isGridFilter() && filterCondition != null && filterCondition.getFilterRow().size() > 5) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5927\u652f\u63015\u4e2a\u6761\u4ef6\u3002", (String)"FilterEdit_0", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                    return;
                }
                FilterCondition toBuildFilterCondition = this.getFilterCondition(filterCondition);
                Object formid = this.getView().getFormShowParameter().getCustomParams().get(FORMID);
                MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)((String)formid));
                FilterBuilder filterBuilder = new FilterBuilder(dataType, toBuildFilterCondition, false);
                try {
                    filterBuilder.buildFilter(false);
                }
                catch (Exception ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                    return;
                }
                String filter = "";
                if (filterCondition != null) {
                    filter = SerializationUtils.toJsonString((Object)filterCondition);
                }
                HashMap<String, Object> para = new HashMap<String, Object>();
                para.put("name", this.getModel().getValue("name"));
                para.put("condition", filter);
                para.put("dataGridId", this.getView().getFormShowParameter().getCustomParam("dataGridId"));
                this.getView().returnDataToParent(para);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FFILTERGRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private FilterCondition loadFilter() {
        Object condition = this.getView().getFormShowParameter().getCustomParams().get("condition");
        if (StringUtils.isNotBlank(condition)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)condition.toString(), FilterCondition.class);
            return filterCondition;
        }
        return null;
    }

    static {
        HIDE_FIELD_SET.add("bd_supplier");
        HIDE_FIELD_SET.add("bd_bizpartner");
        HIDE_FIELD_SET.add("bos_user");
        HIDE_FIELD_SET.add("bos_org");
        HIDE_FIELD_SET.add("bd_customer");
        HIDE_FIELD_SET.add("bos_adminorg_structure");
        HIDE_FIELD_SET.add("srm_supplier");
        HIDE_FIELD_SET.add("perm_pswstrategy");
        HIDE_FIELD_SET.add("srm_imporvebillno");
        HIDE_FIELD_SET.add("pbd_certificationapplyno");
        HIDE_FIELD_SET.add("srm_aptitudebillno");
        HIDE_FIELD_SET.add("pds_tplconfig");
        HIDE_FIELD_SET.add("pur_bizperson");
        HIDE_FIELD_SET.add("bos_user_contacttype");
        HIDE_FIELD_SET.add("scp_bizperson");
        HIDE_FIELD_SET.add("pur_supuser");
        HIDE_FIELD_SET.add("bd_operatorgroup");
        HIDE_FIELD_SET.add("src_projectf7");
        HIDE_FIELD_SET.add("src_supplier");
        HIDE_FIELD_SET.add("pds_purdepart");
    }
}

