/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.tongtech.backport.java.util.Collections;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.MobileFormPosition;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.CustomParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.print.PrintPreviewNewPlugin;
import kd.bos.form.plugin.print.PrintSettingPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.ILoginUserService;
import kd.bos.login.service.dto.AppType;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.utils.HexUtil;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.url.UrlService;

public class MobilePrintSettingPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener,
IConfirmCallBack {
    private static final String TEMPLATE = "template";
    private static final String DEFAULTPRINTER = "defaultprinter";
    public static final String ESC_TPRINTER = "escprinter";
    private static final String ENTITYID = "entityid";
    private static final String PRINTSERVICEID = "printserviceid";
    private static final String SERVICEID = "serviceid";
    public static final String PRINT_MODEL = "printmodel";
    private static final String BLUE_TOOTH_PRINT = "1";
    private static final String TEMPLATE_CACHE_KEY = "TEMPLATE_CACHE_KEY";
    private static final String TEMPLATE_CACHE_KEY_1 = "TEMPLATE_CACHE_KEY_1";
    private static final String IMAGE_AP = "imageap";
    private static final String DEFAULT_IMAGE = "defaultimage";
    private static final int maxWidth = 340;
    private static final int maxHeight = 344;
    private static final String CONNECT_BLUE_TOOTH = "connectBluetooth";
    public static final String OPEN_BLUE_TOOTH = "openBluetooth";
    public static final String DEVICE_LIST = "deviceList";
    private static final String BLUETOOTH_PRINTER_LIST = "bluetoothPrinterList";
    private static Log log = LogFactory.getLog(MobilePrintSettingPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit serviceBsd;
        BasedataEdit printerBsd = (BasedataEdit)this.getView().getControl(DEFAULTPRINTER);
        if (printerBsd != null) {
            printerBsd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((serviceBsd = (BasedataEdit)this.getView().getControl(PRINTSERVICEID)) != null) {
            serviceBsd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"btnok", "btncancel", "btprint", "esclabel", "escvectorap"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] printPrinter;
        String taskId;
        super.afterCreateNewData(e);
        Image imageFlex = (Image)this.getControl(DEFAULT_IMAGE);
        imageFlex.setUrl("/images/mobile/emotion/pt_nodata_184_104.png");
        Object taskObj = this.getView().getFormShowParameter().getCustomParams().get("taskId");
        if (taskObj != null && StringUtils.isNotBlank((CharSequence)(taskId = taskObj.toString()))) {
            this.getPageCache().put("taskId", taskId);
            int curIndex = 1;
            Tuple tuple = PrtTaskResultServiceHelper.loopGetPrtResult((String)(taskId + curIndex), (long)5000L);
            if (tuple.item2 != null) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{DEFAULT_IMAGE});
                PrintPreviewNewPlugin.createImageAp((Container)this.getControl("imageflex"), taskId, curIndex, ((PrtTaskResult.Attach)tuple.item2).getExtParam(), 340, 344, 0, 0);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"nodata"});
            }
        }
        String entityFormId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYID);
        String settingData = this.getSettingData();
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            this.initSetting(settingData);
        } else {
            String defaultTemplateId = PrintSettingPlugin.getManageDefaultTemplateId(entityFormId);
            if (StringUtils.isNotBlank((CharSequence)defaultTemplateId)) {
                this.getModel().setValue(TEMPLATE, (Object)defaultTemplateId);
            }
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        Map<String, String> printTpls = this.getTemplates(entityFormId, appId);
        this.createTemplateComboEdit(printTpls);
        try {
            AppType appType = ((ILoginUserService)ServiceFactory.getService(ILoginUserService.class)).getAppTypeFromSession(RequestContext.get().getGlobalSessionId());
            Map customParam = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
            String openMobileBlueTooth = (String)customParam.get("BOS_MOBILE_BLUETOOTH_PRINT");
            if (!"true".equals(openMobileBlueTooth) && appType != AppType.WeCom) {
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl(PRINT_MODEL);
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1);
                ComboItem item = new ComboItem();
                item.setValue("0");
                item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e91\u6253\u5370", (String)"MobilePrintSettingPlugin_15", (String)"bos-noteprint", (Object[])new Object[0])));
                comboItems.add(item);
                comboEdit.setComboItems(comboItems);
                this.getModel().setValue(PRINT_MODEL, (Object)"0");
            }
        }
        catch (Exception exp) {
            log.warn((Throwable)exp);
        }
        DynamicObject[] printServices = this.getPrintServices();
        if (printServices.length == 1) {
            this.getModel().setValue(PRINTSERVICEID, printServices[0].get("id"));
        }
        if ((printPrinter = this.getPrintPrinter()).length == 1) {
            this.getModel().setValue(DEFAULTPRINTER, printPrinter[0].get("id"));
        }
    }

    private void createTemplateComboEdit(Map<String, String> printTpls) {
        if (printTpls == null || printTpls.size() == 0) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(TEMPLATE);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, String> entry : printTpls.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private boolean isBluetoothPrint() {
        return BLUE_TOOTH_PRINT.equals(this.getModel().getValue(PRINT_MODEL));
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (IMAGE_AP.equals(e.getKey())) {
            Image image = new Image();
            image.setKey(IMAGE_AP);
            image.setView(this.getView());
            image.addClickListener((ClickListener)this);
            e.setControl((Control)image);
        }
    }

    private String getSettingData() {
        String entityFormId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYID);
        String userId = RequestContext.get().getUserId();
        String key = entityFormId + "_printsetting";
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        return settingData;
    }

    public void click(EventObject evt) {
        String controlKey;
        Control control = (Control)evt.getSource();
        switch (controlKey = control.getKey()) {
            case "btnok": {
                this.saveSetting();
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btprint": {
                OperationResult result = this.doPrint();
                if (result != null && result.isSuccess()) break;
                return;
            }
            case "imageap": {
                String taskId = this.getView().getPageCache().get("taskId");
                String attachId = taskId + BLUE_TOOTH_PRINT;
                String downloadUrl = UrlService.getDomainContextUrl() + "/print/download.do?attachId=%s&isMobile=true";
                downloadUrl = EncreptSessionUtils.encryptSession((String)String.format(downloadUrl, attachId));
                HashMap<String, Object> fileParam = new HashMap<String, Object>(8);
                String src = downloadUrl;
                fileParam.put("fileId", "rc-upload-" + attachId);
                fileParam.put("fileExt", "png");
                fileParam.put("downloadUrl", src);
                fileParam.put("previewUrl", src);
                fileParam.put("urlList", new String[]{src});
                this.getView().previewAttachment(fileParam);
                return;
            }
            case "esclabel": 
            case "escvectorap": {
                String deviceList = this.getPageCache().get(DEVICE_LIST);
                if (StringUtils.isNotBlank((CharSequence)deviceList)) {
                    this.showBlueToothPrinterList(SerializationUtils.fromJsonStringToList((String)deviceList, Map.class));
                    break;
                }
                this.openBluetooth();
                break;
            }
        }
    }

    private OperationResult doPrint() {
        this.saveSetting();
        Object printerObj = this.getModel().getValue(DEFAULTPRINTER);
        Object templateObj = this.getModel().getValue(TEMPLATE);
        Object serviceObj = this.getModel().getValue(PRINTSERVICEID);
        Object printModelObj = this.getModel().getValue(PRINT_MODEL);
        if (StringUtils.isBlank((Object)printModelObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u65b9\u5f0f\u3002", (String)"MobilePrintSettingPlugin_8", (String)"bos-noteprint", (Object[])new Object[0]));
            return null;
        }
        if (StringUtils.isBlank((Object)templateObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"MobilePrintSettingPlugin_9", (String)"bos-noteprint", (Object[])new Object[0]));
            return null;
        }
        if (!BLUE_TOOTH_PRINT.equals(printModelObj) && StringUtils.isBlank((Object)serviceObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u529e\u516c\u70b9\u3002", (String)"MobilePrintSettingPlugin_10", (String)"bos-noteprint", (Object[])new Object[0]));
            return null;
        }
        if (!BLUE_TOOTH_PRINT.equals(printModelObj) && printerObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u673a\u3002", (String)"MobilePrintSettingPlugin_11", (String)"bos-noteprint", (Object[])new Object[0]));
            return null;
        }
        IFormView parentView = this.getParentView();
        OperateOption option = OperateOption.create();
        boolean bluetoothPrint = this.isBluetoothPrint();
        String deviceCode = null;
        Object deviceName = null;
        if (bluetoothPrint && StringUtils.isBlank((CharSequence)(deviceCode = this.getPageCache().get("deviceCode"))) && StringUtils.isBlank((Object)(deviceName = this.getModel().getValue(ESC_TPRINTER)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u84dd\u7259\u6253\u5370\u673a\u3002", (String)"MobilePrintSettingPlugin_5", (String)"bos-noteprint", (Object[])new Object[0]));
            return null;
        }
        option.setVariableValue("AllowBlueMobilePrint", "true");
        OperationResult result = parentView.invokeOperation("print", option);
        String taskId = (String)result.getCustomData().get("taskId");
        if (bluetoothPrint && StringUtils.isNotBlank((CharSequence)taskId)) {
            this.sendPlayLoad(taskId, deviceCode, deviceName == null ? "" : deviceName.toString());
        }
        this.getView().sendFormAction(parentView);
        return result;
    }

    private void bluetoothPrintData(String playLoad, String deviceCode, String deviceName) {
        HashMap<String, Object> parameter = new HashMap<String, Object>(2);
        parameter.put("method", "bluetoothPrintData");
        HashMap<String, String> argsMap = new HashMap<String, String>(1);
        argsMap.put("payload", playLoad);
        argsMap.put("deviceCode", deviceCode);
        argsMap.put("deviceName", deviceName);
        parameter.put("args", argsMap);
        this.getView().executeClientCommand("callYZJApi", new Object[]{parameter});
    }

    private void sendPlayLoad(String taskId, String deviceCode, String deviceName) {
        PrtTaskResult prtAttach = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
        for (PrtTaskResult.Attach attach : prtAttach.getAttach()) {
            String firstFilePath = attach.getFilePath();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    InputStream inputStream = PrintFileUtil.getFileInputStream((String)firstFilePath, (String)prtAttach.getDiskType());
                    Throwable throwable2 = null;
                    try {
                        StreamUtil.copy((InputStream)inputStream, (OutputStream)baos, (int)1024);
                        StreamUtil.closeStream((InputStream)inputStream);
                        byte[] bytes = baos.toByteArray();
                        if (bytes.length <= 0) continue;
                        this.bluetoothPrintData(HexUtil.encodeHexStr((byte[])bytes), deviceCode, deviceName);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (baos == null) continue;
                    if (throwable != null) {
                        try {
                            baos.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    baos.close();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    private IFormView getParentView() {
        try {
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            }
            return parentView;
        }
        catch (Exception e) {
            return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String properyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (DEFAULTPRINTER.equals(properyName)) {
            Object newValue;
            if (changeSet != null && changeSet.length > 0 && (newValue = changeSet[0].getNewValue()) != null) {
                DynamicObject dynamicObject = (DynamicObject)newValue;
                dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)dynamicObject.getPkValue(), (String)"bos_cloudprintmanage");
                this.getModel().setValue(PRINTSERVICEID, dynamicObject.get("group_id"));
            }
        } else if (PRINTSERVICEID.equals(properyName) && changeSet != null && changeSet.length > 0 && changeSet[0].getOldValue() != null) {
            this.getModel().setValue(DEFAULTPRINTER, null);
        } else if (TEMPLATE.equals(properyName)) {
            Object newValue;
            if (changeSet != null && changeSet.length > 0 && (newValue = changeSet[0].getNewValue()) != null) {
                IFormView parentView = this.getParentView();
                Map customParams = parentView.getFormShowParameter().getCustomParams();
                customParams.put("SKIP_VALIDATE", "true");
                customParams.put("SPECIFY_TEMPLATE", newValue);
                Object pkValue = this.getParentView().getModel().getDataEntity().getPkValue();
                customParams.put("SPECIFY_PKID", pkValue);
                try {
                    OperationResult operationResult = parentView.invokeOperation("clientpreview");
                    Map customData = operationResult.getCustomData();
                    String taskId = (String)customData.get("taskId");
                    if (taskId != null) {
                        int curIndex = 1;
                        Tuple tuple = PrtTaskResultServiceHelper.loopGetPrtResult((String)(taskId + curIndex), (long)5000L);
                        if (tuple.item2 != null) {
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{DEFAULT_IMAGE});
                            PrintPreviewNewPlugin.createImageAp((Container)this.getControl("imageflex"), taskId, curIndex, ((PrtTaskResult.Attach)tuple.item2).getExtParam(), 340, 344, 0, 0);
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"nodata"});
                        }
                        this.getPageCache().put("taskId", taskId);
                    }
                }
                catch (Exception exp) {
                    log.error((Throwable)exp);
                    ((Container)this.getControl("imageflex")).deleteControls(new String[]{IMAGE_AP});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{DEFAULT_IMAGE});
                }
            }
        } else if (PRINT_MODEL.equals(properyName)) {
            Map<String, String> printTpls = this.getTemplates((String)this.getView().getFormShowParameter().getCustomParam(ENTITYID), this.getView().getFormShowParameter().getAppId());
            this.createTemplateComboEdit(printTpls);
        }
    }

    private void openBluetooth() {
        HashMap<String, Object> parameter = new HashMap<String, Object>(2);
        parameter.put("method", OPEN_BLUE_TOOTH);
        parameter.put("args", new HashMap(0));
        this.getView().executeClientCommand("callYZJApi", new Object[]{parameter});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object serviceObj;
        MobileListShowParameter para = (MobileListShowParameter)evt.getFormShowParameter();
        para.setPosition(MobileFormPosition.Middle);
        if ("bos_cloudprintmanage".equalsIgnoreCase(para.getBillFormId()) && (serviceObj = this.getModel().getValue(PRINTSERVICEID)) != null) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            QFilter filter = new QFilter("group", "=", ((DynamicObject)serviceObj).getPkValue());
            filters.add(filter);
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bos_cloudprintmanage", (Long)RequestContext.get().getOrgId());
            filters.add(orgFilter);
            ListFilterParameter listFilterParameter = new ListFilterParameter(filters, null);
            para.setListFilterParameter(listFilterParameter);
            DynamicObject[] printPrinter = this.getPrintPrinter();
            if (printPrinter.length == 1) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u6709\u4e00\u4e2a\u6253\u5370\u673a\u3002", (String)"MobilePrintSettingPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (printPrinter.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u6253\u5370\u673a\u3002", (String)"MobilePrintSettingPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
        if ("bos_cloudprintservice".equalsIgnoreCase(para.getBillFormId())) {
            DynamicObject[] printServices = this.getPrintServices();
            if (printServices.length == 1) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u6709\u4e00\u4e2a\u529e\u516c\u70b9\u3002", (String)"MobilePrintSettingPlugin_3", (String)"bos-noteprint", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (printServices.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u529e\u516c\u70b9\u3002", (String)"MobilePrintSettingPlugin_4", (String)"bos-noteprint", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (CONNECT_BLUE_TOOTH.equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            this.openBluetooth();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map printer;
        super.closedCallBack(event);
        if (BLUETOOTH_PRINTER_LIST.equals(event.getActionId()) && (printer = (Map)event.getReturnData()) != null) {
            String name = (String)printer.get("Name");
            String deviceCode = (String)printer.get("Code");
            this.escLabelSetText(name);
            this.getModel().setValue(ESC_TPRINTER, (Object)name);
            this.getPageCache().put("deviceCode", deviceCode);
            this.getView().updateView(ESC_TPRINTER);
        }
    }

    private void escLabelSetText(String name) {
        String color;
        Label escLabel = (Label)this.getView().getControl("esclabel");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"MobilePrintSettingPlugin_7", (String)"bos-noteprint", (Object[])new Object[0]);
            color = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiQge1xuwqDCoGNvbG9yOiNjY2NjY2MgIWltcG9ydGFudDtcbsKgfSJ9";
        } else {
            color = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiQge1xuwqDCoGNvbG9yOnJnYigxMTksIDExOSwgMTE5KSAhaW1wb3J0YW50O1xuwqB9In0=";
        }
        escLabel.setText(name);
        escLabel.setCustomeStyles(color);
        this.getView().updateControlMetadata("esclabel", Collections.singletonMap((Object)"cstyles", (Object)escLabel.getCustomeStyles()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void customEvent(CustomEventArgs e) {
        Map resultMap;
        String eventName = e.getEventName();
        if (OPEN_BLUE_TOOTH.equals(eventName)) {
            Map errData;
            String eventArgs = e.getEventArgs();
            if (eventArgs == null) return;
            Map resultMap2 = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            if (resultMap2 == null) return;
            Object success = resultMap2.get("success");
            if (success == null) return;
            if (!Boolean.parseBoolean(success.toString()) && (errData = (Map)resultMap2.get("data")) != null) {
                this.showErrorMsg(errData.get("errCode"));
                return;
            }
            if (!Boolean.parseBoolean(success.toString())) return;
            List devices = (List)resultMap2.get("data");
            if (devices == null) return;
            this.showBlueToothPrinterList(devices);
            return;
        }
        if (!"bluetoothPrintData".equals(eventName)) return;
        String eventArgs = e.getEventArgs();
        Object success = null;
        if (eventArgs != null && (resultMap = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class)) != null) {
            Map data;
            Object v = resultMap.get("success");
            success = v;
            if (v != null && !Boolean.parseBoolean(success.toString()) && (data = (Map)resultMap.get("data")) != null) {
                this.showErrorMsg(data.get("errCode"));
                return;
            }
        }
        if (!Boolean.parseBoolean(String.valueOf(success))) return;
        String message = ResManager.loadKDString((String)"\u6253\u5370\u8bf7\u6c42\u53d1\u9001\u6210\u529f\u3002", (String)"Print_7", (String)"bos-noteprint", (Object[])new Object[0]);
        this.getView().showSuccessNotification(message);
    }

    private void showErrorMsg(Object errCode) {
        if (errCode == null) {
            errCode = "-1";
        }
        switch (errCode.toString()) {
            case "10000": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316\u84dd\u7259\u9002\u914d\u5668\u3002", (String)"MobilePrintSettingPlugin_12", (String)"bos-noteprint", (Object[])new Object[0]));
                this.clearCurrentPrinter();
                break;
            }
            case "10001": 
            case "10002": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u624b\u673a\u8bbe\u7f6e\u4e2d\u5f00\u542f\u4f01\u4e1a\u5fae\u4fe1\u7684\u84dd\u7259\u8bbf\u95ee\u3002", (String)"MobilePrintSettingPlugin_13", (String)"bos-noteprint", (Object[])new Object[0]));
                this.clearCurrentPrinter();
                break;
            }
            default: {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u84dd\u7259\u6253\u5370\u673a\u5df2\u65ad\u5f00\uff0c\u8bf7\u91cd\u65b0\u8fde\u63a5\u3002", (String)"MobilePrintSettingPlugin_14", (String)"bos-noteprint", (Object[])new Object[0]));
                this.clearCurrentPrinter();
            }
        }
    }

    private void clearCurrentPrinter() {
        Object escPrinter = this.getModel().getValue(ESC_TPRINTER);
        this.getModel().setValue(ESC_TPRINTER, null);
        this.escLabelSetText(null);
        String deviceList = this.getPageCache().get(DEVICE_LIST);
        if (StringUtils.isNotBlank((CharSequence)deviceList)) {
            List devices = SerializationUtils.fromJsonStringToList((String)deviceList, Map.class);
            devices.removeIf(next -> next != null && StringUtils.equals((CharSequence)((CharSequence)next.get("Name")), (CharSequence)String.valueOf(escPrinter)));
            this.getPageCache().put(DEVICE_LIST, SerializationUtils.toJsonString((Object)devices));
        }
    }

    private void showBlueToothPrinterList(List<Map<String, String>> devices) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setFormId("bos_mobileblueprinter");
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setCustomParam("rows", devices);
        this.getPageCache().put(DEVICE_LIST, SerializationUtils.toJsonString(devices));
        Object escPrinter = this.getModel().getValue(ESC_TPRINTER);
        if (escPrinter != null) {
            Iterator<Map<String, String>> iterator = devices.iterator();
            while (iterator.hasNext()) {
                String code;
                Map<String, String> selectRow = iterator.next();
                String deviceCode = this.getPageCache().get("deviceCode");
                boolean match = deviceCode != null ? StringUtils.equals((CharSequence)deviceCode, (CharSequence)selectRow.get("Code")) : StringUtils.equals((CharSequence)escPrinter.toString(), (CharSequence)selectRow.get("Name"));
                if (!match) continue;
                HashMap<String, String> row = new HashMap<String, String>(2);
                String name = selectRow.get("Name");
                if (name != null) {
                    row.put("Name", name);
                }
                if ((code = selectRow.get("Code")) != null) {
                    row.put("Code", code);
                }
                mobileFormShowParameter.setCustomParam("selectedRow", row);
                iterator.remove();
                break;
            }
        }
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BLUETOOTH_PRINTER_LIST));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    private void initSetting(String settingData) {
        Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        Object templateId = jsonData.get("templateid");
        Object printerId = jsonData.get("printerid");
        this.getModel().setValue(TEMPLATE, templateId);
        this.getModel().setValue(PRINTSERVICEID, jsonData.get(SERVICEID));
        this.getModel().setValue(PRINT_MODEL, jsonData.get(PRINT_MODEL));
        if (this.isBluetoothPrint()) {
            printerId = jsonData.get(ESC_TPRINTER);
            this.getModel().setValue(ESC_TPRINTER, printerId);
            if (StringUtils.isNotBlank(printerId)) {
                this.escLabelSetText(printerId.toString());
            }
        } else {
            PrintClientUtil.CloudPrinter printer;
            this.getModel().setValue(DEFAULTPRINTER, printerId);
            if (printerId != null && (printer = PrintClientUtil.getCloudPrinter((long)Long.parseLong(printerId.toString()))) != null) {
                this.getModel().setValue(PRINTSERVICEID, (Object)printer.getServiceId());
            }
        }
    }

    private void saveSetting() {
        String jsonData = this.buildJsonData();
        String entityFormId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYID);
        String key = entityFormId + "_printsetting";
        UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)key, (String)jsonData);
    }

    private String buildJsonData() {
        String settingData = this.getSettingData();
        LinkedHashMap<String, Object> data = StringUtils.isNotBlank((CharSequence)settingData) ? (LinkedHashMap<String, Object>)SerializationUtils.fromJsonString((String)settingData, Map.class) : new LinkedHashMap<String, Object>(4);
        Object printerObj = this.getModel().getValue(DEFAULTPRINTER);
        Object templateObj = this.getModel().getValue(TEMPLATE);
        Object serviceObj = this.getModel().getValue(PRINTSERVICEID);
        Object printModelObj = this.getModel().getValue(PRINT_MODEL);
        Object escPrinterObj = this.getModel().getValue(ESC_TPRINTER);
        data.put("templateid", templateObj);
        if (BLUE_TOOTH_PRINT.equals(printModelObj)) {
            data.put(ESC_TPRINTER, escPrinterObj);
        } else if (printerObj != null) {
            data.put("printerid", ((DynamicObject)printerObj).getPkValue());
        } else {
            data.put("printerid", null);
        }
        if (serviceObj != null) {
            data.put(SERVICEID, ((DynamicObject)serviceObj).getPkValue());
        } else {
            data.put(SERVICEID, null);
        }
        data.put(PRINT_MODEL, printModelObj);
        return SerializationUtils.toJsonString(data);
    }

    private Map<String, String> getTemplates(String formId, String appId) {
        String cacheJson = this.isBluetoothPrint() ? this.getPageCache().get(TEMPLATE_CACHE_KEY_1) : this.getPageCache().get(TEMPLATE_CACHE_KEY);
        if (StringUtils.isNotBlank((CharSequence)cacheJson)) {
            Map templatesMap = (Map)SerializationUtils.fromJsonString((String)cacheJson, Map.class);
            return templatesMap;
        }
        Tuple<Map<String, String>, Map<String, String>> templateTuple = PrintSettingPlugin.getTemplates(formId, appId, true);
        Map normal = (Map)templateTuple.item1;
        Map blueTooth = (Map)templateTuple.item2;
        if (normal != null) {
            if (blueTooth != null) {
                normal.putAll(blueTooth);
            }
            this.getPageCache().put(TEMPLATE_CACHE_KEY, SerializationUtils.toJsonString((Object)normal));
        }
        if (blueTooth != null) {
            this.getPageCache().put(TEMPLATE_CACHE_KEY_1, SerializationUtils.toJsonString((Object)blueTooth));
        }
        if (this.isBluetoothPrint()) {
            return blueTooth;
        }
        return normal;
    }

    private DynamicObject[] getPrintServices() {
        DynamicObject[] printServices = BusinessDataServiceHelper.load((String)"bos_cloudprintservice", (String)"FNumber", (QFilter[])new QFilter[]{new QFilter("Enable", "=", (Object)BLUE_TOOTH_PRINT)});
        return printServices;
    }

    private DynamicObject[] getPrintPrinter() {
        DynamicObject[] printPrinter = BusinessDataServiceHelper.load((String)"bos_cloudprintmanage", (String)"FNumber", (QFilter[])new QFilter[]{new QFilter("Enable", "=", (Object)BLUE_TOOTH_PRINT)});
        return printPrinter;
    }
}

