/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListModel;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.PrintJob;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.print.validation.FieldScanner;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.print.dataprovider.PrintDataProviderFactory;

public class OldPrintOperationHelper {
    private static final Log log = LogFactory.getLog(OldPrintOperationHelper.class);

    public static String doPrint(String taskId, String printType, List<PrintJob> jobs, Map<String, Object> extParam) {
        if (extParam == null) {
            extParam = new HashMap<String, Object>();
        }
        extParam.put("isBizOp", true);
        return PrintServiceHelper.execPrint(taskId, printType, jobs, extParam);
    }

    public static String doPrint(String taskId, String printType, List<PrintJob> jobs) {
        return OldPrintOperationHelper.doPrint(taskId, printType, jobs, null);
    }

    public static String printOldTpl(PrintOperationHelper.PrintOperateParam param) {
        String pageId = param.getPageId();
        String formId = param.getFormId();
        String printTaskId = param.getPrintTaskId();
        String defaultTplId = param.getDefaultTplId();
        String printType = param.getPrintType();
        List<Object> pkIds = param.getPkIds();
        List<PrintJob> printJobs = param.getPrintJobs();
        if (printJobs != null) {
            return OldPrintOperationHelper.doPrint(printTaskId, "pdf", printJobs);
        }
        if (StringUtils.isBlank((CharSequence)defaultTplId)) {
            return printTaskId;
        }
        if ("report".equals(printType)) {
            PrintMetadata pMeta = OldPrintTemplateUtil.findOldPrintMetadata((String)defaultTplId);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            IPrintDataProvider provider = OldPrintOperationHelper.createDataProvider("report", pageId, mainEntityType, pMeta);
            ReportView rptFormView = (ReportView)OldPrintOperationHelper.getFormView(pageId);
            provider.setQueryParam(rptFormView.getQueryParam());
            String tplFromId = MetadataDao.getNumberById((String)defaultTplId);
            return OldPrintOperationHelper.doPrint(printTaskId, "pdf", OldPrintOperationHelper.createPrtJob(pageId, formId, tplFromId, "", provider));
        }
        if ("querylist".equals(printType)) {
            FormView formView = (FormView)OldPrintOperationHelper.getFormView(pageId);
            ListView listformView = (ListView)formView;
            ListModel listModel = (ListModel)listformView.getListModel();
            MainEntityType entityType = (MainEntityType)listModel.getDataEntityType();
            String tplFromId = MetadataDao.getNumberById((String)defaultTplId);
            PrintMetadata pMeta = OldPrintTemplateUtil.findOldPrintMetadata((String)defaultTplId);
            IPrintDataProvider provider = OldPrintOperationHelper.createDataProvider("querylist", pageId, entityType, pMeta);
            provider.setPkIds(pkIds);
            return OldPrintOperationHelper.doPrint(printTaskId, "pdf", OldPrintOperationHelper.createPrtJob(pageId, formId, tplFromId, "", provider));
        }
        if ("dynamic".equals(printType)) {
            String tplFromId = MetadataDao.getNumberById((String)defaultTplId);
            PrintMetadata pMeta = OldPrintTemplateUtil.findOldPrintMetadata((String)defaultTplId);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            IPrintDataProvider provider = OldPrintOperationHelper.createDataProvider("dynamic", pageId, mainEntityType, pMeta);
            return OldPrintOperationHelper.doPrint(printTaskId, "pdf", OldPrintOperationHelper.createPrtJob(pageId, formId, tplFromId, "", provider));
        }
        return printTaskId;
    }

    private static IFormView getFormView(String pageId) {
        try {
            IFormView view = SessionManager.getCurrent().getView(pageId);
            if (view == null) {
                return SessionManager.getCurrent().getViewNoPlugin(pageId);
            }
            return view;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return SessionManager.getCurrent().getViewNoPlugin(pageId);
        }
    }

    public static IPrintDataProvider createDataProvider(String type, String pageId, MainEntityType entityType, PrintMetadata printMeta) {
        ArrayList pluginMap = new ArrayList();
        for (Plugin p : printMeta.getRootAp().getPlugins()) {
            if (!p.isEnabled()) continue;
            HashMap<String, Object> mp = new HashMap<String, Object>(1);
            mp.put("type", p.getType());
            mp.put("className", p.getClassName());
            pluginMap.add(mp);
        }
        Map customFields = null;
        if (!pluginMap.isEmpty()) {
            FieldScanner fieldScanner = new FieldScanner(printMeta);
            customFields = fieldScanner.scanCustomFields();
        }
        String inteValue = printMeta.getRootAp().getInteFormat();
        Long intePkid = 0L;
        if (inteValue != null) {
            Map inteFormat = (Map)SerializationUtils.fromJsonString((String)inteValue, Map.class);
            intePkid = Long.valueOf((String)inteFormat.get("id"));
        }
        HashMap allEntities = new HashMap();
        allEntities.putAll(entityType.getAllEntities());
        allEntities.putAll(printMeta.getDynamicObjectTypes());
        IPrintDataProvider provider = PrintDataProviderFactory.createProvider(type);
        provider.setInteFormatId(intePkid);
        provider.setPageId(pageId);
        provider.setMainEntityType(entityType);
        provider.setCustomFieldsMap(customFields);
        provider.setCustomDynamicObjectTypes(allEntities);
        return provider;
    }

    private static List<PrintJob> createPrtJob(String pageId, String formId, String templateFormId, Object pkid, IPrintDataProvider dataProvider) {
        ArrayList<PrintJob> jobs = new ArrayList<PrintJob>(1);
        if (!StringUtils.isBlank((CharSequence)templateFormId) && !StringUtils.isBlank((CharSequence)formId)) {
            String tplId = MetadataDao.getIdByNumber((String)templateFormId, (MetaCategory)MetaCategory.Form);
            PrintJob job = new PrintJob(pageId, formId);
            job.setBillId(pkid);
            job.setTemplateId(tplId);
            job.setDataProvider(dataProvider);
            jobs.add(job);
        }
        return jobs;
    }
}

