/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.format.TimeFormatObject;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.entity.print.PaperSetting;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.inte.api.IInteService;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListGridView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.ViewCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.ILoginUserService;
import kd.bos.login.service.dto.AppType;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.GridPdfExporter;
import kd.bos.mvc.export.ListPdfExporter;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.service.IFontService;
import kd.bos.print.core.service.PrtFont;
import kd.bos.print.service.provider.FontServiceProvider;
import kd.bos.product.ProductSettingService;
import kd.bos.report.ReportList;
import kd.bos.report.ReportOperationColumn;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import org.jetbrains.annotations.NotNull;

public class PaperSettingPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String CONFIG_COMMON_SUFFIX = "_listprintsetting";
    private static final String PAPER = "paper";
    private static final String ORPENTATION = "orentation";
    private static final String MARGINTOP = "margintop";
    private static final String MARGINLEFT = "marginleft";
    private static final String MARGINBOTTOM = "marginbottom";
    private static final String MARGINRIGHT = "marginright";
    private static final String FORMID = "formid";
    private static final String WIDE = "wide";
    private static final String WIDEPROPORTION = "wideproportion";
    private static final String PRINT_TITLE = "printtitle";
    private static final String LIST_FIELD_FONT = "listfieldfont";
    private static final String LIST_LINE_HEIGHT = "listlineheight";
    private static final String FIXED_HEIGHT_VALUE = "fixedheightvalue";
    private static final String PRINT_REMARK = "printremark";
    private static final String ENABLE_WATERMARK = "enablewatermark";
    private static final String LISTFONT = "listfont";
    private static final Log log = LogFactory.getLog(PaperSettingPlugin.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btncancel", "restore"});
    }

    public void afterCreateNewData(EventObject e) {
        Map<String, Object> setting = this.loadSetting();
        if (!setting.isEmpty()) {
            this.getModel().setValue(PAPER, setting.get(PAPER));
            this.getModel().setValue(ORPENTATION, setting.get(ORPENTATION));
            this.getModel().setValue("wrap", setting.get("wrap"));
            this.getModel().setValue(MARGINTOP, setting.get(MARGINTOP));
            this.getModel().setValue(MARGINLEFT, setting.get(MARGINLEFT));
            this.getModel().setValue(MARGINBOTTOM, setting.get(MARGINBOTTOM));
            this.getModel().setValue(MARGINRIGHT, setting.get(MARGINRIGHT));
            this.getModel().setValue(ENABLE_WATERMARK, (Object)Boolean.parseBoolean(String.valueOf(setting.get(ENABLE_WATERMARK))));
            if (setting.get(WIDE) == null) {
                this.getModel().setValue(WIDE, (Object)"customwide");
                this.getModel().setValue(WIDEPROPORTION, (Object)100);
            } else {
                this.getModel().setValue(WIDE, setting.get(WIDE));
                if ("customwide".equals(setting.get(WIDE))) {
                    this.getModel().setValue(WIDEPROPORTION, setting.get(WIDEPROPORTION));
                } else {
                    this.getModel().setValue(WIDEPROPORTION, (Object)100);
                }
            }
            if (setting.get(PRINT_TITLE) != null) {
                this.getModel().setValue(PRINT_TITLE, setting.get(PRINT_TITLE));
            }
            if (setting.get(LIST_FIELD_FONT) != null && (Integer)setting.get(LIST_FIELD_FONT) != 0) {
                this.getModel().setValue(LIST_FIELD_FONT, setting.get(LIST_FIELD_FONT));
            }
            if (setting.get(LIST_LINE_HEIGHT) != null) {
                this.getModel().setValue(LIST_LINE_HEIGHT, setting.get(LIST_LINE_HEIGHT));
                if ("fixedheight".equals(setting.get(LIST_LINE_HEIGHT)) && setting.get(FIXED_HEIGHT_VALUE) != null) {
                    this.getModel().setValue(FIXED_HEIGHT_VALUE, setting.get(FIXED_HEIGHT_VALUE));
                } else {
                    this.getModel().setValue(FIXED_HEIGHT_VALUE, (Object)18);
                }
            }
            if (setting.get(PRINT_REMARK) != null) {
                this.getModel().setValue(PRINT_REMARK, setting.get(PRINT_REMARK));
            }
            if (setting.get(LISTFONT) != null) {
                this.getModel().setValue(LISTFONT, setting.get(LISTFONT));
            }
        }
        QFilter qFilter = new QFilter("tenantid", "=", (Object)RequestContext.get().getTenantId());
        qFilter.or(new QFilter("source", "=", (Object)"1"));
        Object[] ids = new Object[]{1186818181369438208L, 1186818041472623616L, 1189126456966392832L, 1189125939531885568L};
        QFilter qFilter1 = new QFilter("id", "not in", (Object)ids);
        QFilter qFilter2 = new QFilter("number", "!=", (Object)"Microsoft YaHei").or(new QFilter("source", "!=", (Object)"1"));
        QFilter[] filters = new QFilter[]{qFilter2, qFilter1, qFilter, new QFilter("billstatus", "=", (Object)"B")};
        DynamicObject[] fonts = BusinessDataServiceHelper.load((String)"bos_prt_font", (String)"number,name,alias", (QFilter[])filters, (String)"ordernum asc,createtime asc");
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(LISTFONT);
        if (comboEdit != null) {
            HashSet<String> setFonts = new HashSet<String>();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(fonts.length);
            for (DynamicObject font : fonts) {
                String alias = font.getString("alias");
                String name = font.getString("name");
                if (setFonts.contains(name)) continue;
                setFonts.add(name);
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(StringUtils.isNotBlank((CharSequence)alias) ? alias : name));
                item.setValue(name);
                comboItems.add(item);
            }
            comboEdit.setComboItems(comboItems);
        }
        super.afterCreateNewData(e);
    }

    public void beforeClick(BeforeClickEvent evt) {
        Button btn = (Button)evt.getSource();
        if ("btnok".equals(btn.getKey())) {
            Object value;
            Object fontValue = this.getModel().getValue(LIST_FIELD_FONT);
            if (fontValue == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5217\u8868\u5b57\u4f53\u5927\u5c0f\u3002", (String)"PaperSettingPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            float fontSize = Float.parseFloat(fontValue.toString());
            float currentLineHeight = "fixedheight".equals(this.getModel().getValue(LIST_LINE_HEIGHT)) ? ((value = this.getModel().getValue(FIXED_HEIGHT_VALUE)) != null ? Float.parseFloat(value.toString()) : 18.0f) : 18.0f;
            if (currentLineHeight - fontSize < 4.0f && !Boolean.parseBoolean(this.getModel().getValue("wrap").toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5217\u8868\u5b57\u4f53\u5927\u5c0f\u201d\u9700\u5c0f\u4e8e\u201c\u56fa\u5b9a\u884c\u9ad8\u201d4px\uff0c\u8bf7\u8c03\u6574\u5217\u8868\u5b57\u4f53\u5927\u5c0f\u3001\u56fa\u5b9a\u884c\u9ad8\u6216\u5f00\u542f\u81ea\u52a8\u6362\u884c\u3002", (String)"PaperSettingPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnok".equals(btn.getKey())) {
            this.saveSetting();
            this.doPrint();
        } else if ("restore".equals(btn.getKey())) {
            this.getModel().setValue(MARGINTOP, (Object)8.5);
            this.getModel().setValue(MARGINLEFT, (Object)10.6);
            this.getModel().setValue(MARGINBOTTOM, (Object)8.5);
            this.getModel().setValue(MARGINRIGHT, (Object)10.6);
            return;
        }
        this.getView().close();
    }

    private void doPrint() {
        String parentPageid = (String)this.getView().getFormShowParameter().getCustomParam("parentpageid");
        IFormView view = this.getFormView(parentPageid);
        String pdfUrl = "";
        PaperSetting setting = this.getPaperSetting();
        if (StringUtils.isEmpty((CharSequence)setting.getTitle())) {
            setting.setTitle(view.getFormShowParameter().getFormName());
        }
        FontServiceProvider fontService = new FontServiceProvider();
        fontService.setDefaultFont(new PrtFont("\u601d\u6e90\u5b8b\u4f53 CN", "Source Han Serif CN", "source han serif cn.ttf"));
        ExecuteContext.get().getServiceProxy().register((IFontService)fontService);
        if (view instanceof ReportView) {
            pdfUrl = this.exportPdf((ReportView)view, setting);
        } else if (view instanceof AbstractListView) {
            pdfUrl = this.exportPdf((AbstractListView)view, setting);
        }
        boolean hasShowMessage = false;
        try {
            IClientViewProxy iClientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            Field field = iClientViewProxy.getClass().getDeclaredField("_dctactions");
            ReflectionUtils.makeAccessible((Field)field);
            Map actions = (Map)field.get(iClientViewProxy);
            if (actions.containsKey("showMessage")) {
                hasShowMessage = true;
            }
        }
        catch (Exception iClientViewProxy) {
            // empty catch block
        }
        this.getView().sendFormAction(view);
        if (StringUtils.isNotBlank((CharSequence)pdfUrl)) {
            AppType appType = ((ILoginUserService)ServiceFactory.getService(ILoginUserService.class)).getAppTypeFromSession(RequestContext.get().getGlobalSessionId());
            if (appType == AppType.DingTalk) {
                this.getView().download(pdfUrl);
                return;
            }
            IFormView mainView = this.getView().getMainView();
            if (mainView == null) {
                this.getView().openUrl(pdfUrl);
                return;
            }
            FormShowParameter parm = new FormShowParameter();
            parm.setFormId("bos_printpreview");
            parm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            HashMap<String, String> reservedSpace = new HashMap<String, String>();
            reservedSpace.put("reservedSpace", "true");
            parm.getOpenStyle().setCustParam(reservedSpace);
            parm.setCustomParam("src", (Object)pdfUrl);
            IFormView parentView = this.getParentView();
            parentView.showForm(parm);
            this.getView().sendFormAction(parentView);
            return;
        }
        if (!hasShowMessage) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"PaperSettingPlugin_2", (String)"bos-noteprint", (Object[])new Object[0]));
            this.getView().sendFormAction(view);
        }
    }

    private IFormView getFormView(String pageId) {
        try {
            IFormView view = SessionManager.getCurrent().getView(pageId);
            if (view == null) {
                return SessionManager.getCurrent().getViewNoPlugin(pageId);
            }
            return view;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return SessionManager.getCurrent().getViewNoPlugin(pageId);
        }
    }

    private IFormView getParentView() {
        try {
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            }
            return parentView;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        }
    }

    private String exportPdf(ReportView reportView, PaperSetting info) {
        ReportListModel listModel;
        String result = "";
        ReportList reportList = reportView.getReportList();
        if (reportList == null) {
            return result;
        }
        String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)reportView.getFormShowParameter().getSettingKey());
        HashMap<String, Object> columnSetting = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            Map settingMap = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
            columnSetting = (Map)settingMap.get(reportList.getKey());
        }
        if ((listModel = (ReportListModel)reportList.getReportModel()).getRowCount() == 0) {
            reportList.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u5f15\u51fa\u7684\u6570\u636e\uff0c\u8bf7\u5148\u67e5\u8be2\u540e\u518d\u5bfc\u51fa", (String)"ReportList_0", (String)"", (Object[])new Object[0]));
            return "";
        }
        DynamicObjectCollection data = listModel.getRowData(0, listModel.getRowCount());
        AbstractGrid.GridState entryState = reportList.getEntryState();
        int[] selectedRows = entryState.getSelectedRows();
        if (selectedRows != null && selectedRows.length > 0) {
            DynamicObjectCollection newData = new DynamicObjectCollection();
            for (int selectedRow : selectedRows) {
                newData.add(data.get(selectedRow - 1));
            }
            data = newData;
        }
        List<AbstractReportColumn> columns = this.getColumnList(reportList, (IReportListModel)listModel);
        List<ReportColumn> cols = this.getReportColumnList(columns, true);
        NumberFormatProvider numberFormatProvider = ReportColumn.initNumberFormatProvider((DynamicObjectCollection)data, cols);
        ArrayList<AbstractReportColumn> exportColumns = new ArrayList<AbstractReportColumn>();
        List userGridConfigRows = reportList.getReportListProxy().getUserGridConfigRows();
        HashSet<String> hideColKeys = new HashSet<String>(16);
        for (GridConfigurationRow row : userGridConfigRows) {
            this.collectHideKeys(hideColKeys, row);
        }
        FormatObject format = this.getFormat();
        FieldControlRule fieldControlRule = this.getFieldControlRule(reportList);
        for (AbstractReportColumn abstractReportColumn : cols) {
            boolean isHidden;
            if (abstractReportColumn instanceof ReportOperationColumn) continue;
            if (abstractReportColumn instanceof ReportColumnGroup) {
                List childrens = ((ReportColumnGroup)abstractReportColumn).getChildren();
                for (AbstractReportColumn child : childrens) {
                    if (child instanceof ReportOperationColumn) continue;
                    if (child instanceof ReportColumnGroup) {
                        this.recurGroupColumnUserFormat((ReportColumnGroup)child, format);
                        continue;
                    }
                    child.setUserFormat(format);
                }
            } else {
                abstractReportColumn.setUserFormat(format);
            }
            String fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey();
            if (fieldControlRule != null && fieldControlRule.getCanNotReadFields() != null && fieldControlRule.getCanNotReadFields().contains(fieldKey.split("\\.")[0]) || (isHidden = this.isHiddenColumn(fieldKey, columnSetting)) || hideColKeys.contains(fieldKey)) continue;
            exportColumns.add(abstractReportColumn);
        }
        try {
            GridPdfExporter<AbstractReportColumn> exporter = new GridPdfExporter<AbstractReportColumn>();
            IFormView iFormView = reportList.getView();
            if (iFormView != null) {
                info.setAppId(iFormView.getFormShowParameter().getAppId());
            }
            Map<String, Object> customParams = this.getCustomParams();
            return exporter.export(exportColumns, data, numberFormatProvider, info, columnSetting, this.removeHiddenColumn(exportColumns, columns, columnSetting, hideColKeys), customParams);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)BosErrorCode.reportHeadEmpty)) {
                reportList.getView().showErrorNotification(BosErrorCode.reportHeadEmpty.getMessage());
            }
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        return "";
    }

    private boolean hideGroupChildrenCol(ReportColumnGroup group, Set<String> hideColKeys) {
        List children = group.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return true;
        }
        boolean res = true;
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            ReportColumnGroup columnGroup;
            boolean isHide;
            ReportColumn reportColumn;
            String fieldKey;
            AbstractReportColumn next = (AbstractReportColumn)iterator.next();
            if (next instanceof ReportColumn && hideColKeys.contains(fieldKey = (reportColumn = (ReportColumn)next).getFieldKey())) {
                iterator.remove();
                continue;
            }
            if (next instanceof ReportColumnGroup && (isHide = this.hideGroupChildrenCol(columnGroup = (ReportColumnGroup)next, hideColKeys))) {
                iterator.remove();
                continue;
            }
            res = false;
        }
        return res;
    }

    private void collectHideKeys(Set<String> hideColKeys, GridConfigurationRow row) {
        List rowChildren = row.getChildren();
        if (row.isHide()) {
            hideColKeys.add(row.getFieldKey());
            if (!CollectionUtils.isEmpty((Collection)rowChildren)) {
                rowChildren.forEach(r -> this.collectHideKeys(hideColKeys, (GridConfigurationRow)r));
            }
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)rowChildren)) {
            rowChildren.forEach(r -> this.collectHideKeys(hideColKeys, (GridConfigurationRow)r));
        }
    }

    private List<ReportColumn> getReportColumnList(List<AbstractReportColumn> reportColumns, boolean isOnlyVisible) {
        ArrayList<ReportColumn> cols = new ArrayList<ReportColumn>();
        this.setReportColumns(reportColumns, cols, isOnlyVisible);
        return cols;
    }

    private void setReportColumns(List<AbstractReportColumn> acols, List<ReportColumn> cols, boolean isOnlyVisible) {
        for (AbstractReportColumn acol : acols) {
            if (!(!(acol instanceof ReportColumn) || isOnlyVisible && ((ReportColumn)acol).isHide())) {
                cols.add((ReportColumn)acol);
                continue;
            }
            if (!(acol instanceof ReportColumnGroup)) continue;
            this.setReportColumns(((ReportColumnGroup)acol).getChildren(), cols, isOnlyVisible);
        }
    }

    private FormatObject getFormat() {
        String fmt;
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        Map userFormat = inteService.getUserFormat(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        FormatObject result = new FormatObject();
        Map numberFormat = (Map)userFormat.get("numberFormat");
        Map timeFormat = (Map)userFormat.get("timeFormat");
        Map currencyFormat = (Map)userFormat.get("currencyFormat");
        if (!numberFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)numberFormat);
            result.setNumberFormat((NumberFormatObject)SerializationUtils.fromJsonString((String)fmt, NumberFormatObject.class));
        }
        if (!timeFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)timeFormat);
            result.setTimeFormat((TimeFormatObject)SerializationUtils.fromJsonString((String)fmt, TimeFormatObject.class));
        }
        if (!currencyFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)currencyFormat);
            result.setCurrencyFormat((CurrencyFormatObject)SerializationUtils.fromJsonString((String)fmt, CurrencyFormatObject.class));
        }
        result.setDateFormat(new DateFormatObject(userFormat.get("dateFormat").toString()));
        return result;
    }

    private List<AbstractReportColumn> getColumnList(ReportList reportList, IReportListModel reportModel) {
        FormViewPluginProxy pluginProxy;
        String key = reportList.getView().getEntityId() + "_" + reportList.getKey() + "_reportcolumnsmap";
        String columnsSetting = reportList.getModel().getCurrUserSetting(key);
        String json = reportList.getModel().getCurrUserSetting(reportList.getView().getFormShowParameter().getSettingKey());
        List columns = reportModel.getColumns();
        if (columnsSetting != null) {
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)columnsSetting);
            for (AbstractReportColumn column : columns) {
                ReportColumn c;
                if (!(column instanceof ReportColumn) || map.get((c = (ReportColumn)column).getFieldKey()) == null) continue;
                c.setHide(((Boolean)map.get(c.getFieldKey())).booleanValue());
            }
        }
        if (json != null) {
            for (AbstractReportColumn column : columns) {
                this.resovleColumn(column, json);
            }
        }
        if ((pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class)) instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).fireAfterCreateColumn(reportList.getKey(), columns, reportModel.getReportQueryParam(), reportModel.getOtherQueryParam());
        }
        this.mergeColumn(columns);
        SingleOrgContextHelper.createReportSingleOrgContext((List)columns);
        this.filterBlackList(reportList.getView().getEntityId(), columns);
        return columns;
    }

    private void filterBlackList(String entityId, List<AbstractReportColumn> columns) {
        if (StringUtils.isBlank((CharSequence)entityId) || columns == null) {
            return;
        }
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List ctrls = service.getFormDisVistCtl(entityId);
        if (ctrls == null || ctrls.isEmpty()) {
            return;
        }
        this.setBlackListColumn(ctrls, columns);
    }

    private void setBlackListColumn(List<String> ctrls, List<AbstractReportColumn> columns) {
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                if (!ctrls.contains(((ReportColumn)column).getFieldKey())) continue;
                ((ReportColumn)column).setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            List children = ((ReportColumnGroup)column).getChildren();
            this.setBlackListColumn(ctrls, children);
        }
    }

    private void mergeColumn(List<AbstractReportColumn> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            AbstractReportColumn column = columns.get(i);
            if (!(column instanceof ReportColumnGroup)) continue;
            List cols = ((ReportColumnGroup)column).getChildren();
            this.mergeColumn(cols);
            if (!this.isOnlyOneVisibleColumn(cols)) continue;
            columns.remove(i);
            for (AbstractReportColumn col : cols) {
                if (!this.isVisible(col)) continue;
                col.setCaption(column.getCaption());
            }
            columns.addAll(i, cols);
        }
    }

    private boolean isOnlyOneVisibleColumn(List<AbstractReportColumn> columns) {
        ArrayList<AbstractReportColumn> cols = new ArrayList<AbstractReportColumn>();
        for (int i = 0; i < columns.size(); ++i) {
            AbstractReportColumn column = columns.get(i);
            if (!this.isVisible(column)) continue;
            cols.add(column);
            if (cols.size() <= 1) continue;
            return false;
        }
        return cols.size() != 1 || cols.get(0) == null || ((AbstractReportColumn)cols.get(0)).isHideSingleColumnRow();
    }

    private boolean isVisible(AbstractReportColumn column) {
        if (column instanceof ReportColumn && !((ReportColumn)column).isHide()) {
            return true;
        }
        if (column instanceof ReportColumnGroup) {
            List columns = ((ReportColumnGroup)column).getChildren();
            for (int i = 0; i < columns.size(); ++i) {
                if (!this.isVisible((AbstractReportColumn)columns.get(i))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void resovleColumn(AbstractReportColumn column, String json) {
        JSONObject settings = JSON.parseObject((String)json);
        if (column instanceof ReportColumn) {
            JSONObject colObject;
            ReportColumn c = (ReportColumn)column;
            if (settings != null && settings.getJSONObject("reportlistap") != null && (colObject = settings.getJSONObject("reportlistap").getJSONObject("cw")) != null && colObject.get((Object)c.getFieldKey()) != null && colObject.get((Object)c.getFieldKey()) instanceof Integer) {
                int widthObj = (Integer)colObject.get((Object)c.getFieldKey());
                c.setWidth(new LocaleString("" + widthObj));
            }
        } else if (column instanceof ReportColumnGroup) {
            ReportColumnGroup g = (ReportColumnGroup)column;
            for (AbstractReportColumn r : g.getChildren()) {
                this.resovleColumn(r, json);
            }
        }
    }

    protected void recurGroupColumnUserFormat(ReportColumnGroup column, FormatObject format) {
        List children = column.getChildren();
        if (children != null && !children.isEmpty()) {
            for (AbstractReportColumn col : children) {
                if (col instanceof ReportColumnGroup) {
                    this.recurGroupColumnUserFormat((ReportColumnGroup)col, format);
                    continue;
                }
                col.setUserFormat(format);
            }
        }
    }

    private boolean isHiddenColumn(String fieldKey, Map<String, Object> gridInfo) {
        Map columnVisible;
        boolean isHidden = false;
        if (gridInfo != null && (columnVisible = (Map)gridInfo.get("cv")) != null) {
            boolean visible;
            String replaceName = fieldKey;
            if (fieldKey.contains(".")) {
                replaceName = fieldKey.replace('.', '_');
            }
            if (columnVisible.containsKey(replaceName) && !(visible = ((Boolean)columnVisible.get(replaceName)).booleanValue())) {
                isHidden = true;
            }
        }
        return isHidden;
    }

    private List<AbstractReportColumn> removeHiddenColumn(List<AbstractReportColumn> exportColumns, List<AbstractReportColumn> rawColumns, Map<String, Object> columnSetting, Set<String> hideColKeys) {
        ArrayList<AbstractReportColumn> showColumns = new ArrayList<AbstractReportColumn>(10);
        Iterator<AbstractReportColumn> iterator = rawColumns.iterator();
        while (iterator.hasNext()) {
            boolean isHidden;
            AbstractReportColumn column = iterator.next();
            String fieldKey = "";
            if (column instanceof ReportColumn) {
                fieldKey = ((ReportColumn)column).getFieldKey();
            } else if (column instanceof ReportColumnGroup) {
                fieldKey = ((ReportColumnGroup)column).getFieldKey();
            }
            if (isHidden = this.isHiddenColumn2(fieldKey, columnSetting)) continue;
            if (column instanceof ReportColumnGroup) {
                boolean hide = this.hideGroupChildrenCol((ReportColumnGroup)column, hideColKeys);
                if (hide) {
                    iterator.remove();
                    continue;
                }
                showColumns.add(column);
                continue;
            }
            showColumns.add(column);
        }
        return showColumns;
    }

    private boolean isHiddenColumn2(String fieldKey, Map<String, Object> gridInfo) {
        Map columnVisible;
        boolean isHidden = false;
        if (gridInfo != null && (columnVisible = (Map)gridInfo.get("cv")) != null) {
            String replaceName = fieldKey;
            if (fieldKey.contains(".")) {
                replaceName = fieldKey.replace('.', '_');
            }
            if (columnVisible.containsKey(replaceName)) {
                boolean visible = (Boolean)columnVisible.get(replaceName);
                if (!visible) {
                    isHidden = true;
                }
            } else {
                isHidden = true;
            }
        }
        return isHidden;
    }

    private void initChildren(ReportColumnGroup reportColumnGroup, List<AbstractReportColumn> result) {
        if (!CollectionUtils.isEmpty((Collection)reportColumnGroup.getChildren())) {
            for (AbstractReportColumn temp : reportColumnGroup.getChildren()) {
                if (temp instanceof ReportColumnGroup) {
                    this.initChildren((ReportColumnGroup)temp, result);
                    continue;
                }
                result.add(temp);
            }
        }
    }

    private FieldControlRule getFieldControlRule(ReportList reportList) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, ShowFormHelper.getBizAppId((FormShowParameter)reportList.getView().getFormShowParameter()), reportList.getView().getEntityId());
        FieldControlRule fieldControlRule = null;
        String mainOrg = reportList.getModel().getDataEntityType().getMainOrg();
        long orgId = StringUtils.isNotBlank((CharSequence)mainOrg) ? this.getMainOrgId(reportList, mainOrg) : RequestContext.get().getOrgId();
        if (fieldControlRules == null) {
            return null;
        }
        fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
            FieldControlRule temp;
            if (!Objects.equals(listField.getMainOrgId(), orgId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(orgId)) || (temp = listField.getFieldControlRule()) == null) continue;
            fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
            fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
            fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
            fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
        }
        return fieldControlRule;
    }

    private long getMainOrgId(ReportList reportList, String mainOrg) {
        DynamicObject obj = reportList.getView().getModel().getDataEntity();
        long orgId = -1L;
        Object orgObj = obj.get(mainOrg);
        if (orgObj == null) {
            return orgId;
        }
        if (orgObj instanceof DynamicObject) {
            orgId = Long.parseLong(String.valueOf(((DynamicObject)orgObj).getPkValue()));
        } else if (orgObj instanceof Long) {
            orgId = (Long)orgObj;
        }
        return orgId;
    }

    private String exportPdf(AbstractListView listView, PaperSetting info) {
        List<IListColumn> columns = this.getListColumns(listView);
        BillList billList = (BillList)listView.getControl("billlistap");
        QueryResult queryReslt = this.getQueryResult(listView, billList);
        String gridViewKey = "";
        Optional<Control> opt = billList.getItems().stream().filter(p -> p instanceof ListGridView).findFirst();
        if (opt.isPresent()) {
            ListGridView gridView = (ListGridView)opt.get();
            gridViewKey = gridView.getKey();
        }
        String setting = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)listView.getFormShowParameter().getSettingKey());
        Map<String, Object> columnSetting = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            Map settingMap = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
            columnSetting = (Map)settingMap.get(gridViewKey);
        }
        FieldControlRules fieldControlRules = billList.getFieldControlRules();
        String tempUrl = "";
        try {
            ListPdfExporter exporter = new ListPdfExporter();
            info.setAppId(listView.getFormShowParameter().getAppId());
            Map<String, Object> customParams = this.getCustomParams();
            columnSetting.put("userConfigColumnSettings", this.parseUserConfigColumnSettings());
            this.collectGroupW(billList, columnSetting);
            tempUrl = exporter.export(fieldControlRules, listView.getBillFormId(), columns, queryReslt, columnSetting, info, customParams);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)BosErrorCode.reportHeadEmpty)) {
                listView.showErrorNotification(BosErrorCode.reportHeadEmpty.getMessage());
            }
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        return tempUrl;
    }

    private void collectGroupW(BillList billList, Map<String, Object> columnSetting) {
        Map columnWidth = (Map)columnSetting.get("cw");
        if (columnWidth != null) {
            Container gridView = null;
            String listGridViewKey = billList.getListGridViewKey();
            List containers = billList.getItems();
            for (Control c : containers) {
                if (!c.getKey().equals(listGridViewKey)) continue;
                gridView = (Container)c;
            }
            if (null == gridView) {
                return;
            }
            List items = gridView.getItems();
            for (Control item : items) {
                if (!(item instanceof ListColumnGroup)) continue;
                this.collectGoupChildrenW(columnWidth, (ListColumnGroup)item);
            }
        }
    }

    private void collectGoupChildrenW(Map<String, Object> columnWidth, ListColumnGroup item) {
        ListColumnGroup group = item;
        String listFieldKey = String.valueOf(group.getListFieldKey());
        if (columnWidth.containsKey(listFieldKey = this.getListFieldKey(listFieldKey))) {
            Integer width = (Integer)columnWidth.get(listFieldKey);
            List childrenItem = group.getItems();
            if (!CollectionUtils.isEmpty((Collection)childrenItem)) {
                int iW = width / childrenItem.size();
                for (Control control : childrenItem) {
                    String fieldKey;
                    if (control instanceof IListColumn) {
                        IListColumn listColumn = (IListColumn)control;
                        fieldKey = String.valueOf(listColumn.getListFieldKey());
                        if (columnWidth.containsKey(fieldKey = this.getListFieldKey(fieldKey))) continue;
                        columnWidth.put(fieldKey, iW);
                        continue;
                    }
                    if (!(control instanceof ListColumnGroup)) continue;
                    ListColumnGroup listColumnGroup = (ListColumnGroup)control;
                    fieldKey = String.valueOf(listColumnGroup.getListFieldKey());
                    if (!columnWidth.containsKey(fieldKey = this.getListFieldKey(fieldKey))) {
                        columnWidth.put(fieldKey, iW);
                    }
                    this.collectGoupChildrenW(columnWidth, listColumnGroup);
                }
            }
        }
    }

    @NotNull
    private String getListFieldKey(String listFieldKey) {
        if (listFieldKey.contains(".")) {
            listFieldKey = listFieldKey.replace('.', '_');
        }
        return listFieldKey;
    }

    private Map<String, Boolean> parseUserConfigColumnSettings() {
        LinkedHashMap<String, Boolean> userConfigColumnSettings = new LinkedHashMap<String, Boolean>();
        for (Map<String, Object> listFieldsControlColumn : this.getListFieldsControlColumns()) {
            this.parseUserConfigColumnSetting(userConfigColumnSettings, listFieldsControlColumn);
        }
        return userConfigColumnSettings;
    }

    private List<Map<String, Object>> getListFieldsControlColumns() {
        String setting = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)((IListView)this.getParentView()).getBillFormId());
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            return SerializationUtils.fromJsonStringToList((String)setting, Map.class);
        }
        return new ArrayList<Map<String, Object>>();
    }

    private void parseUserConfigColumnSetting(Map<String, Boolean> userConfigColumnSettings, Map<String, Object> listFieldsControlColumn) {
        int visibleValue = Integer.parseInt(listFieldsControlColumn.get("visible").toString());
        String listFieldKey = listFieldsControlColumn.get("listFieldKey").toString();
        if (null != userConfigColumnSettings.get(listFieldKey)) {
            return;
        }
        userConfigColumnSettings.put(listFieldKey, ViewCommonUtil.getListColumnVisible((boolean)true, (boolean)this.isLookup(), (int)visibleValue));
        if (listFieldsControlColumn.containsKey("items") && listFieldsControlColumn.get("items") instanceof List) {
            List items = (List)listFieldsControlColumn.get("items");
            for (Map item : items) {
                this.parseUserConfigColumnSetting(userConfigColumnSettings, item);
            }
        }
    }

    private boolean isLookup() {
        IListView listView = (IListView)this.getParentView();
        ListShowParameter listShowParameter = (ListShowParameter)listView.getFormShowParameter();
        return listShowParameter.isLookUp();
    }

    private Map<String, Object> getCustomParams() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String hidePrintUser = String.valueOf(params.getOrDefault("hidePrintUser", "false"));
        String hidePrintTime = String.valueOf(params.getOrDefault("hidePrintTime", "false"));
        String hidePrintPageNum = String.valueOf(params.getOrDefault("hidePrintPageNum", "false"));
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("hidePrintUser", hidePrintUser);
        customParams.put("hidePrintTime", hidePrintTime);
        customParams.put("hidePrintPageNum", hidePrintPageNum);
        return customParams;
    }

    private List<IListColumn> getListColumns(AbstractListView listView) {
        ArrayList<IListColumn> columns = new ArrayList<IListColumn>();
        for (IListColumn col : listView.getShowListColumns()) {
            boolean isExist;
            if (col.getListFieldKey() == null || (isExist = columns.stream().anyMatch(p -> p.getListFieldKey().contentEquals(col.getListFieldKey())))) continue;
            columns.add(col);
        }
        return columns;
    }

    private QueryResult getQueryResult(AbstractListView listView, BillList billList) {
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            AbstractGrid.GridState state = listView.getGridState();
            int startIndex = (state.getCurrentPageIndex() - 1) * state.getPageRows();
            return billList.queryBatchData(true, startIndex, state.getPageRows().intValue());
        }
        QueryResult queryReslt = billList.getSelectedRowDatas(billList.getListFields(), selectedRows);
        this.sortRows(queryReslt, selectedRows);
        return queryReslt;
    }

    private void sortRows(QueryResult rows, ListSelectedRowCollection subRowSelection) {
        int i;
        List formatRowDatas = rows.getFormatRowDatas();
        DynamicObjectCollection collection = rows.getCollection();
        HashMap sortFormatRowDataMap = new HashMap(16);
        HashMap<Object, Integer> sortRowMap = new HashMap<Object, Integer>(16);
        if (collection.size() != subRowSelection.size()) {
            List pkIds = collection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            log.warn("\u5217\u8868\u67e5\u8be2\u51fa\u6765\u7684\u6570\u636e\u6709\u8bef,\u539fpkIds:" + Arrays.toString(subRowSelection.getPrimaryKeyValues()) + "-----\u67e5\u8be2\u51fa\u6765\u7684pkIds:" + Arrays.toString(pkIds.toArray()));
        }
        for (i = 0; i < subRowSelection.size(); ++i) {
            ListSelectedRow selectedRow = subRowSelection.get(i);
            sortRowMap.put(selectedRow.getPrimaryKeyValue(), i);
        }
        for (i = 0; i < collection.size(); ++i) {
            sortFormatRowDataMap.put(formatRowDatas.get(i), ((DynamicObject)collection.get(i)).getPkValue());
        }
        collection.sort((row1, row2) -> {
            Integer seq2;
            Integer seq1 = (Integer)sortRowMap.get(row1.getPkValue());
            if (this.checkNull(seq1, seq2 = (Integer)sortRowMap.get(row2.getPkValue()))) {
                log.warn(row1.getPkValue() + ":" + seq1 + "-------" + row2.getPkValue() + ":" + seq2);
                return 0;
            }
            return seq1 - seq2;
        });
        formatRowDatas.sort((formatRowData1, formatRowData2) -> {
            Integer seq2;
            Object pkId2;
            Object pkId1 = sortFormatRowDataMap.get(formatRowData1);
            if (this.checkNull(pkId1, pkId2 = sortFormatRowDataMap.get(formatRowData2))) {
                return 0;
            }
            Integer seq1 = (Integer)sortRowMap.get(pkId1);
            if (this.checkNull(seq1, seq2 = (Integer)sortRowMap.get(pkId2))) {
                return 0;
            }
            return seq1 - seq2;
        });
        List collect = collection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        log.debug("\u6392\u5e8f\u540e:" + Arrays.toString(collect.toArray()));
    }

    private boolean checkNull(Object o1, Object o2) {
        return o1 == null || o2 == null;
    }

    private PaperSetting getPaperSetting() {
        PaperSetting setting = new PaperSetting();
        setting.setPaperType(this.getModel().getValue(PAPER).toString());
        setting.setMarginBottom(Float.parseFloat(this.getModel().getValue(MARGINBOTTOM).toString()));
        setting.setMarginLeft(Float.parseFloat(this.getModel().getValue(MARGINLEFT).toString()));
        setting.setMarginRight(Float.parseFloat(this.getModel().getValue(MARGINRIGHT).toString()));
        setting.setMarginTop(Float.parseFloat(this.getModel().getValue(MARGINTOP).toString()));
        setting.setOrentation((String)this.getModel().getValue(ORPENTATION));
        setting.setWrap(((Boolean)this.getModel().getValue("wrap")).booleanValue());
        if (this.getModel().getValue(WIDE) != null) {
            setting.setWideType(this.getModel().getValue(WIDE).toString());
        }
        setting.setWideProportion(Float.parseFloat(this.getModel().getValue(WIDEPROPORTION).toString()));
        setting.setTitle(this.getModel().getValue(PRINT_TITLE).toString());
        setting.setPrintRemark(Boolean.parseBoolean(this.getModel().getValue(PRINT_REMARK).toString()));
        setting.setListFieldFont(Float.parseFloat(this.getModel().getValue(LIST_FIELD_FONT).toString()));
        if ("fixedheight".equals(this.getModel().getValue(LIST_LINE_HEIGHT).toString())) {
            setting.setListLineHeight(Float.parseFloat(this.getModel().getValue(FIXED_HEIGHT_VALUE).toString()));
        } else {
            setting.setListLineHeight(18.0f);
        }
        Object listFont = this.getModel().getValue(LISTFONT);
        if (listFont != null) {
            setting.setListFont(listFont.toString());
        }
        return setting;
    }

    private void saveSetting() {
        String settingData = SerializationUtils.toJsonString((Object)this.getModel().getDataEntity());
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        String userId = RequestContext.get().getUserId();
        String key = formId + CONFIG_COMMON_SUFFIX;
        UserConfigServiceHelper.setSetting((long)Long.parseLong(userId), (String)key, (String)settingData);
    }

    private Map<String, Object> loadSetting() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        String userId = RequestContext.get().getUserId();
        String key = formId + CONFIG_COMMON_SUFFIX;
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        Map<String, Object> setting = new HashMap<String, Object>(16);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            setting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return setting;
    }
}

