/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.security.SecureRandom;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.print.BosPrintService;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.facade.IPrintServiceFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;

public class PrintDataProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CACHEKEY_JOBFORMINFO = "print_jobforminfo";
    private static final String CACHEKEY_TASKID = "print_taskid";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private boolean canClose = false;
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String CUSTPARAM_ENTITYNAME = "entityname";
    private static final String PRINT_PREVIEW_IS_CANCEL = "PRINT_PREVIEW_IS_CANCEL";
    private static final Log LOG = LogFactory.getLog(PrintDataProgressFormPlugin.class);

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel", "returntoback"});
    }

    public void onProgress(ProgressEvent e) {
        try {
            String taskId = this.getTaskId();
            boolean start = this.isStart();
            this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(true));
            if (!start && StringUtils.isBlank((CharSequence)taskId)) {
                this.dispatchTask();
                if (StringUtils.isBlank((CharSequence)taskId)) {
                    double n = new SecureRandom().nextDouble();
                    e.setProgress((int)(50.0 * n));
                }
                return;
            }
            if (start && StringUtils.isBlank((CharSequence)taskId)) {
                this.stopBar();
                this.closeForm();
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                boolean isFinished = this.isFinished();
                this.setFinished(true);
                if (!isFinished) {
                    e.setProgress(99);
                    return;
                }
                IFormView parentView = this.getParentView();
                String taskInfoData = taskInfo.getData();
                if (taskInfoData != null) {
                    Map data = (Map)SerializationUtils.fromJsonString((String)taskInfoData, Map.class);
                    if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
                        this.getView().showErrMessage(taskInfo.getFailureReason(), "");
                        this.stopBar();
                        this.closeForm();
                        return;
                    }
                    Object printTaskId = data.get("taskId");
                    boolean doNext = true;
                    for (IPrintServiceFacade prtService : PrtFacadeFactory.getAllPrtServiceFacades()) {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("iFormView", this.getView());
                        params.put("parentView", parentView);
                        params.put("result", printTaskId);
                        if (prtService.afterDoOperate(params)) continue;
                        doNext = false;
                        break;
                    }
                    if (!doNext) {
                        this.finish();
                        return;
                    }
                    String operateKey = this.getOperateKey();
                    doNext = PrintOperationHelper.fireAfterDoPrint(this.getView(), parentView, operateKey, data);
                    if (!doNext) {
                        this.finish();
                        return;
                    }
                    if (StringUtils.isNotBlank(printTaskId)) {
                        PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)String.valueOf(printTaskId));
                        String extType = taskResult.getExtType();
                        if (PrintWork.EXP_TYPE.EXP_SCPT.getCode().equals(extType)) {
                            Object hideLocalPreview = data.get("nlocalpreview");
                            PrintOperationHelper.clientLocalPrint(this.getView(), this.getParentView(), taskResult, !Boolean.parseBoolean(String.valueOf(hideLocalPreview)));
                        } else if (PrintWork.EXP_TYPE.EXP_XLS.getCode().equals(extType)) {
                            PrintOperationHelper.download(this.getView(), printTaskId, taskResult.getAttach());
                        } else {
                            List attachList = taskResult.getAttach();
                            String isOpenMobPreview = SystemPropertyUtils.getProptyByTenant((String)"PRT_MOBILE_PREVIEW", (String)RequestContext.get().getTenantId());
                            if (parentView instanceof IMobileView && (StringUtils.isBlank((CharSequence)isOpenMobPreview) || StringUtils.isNotBlank((CharSequence)isOpenMobPreview) && Boolean.parseBoolean(isOpenMobPreview))) {
                                PrintOperationHelper.mobilePreview(this.getView(), this.getParentView(), printTaskId, attachList);
                            } else {
                                PrintOperationHelper.preview(this.getView(), this.getParentView(), printTaskId, attachList);
                            }
                        }
                    }
                    if (!Boolean.parseBoolean((String)data.get("success"))) {
                        String msg = String.valueOf(data.get("error"));
                        if ("tip".equalsIgnoreCase(String.valueOf(data.get("msgType")))) {
                            parentView.showTipNotification(msg);
                        } else {
                            parentView.showErrMessage(msg, "");
                        }
                        this.getView().sendFormAction(parentView);
                    }
                }
                this.finish();
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                if (progress == 0) {
                    progress = 50;
                }
                e.setProgress(progress);
            }
        }
        catch (Exception exception) {
            this.stopBar();
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            parentView.showErrMessage(String.format(ResManager.loadKDString((String)"\u62a5\u9519\u4fe1\u606f\uff1a%s", (String)"PrintDataProgressFormPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]), exception.getMessage()), "");
            LOG.error((Throwable)exception);
            this.getView().sendFormAction(parentView);
            this.closeForm();
        }
    }

    private void finish() {
        this.stopBar();
        this.closeForm();
        this.getCurrentAppCache().remove(this.getCancelKey());
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String isStop = (String)this.getCurrentAppCache().get(this.getCancelKey(), String.class);
        if (!this.isStart()) {
            if (isStop != null && Boolean.parseBoolean(isStop)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u7ec8\u6b62\u6253\u5370\u4efb\u52a1\uff1f", (String)"PrintDataProgressFormPlugin_2", (String)"bos-noteprint", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_UNSTART", (IFormPlugin)this));
                e.setCancel(true);
                return;
            }
            e.setCancel(true);
            return;
        }
        if (this.canClose || this.isFinished()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
            if (isStop != null && Boolean.parseBoolean(isStop)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u7ec8\u6b62\u6253\u5370\u4efb\u52a1\uff1f", (String)"PrintDataProgressFormPlugin_2", (String)"bos-noteprint", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_START", (IFormPlugin)this));
                this.stopBar();
                e.setCancel(true);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u6253\u5370\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"PrintDataProgressFormPlugin_3", (String)"bos-noteprint", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
            this.stopBar();
            e.setCancel(true);
        }
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.stop();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.start();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            bar.setPercent(progress);
        }
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private boolean isStart() {
        String taskId = this.getTaskId();
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        return !StringUtils.isBlank((CharSequence)start) || !StringUtils.isBlank((CharSequence)taskId);
    }

    private void dispatchTask() {
        String isStop = (String)this.getCurrentAppCache().get(this.getCancelKey(), String.class);
        if (isStop != null && Boolean.parseBoolean(isStop)) {
            this.getCurrentAppCache().remove(this.getCancelKey());
            return;
        }
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PrintDataProgressFormPlugin_4", (String)"bos-noteprint", (Object[])new Object[0]));
        }
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private JobFormInfo buildJobFormInfo() {
        LocaleString nameL;
        JobInfo jobInfo = new JobInfo();
        FormShowParameter fs = this.getView().getFormShowParameter();
        Object nameValue = this.getView().getFormShowParameter().getCustomParam("entitynameL");
        if (nameValue != null && (nameL = (LocaleString)SerializationUtils.fromJsonString((String)nameValue.toString(), LocaleString.class)) != null) {
            LocaleString taskName = ResManager.getLocaleString((String)"\u6253\u5370 - %s", (String)"PrintDataProgressFormPlugin_6", (String)"bos-noteprint");
            Set langs = taskName.keySet();
            for (String lang : langs) {
                String nameStr;
                String taskStr = (String)taskName.get((Object)lang);
                if (taskStr == null || (nameStr = (String)nameL.getOrDefault((Object)lang, (Object)nameL.getLocaleValue())) == null) continue;
                taskName.put(lang, (Object)String.format(taskStr, nameStr));
            }
            jobInfo.setlName(taskName);
        } else {
            String name = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNAME);
            if (name == null) {
                name = "";
            }
            jobInfo.setName(String.format(ResManager.loadKDString((String)"\u6253\u5370 - %s", (String)"PrintDataProgressFormPlugin_6", (String)"bos-noteprint", (Object[])new Object[0]), name));
        }
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        String appId = "svc-print";
        if (AclAdapter.getAclServiceLookup().hasDeployedAppId(appId)) {
            jobInfo.setAppId(appId);
        } else {
            jobInfo.setAppId(fs.getServiceAppId());
        }
        jobInfo.setTaskClassname("kd.bos.mvc.print.PrintTask");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("parentpageid", fs.getParentPageId());
        params.putAll((Map)fs.getCustomParam("printParam"));
        params.put("fullPath", UrlService.getDomainContextUrlByTenantCode((String)RequestContext.get().getTenantId()));
        Object lang = params.get("lang");
        if (lang != null) {
            jobInfo.setRunByLang(Lang.from((String)lang.toString()));
        }
        String printTaskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
        params.put("printTaskId", printTaskId);
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(fs.getParentPageId());
        jobFormInfo.setRootPageId(fs.getRootPageId());
        jobFormInfo.setTimeout(this.getPrintTimes());
        jobFormInfo.getParams().putAll(fs.getCustomParams());
        if (fs.getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(fs.getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.print.PrintCloseCallBack", "");
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setClickClassName("kd.bos.form.plugin.print.PrintTaskClick");
        return jobFormInfo;
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if ("CLOSE_START".equals(messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                JobFormInfo jobFormInfo = this.getJobFormInfo();
                Object printTaskId = Optional.ofNullable(jobFormInfo).flatMap(u -> Optional.ofNullable(u.getJobInfo())).flatMap(j -> Optional.ofNullable(j.getParams())).map(m -> m.get("printTaskId")).orElse(null);
                if (printTaskId != null) {
                    BosPrintService service = (BosPrintService)ServiceFactory.getService(BosPrintService.class);
                    service.stopPrint(String.valueOf(printTaskId));
                }
                ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
                bar.stop();
                this.closeForm();
            } else {
                ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
                bar.start();
            }
        } else if ("CLOSE_UNSTART".equals(messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
                bar.stop();
                this.closeForm();
            } else {
                this.dispatchTask();
            }
        } else if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.start();
        }
        this.getCurrentAppCache().remove(this.getCancelKey());
    }

    private String getCancelKey() {
        return this.getTaskId() + PRINT_PREVIEW_IS_CANCEL;
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHEKEY_JOBFORMINFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(CACHEKEY_JOBFORMINFO, str);
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = null;
        str = this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_JOBFORMINFO) ? (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_JOBFORMINFO) : this.getPageCache().get(CACHEKEY_JOBFORMINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private IAppCache getCurrentAppCache() {
        return AppCache.get((String)this.getView().getFormShowParameter().getFormConfig().getAppId());
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btncancel".equals(c.getKey())) {
            this.getCurrentAppCache().put(this.getCancelKey(), (Object)"true");
            this.getView().close();
        }
        if ("returntoback".equals(c.getKey())) {
            if (this.isFinished()) {
                return;
            }
            this.getView().close();
        }
    }

    private int getPrintTimes() {
        int selectRow = (Integer)this.getView().getFormShowParameter().getCustomParam("selectrows");
        if (selectRow <= 120) {
            selectRow = 120;
        }
        return selectRow;
    }

    private IFormView getParentView() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = null;
        try {
            parentView = this.getView().getView(parentPageId);
            if (parentView == null) {
                parentView = this.getView().getViewNoPlugin(parentPageId);
            }
        }
        catch (Exception e) {
            LOG.warn("getParentView\u5931\u8d25", (Throwable)e);
            parentView = this.getView().getViewNoPlugin(parentPageId);
        }
        return parentView;
    }

    private String getOperateKey() {
        Object operateKey = this.getView().getFormShowParameter().getCustomParams().get("operateKey");
        return operateKey == null ? null : String.valueOf(operateKey);
    }
}

