/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import dm.jdbc.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.PrintCountProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxLink;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.operate.printop.AfterDoPrintEventArgs;
import kd.bos.form.operate.printop.IPrintOperatePlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.print.PrintConfirmCallBackListener;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.ILoginUserService;
import kd.bos.login.service.dto.AppType;
import kd.bos.mservice.print.BosPrintBusinessService;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintParam;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.service.provider.ClientScptServiceProvider;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.report.IReportView;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.print.NotePrintService;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.tenant.TenantInfo;
import kd.bos.url.UrlService;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ObjectUtils;

@SdkPublic
public class PrintOperationHelper {
    private static final Log log = LogFactory.getLog(PrintOperationHelper.class);

    public static void recordPrintField(String entityTypeId, List<PrintJob> newPrintJobs, List<PrintJob> oldPrintJobs) {
        if (entityTypeId != null) {
            Set<Object> billIds = PrintOperationHelper.recordPkIds(entityTypeId, newPrintJobs, oldPrintJobs);
            PrintOperationHelper.updatePrintCountField(entityTypeId, new ArrayList<Object>(billIds));
        }
    }

    public static void clientLocalPrint(IFormView actionView, IFormView previewView, PrtTaskResult taskResult, boolean needPreview) {
        if (actionView == null) {
            log.info("actionView==null");
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)actionView.getService(IClientViewProxy.class);
        HashMap<String, Object> proxyData = new HashMap<String, Object>();
        proxyData.put("url", ClientScptServiceProvider.getClientLocalServerUrl() + "/print");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("serverUrl", UrlService.getDomainContextUrl());
        param.put("taskId", taskResult.getTaskId());
        param.put("count", Integer.valueOf(taskResult.getServiceN()));
        param.put("preview", needPreview);
        param.put("ur", RequestContext.get().getUserId());
        param.put("accountId", RequestContext.get().getAccountId());
        param.put("jobNum", Integer.parseInt(taskResult.getServiceN()));
        TenantInfo tenantInfo = AccountUtils.getTenantByid((String)RequestContext.get().getTenantId());
        param.put("tenantId", RequestContext.get().getTenantId());
        param.put("tenantCode", RequestContext.get().getTenantCode());
        param.put("instanceNumber", tenantInfo.getInstanceNumber());
        proxyData.put("param", param);
        proxy.addAction("lspPostUrl", proxyData);
    }

    public static void download(IFormView actionView, Object printTaskId, List<PrtTaskResult.Attach> attachList) {
        String downloadUrl = "api/print/download.do?taskId=%s&attachId=%s";
        for (PrtTaskResult.Attach attach : attachList) {
            actionView.download(String.format(downloadUrl, printTaskId, attach.getAttachId()));
        }
    }

    public static void preview(IFormView actionView, IFormView previewView, Object printTaskId, List<PrtTaskResult.Attach> attachList) {
        AppType appType = ((ILoginUserService)ServiceFactory.getService(ILoginUserService.class)).getAppTypeFromSession(RequestContext.get().getGlobalSessionId());
        if (attachList.size() <= 3) {
            for (PrtTaskResult.Attach attach : attachList) {
                String url = String.format("api/print/download.do?taskId=%s&attachId=%s", printTaskId, attach.getAttachId());
                if (appType == AppType.DingTalk) {
                    url = url + "&downloadAttach=true";
                    previewView.download(url);
                    actionView.sendFormAction(previewView);
                    continue;
                }
                FormShowParameter para = new FormShowParameter();
                para.setFormId("bos_printpreview");
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                HashMap<String, String> reservedSpace = new HashMap<String, String>(1);
                reservedSpace.put("reservedSpace", "true");
                para.getOpenStyle().setCustParam(reservedSpace);
                para.setCustomParam("src", (Object)url);
                previewView.showForm(para);
                actionView.sendFormAction(previewView);
            }
        } else {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bos_print_resultview");
            para.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u7ed3\u679c", (String)"PrintDataProgressFormPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setCustomParam("taskId", printTaskId);
            para.setCustomParam("openSource", (Object)(appType == null ? "" : appType.getName()));
            previewView.showForm(para);
            actionView.sendFormAction(previewView);
        }
    }

    public static void clientPreview(IFormView actionView, IFormView previewView, Object printTaskId, List<Object> pkIds, String printJobs) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_clientpreview");
        para.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> reservedSpace = new HashMap<String, String>(1);
        reservedSpace.put("reservedSpace", "true");
        para.getOpenStyle().setCustParam(reservedSpace);
        para.setCustomParam("taskId", printTaskId);
        para.setCustomParam("pkIds", pkIds);
        para.setCustomParam("ServiceAppId", (Object)previewView.getFormShowParameter().getServiceAppId());
        FormShowParameter previewViewParameter = previewView.getFormShowParameter();
        String formId = previewViewParameter instanceof ListShowParameter ? ((ListShowParameter)previewViewParameter).getBillFormId() : previewViewParameter.getFormId();
        para.setCustomParam("bizFormId", (Object)formId);
        para.setCustomParam("printJobs", (Object)printJobs);
        para.setCustomParam("showCopyNum", (Object)(previewView instanceof BillView));
        String extParam = actionView.getPageCache().get("extParam");
        if (StringUtils.isNotBlank((CharSequence)extParam)) {
            para.setCustomParam("extParam", (Object)extParam);
        }
        previewView.showForm(para);
        actionView.sendFormAction(previewView);
    }

    public static void clientInstallTips(IFormView view) {
        ArrayList<MessageBoxLink> links = new ArrayList<MessageBoxLink>(1);
        MessageBoxLink link = new MessageBoxLink();
        link.setText(ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b", (String)"ClientPreview_4", (String)"bos-noteprint", (Object[])new Object[0]));
        link.setUrl("https://vip.kingdee.com/article/480418938422175744");
        links.add(link);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("printerInstallTips");
        view.showMessage(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5b89\u88c5\u6253\u5370\u5ba2\u6237\u7aef\u5e76\u6dfb\u52a0\u4e91\u6253\u5370\u673a\uff0c\u5b89\u88c5\u53ca\u4f7f\u7528\u6d41\u7a0b#{0}", (String)"ClientPreview_5", (String)"bos-noteprint", (Object[])new Object[0]), links, MessageTypes.Default, confirmCallBacks);
    }

    public static void printerSettingTips(IFormView view) {
        ArrayList<MessageBoxLink> links = new ArrayList<MessageBoxLink>(1);
        MessageBoxLink link = new MessageBoxLink();
        link.setText(ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b", (String)"ClientPreview_4", (String)"bos-noteprint", (Object[])new Object[0]));
        link.setUrl("https://vip.kingdee.com/article/480418938422175744");
        links.add(link);
        PrintConfirmCallBackListener listener = new PrintConfirmCallBackListener();
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("printSettingsTips", (IConfirmCallBack)listener);
        HashMap<Integer, String> btnName = new HashMap<Integer, String>(2);
        btnName.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u53bb\u8bbe\u7f6e", (String)"ClientPreview_7", (String)"bos-noteprint", (Object[])new Object[0]));
        btnName.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ClientPreview_8", (String)"bos-noteprint", (Object[])new Object[0]));
        view.showConfirm(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u6253\u5370\u673a\u6216\u9ed8\u8ba4\u6a21\u677f\uff0c\u4f7f\u7528\u6b65\u9aa4#{0}", (String)"ClientPreview_6", (String)"bos-noteprint", (Object[])new Object[0]), links, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, btnName);
    }

    public static void mobilePreview(IFormView actionView, IFormView previewView, Object printTaskId, List<PrtTaskResult.Attach> attachList) {
        if (attachList.size() == 1) {
            PrtTaskResult.Attach attach = attachList.get(0);
            String attachId = attach.getAttachId();
            String downloadUrl = UrlService.getDomainContextUrl() + "/print/download.do?taskId=%s&attachId=%s";
            downloadUrl = PrintOperationHelper.wrapMobileUrl(downloadUrl);
            downloadUrl = EncreptSessionUtils.encryptSession((String)String.format(downloadUrl, printTaskId, attachId));
            HashMap<String, Object> fileParam = new HashMap<String, Object>(8);
            String src = downloadUrl;
            String taskId = (String)printTaskId;
            PrtTaskResult prtResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId, (boolean)false);
            if (prtResult != null) {
                PrtTaskResult.Attach attachment = null;
                for (PrtTaskResult.Attach att : prtResult.getAttach()) {
                    if (!StringUtil.equals((String)attachId, (String)att.getAttachId())) continue;
                    attachment = att;
                    break;
                }
                if (attachment != null) {
                    try {
                        fileParam.put("fileName", attachment.getFileName());
                        InputStream in = PrintFileUtil.getFileInputStream((String)attachment.getFilePath(), (String)prtResult.getDiskType());
                        fileParam.put("md5", DigestUtils.md5Hex((InputStream)in));
                        fileParam.put("fileSize", PrintOperationHelper.getFileSize(in));
                        fileParam.put("fileTime", System.currentTimeMillis());
                    }
                    catch (Exception e) {
                        log.warn("\u8bbe\u7f6epdf\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                    }
                }
            }
            fileParam.put("fileId", "rc-upload-" + attachId);
            fileParam.put("fileExt", "pdf");
            fileParam.put("downloadUrl", src);
            fileParam.put("fileDownloadUrl", src);
            fileParam.put("supportOnlinePreview", true);
            fileParam.put("filesource", 1);
            actionView.previewAttachment(fileParam);
        } else {
            previewView.showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u9884\u89c8\u7684pdf\u6587\u4ef6\u8d85\u8fc71000\u9875\uff0c\u8bf7\u5728\u7535\u8111\u7aef\u8fdb\u884c\u6253\u5370\u3002", (String)"PrintDataProgressFormPlugin_5", (String)"bos-noteprint", (Object[])new Object[0]));
        }
        actionView.sendFormAction(previewView);
    }

    private static int getFileSize(InputStream in) throws IOException {
        int ch;
        int fileSize = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((ch = in.read()) != -1) {
            baos.write(ch);
        }
        byte[] data = baos.toByteArray();
        in.close();
        baos.close();
        fileSize = data.length;
        return fileSize;
    }

    private static String wrapMobileUrl(String url) {
        return url + "&isMobile=true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationResult doPrintOperation(IFormView view, PrintOperateParam param) {
        OperationResult result;
        block26: {
            String serviceType;
            result = new OperationResult();
            Lang curLang = RequestContext.get().getLang();
            String printLangStr = param.getLang();
            if (StringUtils.isNotBlank((CharSequence)printLangStr)) {
                RequestContext.get().setLang(Lang.from((String)printLangStr));
            }
            if (StringUtils.isBlank((CharSequence)(serviceType = param.getServiceType()))) {
                DynamicObject cloudPrint;
                if (param.getPrinterId() == null || (cloudPrint = BusinessDataServiceHelper.loadSingleFromCache((Object)param.getPrinterId(), (String)"bos_cloudprintmanage")) == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u673a\u3002", (String)"Print_9", (String)"bos-noteprint", (Object[])new Object[0]));
                    return result;
                }
                serviceType = cloudPrint.getString("group.servicetype");
            }
            try {
                List<PrintJob> oldPrintJobs;
                boolean printResult = true;
                String message = ResManager.loadKDString((String)"\u6253\u5370\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\u3002", (String)"Print_8", (String)"bos-noteprint", (Object[])new Object[0]);
                if (view instanceof IReportView) {
                    message = ResManager.loadKDString((String)"\u62a5\u8868\u6682\u672a\u63d0\u4f9b\u6253\u5370\u529f\u80fd\u3002", (String)"Print_0", (String)"bos-noteprint", (Object[])new Object[0]);
                    view.showTipNotification(message);
                    result.setSuccess(false);
                    result.setMessage(message);
                    OperationResult operationResult = result;
                    return operationResult;
                }
                List<PrintJob> printJobs = param.getPrintJobs();
                printJobs = PrintOperationHelper.sortAndMergeJobs(param.getPkIds(), printJobs);
                Map<String, List<PrintJob>> classifyPrintJob = PrintOperationHelper.classifyPrintJob(printJobs);
                if (printJobs == null || printJobs.isEmpty()) {
                    message = ResManager.loadKDString((String)"\u65e0\u53ef\u6253\u5370\u6570\u636e\u3002", (String)"Print_2", (String)"bos-noteprint", (Object[])new Object[0]);
                    view.showTipNotification(message);
                    result.setSuccess(false);
                    result.setMessage(message);
                    OperationResult operationResult = result;
                    return operationResult;
                }
                List<PrintJob> newPrintJobs = classifyPrintJob.get("newPrintJobs");
                NotePrintService printSvr = new NotePrintService();
                if (newPrintJobs != null && newPrintJobs.size() > 0) {
                    ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(10);
                    for (PrintJob job : newPrintJobs) {
                        PrintTask task = new PrintTask();
                        task.setPkIds(job.getBillIds());
                        task.setFormId(job.getFormId());
                        task.setPageId(job.getPageId());
                        task.setTplId(String.valueOf(job.getTemplateId()));
                        task.setPrintType("billForm");
                        taskList.add(task);
                    }
                    String lang = curLang.toString();
                    if (StringUtils.isNotBlank((CharSequence)printLangStr)) {
                        lang = printLangStr;
                    }
                    PrintParam printParam = new PrintParam();
                    printParam.setPageId(((PrintTask)taskList.get(0)).getPageId());
                    printParam.setPrintLang(lang);
                    printParam.setExpType("pdf");
                    printParam.setTaskList(taskList);
                    printParam.setBillFormId(param.getFormId());
                    printParam.setCopyNum(param.getCopyNum());
                    printParam.setExtParam(param.getExtParam());
                    BosPrintBusinessService service = (BosPrintBusinessService)ServiceFactory.getService(BosPrintBusinessService.class);
                    if ("B".equals(serviceType)) {
                        printParam.setExpType(PrintWork.EXP_TYPE.EXP_CLIENT.getCode());
                        printParam.setPrinterId(param.getPrinterId().toString());
                        service.doPrint(null, (Object)printParam);
                    } else {
                        PrtTaskResult.Attach attach;
                        String taskId = service.doPrint(null, (Object)printParam);
                        PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
                        List attachList = taskResult.getAttach();
                        Iterator iterator = attachList.iterator();
                        while (iterator.hasNext() && (printResult = printSvr.createPrintJob((attach = (PrtTaskResult.Attach)iterator.next()).getAttachId(), attach.getAttachId(), attach.getFilePath(), new LocaleString(attach.getFileName()), param.getPrinterId()))) {
                        }
                    }
                }
                if (printResult && (oldPrintJobs = classifyPrintJob.get("oldPrintJobs")) != null && oldPrintJobs.size() > 0) {
                    if ("B".equals(serviceType)) {
                        OperationResult operationResult;
                        message = ResManager.loadKDString((String)"\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u5ba2\u6237\u7aef\u6253\u5370\uff0c\u8bf7\u5347\u7ea7\u4e3a\u65b0\u6a21\u677f\u540e\u4f7f\u7528\u3002", (String)"Print_6", (String)"bos-noteprint", (Object[])new Object[0]);
                        if ("print".equals(param.getOperateKey()) && CollectionUtils.isEmpty(newPrintJobs)) {
                            result.setMessage(message);
                            view.showTipNotification(message);
                            result.setSuccess(false);
                            operationResult = result;
                            return operationResult;
                        }
                        message = ResManager.loadKDString((String)"\u6253\u5370\u8bf7\u6c42\u53d1\u9001\u6210\u529f\u3002", (String)"Print_7", (String)"bos-noteprint", (Object[])new Object[0]);
                        result.setMessage(message);
                        result.setSuccess(true);
                        view.showSuccessNotification(message);
                        operationResult = result;
                        return operationResult;
                    }
                    printResult = printSvr.createPrintJob(null, oldPrintJobs);
                    result.setSuccess(printResult);
                }
                if (printResult) {
                    message = ResManager.loadKDString((String)"\u6253\u5370\u8bf7\u6c42\u53d1\u9001\u6210\u529f\u3002", (String)"Print_7", (String)"bos-noteprint", (Object[])new Object[0]);
                    result.setMessage(message);
                    view.showSuccessNotification(message);
                } else {
                    view.showErrorNotification(message);
                }
            }
            catch (Exception e) {
                result.setSuccess(false);
                if (e instanceof KDBizException) {
                    view.showTipNotification(e.getMessage());
                    break block26;
                }
                throw e;
            }
            finally {
                RequestContext.get().setLang(curLang);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationResult doNewPrintOperation(IFormView view, PrintOperateParam param) {
        OperationResult result;
        block13: {
            result = new OperationResult();
            Lang curLang = RequestContext.get().getLang();
            String printLangStr = param.getLang();
            if (StringUtils.isNotBlank((CharSequence)printLangStr)) {
                RequestContext.get().setLang(Lang.from((String)printLangStr));
            }
            try {
                if (view instanceof IReportView) {
                    String message = ResManager.loadKDString((String)"\u62a5\u8868\u6682\u672a\u63d0\u4f9b\u6253\u5370\u529f\u80fd\u3002", (String)"Print_0", (String)"bos-noteprint", (Object[])new Object[0]);
                    view.showTipNotification(message);
                    result.setSuccess(false);
                    result.setMessage(message);
                    OperationResult operationResult = result;
                    return operationResult;
                }
                List<PrintJob> printJobs = param.getPrintJobs();
                if (printJobs == null || printJobs.isEmpty()) {
                    String message = ResManager.loadKDString((String)"\u65e0\u53ef\u6253\u5370\u6570\u636e\u3002", (String)"Print_2", (String)"bos-noteprint", (Object[])new Object[0]);
                    view.showTipNotification(message);
                    result.setSuccess(false);
                    result.setMessage(message);
                    OperationResult operationResult = result;
                    return operationResult;
                }
                ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(printJobs.size());
                for (PrintJob job : printJobs) {
                    PrintTask task = new PrintTask();
                    task.setPkIds(job.getBillIds());
                    task.setFormId(job.getFormId());
                    task.setPageId(job.getPageId());
                    task.setTplId(String.valueOf(job.getTemplateId()));
                    task.setPrintType("billForm");
                    taskList.add(task);
                }
                String lang = curLang.toString();
                if (StringUtils.isNotBlank((CharSequence)printLangStr)) {
                    lang = printLangStr;
                }
                PrintParam printParam = new PrintParam();
                printParam.setPageId(((PrintTask)taskList.get(0)).getPageId());
                printParam.setPrintLang(lang);
                printParam.setExpType(param.getExpType().getCode());
                printParam.setTaskList(taskList);
                printParam.setBillFormId(param.getFormId());
                printParam.setCopyNum(param.getCopyNum());
                printParam.setExtParam(param.getExtParam());
                printParam.setPrinterId(param.getBtPrinter());
                BosPrintBusinessService service = (BosPrintBusinessService)ServiceFactory.getService(BosPrintBusinessService.class);
                String taskId = service.doPrint(null, (Object)printParam);
                result.setCustomData(Collections.singletonMap("taskId", taskId));
            }
            catch (Exception e) {
                result.setSuccess(false);
                if (e instanceof KDBizException) {
                    view.showTipNotification(e.getMessage());
                    break block13;
                }
                throw e;
            }
            finally {
                RequestContext.get().setLang(curLang);
            }
        }
        return result;
    }

    public static String printNewTpl(PrintOperateParam param) {
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(10);
        if (param.getPrintJobs() != null) {
            for (PrintJob job : param.getPrintJobs()) {
                PrintTask task = new PrintTask();
                task.setPkIds(job.getBillIds());
                task.setFormId(job.getFormId());
                task.setPageId(job.getPageId());
                task.setTplId(String.valueOf(job.getTemplateId()));
                task.setPrintType("billForm");
                taskList.add(task);
            }
        } else if (StringUtils.isNotBlank((CharSequence)param.getDefaultTplId())) {
            if (param.getPkIds().isEmpty() && !"report".equals(param.getPrintType()) && !"dynamic".equals(param.getPrintType()) && !"querylist".equals(param.getPrintType())) {
                return param.getPrintTaskId();
            }
            PrintTask task = new PrintTask();
            task.setPkIds(param.getPkIds());
            task.setPageId(String.valueOf(param.getPageId()));
            task.setFormId(String.valueOf(param.getFormId()));
            task.setTplId(param.getDefaultTplId());
            task.setPrintType(param.getPrintType());
            taskList.add(task);
        }
        if (taskList.isEmpty()) {
            return param.getPrintTaskId();
        }
        PrintParam printParam = new PrintParam();
        printParam.setPageId(((PrintTask)taskList.get(0)).getPageId());
        if (StringUtils.isBlank((CharSequence)param.getLang())) {
            printParam.setPrintLang(RequestContext.get().getLang().toString());
        } else {
            printParam.setPrintLang(param.lang);
        }
        if (param.getExpType() == null) {
            printParam.setExpType("pdf");
        } else {
            printParam.setExpType(param.getExpType().getCode());
        }
        printParam.setTaskList(taskList);
        printParam.setBillFormId(param.getFormId());
        printParam.setExtParam(param.getExtParam());
        BosPrintBusinessService service = (BosPrintBusinessService)ServiceFactory.getService(BosPrintBusinessService.class);
        return service.doPrint(param.getPrintTaskId(), (Object)printParam);
    }

    public static Set<Object> recordPkIds(String entityTypeId, List<PrintJob> newPrintJobs, List<PrintJob> oldPrintJobs) {
        HashSet<Object> billIds = new HashSet<Object>(16);
        if (null != entityTypeId) {
            if (null != newPrintJobs) {
                for (PrintJob job : newPrintJobs) {
                    billIds.addAll(job.getBillIds());
                }
            }
            if (null != oldPrintJobs) {
                for (PrintJob job : oldPrintJobs) {
                    billIds.addAll(job.getBillIds());
                }
            }
        }
        return billIds;
    }

    public static void updatePrintCountField(String entityTypeId, List<Object> pkIds) {
        try {
            PrintClientUtil.updatePrintCountField((String)entityTypeId, pkIds, (PrintCountProp.PrintRecordModel)PrintCountProp.PrintRecordModel.OPERATE);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static boolean fireAfterDoPrint(IFormView thisView, IFormView parentView, String operateKey, Map<String, Object> data) {
        Object printTaskId = data.get("taskId");
        if (StringUtils.isNotBlank((CharSequence)operateKey)) {
            FormShowParameter formShowParameter = thisView.getFormShowParameter();
            Map printParam = (Map)formShowParameter.getCustomParam("printParam");
            AfterDoPrintEventArgs.EventOption eventOption = new AfterDoPrintEventArgs.EventOption();
            eventOption.setOperateKey(operateKey);
            eventOption.setPrintParam(printParam);
            eventOption.setTaskId(String.valueOf(printTaskId));
            AfterDoPrintEventArgs afterDoPrintEventArgs = new AfterDoPrintEventArgs(parentView, eventOption);
            FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)parentView.getService(FormViewPluginProxy.class);
            List plugIns = formViewPluginProxy.getPlugIns();
            for (IFormPlugin plugin : plugIns) {
                if (!afterDoPrintEventArgs.isDoNext()) break;
                if (!(plugin instanceof IPrintOperatePlugin)) continue;
                IPrintOperatePlugin printOperatePlugin = (IPrintOperatePlugin)plugin;
                printOperatePlugin.afterDoPrintOperation(afterDoPrintEventArgs);
            }
            return afterDoPrintEventArgs.isDoNext();
        }
        return true;
    }

    private static boolean workflowMapEqual(Map<String, Object> map1, Map<String, Object> map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1 != null && map2 != null && map1.size() == map2.size()) {
            if (map1.isEmpty()) {
                return true;
            }
            for (Map.Entry<String, Object> entry : map1.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (ObjectUtils.equals((Object)value, (Object)map2.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<PrintJob> sortAndMergeJobs(List<Object> pkIds, List<PrintJob> oriJobs) {
        if (pkIds == null || pkIds.isEmpty()) {
            return oriJobs;
        }
        if (oriJobs == null || oriJobs.isEmpty()) {
            return oriJobs;
        }
        HashMap<String, List> printJobMap = new HashMap<String, List>(oriJobs.size());
        for (PrintJob j : oriJobs) {
            List<Object> billIdObjs = j.getBillIds();
            for (Object billId : billIdObjs) {
                PrintJob job = new PrintJob();
                ArrayList<Object> singlePkIds = new ArrayList<Object>();
                singlePkIds.add(billId);
                job.setBillIds(singlePkIds);
                job.setDataProvider(j.getDataProvider());
                job.setFormId(j.getFormId());
                job.setName(j.getName());
                job.setOrderBy(j.getOrderBy());
                job.setPageId(j.getPageId());
                job.setPrinterId(j.getPrinterId());
                job.setSample(j.isSample());
                job.setTemplateId(j.getTemplateId());
                job.setType(j.getType());
                job.setWorkFlowParams(j.getWorkFlowParams());
                List printJobs = printJobMap.getOrDefault(String.valueOf(billId), new ArrayList(4));
                printJobs.add(job);
                printJobMap.put(String.valueOf(billId), printJobs);
            }
        }
        ArrayList<PrintJob> newPrintJobs = new ArrayList<PrintJob>(oriJobs.size());
        PrintJob lastJob = null;
        for (Object pk : pkIds) {
            List printJobs = (List)printJobMap.get(String.valueOf(pk));
            if (printJobs == null || printJobs.isEmpty()) continue;
            for (PrintJob printJob : printJobs) {
                if (lastJob == null) {
                    lastJob = printJob;
                    newPrintJobs.add(printJob);
                    continue;
                }
                String lastTplId = String.valueOf(lastJob.getTemplateId());
                String curTplId = String.valueOf(printJob.getTemplateId());
                Map<String, Object> lastWorkFlowParams = lastJob.getWorkFlowParams();
                Map<String, Object> curWorkFlowParams = printJob.getWorkFlowParams();
                if (StringUtils.equals((CharSequence)lastTplId, (CharSequence)curTplId) && PrintOperationHelper.workflowMapEqual(lastWorkFlowParams, curWorkFlowParams)) {
                    lastJob.getBillIds().addAll(printJob.getBillIds());
                    continue;
                }
                lastJob = printJob;
                newPrintJobs.add(printJob);
            }
        }
        return newPrintJobs;
    }

    public static Map<String, List<PrintJob>> classifyPrintJob(List<PrintJob> printJobs) {
        if (CollectionUtils.isEmpty(printJobs)) {
            HashMap<String, List<PrintJob>> empMap = new HashMap<String, List<PrintJob>>(0);
            return empMap;
        }
        List tplIds = printJobs.stream().map(item -> item.getTemplateId()).collect(Collectors.toList());
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_manageprinttpl", (String)"id,type,printtplid_id", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "in", tplIds)});
        HashMap<String, Object> config = new HashMap<String, Object>(16);
        for (DynamicObject obj : dynamicObjectMap.values()) {
            String type = obj.getString("type");
            String tplId = obj.getString("printtplid_id");
            config.put(tplId, type);
        }
        ArrayList<PrintJob> oldPrintJobs = new ArrayList<PrintJob>();
        ArrayList<PrintJob> newPrintJobs = new ArrayList<PrintJob>();
        for (PrintJob job : printJobs) {
            String type = (String)config.get(job.getTemplateId());
            if ("B".equals(type)) {
                newPrintJobs.add(job);
                continue;
            }
            oldPrintJobs.add(job);
        }
        HashMap<String, List<PrintJob>> result = new HashMap<String, List<PrintJob>>(2);
        result.put("oldPrintJobs", oldPrintJobs);
        result.put("newPrintJobs", newPrintJobs);
        return result;
    }

    @Deprecated
    public static List<PrintTask> sortAndMergeTasks(List sortPkids, List<PrintTask> taskList) {
        return Collections.emptyList();
    }

    public static class PrintOperateParam {
        private String pageId;
        private String formId;
        private String printTaskId;
        private String printType;
        private String defaultTplId;
        private String lang;
        private List<PrintJob> printJobs;
        private List<Object> pkIds;
        private Map<String, Object> extParam;
        private PrintWork.EXP_TYPE expType;
        private String serviceType;
        private Long printerId;
        private String btPrinter;
        private int copyNum;
        private String operateKey;

        public PrintOperateParam() {
        }

        public PrintOperateParam(String pageId, String formId, String printTaskId, String printType, String defaultTplId, String lang, List<Object> pkIds, List<PrintJob> printJobs, Map<String, Object> extParam) {
            this.pageId = pageId;
            this.formId = formId;
            this.lang = lang;
            this.printTaskId = printTaskId;
            this.printType = printType;
            this.defaultTplId = defaultTplId;
            this.printJobs = printJobs;
            this.pkIds = pkIds;
            this.extParam = extParam;
        }

        public PrintOperateParam(String pageId, String formId, String printTaskId, String printType, String defaultTplId, List<Object> pkIds, List<PrintJob> printJobs) {
            this.pageId = pageId;
            this.formId = formId;
            this.printTaskId = printTaskId;
            this.printType = printType;
            this.defaultTplId = defaultTplId;
            this.printJobs = printJobs;
            this.pkIds = pkIds;
        }

        public String getOperateKey() {
            return this.operateKey;
        }

        public void setOperateKey(String operateKey) {
            this.operateKey = operateKey;
        }

        public String getPageId() {
            return this.pageId;
        }

        public String getFormId() {
            return this.formId;
        }

        public String getLang() {
            return this.lang;
        }

        public String getPrintTaskId() {
            return this.printTaskId;
        }

        public String getPrintType() {
            return this.printType;
        }

        public String getDefaultTplId() {
            return this.defaultTplId;
        }

        public List<PrintJob> getPrintJobs() {
            return this.printJobs;
        }

        public List<Object> getPkIds() {
            return this.pkIds;
        }

        public Map<String, Object> getExtParam() {
            return this.extParam;
        }

        public PrintWork.EXP_TYPE getExpType() {
            return this.expType;
        }

        public void setExpType(PrintWork.EXP_TYPE expType) {
            this.expType = expType;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public Long getPrinterId() {
            return this.printerId;
        }

        public void setPrinterId(Long printerId) {
            this.printerId = printerId;
        }

        public int getCopyNum() {
            return this.copyNum;
        }

        public void setCopyNum(int copyNum) {
            this.copyNum = copyNum;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }

        public void setPrintJobs(List<PrintJob> printJobs) {
            this.printJobs = printJobs;
        }

        public void setPkIds(List<Object> pkIds) {
            this.pkIds = pkIds;
        }

        public void setFormId(String formId) {
            this.formId = formId;
        }

        public void setExtParam(Map<String, Object> extParam) {
            this.extParam = extParam;
        }

        public String getBtPrinter() {
            return this.btPrinter;
        }

        public void setBtPrinter(String btPrinter) {
            this.btPrinter = btPrinter;
        }
    }
}

