/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.print.BosPrintService;
import kd.bos.orm.query.QFilter;
import kd.bos.print.PrintJob;
import kd.bos.print.business.designer.plugin.PrintResultPlugin;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;

public class PrintPreviewNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");
    public static final String FORM_ID = "bos_clientpreview";
    public static final String PRINTER = "printer";
    public static final String COPY_NUM = "copynum";
    public static final String TASK_ID = "taskId";
    private static final String pageNumFormat = "%1$s/%2$s";
    private static final String CONFIG_COMMON_SUFFIX = "_printsetting";
    private static final String PAGENUM_LB = "pagenum_lb";
    private static final String PREV_VT = "prev_vt";
    private static final String NEXT_VT = "next_vt";
    private static final String CLIENT_PRINT = "clientpreview";
    private static final String SAVE_SETTINGS = "savesettings";
    private static final String IMAGE_AP = "imageap";
    private static final String IMAGE_FLAX = "imageflex";
    private static final String CUR_INDEX = "curIndex";
    private static final String ATTACH_NUM = "attachNum";
    public static final String PRINT_JOBS = "printJobs";
    public static final String SHOW_COPY_NUM = "showCopyNum";
    public static final String PK_IDS = "pkIds";
    private static final int maxWidth = 672;
    private static final int maxHeight = 532;
    private static final int leftPadding = 60;
    private static final int topPadding = 20;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit printer = (BasedataEdit)this.getControl(PRINTER);
        printer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{PREV_VT, NEXT_VT, CLIENT_PRINT, SAVE_SETTINGS, "clientprint"});
    }

    public void afterCreateNewData(EventObject evt) {
        Object copyNum;
        DynamicObject cloudPrint;
        int attachNum;
        Boolean showCopyNum = (Boolean)this.getView().getFormShowParameter().getCustomParam(SHOW_COPY_NUM);
        if (!showCopyNum.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"copynumlabelap", "copynumflexap"});
        }
        String taskId = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get(TASK_ID));
        this.getPageCache().put(TASK_ID, taskId);
        String imageNum = (String)distributeCache.get(taskId + "_imagenum");
        if (imageNum == null || (attachNum = Integer.parseInt(imageNum)) == 0) {
            this.getPageCache().put(ATTACH_NUM, "0");
            return;
        }
        this.getPageCache().put(ATTACH_NUM, String.valueOf(attachNum));
        int curIndex = 1;
        Tuple tuple = PrtTaskResultServiceHelper.loopGetPrtResult((String)(this.getTaskId() + curIndex), (long)60000L);
        if (tuple.item2 == null) {
            return;
        }
        PrintPreviewNewPlugin.createImageAp((Container)this.getControl(IMAGE_FLAX), taskId, curIndex, ((PrtTaskResult.Attach)tuple.item2).getExtParam(), 672, 532, 60, 20);
        this.getPageCache().put(CUR_INDEX, "1");
        Label label = (Label)this.getControl(PAGENUM_LB);
        label.setText(String.format(pageNumFormat, 1, attachNum));
        Map<String, Object> settingMap = this.getPrintSetting();
        Object printerId = settingMap.get("printerid");
        if (printerId != null && (cloudPrint = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(printerId.toString()), (String)"bos_cloudprintmanage")) != null && "B".equals(cloudPrint.getString("group.servicetype"))) {
            this.getModel().setValue(PRINTER, settingMap.get("printerid"));
        }
        if ((copyNum = settingMap.get("copyNum")) == null || !showCopyNum.booleanValue()) {
            this.getModel().setValue(COPY_NUM, (Object)1);
        } else {
            this.getModel().setValue(COPY_NUM, copyNum);
        }
    }

    public static void createImageAp(Container container, String taskId, int curIndex, String scaleValue, int maxWidth, int maxHeight, int leftPadding, int topPadding) {
        double scale;
        String url = String.format("api/print/download.do?attachId=%s", taskId + curIndex);
        maxWidth -= leftPadding * 2;
        maxHeight -= topPadding * 2;
        int width = 0;
        int height = 0;
        if (!StringUtils.isEmpty((CharSequence)scaleValue) && (scale = Double.parseDouble(scaleValue)) != 0.0) {
            if (scale > 1.0) {
                height = (int)((double)maxWidth / scale);
                width = maxWidth;
            } else {
                width = (int)((double)maxHeight * scale);
                height = maxHeight;
            }
        }
        ImageAp imageAp = new ImageAp();
        imageAp.setKey(IMAGE_AP);
        imageAp.setImageKey(url);
        imageAp.setWidth(new LocaleString(width + "px"));
        imageAp.setHeight(new LocaleString(height + "px"));
        imageAp.setClickable(true);
        container.deleteControls(new String[]{IMAGE_AP});
        container.addControls(Collections.singletonList(imageAp.createControl()));
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (IMAGE_AP.equals(e.getKey())) {
            Image image = new Image();
            image.setKey(IMAGE_AP);
            image.setView(this.getView());
            image.addClickListener((ClickListener)this);
            e.setControl((Control)image);
        }
    }

    private Map<String, Object> getPrintSetting() {
        String settingData = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)this.getSettingKey());
        if (settingData != null) {
            return (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return Collections.emptyMap();
    }

    private String getSettingKey() {
        return this.getView().getFormShowParameter().getCustomParam("bizFormId") + CONFIG_COMMON_SUFFIX;
    }

    public void click(EventObject evt) {
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        if (NEXT_VT.equals(key)) {
            this.viewImage(this.nextPage(this.getAttachNum()));
        } else if (PREV_VT.equals(key)) {
            this.viewImage(this.prePage());
        } else if (SAVE_SETTINGS.equals(key)) {
            if (!this.validateSettings()) {
                return;
            }
            Integer copyNum = (Integer)this.getModel().getValue(COPY_NUM);
            DynamicObject printer = (DynamicObject)this.getModel().getValue(PRINTER);
            Map<String, Object> settingMap = this.getPrintSetting();
            if (copyNum != null) {
                settingMap.put("copyNum", copyNum);
            }
            Object printerId = null;
            if (printer != null) {
                printerId = printer.getPkValue();
            }
            settingMap.put("printerid", printerId);
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)this.getSettingKey(), (String)SerializationUtils.toJsonString(settingMap));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PrintPreviewNewPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
        } else if (IMAGE_AP.equals(key)) {
            PrintResultPlugin.showPictureView((IFormView)this.getView(), (String[])this.getSrcs(), (int)(Integer.parseInt(this.getPageCache().get(CUR_INDEX)) - 1));
        } else if ("clientprint".equals(key)) {
            OperationResult operationResult;
            if (!this.validateSettings()) {
                return;
            }
            PrintOperationHelper.PrintOperateParam param = new PrintOperationHelper.PrintOperateParam();
            DynamicObject printer = (DynamicObject)this.getModel().getValue(PRINTER);
            if (printer != null) {
                PrintClientUtil.CloudPrinter cloudPrint;
                param.setPrinterId((Long)printer.getPkValue());
                if (param.getPrinterId() == null || (cloudPrint = PrintClientUtil.getCloudPrinter((long)param.getPrinterId())) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u673a\u3002", (String)"Print_9", (String)"bos-noteprint", (Object[])new Object[0]));
                    return;
                }
                PrintClientUtil.PrinterStatus printerStatus = PrintClientUtil.printerStatus((String)cloudPrint.getServiceN(), (String)cloudPrint.getPrinterName(), (String)cloudPrint.getServiceType());
                if (printerStatus == PrintClientUtil.PrinterStatus.offline) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u5ba2\u6237\u7aef\u4e0d\u5728\u7ebf\u3002", (String)"ClientPreview_3", (String)"bos-noteprint", (Object[])new Object[0]));
                    return;
                }
                if (printerStatus == PrintClientUtil.PrinterStatus.busy) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6253\u5370\u673a\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ClientPreview_9", (String)"bos-noteprint", (Object[])new Object[0]));
                    return;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u673a\u3002", (String)"Print_9", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            List pkIds = (List)this.getView().getFormShowParameter().getCustomParam(PK_IDS);
            if (pkIds != null) {
                param.setPkIds(pkIds);
            }
            String curLang = RequestContext.get().getLang().toString();
            String printLangStr = (String)this.getPrintSetting().get("printlang");
            if (StringUtils.isNotBlank((CharSequence)printLangStr)) {
                curLang = printLangStr;
            }
            param.setLang(curLang);
            Object printJobs = this.getView().getFormShowParameter().getCustomParam(PRINT_JOBS);
            if (printJobs != null) {
                param.setPrintJobs(SerializationUtils.fromJsonStringToList((String)printJobs.toString(), PrintJob.class));
            }
            String bizFormId = (String)this.getView().getFormShowParameter().getCustomParam("bizFormId");
            param.setFormId(bizFormId);
            Object copyNum = this.getModel().getValue(COPY_NUM);
            if (copyNum == null) {
                param.setCopyNum(1);
            } else {
                param.setCopyNum(Integer.parseInt(copyNum.toString()));
            }
            Object extParam = this.getView().getFormShowParameter().getCustomParam("extParam");
            if (StringUtils.isNotBlank((Object)extParam)) {
                Map extParamMap = (Map)SerializationUtils.fromJsonString((String)((String)extParam), Map.class);
                param.setExtParam(extParamMap);
            }
            if ((operationResult = PrintOperationHelper.doPrintOperation(this.getView(), param)).isSuccess()) {
                String parentPageId = this.getView().getFormShowParameter().getParentPageId();
                IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
                parentView.showSuccessNotification(operationResult.getMessage());
                this.getView().sendFormAction(parentView);
                this.getView().close();
                if (pkIds != null) {
                    PrintOperationHelper.updatePrintCountField(bizFormId, new ArrayList<Object>(pkIds));
                }
                String appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(bizFormId);
                PrintOpLogUtils.addLog((String)appId, (String)FORM_ID, (String)bizFormId, (PrintOpLogMsgEnum)PrintOpLogMsgEnum.PRINT_SUCEESS);
            }
        }
    }

    private boolean validateSettings() {
        Object value = this.getModel().getValue(PRINTER);
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u673a\u3002", (String)"Print_9", (String)"bos-noteprint", (Object[])new Object[0]));
            return false;
        }
        Integer copyNum = (Integer)this.getModel().getValue(COPY_NUM);
        if (copyNum > 100 || copyNum < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efd\u6570\u8d85\u51fa\u6700\u5927\u8303\u56f4[1,100]\u3002", (String)"PrintPreviewNewPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void viewImage(int curIndex) {
        Label label = (Label)this.getControl(PAGENUM_LB);
        int attachNum = this.getAttachNum();
        Tuple tuple = PrtTaskResultServiceHelper.loopGetPrtResult((String)(this.getTaskId() + curIndex), (long)5000L);
        if (tuple.item2 != null) {
            PrintPreviewNewPlugin.createImageAp((Container)this.getControl(IMAGE_FLAX), this.getTaskId(), curIndex, ((PrtTaskResult.Attach)tuple.item2).getExtParam(), 672, 532, 60, 20);
            label.setText(String.format(pageNumFormat, curIndex, attachNum));
            this.getPageCache().put(CUR_INDEX, Integer.toString(curIndex));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        BosPrintService service = (BosPrintService)ServiceFactory.getService(BosPrintService.class);
        service.stopPrint(String.valueOf(this.getTaskId()));
    }

    private String getTaskId() {
        return this.getPageCache().get(TASK_ID);
    }

    private int getAttachNum() {
        return Integer.parseInt(this.getPageCache().get(ATTACH_NUM));
    }

    private String[] getSrcs() {
        int attachNum = this.getAttachNum();
        String[] srcs = new String[attachNum];
        String taskId = this.getTaskId();
        for (int i = 0; i < attachNum; ++i) {
            srcs[i] = String.format("api/print/download.do?attachId=%s", taskId + (i + 1));
        }
        return srcs;
    }

    private int nextPage(int size) {
        int curIndex;
        String index = this.getPageCache().get(CUR_INDEX);
        if (index == null) {
            index = "0";
        }
        if ((curIndex = Integer.parseInt(index)) < size) {
            ++curIndex;
        }
        return curIndex;
    }

    private int prePage() {
        int curIndex;
        String index = this.getPageCache().get(CUR_INDEX);
        if (index == null) {
            index = "0";
        }
        if ((curIndex = Integer.parseInt(index)) > 1) {
            --curIndex;
        }
        return curIndex;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataEntityProperty property = evt.getProperty();
        if (PRINTER.equals(property.getName())) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bos_cloudprintmanage", (Long)RequestContext.get().getOrgId());
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("group.servicetype", "=", (Object)"B"));
            qFilters.add(orgFilter);
            formShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("servicetype", "=", (Object)"B"));
        }
    }
}

