/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.basedata.query.BillTypeQueryHelper;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.print.ComplexSettingItem;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.report.IReportView;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.template.orgctrl.model.TemplateInfo;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class PrintSettingPlugin
extends AbstractFormPlugin
implements ClickListener,
TabSelectListener,
BeforeF7SelectListener {
    private static final String KEY_ADVGRID = "adventryentity";
    private static final String KEY_BASEGRID = "baseentryentity";
    private static final String CONFIG_COMMON_SUFFIX = "_printsetting";
    private static final String KEY_FILTERNAME = "filtername";
    public static final String KEY_FORMID = "formid";
    private static final String KEY_DEFAULTTEMPLATE = "defaulttemplate";
    private static final String KEY_TEMPLATEID = "templateid";
    private static final String KEY_FILTERTEMPLATEID = "filtertemplateid";
    private static final String KEY_DEFAULTPRINTER = "defaultprinter";
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String KEY_BILLTYPEID = "billtypeid";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_FILTERTYPE = "filtertype";
    private static final String BAS_MANAGEPRINTTPL = "bas_manageprinttpl";
    private static final String RESET = "reset";
    private static final String PRINTLANG = "printlang";
    private static final String PRINTTPLID = "printtplid";
    private static final String NAME = "name";
    private static final String PRINTERID = "printerid";
    private static final String TEMPLATE_CACHE_KEY = "TEMPLATE_CACHE_KEY";
    public static final String PRINT_PREVIEW_TYPE = "previewtype";
    public static final String HIDE_LOCAL_PREVIEW = "nlocalpreview";
    public static final String PDF_CREATE_TYPE = "filecreatetype";

    public void initialize() {
        super.initialize();
        String formType = (String)this.getView().getFormShowParameter().getCustomParam("formtype");
        boolean isDynamicForm = this.isDynamicForm();
        if ("IReportView".equals(formType) || isDynamicForm) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap", "tabpageap1"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit printer = (BasedataEdit)this.getControl(KEY_DEFAULTPRINTER);
        printer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btnok", "btncancel", "btnreset", KEY_FILTERNAME});
    }

    public void afterCreateNewData(EventObject e) {
        String formId;
        super.afterCreateNewData(e);
        if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap"});
        }
        if (StringUtils.isBlank((CharSequence)(formId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_FORMID)))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"PrintingSchemePlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        Map<String, String> templates = this.getCacheTemplates(formId, appId);
        if (!templates.isEmpty()) {
            this.initDefaultCombo(KEY_DEFAULTTEMPLATE, templates, false);
            Map<String, String> templateForBill = ParamUtils.isTemplateOrgIsolated() ? PrintTemplateServiceFactory.getService().getUserPermOldPrintTemplateMap(formId, appId) : PrintSettingPlugin.getNewTemplates(formId, false);
            this.initDefaultCombo(KEY_TEMPLATEID, templateForBill, false);
            this.initDefaultCombo(KEY_FILTERTEMPLATEID, templates, true);
        }
        this.initPrintLangCombo();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            this.initBaseGrid(formId);
            String settingData = this.getPrintSetting(formId);
            if (StringUtils.isNotBlank((CharSequence)settingData)) {
                this.initSetting(settingData);
            } else {
                String defaultTemplateId = PrintSettingPlugin.getManageDefaultTemplateId(formId);
                if (StringUtils.isNotBlank((CharSequence)defaultTemplateId)) {
                    this.getModel().setValue(KEY_DEFAULTTEMPLATE, (Object)defaultTemplateId);
                }
                Lang lang = RequestContext.get().getLang();
                this.getModel().setValue(PRINTLANG, (Object)(lang == null ? "" : lang.getLocale().toString()));
            }
        }
    }

    private String getPrintSetting(String formId) {
        String userId = RequestContext.get().getUserId();
        String key = formId + CONFIG_COMMON_SUFFIX;
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        return settingData;
    }

    static String getManageDefaultTemplateId(String formId) {
        String entityId = formId;
        String tplId = "";
        QFilter[] qFilters = new QFilter[]{new QFilter("billformid", "=", (Object)entityId), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter(KEY_ENABLE, "=", (Object)Boolean.TRUE)};
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)BAS_MANAGEPRINTTPL, (String)"printtplid.id", (QFilter[])qFilters);
        if (defaultObj != null) {
            tplId = (String)defaultObj.get("printtplid.id");
        }
        return tplId;
    }

    public void click(EventObject evt) {
        String controlKey;
        Control control = (Control)evt.getSource();
        switch (controlKey = control.getKey()) {
            case "btnok": {
                String message = this.validAdvSetting();
                if (StringUtils.isEmpty((CharSequence)message)) {
                    this.saveSetting();
                    break;
                }
                this.getView().showErrorNotification(message);
                break;
            }
            case "filtername": {
                this.showFilterEditer();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnreset": {
                String formId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_FORMID);
                this.getModel().setValue(KEY_DEFAULTTEMPLATE, (Object)PrintSettingPlugin.getManageDefaultTemplateId(formId));
                this.getModel().setValue(KEY_DEFAULTPRINTER, (Object)"");
                Lang lang = RequestContext.get().getLang();
                this.getModel().setValue(PRINTLANG, (Object)(lang == null ? "" : lang.getLocale().toString()));
                this.getModel().deleteEntryData(KEY_BASEGRID);
                this.initBaseGrid(formId);
                this.getModel().deleteEntryData(KEY_ADVGRID);
                this.getModel().setValue("hsavepage", (Object)"");
                this.getModel().setValue("vsavepage", (Object)"");
                this.getModel().setValue("economizebybill", (Object)"");
                this.getModel().setValue("pagenumtype", (Object)"");
                this.getModel().setValue("pageseparation", (Object)"");
                this.getModel().setValue(PDF_CREATE_TYPE, (Object)"");
                this.getPageCache().put(RESET, "true");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map retData;
        super.closedCallBack(evt);
        if (KEY_FILTERNAME.equals(evt.getActionId()) && (retData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ADVGRID);
            this.getModel().setValue(KEY_FILTERNAME, retData.get(NAME), currentRowIndex);
            this.getModel().setValue(KEY_FILTERCONDITION, retData.get("condition"), currentRowIndex);
        }
    }

    private void initBaseGrid(String formId) {
        DynamicObjectCollection billtypeObjs = BillTypeQueryHelper.queryAllBillType((String)formId, (String)"id,name,defprinttemplate");
        if (billtypeObjs != null && !billtypeObjs.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(KEY_BASEGRID, billtypeObjs.size());
            for (int i = 0; i < billtypeObjs.size(); ++i) {
                String templateId;
                DynamicObject billtypeObj = (DynamicObject)billtypeObjs.get(i);
                Long id = (Long)billtypeObj.getPkValue();
                ILocaleString localeName = billtypeObj.getLocaleString(NAME);
                String name = localeName.getLocaleValue();
                String defprinttemplate = billtypeObj.getString("defprinttemplate");
                this.getModel().setValue("billtypename", (Object)name, i);
                this.getModel().setValue(KEY_BILLTYPEID, (Object)id, i);
                if (StringUtils.isNotBlank((CharSequence)defprinttemplate) && this.isExistEnableTpl(defprinttemplate)) {
                    this.getModel().setValue(KEY_TEMPLATEID, (Object)defprinttemplate, i);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)defprinttemplate) || !this.isExistEnableTpl(templateId = MetadataDao.getIdByNumber((String)defprinttemplate, (MetaCategory)MetaCategory.Form))) continue;
                this.getModel().setValue(KEY_TEMPLATEID, (Object)templateId, i);
            }
        }
    }

    private void initSetting(String settingData) {
        Object fileCreateType;
        Object hideLocalPreview;
        Object printPreviewType;
        Object copyNum;
        Object pageSeparation;
        Object pageNumType;
        Object economizeByBill;
        Object vSavePage;
        Object hSavePage;
        Object complexSetting;
        Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        Object defaultTemplate = jsonData.get("template");
        Object defaultTemplateId = jsonData.get(KEY_TEMPLATEID);
        Object printerId = jsonData.get(PRINTERID);
        Object printLang = jsonData.get(PRINTLANG);
        if (StringUtils.isNotBlank(printLang)) {
            this.getModel().setValue(PRINTLANG, printLang);
        } else {
            Lang lang = RequestContext.get().getLang();
            this.getModel().setValue(PRINTLANG, (Object)lang.getLocale().toString());
        }
        if (StringUtils.isBlank(defaultTemplateId) && StringUtils.isNotBlank(defaultTemplate)) {
            String templateId = MetadataDao.getIdByNumber((String)defaultTemplate.toString(), (MetaCategory)MetaCategory.Form);
            defaultTemplateId = templateId;
        }
        if (this.isExistEnableTpl(defaultTemplateId)) {
            this.getModel().setValue(KEY_DEFAULTTEMPLATE, defaultTemplateId);
        }
        this.getModel().setValue(KEY_DEFAULTPRINTER, printerId);
        List baseEntity = (List)jsonData.get("basesetting");
        if (baseEntity != null && !baseEntity.isEmpty()) {
            for (Map map : baseEntity) {
                String billtypeid = (String)map.get(KEY_BILLTYPEID);
                String templateid = (String)map.get(KEY_TEMPLATEID);
                if (billtypeid == null || templateid == null) continue;
                int entryRowCount = this.getModel().getEntryRowCount(KEY_BASEGRID);
                for (int i = 0; i < entryRowCount; ++i) {
                    if (!billtypeid.equals(this.getModel().getValue(KEY_BILLTYPEID, i)) || !this.isExistEnableTpl(templateid)) continue;
                    this.getModel().setValue(KEY_TEMPLATEID, (Object)templateid, i);
                }
            }
        }
        if (StringUtils.isNotBlank(complexSetting = jsonData.get("complexsetting"))) {
            List objs = new ArrayList();
            objs = complexSetting instanceof String ? SerializationUtils.fromJsonStringToList((String)complexSetting.toString(), ComplexSettingItem.class) : SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(complexSetting), ComplexSettingItem.class);
            if (objs != null && objs.size() > 0) {
                this.getModel().batchCreateNewEntryRow(KEY_ADVGRID, objs.size());
                for (int i = 0; i < objs.size(); ++i) {
                    ComplexSettingItem filterItem = (ComplexSettingItem)objs.get(i);
                    this.getModel().setValue(KEY_ENABLE, (Object)filterItem.isEnable(), i);
                    this.getModel().setValue(KEY_FILTERTYPE, (Object)filterItem.getFiltertype(), i);
                    this.getModel().setValue(KEY_FILTERNAME, (Object)filterItem.getFiltername(), i);
                    this.getModel().setValue(KEY_FILTERCONDITION, filterItem.getFiltercondition(), i);
                    if (!this.isExistEnableTpl(filterItem.getFiltertemplateid())) continue;
                    this.getModel().setValue(KEY_FILTERTEMPLATEID, (Object)filterItem.getFiltertemplateid(), i);
                }
            }
        }
        if ((hSavePage = jsonData.get("hSavePage")) instanceof Boolean) {
            this.getModel().setValue("hsavepage", hSavePage);
        }
        if ((vSavePage = jsonData.get("vSavePage")) instanceof Boolean) {
            this.getModel().setValue("vsavepage", vSavePage);
        }
        if ((economizeByBill = jsonData.get("economizeByBill")) instanceof Boolean) {
            this.getModel().setValue("economizebybill", economizeByBill);
        }
        if (StringUtils.isNotBlank(pageNumType = jsonData.get("pageNumType"))) {
            this.getModel().setValue("pagenumtype", pageNumType);
        }
        if (StringUtils.isNotBlank(pageSeparation = jsonData.get("pageSeparation"))) {
            this.getModel().setValue("pageseparation", pageSeparation);
        }
        if ((copyNum = jsonData.get("copyNum")) != null) {
            this.getModel().setValue("copynum", copyNum);
        }
        if (StringUtils.isNotBlank(printPreviewType = jsonData.get(PRINT_PREVIEW_TYPE))) {
            this.getModel().setValue(PRINT_PREVIEW_TYPE, printPreviewType);
        }
        if ((hideLocalPreview = jsonData.get(HIDE_LOCAL_PREVIEW)) instanceof Boolean) {
            this.getModel().setValue(HIDE_LOCAL_PREVIEW, hideLocalPreview);
        }
        if (StringUtils.isNotBlank(fileCreateType = jsonData.get("fileCreateType"))) {
            this.getModel().setValue(PDF_CREATE_TYPE, fileCreateType);
        }
    }

    public static Map<String, String> getTemplates(String formId, String appId) {
        Map<String, String> templates = ParamUtils.isTemplateOrgIsolated() ? PrintTemplateServiceFactory.getService().getUserPermPrintTemplateMap(formId, appId) : PrintSettingPlugin.getNewTemplates(formId, true);
        return templates;
    }

    public static Tuple<Map<String, String>, Map<String, String>> getTemplates(String formId, String appId, boolean includeBizType) {
        Tuple<Map<String, String>, Map<String, String>> templates = ParamUtils.isTemplateOrgIsolated() ? PrintTemplateServiceFactory.getService().getUserPermPrintTemplateMap(formId, appId, includeBizType) : PrintSettingPlugin.getNewTemplates(formId, true, includeBizType);
        return templates;
    }

    private Map<String, String> getCacheTemplates(String formId, String appId) {
        String cacheJson = this.getPageCache().get(TEMPLATE_CACHE_KEY);
        if (StringUtils.isNotBlank((CharSequence)cacheJson)) {
            Map templatesMap = (Map)SerializationUtils.fromJsonString((String)cacheJson, Map.class);
            return templatesMap;
        }
        Map<String, String> templates = ParamUtils.isTemplateOrgIsolated() ? PrintTemplateServiceFactory.getService().getUserPermPrintTemplateMap(formId, appId) : PrintSettingPlugin.getNewTemplates(formId, true);
        this.getPageCache().put(TEMPLATE_CACHE_KEY, SerializationUtils.toJsonString(templates));
        return templates;
    }

    private static Map<String, String> getNewTemplates(String formId, boolean includeNew) {
        List<TemplateInfo> templates = PrintTemplateServiceFactory.getService().getTemplates(formId, includeNew);
        LinkedHashMap<String, String> templateMap = new LinkedHashMap<String, String>(3);
        if (CollectionUtils.isEmpty(templates)) {
            return templateMap;
        }
        for (TemplateInfo info : templates) {
            templateMap.put(info.getId(), info.getName());
        }
        return templateMap;
    }

    private static Tuple<Map<String, String>, Map<String, String>> getNewTemplates(String formId, boolean includeNew, boolean includeBizType) {
        List<TemplateInfo> templates = PrintTemplateServiceFactory.getService().getTemplates(formId, includeNew, includeBizType);
        if (CollectionUtils.isEmpty(templates)) {
            return Tuple.create(null, null);
        }
        LinkedHashMap<String, String> templateMap_0 = new LinkedHashMap<String, String>(3);
        LinkedHashMap<String, String> templateMap_1 = new LinkedHashMap<String, String>(3);
        for (TemplateInfo info : templates) {
            if (info == null) continue;
            if ("1".equals(info.getBizType())) {
                templateMap_1.put(info.getId(), info.getName());
                continue;
            }
            templateMap_0.put(info.getId(), info.getName());
        }
        return Tuple.create(templateMap_0, templateMap_1);
    }

    private void initPrintLangCombo() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        ComboEdit printLangCombo = (ComboEdit)this.getView().getControl(PRINTLANG);
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List enableLangs = inteService.getLocalLangForPrint("1");
        for (EnabledLang lang : enableLangs) {
            ComboItem item = new ComboItem();
            item.setValue(lang.getNumber());
            item.setCaption(new LocaleString(lang.getName()));
            comboItems.add(item);
        }
        printLangCombo.setComboItems(comboItems);
    }

    private void initDefaultCombo(String controlKey, Map<String, String> templatesMap, boolean notEmpty) {
        ComboEdit defaultCombo = (ComboEdit)this.getView().getControl(controlKey);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, String> entry : templatesMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            comboItems.add(item);
        }
        defaultCombo.setComboItems(comboItems);
    }

    private void saveSetting() {
        String settingData = this.buildSettingData();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_FORMID);
        String userId = RequestContext.get().getUserId();
        String key = formId + CONFIG_COMMON_SUFFIX;
        String reset = this.getPageCache().get(RESET);
        if (StringUtils.isBlank((CharSequence)settingData) || StringUtils.isNotBlank((CharSequence)reset) && Boolean.parseBoolean(reset)) {
            if (StringUtils.isBlank((CharSequence)settingData)) {
                UserConfigServiceHelper.clearSetting((long)Long.parseLong(userId), (String)key);
            } else {
                UserConfigServiceHelper.setSetting((long)Long.parseLong(userId), (String)key, (String)settingData);
            }
        } else {
            UserConfigServiceHelper.setSetting((long)Long.parseLong(userId), (String)key, (String)settingData);
        }
        this.getView().close();
    }

    private String buildSettingData() {
        Object value;
        Object copyNum;
        Object pageSeparation;
        Object pageNumType;
        Object vSavePage;
        Object hSavePage;
        String settingData = this.getPrintSetting((String)this.getView().getFormShowParameter().getCustomParam(KEY_FORMID));
        LinkedHashMap<String, Object> data = StringUtils.isNotBlank((CharSequence)settingData) ? (LinkedHashMap<String, Object>)SerializationUtils.fromJsonString((String)settingData, Map.class) : new LinkedHashMap<String, Object>(4);
        String printLang = (String)this.getModel().getValue(PRINTLANG);
        if (printLang != null) {
            data.put(PRINTLANG, printLang);
        }
        String defaulttemplate = (String)this.getModel().getValue(KEY_DEFAULTTEMPLATE);
        data.put(KEY_TEMPLATEID, defaulttemplate);
        Object printerObj = this.getModel().getValue(KEY_DEFAULTPRINTER);
        if (printerObj != null) {
            data.put(PRINTERID, ((DynamicObject)printerObj).getPkValue());
        } else {
            data.put(PRINTERID, null);
        }
        Object previewtype = this.getModel().getValue(PRINT_PREVIEW_TYPE);
        data.put(PRINT_PREVIEW_TYPE, previewtype);
        Object nlocalpreview = this.getModel().getValue(HIDE_LOCAL_PREVIEW);
        if (nlocalpreview instanceof Boolean) {
            data.put(HIDE_LOCAL_PREVIEW, nlocalpreview);
        }
        ArrayList baseEntity = new ArrayList();
        int entryRowCount = this.getModel().getEntryRowCount(KEY_BASEGRID);
        String reset = this.getPageCache().get(RESET);
        for (int i = 0; i < entryRowCount; ++i) {
            String billtypeid = (String)this.getModel().getValue(KEY_BILLTYPEID, i);
            String templateid = "";
            if (!"true".equals(reset)) {
                templateid = (String)this.getModel().getValue(KEY_TEMPLATEID, i);
            }
            HashMap<String, String> billtypeprint = new HashMap<String, String>();
            billtypeprint.put(KEY_BILLTYPEID, billtypeid);
            billtypeprint.put(KEY_TEMPLATEID, templateid);
            if (templateid == null) continue;
            baseEntity.add(billtypeprint);
        }
        if (!baseEntity.isEmpty()) {
            data.put("basesetting", baseEntity);
        }
        DynamicObjectCollection objs = this.getModel().getEntryEntity(KEY_ADVGRID);
        int advSettingCount = this.getModel().getEntryRowCount(KEY_ADVGRID);
        if (advSettingCount >= 0) {
            data.put("complexsetting", objs);
        }
        if (StringUtils.isNotBlank((Object)(hSavePage = this.getModel().getValue("hsavepage")))) {
            data.put("hSavePage", hSavePage);
        }
        if (StringUtils.isNotBlank((Object)(vSavePage = this.getModel().getValue("vsavepage")))) {
            data.put("vSavePage", vSavePage);
        }
        Object economizeByBill = this.getModel().getValue("economizebybill");
        if (StringUtils.isNotBlank((Object)vSavePage)) {
            data.put("economizeByBill", economizeByBill);
        }
        if (StringUtils.isNotBlank((Object)(pageNumType = this.getModel().getValue("pagenumtype")))) {
            data.put("pageNumType", pageNumType);
        }
        if (StringUtils.isNotBlank((Object)(pageSeparation = this.getModel().getValue("pageseparation")))) {
            data.put("pageSeparation", pageSeparation);
        }
        if ((copyNum = this.getModel().getValue("copynum")) != null) {
            data.put("copyNum", copyNum);
        }
        if ((value = this.getModel().getValue(PDF_CREATE_TYPE)) != null) {
            data.put("fileCreateType", value);
        }
        if (data.isEmpty()) {
            return "";
        }
        return SerializationUtils.toJsonString(data);
    }

    private void showFilterEditer() {
        FormMetadata formMeta;
        String entityId;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ADVGRID);
        Object name = this.getModel().getValue(KEY_FILTERNAME, currentRowIndex);
        Object condition = this.getModel().getValue(KEY_FILTERCONDITION, currentRowIndex);
        Object type = this.getModel().getValue(KEY_FILTERTYPE, currentRowIndex);
        if (null == type || StringUtils.isEmpty((CharSequence)type.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u7c7b\u578b\u3002", (String)"PrintingSchemePlugin_3", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        if (Integer.parseInt(type.toString()) == 2) {
            return;
        }
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_FORMID);
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        if (!id.equals(entityId = (formMeta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form)).getEntityId())) {
            formId = MetadataDao.getNumberById((String)entityId);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_printfilterediter");
        showParameter.setCustomParam(KEY_FORMID, (Object)formId);
        showParameter.setCustomParam(NAME, name);
        showParameter.setCustomParam("condition", condition);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_FILTERNAME);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private String validAdvSetting() {
        String message = "";
        DynamicObjectCollection objs = this.getModel().getEntryEntity(KEY_ADVGRID);
        int filtertypecount = 0;
        boolean existTemplateid = true;
        for (DynamicObject obj : objs) {
            if (Integer.parseInt(obj.getString(KEY_FILTERTYPE)) == 2) {
                ++filtertypecount;
            }
            if (!obj.getBoolean(KEY_ENABLE) || !StringUtils.isEmpty((CharSequence)obj.getString(KEY_FILTERTEMPLATEID))) continue;
            existTemplateid = false;
        }
        if (filtertypecount > 1) {
            message = ResManager.loadKDString((String)"\u53ea\u80fd\u6dfb\u52a0\u4e00\u6761\u7c7b\u578b\u4e3a\u201c\u5176\u5b83\u201d\u7684\u6761\u4ef6\u3002", (String)"PrintSettingPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]).replace("\uff01", "\u3002");
        } else if (!existTemplateid) {
            message = ResManager.loadKDString((String)"\u542f\u7528\u6761\u4ef6\u65f6\uff0c\u6253\u5370\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PrintSettingPlugin_2", (String)"bos-noteprint", (Object[])new Object[0]).replace("\uff01", "\u3002");
        }
        return message;
    }

    protected String getDefaulttplInManangeTool(String formId) {
        return PrintSettingPlugin.getManageDefaultTemplateId(formId);
    }

    public void tabSelected(TabSelectEvent tabselectevent) {
    }

    private boolean isExistEnableTpl(Object tplId) {
        boolean isExist = false;
        QFilter[] qFilters = new QFilter[]{new QFilter(PRINTTPLID, "=", tplId), new QFilter(KEY_ENABLE, "=", (Object)"1")};
        isExist = QueryServiceHelper.exists((String)BAS_MANAGEPRINTTPL, (QFilter[])qFilters);
        if (isExist && ParamUtils.isTemplateOrgIsolated()) {
            Map<String, String> cacheTemplates = this.getCacheTemplates((String)this.getView().getFormShowParameter().getCustomParam(KEY_FORMID), this.getView().getFormShowParameter().getAppId());
            return cacheTemplates.containsKey(tplId);
        }
        return isExist;
    }

    private boolean isDynamicForm() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView view = this.getView().getViewNoPlugin(parentPageId);
        boolean isDynamicForm = false;
        isDynamicForm = view instanceof IListView ? false : (view instanceof IReportView ? false : (view instanceof IMobileView ? this.getView() instanceof MobileFormView : !(view instanceof IBillView)));
        return isDynamicForm;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataEntityProperty property = evt.getProperty();
        if (KEY_DEFAULTPRINTER.equals(property.getName())) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bos_cloudprintmanage", (Long)RequestContext.get().getOrgId());
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(orgFilter);
        }
    }
}

