/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.facade.FacadeClassType;
import kd.bos.print.api.facade.IPrintServiceFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;

public class PrintTaskClick
extends AbstractTaskClick {
    private static final Log log = LogFactory.getLog(PrintTaskClick.class);

    public IFormView getParentView() {
        IFormView parentView = null;
        try {
            parentView = super.getParentView();
            if (parentView == null) {
                return this.getViewNoPlugin();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return this.getViewNoPlugin();
    }

    private IFormView getViewNoPlugin() {
        IFormView parentView = null;
        if (this.getJobFormInfo() != null && !StringUtils.isBlank((CharSequence)this.getJobFormInfo().getParentPageId())) {
            parentView = SessionManager.getCurrent().getViewNoPlugin(this.getJobFormInfo().getParentPageId());
        }
        return parentView;
    }

    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo == null) {
            return;
        }
        if (!taskInfo.isTaskEnd()) {
            this.showProgress();
        } else {
            Map data = null;
            if (taskInfo.getData() != null) {
                data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
            }
            List registerCalss = PrtFacadeFactory.getRegisterClass((FacadeClassType)FacadeClassType.PRINT_SERVICE);
            boolean isNotLast = true;
            if (data != null && this.getParentView() != null) {
                IFormView mainView = this.getParentView().getMainView();
                if (Boolean.parseBoolean((String)data.get("success"))) {
                    Object printTaskId = data.get("taskId");
                    if (printTaskId != null) {
                        for (String rc : registerCalss) {
                            try {
                                IPrintServiceFacade printServiceFacade = (IPrintServiceFacade)TypesContainer.getOrRegister((String)rc).newInstance();
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("iFormView", this.getParentView());
                                params.put("result", printTaskId);
                                isNotLast = printServiceFacade.afterDoOperate(params);
                                if (isNotLast) continue;
                                break;
                            }
                            catch (Exception exception) {
                                log.error((Throwable)exception);
                            }
                        }
                        if (isNotLast) {
                            PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)String.valueOf(printTaskId));
                            if (PrintWork.EXP_TYPE.EXP_SCPT.getCode().equals(taskResult.getExtType())) {
                                Object hideLocalPreview = data.get("nlocalpreview");
                                PrintOperationHelper.clientLocalPrint(this.getParentView(), this.getParentView(), taskResult, !Boolean.parseBoolean(String.valueOf(hideLocalPreview)));
                            } else if (PrintWork.EXP_TYPE.EXP_XLS.getCode().equals(taskResult.getExtType())) {
                                PrintOperationHelper.download(this.getParentView(), printTaskId, taskResult.getAttach());
                            } else {
                                List attachList = taskResult.getAttach();
                                if (attachList.size() <= 3) {
                                    for (PrtTaskResult.Attach attach : attachList) {
                                        String attachId = attach.getAttachId();
                                        String downloadUrl = "api/print/download.do?taskId=%s&attachId=%s";
                                        downloadUrl = String.format(downloadUrl, printTaskId, attachId);
                                        if (mainView == null) {
                                            this.getParentView().openUrl(downloadUrl);
                                            continue;
                                        }
                                        FormShowParameter para = new FormShowParameter();
                                        para.setFormId("bos_printpreview");
                                        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                        HashMap<String, String> reservedSpace = new HashMap<String, String>();
                                        reservedSpace.put("reservedSpace", "true");
                                        para.getOpenStyle().setCustParam(reservedSpace);
                                        para.setCustomParam("src", (Object)downloadUrl);
                                        if (mainView.getFormShowParameter().getPageId().equals(this.getParentView().getFormShowParameter().getPageId())) {
                                            downloadUrl = String.format(downloadUrl, printTaskId, attachId);
                                            mainView.openUrl(downloadUrl);
                                            continue;
                                        }
                                        this.getParentView().showForm(para);
                                    }
                                } else {
                                    FormShowParameter para = new FormShowParameter();
                                    para.setFormId("bos_print_resultview");
                                    para.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u7ed3\u679c", (String)"PrintDataProgressFormPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
                                    para.getOpenStyle().setShowType(ShowType.Modal);
                                    para.setCustomParam("taskId", printTaskId);
                                    this.getParentView().showForm(para);
                                }
                            }
                        }
                    }
                } else {
                    this.getParentView().showErrMessage(String.format(ResManager.loadKDString((String)"\u6253\u5370\u9884\u89c8\u62a5\u9519\uff1a%s\u3002", (String)"PrintTaskClick_0", (String)"bos-noteprint", (Object[])new Object[0]), data.get("error")), "");
                }
            } else if (data != null && Boolean.parseBoolean((String)data.get("success"))) {
                IFormView mainView = this.getMainView();
                Object printTaskId = data.get("taskId");
                if (printTaskId != null && mainView != null) {
                    for (String rc : registerCalss) {
                        try {
                            IPrintServiceFacade printServiceFacade = (IPrintServiceFacade)TypesContainer.getOrRegister((String)rc).newInstance();
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put("iFormView", mainView);
                            params.put("result", printTaskId);
                            isNotLast = printServiceFacade.afterDoOperate(params);
                            if (isNotLast) continue;
                            break;
                        }
                        catch (Exception exception) {
                            log.error((Throwable)exception);
                        }
                    }
                    if (isNotLast) {
                        PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)String.valueOf(printTaskId));
                        if (PrintWork.EXP_TYPE.EXP_SCPT.getCode().equals(taskResult.getExtType())) {
                            Object hideLocalPreview = data.get("nlocalpreview");
                            PrintOperationHelper.clientLocalPrint(this.getParentView() == null ? mainView : this.getParentView(), this.getParentView(), taskResult, !Boolean.parseBoolean(String.valueOf(hideLocalPreview)));
                        } else {
                            List attachList = taskResult.getAttach();
                            if (attachList.size() <= 3) {
                                for (PrtTaskResult.Attach attach : attachList) {
                                    String attachId = attach.getAttachId();
                                    String downloadUrl = "api/print/download.do?taskId=%s&attachId=%s";
                                    downloadUrl = String.format(downloadUrl, printTaskId, attachId);
                                    mainView.openUrl(downloadUrl);
                                }
                            } else {
                                FormShowParameter para = new FormShowParameter();
                                para.setFormId("bos_print_resultview");
                                para.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u7ed3\u679c", (String)"PrintDataProgressFormPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
                                para.getOpenStyle().setShowType(ShowType.Modal);
                                para.setCustomParam("taskId", printTaskId);
                                mainView.showForm(para);
                            }
                        }
                    }
                }
            }
            TaskClientProxy.delTask((IFormView)this.getMainView(), (String)this.getTaskId());
        }
        IFormView view = this.getParentView();
        if (view != null && this.getMainView() != null) {
            this.getMainView().sendFormAction(view);
        }
    }

    private void showProgress() {
        if (this.isExistProgressForm()) {
            return;
        }
        IFormView view = this.getParentView();
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (view == null || jobFormInfo == null) {
            this.getMainView().showMessage(ResManager.loadKDString((String)"\u542f\u52a8\u4efb\u52a1\u7684\u754c\u9762\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u518d\u6253\u5f00\u8fdb\u5ea6\u754c\u9762\u3002", (String)"PrintTaskClick_1", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        TaskClientProxy.delTask((IFormView)this.getMainView(), (String)this.getTaskId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_printing");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(false);
        showParameter.getCustomParams().putAll(jobFormInfo.getParams());
        showParameter.getCustomParams().put("print_jobforminfo", SerializationUtils.toJsonString((Object)jobFormInfo));
        showParameter.getCustomParams().put("print_taskid", this.getTaskId());
        view.showForm(showParameter);
        this.setProgressPageId(showParameter.getPageId());
    }
}

