/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Delete;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.print.service.util.PrintClientMsgUtil;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PrinterManageListPlugin
extends AbstractListPlugin {
    private List<Object> clientStatus = null;
    private static final String CLIENT_STATUS = "clientstatus";
    private static final String CLIENT_STATUS_ASC = "clientstatus asc";
    private static final String CLIENT_STATUS_DESC = "clientstatus desc";
    private static final String DELETE = "delete";
    private static final String CLEAR_CACHE = "clearCache";
    private List<String> changeServiceN;

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "iscontainlower"});
    }

    public void setFilter(SetFilterEvent e) {
        Optional<QFilter> first;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        if (qFilters != null && (first = qFilters.stream().filter(f -> CLIENT_STATUS.equals(f.getProperty())).findFirst()).isPresent()) {
            QFilter qFilter = first.get();
            this.clientStatus = (List)qFilter.getValue();
            qFilters.remove(qFilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new PrinterManageList());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ListGridView gridView = (ListGridView)this.getView().getControl("gridview");
        List controls = gridView.getItems();
        controls.stream().filter(f -> f instanceof ListColumn && CLIENT_STATUS.equals(((ListColumn)f).getListFieldKey())).findFirst().ifPresent(control -> {
            ListColumn column = (ListColumn)control;
            column.setBlankFieldCanOrderAndFilter(true);
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (DELETE.equals(args.getOperateKey()) && this.changeServiceN != null) {
            for (String serviceN : this.changeServiceN) {
                PrintClientMsgUtil.sendMsgToClient((String)serviceN, (PrintClientMsgUtil.MsgType)PrintClientMsgUtil.MsgType.S_PRINTER_CHANGE);
            }
        } else if (CLEAR_CACHE.equalsIgnoreCase(args.getOperateKey())) {
            DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_bas_cloudprinter");
            cacheManager.removeByDt();
            this.getView().showSuccessNotification("Success.");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete) {
            Object[] pkIds = args.getListSelectedData().stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            Map map = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)"bos_cloudprintmanage");
            this.changeServiceN = map.values().stream().map(m -> m.getString("group.number")).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
    }

    private class PrinterManageList
    extends ListDataProvider {
        private PrinterManageList() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection data = super.getData(start, limit);
            if (data == null || data.size() <= 0) {
                return data;
            }
            DynamicObjectType type = data.getDynamicObjectType();
            DynamicSimpleProperty dynamicSimpleProperty = new DynamicSimpleProperty(PrinterManageListPlugin.CLIENT_STATUS, String.class, (Object)"");
            type.registerSimpleProperty(dynamicSimpleProperty);
            Iterator iterator = data.iterator();
            List onlineService = PrintClientUtil.getAllOnlineService();
            while (iterator.hasNext()) {
                String flag;
                DynamicObject row = (DynamicObject)iterator.next();
                String serviceN = String.valueOf(row.get("group.number"));
                String serviceType = String.valueOf(row.get("group.servicetype"));
                boolean isOnline = "A".equals(serviceType) ? true : onlineService.contains(serviceN);
                String string = flag = isOnline ? "A" : "B";
                if (PrinterManageListPlugin.this.clientStatus != null && !PrinterManageListPlugin.this.clientStatus.contains(flag)) {
                    iterator.remove();
                }
                row.set(PrinterManageListPlugin.CLIENT_STATUS, (Object)(isOnline ? ResManager.loadKDString((String)"\u5728\u7ebf", (String)"PrinterManageListPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u79bb\u7ebf", (String)"PrinterManageListPlugin_1", (String)"bos-noteprint", (Object[])new Object[0])));
            }
            String orderByExpr = this.getOrderByExpr();
            if (orderByExpr != null && orderByExpr.contains(PrinterManageListPlugin.CLIENT_STATUS)) {
                List filteredRows;
                Comparator nameComparator = (o1, o2) -> {
                    String s1 = o1.getString(PrinterManageListPlugin.CLIENT_STATUS);
                    String s2 = o2.getString(PrinterManageListPlugin.CLIENT_STATUS);
                    if (s1 == null || s2 == null) {
                        return 0;
                    }
                    return s2.compareTo(s1);
                };
                if (orderByExpr.contains(PrinterManageListPlugin.CLIENT_STATUS_ASC)) {
                    filteredRows = data.stream().sorted(nameComparator).collect(Collectors.toList());
                } else if (orderByExpr.contains(PrinterManageListPlugin.CLIENT_STATUS_DESC)) {
                    filteredRows = data.stream().sorted(nameComparator.reversed()).collect(Collectors.toList());
                } else {
                    return data;
                }
                data.clear();
                data.addAll(filteredRows);
            }
            return data;
        }
    }
}

