/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.tree.BizAppTreeBuilder;
import kd.bos.entity.EntityObjectReader;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;

public class PrintingSchemeListEdit
extends StandardTreeListPlugin
implements RowClickEventListener,
ItemClickListener {
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String KEY_TBLNEW = "tblnew";
    private static final String KEY_BILLFORMID = "billformid";
    private static final String KEY_BILLFORMID_APPID = "billformid.bizappid.id";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";
    private static final String UPDATEOTHER_SQL = "update %s set  fispreference = ? where fbillformid = ? and fid <> ?";
    private static final String UPDATE_SQL = "update %s set  fispreference = ? where fid = ?";
    private static final String TABLENAME = "t_bas_printingscheme";
    public static final String ADDNEW_PERMID = "47156aff000000ac";
    public static final String EDIT_PERMID = "4715a0df000000ac";
    public static final String DELETE_PERMID = "4715e1f1000000ac";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String APP_IDS = "appIds";
    private static final String App_EXT_IDS = "appExtIds";
    private QFilter filter = null;

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
    }

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    private void initTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeListModel_0", (String)"bos-noteprint", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("root");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        root.setChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    private List<TreeNode> getCloudNodes() {
        BizAppTreeBuilder bizAppTreeBuilder = new BizAppTreeBuilder();
        bizAppTreeBuilder.setRuntime(true);
        TreeNode root = bizAppTreeBuilder.buildTree();
        Map appExtIds = bizAppTreeBuilder.getAppExtIds();
        this.getPageCache().put(App_EXT_IDS, SerializationUtils.toJsonString((Object)appExtIds));
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>(0);
        }
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        clouds = treeNodeFilter.filterCloudTreeNode(clouds);
        ArrayList appIds = new ArrayList(10);
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudNodeId = PREFIX_CLOUD + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            apps = treeNodeFilter.filterAppTreeNode(apps);
            cloud.setChildren(apps);
            apps.stream().map(TreeNode::getId).forEach(appId -> {
                appIds.add(appId);
                List appExtIdList = (List)appExtIds.get(appId);
                if (appExtIdList != null) {
                    appIds.addAll(appExtIdList);
                }
            });
            if (CollectionUtils.isEmpty((Collection)apps)) {
                cloudIterator.remove();
                continue;
            }
            for (TreeNode app : apps) {
                String appNodeId = PREFIX_APP + app.getId();
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
                app.setChildren(new ArrayList(0));
            }
        }
        this.getPageCache().put(APP_IDS, SerializationUtils.toJsonString(appIds));
        return clouds;
    }

    private List<TreeNode> getChildNodes(String parentId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(parentId, 20);
        if (parent == null) {
            return new ArrayList<TreeNode>();
        }
        if (!parentId.startsWith(PREFIX_APP)) {
            return parent.getChildren();
        }
        if (parent.getChildren() == null || !parent.getChildren().isEmpty()) {
            return parent.getChildren();
        }
        List<TreeNode> billNodes = this.buildBillNodesInApp(parentId.substring(PREFIX_APP.length()));
        if (billNodes == null || billNodes.isEmpty()) {
            return null;
        }
        return billNodes;
    }

    private List<TreeNode> buildBillNodesInApp(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return new ArrayList<TreeNode>(0);
        }
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"));
        QFilter propertyFilter = isTemplateFilter.and(modelTypeFilter);
        QFilter[] filters = new QFilter[]{propertyFilter};
        List billNodes = EntityObjectReader.buildBillNodesInApp((String)appId, (QFilter[])filters);
        if (billNodes == null || billNodes.isEmpty()) {
            return billNodes;
        }
        for (TreeNode bill : billNodes) {
            String parentId = PREFIX_APP + appId;
            bill.setParentid(parentId);
        }
        return billNodes;
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String oldSearchText = pageCache.get("searchText");
        if (!searchText.equals(oldSearchText)) {
            this.loadAppNodes(searchText);
            pageCache.put("searchText", searchText);
        }
        super.search(evt);
    }

    private void loadAppNodes(String searchText) {
        ArrayList<String> selectFields = new ArrayList<String>(4);
        selectFields.add("id");
        selectFields.add("number");
        selectFields.add("name");
        selectFields.add("bizappid");
        Map entityMap = EntityObjectReader.loadEntityObjectsFromCache(selectFields, (QFilter[])new QFilter[]{new QFilter("name", "like", (Object)("%" + searchText + "%"))});
        if (CollectionUtils.isEmpty((Map)entityMap)) {
            return;
        }
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.getRoot();
        Map<String, TreeNode> notLoadAppNodes = this.getNotLoadAppNodes(root);
        Set<String> needLoadAppIdSet = notLoadAppNodes.keySet();
        if (CollectionUtils.isEmpty(needLoadAppIdSet)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID,FMasterId FROM t_meta_bizapp WHERE ", new Object[0]);
        sqlBuilder.appendIn("FMasterId", needLoadAppIdSet.toArray());
        sqlBuilder.append("and FType = '2'", new Object[0]);
        ResultSetHandler action = rs -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            while (rs.next()) {
                String appId = rs.getString("FID");
                String sourceAppId = rs.getString("FMasterId");
                map.put(appId, sourceAppId);
            }
            return map;
        };
        Map appIdMap = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        for (String string : needLoadAppIdSet) {
            appIdMap.put(string, string);
        }
        HashMap<String, Set> sourceAppIdMap = new HashMap<String, Set>(appIdMap.size());
        for (Map.Entry entry : appIdMap.entrySet()) {
            String appId = (String)entry.getKey();
            String sourceAppId = (String)entry.getValue();
            Set childSet = sourceAppIdMap.getOrDefault(sourceAppId, new HashSet(1));
            childSet.add(appId);
            sourceAppIdMap.put(sourceAppId, childSet);
        }
        HashMap<String, List> hashMap = new HashMap<String, List>(needLoadAppIdSet.size());
        HashSet hashSet = new HashSet(16);
        for (Object entityObject : entityMap.values()) {
            String bizappid;
            DynamicObject bizappidObj = entityObject.getDynamicObject("bizappid");
            if (bizappidObj == null || !appIdMap.containsKey(bizappid = String.valueOf(bizappidObj.getPkValue()))) continue;
            String sourceAppId = (String)appIdMap.get(bizappid);
            hashSet.addAll((Collection)sourceAppIdMap.get(sourceAppId));
        }
        Map loadEntityMap = EntityObjectReader.loadEntityObjectsFromCache(selectFields, (QFilter[])new QFilter[]{new QFilter("bizappid", "in", (Object)hashSet.toArray())});
        for (DynamicObject entityObject : loadEntityMap.values()) {
            String bizappid;
            DynamicObject bizappidObj = entityObject.getDynamicObject("bizappid");
            if (bizappidObj == null || !appIdMap.containsKey(bizappid = String.valueOf(bizappidObj.getPkValue()))) continue;
            String sourceAppId = (String)appIdMap.get(bizappid);
            hashSet.addAll((Collection)sourceAppIdMap.get(sourceAppId));
            List entityNodes = hashMap.getOrDefault(sourceAppId, new ArrayList(10));
            String nodeId = entityObject.getString("id");
            String name = entityObject.getLocaleString("name").toString();
            String data = entityObject.getString("number");
            TreeNode node = new TreeNode(PREFIX_APP + sourceAppId, nodeId, name, (Object)data);
            entityNodes.add(node);
            hashMap.put(sourceAppId, entityNodes);
        }
        TreeView treeView = this.getTreeListView().getTreeView();
        for (Map.Entry entry : hashMap.entrySet()) {
            String appId = (String)entry.getKey();
            List children = (List)entry.getValue();
            if (!notLoadAppNodes.containsKey(appId)) continue;
            TreeNode appNode = notLoadAppNodes.get(appId);
            appNode.setChildren(children);
        }
        this.getTreeListView().refreshTreeView();
    }

    private Map<String, TreeNode> getNotLoadAppNodes(TreeNode root) {
        List cloudNodes = root.getChildren();
        HashMap<String, TreeNode> toLoadAppNodes = new HashMap<String, TreeNode>(10);
        if (CollectionUtils.isEmpty((Collection)root.getChildren())) {
            return toLoadAppNodes;
        }
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
            for (TreeNode appNode : appNodes) {
                if (!CollectionUtils.isEmpty((Collection)appNode.getChildren())) continue;
                String appId = String.valueOf(appNode.getId()).substring(PREFIX_APP.length());
                toLoadAppNodes.put(appId, appNode);
            }
        }
        return toLoadAppNodes;
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{BTN_EDIT, BTN_DELETE});
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        List<TreeNode> childNodes = this.getChildNodes(nodeId);
        e.setChildNodes(childNodes);
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        String nodeId = treenodeevent.getNodeId().toString();
        this.getPageCache().put("nodeId", nodeId);
        super.treeNodeClick(treenodeevent);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.filter != null && !e.getQFilters().contains(this.filter)) {
            e.getQFilters().add(this.filter);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        if ("root".equals(nodeId)) {
            String str = this.getPageCache().get(APP_IDS);
            if (str == null) {
                return;
            }
            List appIds = SerializationUtils.fromJsonStringToList((String)str, String.class);
            this.filter = new QFilter(KEY_BILLFORMID_APPID, "in", (Object)appIds);
        } else if (nodeId.startsWith(PREFIX_CLOUD)) {
            TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(nodeId);
            String appExtStr = this.getPageCache().get(App_EXT_IDS);
            if (treeNode != null && appExtStr != null) {
                Map appExtMap = (Map)SerializationUtils.fromJsonString((String)appExtStr, Map.class);
                List children = treeNode.getChildren();
                ArrayList appIds = new ArrayList(10);
                children.stream().map(m -> StringUtils.substringAfter((String)m.getId(), (String)"_")).forEach(appId -> {
                    appIds.add(appId);
                    List appExtIds = (List)appExtMap.get(appId);
                    if (appExtIds != null) {
                        appIds.addAll(appExtIds);
                    }
                });
                this.filter = new QFilter(KEY_BILLFORMID_APPID, "in", appIds);
            }
        } else if (nodeId.startsWith(PREFIX_APP)) {
            Map appExtMap;
            List appExtIds;
            String appId2 = StringUtils.substringAfter((String)nodeId, (String)"_");
            ArrayList<String> appIds = new ArrayList<String>(10);
            appIds.add(appId2);
            String appExtStr = this.getPageCache().get(App_EXT_IDS);
            if (appExtStr != null && (appExtIds = (List)(appExtMap = (Map)SerializationUtils.fromJsonString((String)appExtStr, Map.class)).get(appId2)) != null) {
                appIds.addAll(appExtIds);
            }
            this.filter = new QFilter(KEY_BILLFORMID_APPID, "in", appIds);
            List<TreeNode> nodes = this.getChildNodes(nodeId);
            TreeView tView = this.getTreeListView().getTreeView();
            tView.addNodes(nodes);
        } else {
            this.filter = new QFilter(KEY_BILLFORMID, "=", (Object)nodeId);
        }
        e.addQFilter(this.filter);
        e.setCancel(true);
    }

    public void beforeItemClick(BeforeItemClickEvent arg0) {
        String nodeId = this.getPageCache().get("nodeId");
        if (arg0.getItemKey().equals(KEY_TBLNEW) && (StringUtils.isBlank((CharSequence)nodeId) || "root".equals(nodeId) || nodeId.contains(PREFIX_CLOUD) || nodeId.contains(PREFIX_APP))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u8282\u70b9\u3002", (String)"PrintingSchemeListEdit_3", (String)"bos-noteprint", (Object[])new Object[0]));
            arg0.setCancel(true);
        }
        super.beforeItemClick(arg0);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains(PREFIX_CLOUD) || currentNodeId.contains(PREFIX_APP) || rootId.equals(currentNodeId)) {
            param.setCustomParam("currentNodeId", (Object)currentNodeId);
        } else {
            param.setCustomParam("tree_parent_id", null);
            param.setCustomParam(KEY_BILLFORMID, (Object)currentNodeId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("donothing_setdefault".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractListView_0", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"ManagePrintInfoListEdit_15", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            Long pkid = (Long)listSelectedRow.getPrimaryKeyValue();
            Map cacheObjs = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{pkid}, (String)"bos_printingscheme");
            DynamicObject infoObj = (DynamicObject)cacheObjs.get(pkid);
            if (infoObj == null) {
                return;
            }
            String formId = infoObj.getString("billformId_id");
            boolean enable = infoObj.getBoolean("enable");
            if (enable) {
                this.updateInfo(pkid, formId);
                this.getView().updateView("billlistap");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9996\u9009\u65b9\u6848\u6210\u529f\u3002", (String)"PrintingSchemeListEdit_0", (String)"bos-noteprint", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u9996\u9009\u65b9\u6848\u3002", (String)"PrintingSchemeListEdit_7", (String)"bos-noteprint", (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
    }

    public static boolean checkPagePermission(String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int flag = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)0L, (String)"bos_printingscheme", (String)permissionItemId);
        boolean isHasPermission = flag == 1;
        return isHasPermission;
    }

    private void updateInfo(Object id, Object billFormId) {
        String sql = String.format(UPDATE_SQL, TABLENAME);
        Object[] params = new SqlParameter[]{new SqlParameter("fisdefault", 1, (Object)"1"), new SqlParameter("fid", -5, id)};
        String updataOtherSql = String.format(UPDATEOTHER_SQL, TABLENAME);
        Object[] otherParams = new SqlParameter[]{new SqlParameter("fisdefault", 1, (Object)"0"), new SqlParameter("fbillformid", 12, billFormId), new SqlParameter("fid", -5, id)};
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            DB.execute((DBRoute)DBRoute.basedata, (String)updataOtherSql, (Object[])otherParams);
        }
        catch (OrmException | KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s.", e.getMessage())});
        }
    }
}

