/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class PrintingSchemePlugin
extends AbstractBasePlugIn
implements ClickListener,
BeforeF7SelectListener {
    private static final String F_FILTERTEMPLATEID = "filtertemplateid";
    private static final String F_DEFAULTTEMPLATE = "defaulttemplate";
    private static final String F_FILTERNAME = "filtername";
    public static final String F_BILLFORMID = "billformid";
    private static final String EE_ENTRYENTITY = "complexsetting";
    private static final String UPDATE_SQL = "update %s set fmodifytime = ?, fispreference = ? where fbillformid = ? and fid <> ?";
    private static final String TABLENAME = "t_bas_printingscheme";
    private static final String BOS_NOTEPRINT = "bos-noteprint";

    public void registerListener(EventObject e) {
        BasedataEdit bsdPrintTpl = (BasedataEdit)this.getView().getControl(F_BILLFORMID);
        bsdPrintTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{F_FILTERNAME});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void afterBindData(EventObject e) {
        Map<String, String> templates;
        Object bizEntity;
        super.afterBindData(e);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(F_BILLFORMID);
        if (StringUtils.isBlank((CharSequence)formId) && (bizEntity = this.getModel().getValue(F_BILLFORMID)) != null) {
            formId = ((DynamicObject)bizEntity).getString("number");
        }
        if (StringUtils.isBlank((CharSequence)formId)) {
            formId = this.getPageCache().get(F_BILLFORMID);
        }
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"PrintingSchemePlugin_0", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(F_BILLFORMID, formId);
        this.getModel().setValue(F_BILLFORMID, (Object)formId);
        Map<String, String> map = templates = ParamUtils.isTemplateOrgIsolated() ? PrintTemplateServiceFactory.getService().getUserPermOldPrintTemplateMap(formId) : this.getTemplates(formId);
        if (templates != null && templates.size() > 0) {
            this.initDefaultCombo(F_DEFAULTTEMPLATE, templates, false);
            this.initDefaultCombo(F_FILTERTEMPLATEID, templates, true);
        }
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (F_FILTERNAME.equals(controlKey)) {
            this.showFilterEditer();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        boolean isDefault;
        List erroInfos;
        super.afterDoOperation(arg);
        if ("save".equals(arg.getOperateKey()) && (erroInfos = arg.getOperationResult().getAllErrorOrValidateInfo()).isEmpty() && (isDefault = ((Boolean)this.getModel().getValue("ispreference")).booleanValue())) {
            Object id = this.getModel().getDataEntity().getPkValue();
            DynamicObject formObj = (DynamicObject)this.getModel().getValue(F_BILLFORMID);
            Object formId = formObj.getPkValue();
            this.updatePrintInfo(id, formId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operate.getOperateKey())) {
            DynamicObjectCollection objs = this.getModel().getEntryEntity(EE_ENTRYENTITY);
            int filtertypecount = 0;
            boolean existTemplateid = true;
            for (DynamicObject obj : objs) {
                if (Integer.parseInt(obj.getString("filtertype")) == 2) {
                    ++filtertypecount;
                }
                if (!obj.getBoolean("ischecked") || !StringUtils.isEmpty((CharSequence)obj.getString(F_FILTERTEMPLATEID))) continue;
                existTemplateid = false;
            }
            if (filtertypecount > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u6dfb\u52a0\u4e00\u6761\u7c7b\u578b\u4e3a\u201c\u5176\u5b83\u201d\u7684\u6761\u4ef6\u3002", (String)"PrintingSchemePlugin_1", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                args.setCancel(true);
            } else if (!existTemplateid) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u6761\u4ef6\u65f6\uff0c\u6253\u5370\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PrintingSchemePlugin_2", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        FormShowParameter showParameter = arg0.getFormShowParameter();
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String currentNodeId = (String)configInfo.get("currentNodeId");
        if (showParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            listShowParameter.setCustomParam("currentNodeId", (Object)currentNodeId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map retData;
        super.closedCallBack(evt);
        if (F_FILTERNAME.equals(evt.getActionId()) && (retData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(EE_ENTRYENTITY);
            this.getModel().setValue(F_FILTERNAME, retData.get("name"), currentRowIndex);
            this.getModel().setValue("filtercondition", retData.get("condition"), currentRowIndex);
        }
    }

    private void showFilterEditer() {
        FormMetadata formMeta;
        String entityId;
        Object bizEntity;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(EE_ENTRYENTITY);
        Object name = this.getModel().getValue(F_FILTERNAME, currentRowIndex);
        Object condition = this.getModel().getValue("filtercondition", currentRowIndex);
        Object type = this.getModel().getValue("filtertype", currentRowIndex);
        if (null == type || StringUtils.isEmpty((CharSequence)type.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u7c7b\u578b\u3002", (String)"PrintingSchemePlugin_3", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return;
        }
        if (Integer.parseInt(type.toString()) == 2) {
            return;
        }
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String formId = (String)configInfo.get(F_BILLFORMID);
        if (StringUtils.isBlank((CharSequence)formId) && (bizEntity = this.getModel().getValue(F_BILLFORMID)) != null) {
            formId = ((DynamicObject)bizEntity).getString("number");
        }
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"PrintingSchemePlugin_0", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return;
        }
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        if (!id.equals(entityId = (formMeta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form)).getEntityId())) {
            formId = MetadataDao.getNumberById((String)entityId);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_printfilterediter");
        showParameter.setCustomParam("formid", (Object)formId);
        showParameter.setCustomParam("name", name);
        showParameter.setCustomParam("condition", condition);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, F_FILTERNAME);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void updatePrintInfo(Object id, Object billFormId) {
        String sql = String.format(UPDATE_SQL, TABLENAME);
        Object[] params = new SqlParameter[]{new SqlParameter("fmodifytime", 91, (Object)new Date()), new SqlParameter("fispreference", 1, (Object)"0"), new SqlParameter("fbillformid", 12, billFormId), new SqlParameter("fid", -5, id)};
        try (TXHandle h = TX.beginNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        catch (KDException e) {
            throw e;
        }
        catch (OrmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s.", e.getMessage())});
        }
    }

    private Map<String, String> getTemplates(String formId) {
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        String entityId = formMeta.getEntityId();
        LinkedHashMap<String, String> templateMap = new LinkedHashMap<String, String>(3);
        QFilter filter = new QFilter("modeltype", "=", (Object)"PrintModel");
        QFilter filter1 = new QFilter("basedatafield", "=", (Object)entityId);
        QFilter[] filters = new QFilter[]{filter, filter1};
        String orderBy = "name asc";
        DynamicObject[] formmetaMap = OldPrintTemplateUtil.load((String)"id, number, name", (QFilter[])filters, (String)orderBy);
        if (formmetaMap.length > 0) {
            for (DynamicObject dynamicObject : formmetaMap) {
                Object pkid = dynamicObject.getPkValue();
                DynamicObject printTplInfo = BusinessDataServiceHelper.loadSingle((String)"bas_manageprinttpl", (String)"number, name, enable", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "=", pkid)});
                String name = dynamicObject.getLocaleString("name").getLocaleValue();
                if (printTplInfo == null || !printTplInfo.get("enable").equals("1") && !printTplInfo.get("enable").equals("")) continue;
                templateMap.put(pkid.toString(), name);
            }
        }
        return templateMap;
    }

    private void initDefaultCombo(String controlKey, Map<String, String> templatesMap, boolean notEmpty) {
        String formId;
        String defaulttpId;
        ComboEdit defaultCombo = (ComboEdit)this.getView().getControl(controlKey);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, String> entry : templatesMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            comboItems.add(item);
        }
        defaultCombo.setComboItems(comboItems);
        if (F_DEFAULTTEMPLATE.equals(controlKey) && StringUtils.isNotBlank((CharSequence)(defaulttpId = this.getDefaulttplInManangeTool(formId = (String)this.getView().getFormShowParameter().getCustomParam("formid"))))) {
            this.getModel().setValue(F_DEFAULTTEMPLATE, (Object)defaulttpId);
        }
    }

    protected String getDefaulttplInManangeTool(String formId) {
        String tplId = null;
        QFilter[] qFilters = new QFilter[]{new QFilter(F_BILLFORMID, "=", (Object)formId), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
        Map cacheDatas = BusinessDataServiceHelper.loadFromCache((String)"bas_manageprinttpl", (String)"printtplid.id", (QFilter[])qFilters);
        if (!cacheDatas.isEmpty()) {
            for (Map.Entry cacheData : cacheDatas.entrySet()) {
                DynamicObject manageToolObj = (DynamicObject)cacheData.getValue();
                DynamicObject printtplObj = (DynamicObject)manageToolObj.get("printtplid");
                if (printtplObj == null) continue;
                tplId = (String)printtplObj.getPkValue();
                break;
            }
        }
        return tplId;
    }
}

