/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class UserPrintPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String PRINTSERVICE = "printservice";
    public static final String PRINTERID = "printerid";
    public static final String NUMBER = "serviceid.id";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        BasedataEdit bsdPrintTpl = (BasedataEdit)this.getView().getControl(PRINTERID);
        BasedataEdit printService = (BasedataEdit)this.getView().getControl(PRINTSERVICE);
        bsdPrintTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        printService.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{PRINTERID});
        this.addClickListeners(new String[]{PRINTSERVICE});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject printservice;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        ArrayList<String> userList = new ArrayList<String>();
        if ("save".equals(operate.getOperateKey()) && (printservice = (DynamicObject)this.getModel().getValue(PRINTSERVICE)) != null) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            Object printserviceId = printservice.get("id");
            Object name = printservice.get("name");
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject userid = (DynamicObject)this.getModel().getValue("userid", i);
                DynamicObject printerid = (DynamicObject)this.getModel().getValue(PRINTERID, i);
                if (userid == null || printerid == null) continue;
                Object masterid = userid.get("masterid");
                if (userList.contains(masterid.toString())) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7528\u6237%1$s\u5728\u670d\u52a1%2$s\u5df2\u5b58\u5728\u3002", (String)"UserPrintPlugin_3", (String)"bos-noteprint", (Object[])new Object[0]), userid.get("name"), name));
                    return;
                }
                userList.add(masterid.toString());
                String sql = String.format("select  userprinter.fprintservice as id,userprinter.fnumber as number from %s userprintersetting  left join t_bas_userprinter  userprinter on userprintersetting.fid=userprinter.fid where userprintersetting.fuserid = ? ", "t_bas_userprintersetting");
                Object[] params = new SqlParameter[]{new SqlParameter(":fuserid", -5, masterid)};
                ResultSetHandler<Map<String, Object>> action = new ResultSetHandler<Map<String, Object>>(){

                    public Map<String, Object> handle(ResultSet rs) throws Exception {
                        if (rs.next()) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("id", rs.getObject("id"));
                            map.put("name", rs.getObject("number"));
                            return map;
                        }
                        return null;
                    }
                };
                Map query = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, (ResultSetHandler)action);
                if (query == null || printserviceId == null || query.get("id").toString().equals(printserviceId.toString())) continue;
                args.setCancel(true);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7528\u6237%1$s\u5728\u670d\u52a1%2$s\u5df2\u5b58\u5728\u3002", (String)"UserPrintPlugin_3", (String)"bos-noteprint", (Object[])new Object[0]), userid.get("name"), query.get("name")));
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getView().getModel();
        IDataEntityProperty p = e.getProperty();
        if (p.getName().equals(PRINTSERVICE)) {
            model.setValue(PRINTERID, null);
        }
        super.propertyChanged(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "printerid": {
                DynamicObject printService = (DynamicObject)this.getView().getModel().getValue(PRINTSERVICE);
                Long printMasterId = null;
                if (printService != null) {
                    printMasterId = printService.getLong("id");
                }
                QFilter qFilter = new QFilter(NUMBER, "=", (Object)printMasterId);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                QFilter qFilterTree = new QFilter("id", "=", (Object)printMasterId);
                showParameter.getTreeFilterParameter().getQFilters().add(qFilterTree);
                break;
            }
            case "printservice": {
                Map allData = BusinessDataServiceHelper.loadFromCache((String)"bos_userprinter", (QFilter[])new QFilter[0]);
                ArrayList<Object> list = new ArrayList<Object>(10);
                Iterator it = allData.entrySet().iterator();
                while (it.hasNext()) {
                    Object printServiceId = ((DynamicObject)it.next().getValue()).get("printservice.id");
                    list.add(printServiceId);
                }
                e.addCustomQFilter(new QFilter("id", "not in", list));
                break;
            }
        }
    }
}

