/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print.bluetooth;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;

public class BluePrinterMobileF7Plugin
extends AbstractMobFormPlugin
implements CreateListDataProviderListener,
ListRowClickListener,
IConfirmCallBack {
    public static final String PARAM_LIST = "rows";
    public static final String PARAM_SELECT_ROW = "selectedRow";
    public static final String PARAM_FIELD_NAME = "Name";
    public static final String PARAM_FIELD_CODE = "Code";
    private static final String CONNECT_CALLBACK_ID = "connectBlueToothPrinter";
    private static final String BILL_LIST_SELECTED = "billlistapsel";
    private static final String BILL_LIST = "billlistap";
    private static final String VECTOR_BACK = "vectorapback";
    private static final String LABEL_REFRESH = "labelrefresh";

    public void initialize() {
        super.initialize();
        BillList billListApSel = (BillList)this.getControl(BILL_LIST_SELECTED);
        billListApSel.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billListApSel.addListRowClickListener((ListRowClickListener)this);
        BillList billListAp = (BillList)this.getControl(BILL_LIST);
        billListAp.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billListAp.addListRowClickListener((ListRowClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Vector)this.getControl(VECTOR_BACK)).addClickListener((ClickListener)this);
        ((Label)this.getControl(LABEL_REFRESH)).addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object rows;
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object selectedRow = customParams.get(PARAM_SELECT_ROW);
        if (selectedRow != null) {
            this.setSelectedRow(selectedRow);
        }
        if ((rows = customParams.get(PARAM_LIST)) != null) {
            this.setRows(rows);
        }
    }

    private void setSelectedRow(Object selectedRow) {
        if (selectedRow == null) {
            this.getPageCache().remove(PARAM_SELECT_ROW);
            return;
        }
        this.getPageCache().put(PARAM_SELECT_ROW, SerializationUtils.toJsonString((Object)selectedRow));
    }

    private void setRows(Object rows) {
        if (rows == null) {
            this.getPageCache().remove(PARAM_LIST);
            return;
        }
        this.getPageCache().put(PARAM_LIST, SerializationUtils.toJsonString((Object)rows));
    }

    private Map<String, String> getSelectedRow() {
        String selectedRow = this.getPageCache().get(PARAM_SELECT_ROW);
        if (selectedRow == null) {
            return new HashMap<String, String>(0);
        }
        return (Map)SerializationUtils.fromJsonString((String)selectedRow, Map.class);
    }

    private List<Map<String, String>> getRows() {
        String rows = this.getPageCache().get(PARAM_LIST);
        if (rows == null) {
            return new ArrayList<Map<String, String>>(0);
        }
        return SerializationUtils.fromJsonStringToList((String)rows, Map.class);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        BluePrinterListDataProvider dataProvider = new BluePrinterListDataProvider();
        BillList billList = (BillList)args.getSource();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_cloudprintmanage");
        DynamicObjectCollection collections = new DynamicObjectCollection((DynamicObjectType)mainEntityType, null);
        if (BILL_LIST_SELECTED.equals(billList.getKey())) {
            Map<String, String> selectedRow = this.getSelectedRow();
            if (selectedRow.size() > 0) {
                DynamicObject dynamicObject = (DynamicObject)mainEntityType.createInstance();
                dynamicObject.set("printeraddress", (Object)selectedRow.get(PARAM_FIELD_NAME));
                dynamicObject.set("number", (Object)selectedRow.get(PARAM_FIELD_CODE));
                collections.add((Object)dynamicObject);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BILL_LIST_SELECTED});
            }
        } else if (BILL_LIST.equals(billList.getKey())) {
            List sortedRows = this.getRows().stream().sorted(Comparator.comparing(r -> (String)r.get(PARAM_FIELD_NAME))).collect(Collectors.toList());
            for (Map row : sortedRows) {
                DynamicObject dynamicObject = (DynamicObject)mainEntityType.createInstance();
                dynamicObject.set("printeraddress", row.get(PARAM_FIELD_NAME));
                dynamicObject.set("number", row.get(PARAM_FIELD_CODE));
                collections.add((Object)dynamicObject);
            }
        }
        dataProvider.setCustomData(collections);
        args.setListDataProvider((IListDataProvider)dataProvider);
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList = (BillList)evt.getSource();
        BluePrinterListDataProvider provider = (BluePrinterListDataProvider)billList.getListModel().getProvider();
        DynamicObjectCollection customData = provider.getCustomData();
        int row = evt.getRow();
        if (customData == null || 0 > row || row >= customData.size()) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)customData.get(row);
        String printerAddress = dynamicObject.getString("printeraddress");
        if (BILL_LIST.equals(billList.getKey())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONNECT_CALLBACK_ID, (IConfirmCallBack)this);
            HashMap<Integer, String> btnName = new HashMap<Integer, String>(2);
            btnName.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u8fde\u63a5\u5e76\u9009\u4e2d", (String)"ClientPreview_10", (String)"bos-noteprint", (Object[])new Object[0]));
            btnName.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ClientPreview_8", (String)"bos-noteprint", (Object[])new Object[0]));
            this.getView().showConfirm(printerAddress, "", null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnName, printerAddress);
        } else if (BILL_LIST_SELECTED.equals(billList.getKey())) {
            this.getView().returnDataToParent(this.getSelectedRow());
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (VECTOR_BACK.equals(control.getKey())) {
            this.getView().close();
        } else if (LABEL_REFRESH.equals(control.getKey())) {
            HashMap<String, Object> parameter = new HashMap<String, Object>(2);
            parameter.put("method", "openBluetooth");
            parameter.put("args", new HashMap(0));
            this.getView().executeClientCommand("callYZJApi", new Object[]{parameter});
        }
    }

    public void customEvent(CustomEventArgs e) {
        Object success;
        Map resultMap;
        String eventArgs;
        String eventName = e.getEventName();
        if ("openBluetooth".equals(eventName) && (eventArgs = e.getEventArgs()) != null && (resultMap = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class)) != null && (success = resultMap.get("success")) != null) {
            List devices;
            Map errData;
            if (!Boolean.parseBoolean(success.toString()) && (errData = (Map)resultMap.get("data")) != null) {
                this.showErrorMsg(errData.get("errCode"));
            } else if (Boolean.parseBoolean(success.toString()) && (devices = (List)resultMap.get("data")) != null) {
                Map<String, String> selectedRow = this.getSelectedRow();
                Optional<Map> first = devices.stream().filter(f -> StringUtils.equals((CharSequence)String.valueOf(f.get(PARAM_FIELD_NAME)), (CharSequence)((CharSequence)selectedRow.get(PARAM_FIELD_NAME)))).findFirst();
                if (first.isPresent()) {
                    devices.remove(first.get());
                }
                devices = devices.stream().sorted(Comparator.comparing(r -> String.valueOf(r.get(PARAM_FIELD_NAME)))).collect(Collectors.toList());
                this.setRows(devices);
                BillList billListAp = (BillList)this.getControl(BILL_LIST);
                billListAp.refresh();
                BillList billListSelAp = (BillList)this.getControl(BILL_LIST_SELECTED);
                billListSelAp.refresh();
            }
        }
    }

    private void showErrorMsg(Object errCode) {
        if (errCode == null) {
            errCode = "-1";
        }
        switch (errCode.toString()) {
            case "10000": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316\u84dd\u7259\u9002\u914d\u5668\u3002", (String)"MobilePrintSettingPlugin_12", (String)"bos-noteprint", (Object[])new Object[0]));
                break;
            }
            case "10001": 
            case "10002": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u624b\u673a\u8bbe\u7f6e\u4e2d\u5f00\u542f\u4f01\u4e1a\u5fae\u4fe1\u7684\u84dd\u7259\u8bbf\u95ee\u3002", (String)"MobilePrintSettingPlugin_13", (String)"bos-noteprint", (Object[])new Object[0]));
                break;
            }
            default: {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u84dd\u7259\u6253\u5370\u673a\u5df2\u65ad\u5f00\uff0c\u8bf7\u91cd\u65b0\u8fde\u63a5\u3002", (String)"MobilePrintSettingPlugin_14", (String)"bos-noteprint", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (CONNECT_CALLBACK_ID.equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            Optional<Map> firstOp;
            String name = e.getCustomVaule();
            if (name == null) {
                return;
            }
            BillList billListApSel = (BillList)this.getControl(BILL_LIST_SELECTED);
            BillList billListAp = (BillList)this.getControl(BILL_LIST);
            List<Map<String, String>> rows = this.getRows();
            Map<String, String> selectedRow = this.getSelectedRow();
            if (selectedRow.size() > 0) {
                rows.add(selectedRow);
            }
            if (!(firstOp = rows.stream().filter(f -> name.equals(f.get(PARAM_FIELD_NAME))).findFirst()).isPresent()) {
                return;
            }
            Map removeRow = firstOp.get();
            rows.remove(removeRow);
            this.setSelectedRow(removeRow);
            this.setRows(rows);
            billListAp.refresh();
            billListApSel.refresh();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BILL_LIST_SELECTED});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent(this.getSelectedRow());
    }

    private static class BluePrinterListDataProvider
    extends ListDataProvider {
        private DynamicObjectCollection customData;

        private BluePrinterListDataProvider() {
        }

        public void setCustomData(DynamicObjectCollection customData) {
            this.customData = customData;
        }

        public DynamicObjectCollection getCustomData() {
            return this.customData;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            return this.customData;
        }
    }
}

