/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.IBaseColumn;
import kd.bos.entity.IColumn;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.print.PaperSetting;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.export.IExporter;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.PdfHeaderFooter;
import kd.bos.mvc.export.entity.TreeNode;
import kd.bos.mvc.export.entity.TreeNodeUtil;
import kd.bos.print.core.ctrl.print.io.PrintFontMapper;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.svc.util.print.PrintFileUtil;
import org.apache.commons.collections4.CollectionUtils;

public class GridPdfExporter<T extends IBaseColumn>
implements IExporter<T> {
    private static final Log log = LogFactory.getLog(GridPdfExporter.class);
    private static int currentDpi = -1;
    private static final float PIXEL_PER_LOMETRIC = (float)GridPdfExporter.getCurrentDpi() / 254.3f;
    private static BaseFont baseFont = null;
    private com.lowagie.text.Font font;

    public static int getCurrentDpi() {
        if (currentDpi == -1) {
            try {
                currentDpi = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (Exception e) {
                currentDpi = 96;
            }
        }
        return currentDpi;
    }

    public static final float lom2Pixel(float lom) {
        return (float)((double)(lom * PIXEL_PER_LOMETRIC) + 0.5);
    }

    public static final float pixel2Lom(Float float1) {
        return (float)((double)(float1.floatValue() / PIXEL_PER_LOMETRIC) + 0.5);
    }

    public String export(List<T> columns, DynamicObjectCollection rowDatas, NumberFormatProvider numberFormatProvider, PaperSetting pSetting, Map<String, Object> columnSetting, List<T> rawColumns) {
        return this.export(columns, rowDatas, numberFormatProvider, pSetting, columnSetting, rawColumns, new HashMap<String, Object>(0));
    }

    public String export(List<T> columns, DynamicObjectCollection rowDatas, NumberFormatProvider numberFormatProvider, PaperSetting pSetting, Map<String, Object> columnSetting, List<T> rawColumns, Map<String, Object> customParams) {
        int i;
        float[] newRelativeWidths;
        DynamicObjectType dynamicObjectType = rowDatas.getDynamicObjectType();
        String formName = pSetting.getTitle();
        String formId = dynamicObjectType.getName();
        String appId = pSetting.getAppId();
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        Map<String, Float> columnWidth = this.getColumnWidth(columnSetting);
        Rectangle pz = PageSize.A4;
        String paperType = pSetting.getPaperType();
        if ("b5".equals(paperType)) {
            pz = PageSize.B5;
        }
        Rectangle rotatePage = new Rectangle(pz);
        String orentation = pSetting.getOrentation();
        if (!"vertical".equals(orentation)) {
            rotatePage = pz.rotate();
        }
        float marginLeft = GridPdfExporter.lom2Pixel(pSetting.getMarginLeft() * 10.0f);
        float marginRight = GridPdfExporter.lom2Pixel(pSetting.getMarginRight() * 10.0f);
        float marginTop = GridPdfExporter.lom2Pixel(pSetting.getMarginTop() * 10.0f);
        float marginBottom = GridPdfExporter.lom2Pixel(pSetting.getMarginBottom() * 10.0f);
        float usableWidth = rotatePage.getWidth() - marginLeft - marginRight;
        float[] relativeWidths = this.getrelativeWidths(usableWidth, columns, columnWidth);
        if ("pagewide".equals(pSetting.getWideType())) {
            float allRelativeWidths = 0.0f;
            for (float relativeWidth : relativeWidths) {
                allRelativeWidths += relativeWidth;
            }
            newRelativeWidths = new float[relativeWidths.length];
            for (i = 0; i < relativeWidths.length; ++i) {
                newRelativeWidths[i] = relativeWidths[i] * (usableWidth / allRelativeWidths);
            }
            relativeWidths = newRelativeWidths;
        } else if ("customwide".equals(pSetting.getWideType())) {
            float wideProportion = pSetting.getWideProportion();
            newRelativeWidths = new float[relativeWidths.length];
            for (i = 0; i < relativeWidths.length; ++i) {
                newRelativeWidths[i] = relativeWidths[i] * (wideProportion / 100.0f);
            }
            relativeWidths = newRelativeWidths;
        }
        Document document = new Document(rotatePage, marginLeft, marginRight, marginTop, marginBottom);
        try {
            float top;
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
            BaseFont bfChinese = this.getBaseFont(pSetting.getListFont());
            PdfHeaderFooter headerFooter = new PdfHeaderFooter(bfChinese, 16, 12, rotatePage);
            headerFooter.setHeaderText(pSetting.getTitle());
            headerFooter.setFormId(dynamicObjectType.getName());
            writer.setPageEvent((PdfPageEvent)headerFooter);
            headerFooter.setCustomParams(customParams);
            document.open();
            PdfPTable tbl = new PdfPTable(relativeWidths);
            float allWidth = 0.0f;
            for (float temp : relativeWidths) {
                allWidth += temp;
            }
            tbl.setTotalWidth(allWidth);
            this.createHeadNew(rawColumns, tbl, usableWidth, columnWidth, pSetting);
            Object object = rowDatas.iterator();
            while (object.hasNext()) {
                DynamicObject row = (DynamicObject)object.next();
                this.createDetailRow(columns, row, tbl, pSetting, numberFormatProvider);
            }
            int count = rowDatas.size() + 1;
            float totalWidth = 0.0f;
            float tempWidth = 0.0f;
            int numCols = relativeWidths.length;
            ArrayList<Integer> splitColIndex = new ArrayList<Integer>();
            for (int k = 0; k < numCols; ++k) {
                totalWidth += relativeWidths[k];
                if (!((tempWidth += relativeWidths[k]) > rotatePage.getWidth() - marginLeft - marginRight) || "pagewide".equals(pSetting.getWideType())) continue;
                splitColIndex.add(k);
                tempWidth = relativeWidths[k];
            }
            tbl.setTotalWidth(totalWidth);
            PdfContentByte canvas = writer.getDirectContent();
            float yPos = top = document.top() - 20.0f - 15.0f - tbl.getRowHeight(0);
            int start = 1;
            int stop = 1;
            int pageTotal = 0;
            float tableAreaHeight = document.bottomMargin() + 20.0f;
            float splitColIndexSize = splitColIndex.size();
            pageTotal = this.getPageTotal(tbl, count, top, tableAreaHeight, splitColIndexSize);
            headerFooter.setPageNumber(pageTotal);
            float largeRowHeight = top - tableAreaHeight;
            int pageNumber = 0;
            for (int i2 = 1; i2 < count; ++i2) {
                int index;
                int endIndex;
                int startIndex;
                if (tbl.getRowHeight(i2) > largeRowHeight) {
                    tbl.getRow(i2).setMaxHeights(largeRowHeight);
                    yPos = start == i2 ? tableAreaHeight : (yPos -= tbl.getRowHeight(i2));
                } else {
                    yPos -= tbl.getRowHeight(i2);
                }
                if (yPos < tableAreaHeight) {
                    stop = i2;
                    startIndex = 0;
                    endIndex = -1;
                    for (index = 0; index < splitColIndex.size(); ++index) {
                        endIndex = (Integer)splitColIndex.get(index);
                        tbl.writeSelectedRows(startIndex, endIndex, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                        tbl.writeSelectedRows(startIndex, endIndex, start, stop, document.leftMargin(), top, canvas);
                        document.newPage();
                        ++pageNumber;
                        startIndex = endIndex;
                        if (index != splitColIndex.size() - 1) continue;
                        tbl.writeSelectedRows(startIndex, -1, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                        tbl.writeSelectedRows(startIndex, -1, start, stop, document.leftMargin(), top, canvas);
                    }
                    if (splitColIndex.isEmpty()) {
                        tbl.writeSelectedRows(startIndex, -1, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                        tbl.writeSelectedRows(startIndex, -1, start, stop, document.leftMargin(), top, canvas);
                    }
                    start = stop;
                    document.newPage();
                    yPos = top - tbl.getRowHeight(i2);
                    ++pageNumber;
                }
                if (i2 != count - 1) continue;
                stop = i2 + 2;
                startIndex = 0;
                endIndex = 0;
                for (index = 0; index < splitColIndex.size(); ++index) {
                    endIndex = (Integer)splitColIndex.get(index);
                    tbl.writeSelectedRows(startIndex, endIndex, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                    tbl.writeSelectedRows(startIndex, endIndex, start, stop, document.leftMargin(), top, canvas);
                    document.newPage();
                    ++pageNumber;
                    startIndex = endIndex;
                    if (index != splitColIndex.size() - 1) continue;
                    tbl.writeSelectedRows(startIndex, -1, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                    tbl.writeSelectedRows(startIndex, -1, start, stop, document.leftMargin(), top, canvas);
                }
                if (splitColIndex.isEmpty()) {
                    tbl.writeSelectedRows(startIndex, -1, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                    tbl.writeSelectedRows(startIndex, -1, start, stop, document.leftMargin(), top, canvas);
                }
                ++pageNumber;
            }
            document.addTitle(formName + ".pdf");
            document.close();
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
        return this.writeToFile(fos, formName, formId, appId);
    }

    private BaseFont getBaseFont(String fontName) {
        Font kf;
        BaseFont bfChinese = fontName == null || (kf = KDFont.loadFontFromJAR((String)fontName, (int)0, (float)12.0f)) == null ? baseFont : PrintFontMapper.createInstance().awtToPdf(kf);
        if (bfChinese == null) {
            try {
                bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception ex) {
                log.warn("\u5217\u8868\u6253\u5370--\u521b\u5efa\u6253\u5370\u5b57\u4f53\u5931\u8d25, \u5c06\u5c1d\u8bd5\u4f7f\u7528\u5b57\u4f53\u5305\u521b\u5efa\u5b57\u4f53\u3002 --- " + ex.getCause());
            }
        }
        return bfChinese;
    }

    private int getPageTotal(PdfPTable tbl, int count, float top, float tableAreaHeight, float splitColIndexSize) {
        int pageTotal = 0;
        float yPos = top;
        for (int i = 1; i < count; ++i) {
            if ((yPos -= tbl.getRowHeight(i)) < tableAreaHeight) {
                ++pageTotal;
                pageTotal = (int)((float)pageTotal + splitColIndexSize);
                yPos = top - tbl.getRowHeight(i);
            }
            if (i != count - 1) continue;
            ++pageTotal;
            pageTotal = (int)((float)pageTotal + splitColIndexSize);
        }
        return pageTotal;
    }

    private float[] getrelativeWidths(float usableWidth, List<T> columns, Map<String, Float> columnWidth) {
        int length = columns.size();
        float[] relativeWidths = new float[length];
        int j = 0;
        for (int i = 0; i < columns.size(); ++i) {
            ReportColumn column = (ReportColumn)columns.get(i);
            float width = 60.0f;
            width = columnWidth.containsKey(column.getFieldKey()) ? columnWidth.get(column.getFieldKey()).floatValue() * 3.0f / 4.0f : (column.getWidth() == null ? 30.0f : 30.0f);
            if (width >= usableWidth) {
                width /= 2.0f;
            }
            relativeWidths[j] = width;
            ++j;
        }
        return relativeWidths;
    }

    private void createDetailRow(List<T> columns, DynamicObject rowData, PdfPTable table, PaperSetting setting, NumberFormatProvider numberFormatProvider) {
        com.lowagie.text.Font font = null;
        try {
            int fontSize = (int)setting.getListFieldFont();
            if ("customwide".equals(setting.getWideType())) {
                fontSize = (int)(setting.getListFieldFont() * setting.getWideProportion() / 100.0f);
            }
            font = this.getPdfChineseFont(setting.getListFont(), Math.max(fontSize, 1));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        for (int i = 0; i < columns.size(); ++i) {
            ReportColumn rptColumn = (ReportColumn)columns.get(i);
            PdfPCell pdfCell = new PdfPCell();
            pdfCell.setMinimumHeight(30.0f);
            int hAlignment = 1;
            if (i == 0) {
                hAlignment = 1;
            } else if (i == 1) {
                hAlignment = 0;
            } else if (rptColumn.getStyle() != null) {
                String tAlign;
                switch (tAlign = rptColumn.getStyle().getTextAlign()) {
                    case "right": {
                        hAlignment = 2;
                        break;
                    }
                    case "left": {
                        hAlignment = 0;
                        break;
                    }
                    case "center": {
                        hAlignment = 1;
                        break;
                    }
                    default: {
                        if (rptColumn.getFieldProperty() instanceof IntegerProp || rptColumn.getFieldProperty() instanceof DecimalProp || rptColumn.getFieldProperty() instanceof BigIntProp || rptColumn.getFieldProperty() instanceof AmountProp || rptColumn.getFieldProperty() instanceof PriceProp) {
                            hAlignment = 2;
                            break;
                        }
                        if (rptColumn.getFieldProperty() instanceof CurrencyProp) {
                            hAlignment = 0;
                            break;
                        }
                        hAlignment = 1;
                        break;
                    }
                }
            } else {
                hAlignment = rptColumn.getFieldProperty() instanceof IntegerProp || rptColumn.getFieldProperty() instanceof DecimalProp || rptColumn.getFieldProperty() instanceof BigIntProp || rptColumn.getFieldProperty() instanceof AmountProp || rptColumn.getFieldProperty() instanceof PriceProp ? 2 : (rptColumn.getFieldProperty() instanceof CurrencyProp ? 0 : 1);
            }
            pdfCell.setHorizontalAlignment(hAlignment);
            pdfCell.setVerticalAlignment(1);
            pdfCell.setBackgroundColor(Color.WHITE);
            pdfCell.setBorder(0);
            pdfCell.setBorderWidthTop(0.1f);
            pdfCell.setBorderWidthBottom(0.1f);
            pdfCell.setBorderWidthLeft(0.1f);
            pdfCell.setBorderWidthRight(0.1f);
            if (setting.isWrap()) {
                pdfCell.setMinimumHeight(setting.getListLineHeight());
                pdfCell.setNoWrap(false);
            } else {
                pdfCell.setFixedHeight(setting.getListLineHeight());
            }
            if (rptColumn.getStyle() != null && rptColumn.getStyle().getFontSize() != 12) {
                try {
                    font = this.getPdfChineseFont(setting.getListFont(), rptColumn.getStyle().getFontSize());
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            String text = this.getCellValue((IColumn)rptColumn, rowData, numberFormatProvider);
            Paragraph paragraph = new Paragraph(text, font);
            pdfCell.setPhrase((Phrase)paragraph);
            table.addCell(pdfCell);
        }
    }

    protected String getCellValue(IColumn col, DynamicObject rowData, NumberFormatProvider numberFormatProvider) {
        String result = " ";
        Object value = col.getValue(rowData, numberFormatProvider);
        if (col instanceof ReportColumn && ((ReportColumn)col).getFieldProperty() instanceof ComboProp && value != null) {
            ComboProp combo = (ComboProp)((ReportColumn)col).getFieldProperty();
            value = combo.getItemByName((String)value);
            result = (String)value;
        }
        if (col instanceof ReportColumn && ((ReportColumn)col).getFieldProperty() instanceof FlexProp) {
            value = FlexValueFormatUtils.getReportDisplayValue((DynamicObject)rowData, (FlexProp)((FlexProp)((ReportColumn)col).getFieldProperty()));
            result = value == null ? "" : value.toString();
        } else if ("fseq".equals(col.getFieldKey())) {
            result = value == null ? "" : value.toString();
        } else if (((ReportColumn)col).getFieldProperty() instanceof BigIntProp) {
            result = value == null ? "" : value.toString();
        } else if (col instanceof ReportColumn && (((ReportColumn)col).getFieldProperty() instanceof IntegerProp || ((ReportColumn)col).getFieldProperty() instanceof DecimalProp || ((ReportColumn)col).getFieldProperty() instanceof BigIntProp || ((ReportColumn)col).getFieldProperty() instanceof AmountProp || ((ReportColumn)col).getFieldProperty() instanceof PriceProp)) {
            if (value instanceof Object[] && ((Object[])value).length > 0) {
                value = ((Object[])value)[0];
            }
            result = value != null ? value.toString().replace('\uffe5', '\u00a5') : " ";
        } else if (col instanceof ReportColumn && (((ReportColumn)col).getFieldProperty() instanceof DateProp || ((ReportColumn)col).getFieldProperty() instanceof DateTimeProp)) {
            if (value instanceof Object[]) {
                Object[] val = (Object[])value;
                result = val[0].toString();
            } else {
                result = value == null ? "" : value.toString();
            }
        } else {
            result = col instanceof ReportColumn && ((ReportColumn)col).getFieldProperty() instanceof BooleanProp ? (value == null ? "" : (value instanceof Boolean && (Boolean)value != false ? ResManager.loadKDString((String)"\u662f", (String)"GridPdfExporter_0", (String)"bos-form-mvc", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"GridPdfExporter_1", (String)"bos-form-mvc", (Object[])new Object[0]))) : (value == null ? "" : value.toString());
        }
        return result;
    }

    private String writeToFile(ByteArrayOutputStream fos, String formName, String formId, String appId) {
        try {
            fos.flush();
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        byte[] bytes = fos.toByteArray();
        return PrintFileUtil.byteToTempUrl((String)(formName + ".pdf"), (String)appId, (String)formId, (byte[])bytes);
    }

    private com.lowagie.text.Font getPdfChineseFont(String fontName, int size) {
        if (this.font != null) {
            return this.font;
        }
        this.font = new com.lowagie.text.Font(this.getBaseFont(fontName), (float)size, 0);
        return this.font;
    }

    private Map<String, Float> getColumnWidth(Map<String, Object> columnSetting) {
        try {
            List widthMap = (List)columnSetting.get("cwg");
            HashMap<String, Float> resultWidths = new HashMap<String, Float>(16);
            this.parseColumnWidth(widthMap, resultWidths);
            return resultWidths;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u8868\u683c\u8868\u5934\u5bbd\u5ea6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private void parseColumnWidth(List<Map<String, Object>> widthMap, Map<String, Float> resultWidths) {
        for (Map<String, Object> column : widthMap) {
            if (column.containsKey("children") && column.get("children") != null) {
                Object value = column.get("children");
                if (!(value instanceof List)) continue;
                this.parseColumnWidth((List)value, resultWidths);
                continue;
            }
            resultWidths.put(column.get("colId").toString(), Float.valueOf(Float.parseFloat(column.get("width").toString())));
        }
    }

    private void parseColumnGroup(List<AbstractReportColumn> children, List<ReportColumn> results) {
        for (AbstractReportColumn temp : children) {
            if (temp instanceof ReportColumn && !((ReportColumn)temp).isHide()) {
                results.add((ReportColumn)temp);
                continue;
            }
            if (!(temp instanceof ReportColumnGroup)) continue;
            this.parseColumnGroup(((ReportColumnGroup)temp).getChildren(), results);
        }
    }

    private void createHeadNew(List<T> columns, PdfPTable table, float usableWidth, Map<String, Float> columnWidth, PaperSetting setting) {
        com.lowagie.text.Font font = null;
        try {
            int fontSize = (int)setting.getListFieldFont();
            if ("customwide".equals(setting.getWideType())) {
                fontSize = (int)(setting.getListFieldFont() * setting.getWideProportion() / 100.0f);
            }
            font = this.getPdfChineseFont(setting.getListFont(), Math.max(fontSize, 1));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        for (int i = 0; i < columns.size(); ++i) {
            if (columns.get(i) instanceof ReportColumnGroup) {
                TreeNode rootTreeNode = TreeNodeUtil.buildTree((ReportColumnGroup)columns.get(i), true);
                List<TreeNode> treeNodes = TreeNodeUtil.breadthFirst(rootTreeNode);
                if (!CollectionUtils.isNotEmpty(treeNodes)) continue;
                int maxColspan = treeNodes.get(0).getColspan();
                ArrayList<ReportColumn> actualColumn = new ArrayList<ReportColumn>(maxColspan);
                this.parseColumnGroup(((ReportColumnGroup)columns.get(i)).getChildren(), actualColumn);
                float[] width = this.getrelativeWidths(usableWidth, actualColumn, columnWidth);
                PdfPTable innerTable = new PdfPTable(width);
                for (TreeNode treeNode : treeNodes) {
                    PdfPCell cell = null;
                    Object value = treeNode.getValue();
                    int hAlignment = 0;
                    if (value instanceof ReportColumn) {
                        cell = new PdfPCell((Phrase)new Paragraph(((ReportColumn)value).getCaption().toString(), font));
                        hAlignment = 0;
                        if (((ReportColumn)value).getStyle() != null) {
                            String tAlign;
                            switch (tAlign = ((ReportColumn)value).getStyle().getTextAlign()) {
                                case "right": {
                                    hAlignment = 2;
                                    break;
                                }
                                case "center": {
                                    hAlignment = 1;
                                    break;
                                }
                                case "left": {
                                    hAlignment = 0;
                                    break;
                                }
                                default: {
                                    if (value instanceof DecimalReportColumn) {
                                        hAlignment = 2;
                                        break;
                                    }
                                    hAlignment = 0;
                                    break;
                                }
                            }
                        }
                    } else if (value instanceof ReportColumnGroup) {
                        String align;
                        cell = new PdfPCell((Phrase)new Paragraph(((ReportColumnGroup)value).getCaption().toString(), font));
                        hAlignment = 1;
                        switch (align = ((ReportColumnGroup)value).getTextAlign()) {
                            case "right": {
                                hAlignment = 2;
                                break;
                            }
                            case "left": {
                                hAlignment = 0;
                                break;
                            }
                            default: {
                                hAlignment = 1;
                            }
                        }
                    }
                    if (cell == null) continue;
                    cell.setHorizontalAlignment(hAlignment);
                    cell.setVerticalAlignment(5);
                    cell.setColspan(treeNode.getColspan());
                    cell.setRowspan(treeNode.getRowspan());
                    cell.setNoWrap(false);
                    innerTable.addCell(cell);
                }
                PdfPCell outCell = new PdfPCell(innerTable);
                outCell.setColspan(maxColspan);
                outCell.setRowspan(1);
                table.addCell(outCell);
                continue;
            }
            ReportColumn rptColumn = (ReportColumn)columns.get(i);
            PdfPCell pdfCell = new PdfPCell();
            pdfCell.setMinimumHeight(30.0f);
            int hAlignment = 0;
            if (rptColumn.getStyle() != null) {
                String tAlign;
                switch (tAlign = rptColumn.getStyle().getTextAlign()) {
                    case "right": {
                        hAlignment = 2;
                        break;
                    }
                    case "left": {
                        hAlignment = 0;
                        break;
                    }
                    case "center": {
                        hAlignment = 1;
                        break;
                    }
                    default: {
                        hAlignment = rptColumn.getFieldProperty() instanceof IntegerProp || rptColumn.getFieldProperty() instanceof DecimalProp || rptColumn.getFieldProperty() instanceof BigIntProp || rptColumn.getFieldProperty() instanceof AmountProp || rptColumn.getFieldProperty() instanceof PriceProp ? 2 : (rptColumn.getFieldProperty() instanceof CurrencyProp ? 0 : 1);
                    }
                }
            }
            pdfCell.setHorizontalAlignment(hAlignment);
            pdfCell.setVerticalAlignment(5);
            pdfCell.setBackgroundColor(Color.WHITE);
            pdfCell.setBorder(0);
            pdfCell.setBorderWidthTop(0.1f);
            pdfCell.setBorderWidthBottom(0.1f);
            pdfCell.setBorderWidthLeft(0.1f);
            pdfCell.setBorderWidthRight(0.1f);
            pdfCell.setColspan(1);
            pdfCell.setRowspan(1);
            Paragraph paragraph = new Paragraph(rptColumn.getCaption().toString(), font);
            if ("fseq".equals(rptColumn.getFieldKey())) {
                paragraph = new Paragraph("#", font);
            }
            pdfCell.setPhrase((Phrase)paragraph);
            table.addCell(pdfCell);
        }
    }

    static {
        try {
            Font kf = KDFont.loadFontFromJAR((String)"\u601d\u6e90\u5b8b\u4f53 CN", (int)0, (float)12.0f);
            baseFont = PrintFontMapper.createInstance().awtToPdf(kf);
        }
        catch (Exception e) {
            log.error(e.getCause());
        }
    }
}

