/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.IBaseColumn;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.FormatFieldData;
import kd.bos.entity.list.FormatRowData;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.print.PaperSetting;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.export.IExporter;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.Control;
import kd.bos.inte.api.IInteService;
import kd.bos.list.CheckBoxListColumn;
import kd.bos.list.ComboListColumn;
import kd.bos.list.DateListColumn;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.FlexListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.MergeListColumn;
import kd.bos.list.TimeListColumn;
import kd.bos.list.ViewCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.PdfHeaderFooter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.print.core.ctrl.print.io.PrintFontMapper;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.svc.util.print.PrintDesensitive;
import kd.bos.svc.util.print.PrintFileUtil;

public class ListPdfExporter<T extends IBaseColumn>
implements IExporter<T> {
    private static final Log LOG = LogFactory.getLog(ListPdfExporter.class);
    private static final String ALIAS = "alias";
    private static int currentDotsPerInch = -1;
    private static final float CURRENT_PIXEL_PER_LOMETRIC = (float)ListPdfExporter.getCurrentDpi() / 254.3f;
    private String entityId;
    private FieldControlRules fieldControlRules;
    private static final String REPLACE_CHARS_FOR_ENCRYPTION = "******";
    private static final String B5 = "b5";
    private static final String VERTICAL = "vertical";
    private static final String PAGEWIDE = "pagewide";
    private static final String CUSTOMWIDE = "customwide";
    private static final String EMPTY_LINE = " ";
    private MainEntityType mainEntityType = null;

    public ListPdfExporter() {
    }

    public ListPdfExporter(FieldControlRules fieldControlRules, String entityId) {
        this.fieldControlRules = fieldControlRules;
        this.entityId = entityId;
    }

    public static int getCurrentDpi() {
        if (currentDotsPerInch == -1) {
            try {
                currentDotsPerInch = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (Exception e) {
                currentDotsPerInch = 96;
            }
        }
        return currentDotsPerInch;
    }

    public static final float pixel2Lom(Float float1) {
        return (float)((double)(float1.floatValue() / CURRENT_PIXEL_PER_LOMETRIC) + 0.5);
    }

    public static final float lom2Pixel(float lom) {
        return (float)((double)(lom * CURRENT_PIXEL_PER_LOMETRIC) + 0.5);
    }

    public String export(List<IListColumn> columns, QueryResult queryReslt, Map<String, Object> columnSetting, PaperSetting info) {
        String tempUrl = "";
        try {
            ByteArrayOutputStream fos = this.createPdf(columns, queryReslt, columnSetting, info, new HashMap<String, Object>(0));
            byte[] pdfByte = fos.toByteArray();
            if (pdfByte.length > 0) {
                tempUrl = PrintFileUtil.byteToTempUrl((String)(info.getTitle() + ".pdf"), null, null, (byte[])pdfByte);
            } else {
                LOG.debug("\u5217\u8868\u6253\u5370--\u751f\u6210\u4e86\u7a7aPDF");
            }
        }
        catch (DocumentException | IOException e) {
            LOG.error("\u5217\u8868\u6253\u5370--\u751f\u6210pdf\u5931\u8d25\uff1a" + e);
        }
        return tempUrl;
    }

    public String export(FieldControlRules fieldControlRules, String entityId, List<IListColumn> columns, QueryResult queryReslt, Map<String, Object> columnSetting, PaperSetting info, Map<String, Object> customParams) {
        this.fieldControlRules = fieldControlRules;
        this.entityId = PrintServiceHelper.getRealBillFormId(entityId);
        String tempUrl = "";
        try {
            ByteArrayOutputStream fos = this.createPdf(columns, queryReslt, columnSetting, info, customParams);
            byte[] pdfByte = fos.toByteArray();
            if (pdfByte.length > 0) {
                tempUrl = PrintFileUtil.byteToTempUrl((String)(info.getTitle() + ".pdf"), (String)info.getAppId(), (String)entityId, (byte[])pdfByte);
            } else {
                LOG.debug("\u5217\u8868\u6253\u5370--\u751f\u6210\u4e86\u7a7aPDF");
            }
        }
        catch (DocumentException | IOException e) {
            LOG.error("\u5217\u8868\u6253\u5370--\u751f\u6210pdf\u5931\u8d25\uff1a" + e);
        }
        return tempUrl;
    }

    public String export(FieldControlRules fieldControlRules, String entityId, List<IListColumn> columns, QueryResult queryReslt, Map<String, Object> columnSetting, PaperSetting info) {
        return this.export(fieldControlRules, entityId, columns, queryReslt, columnSetting, info, new HashMap<String, Object>(0));
    }

    private boolean isListColumnVisible(EntityType entityType, Map<String, Boolean> userConfigColumnSettings, IListColumn listColumn) {
        Boolean configColumnVisible;
        String listFieldKey = null;
        int visibleValue = 0;
        if (listColumn != null) {
            listFieldKey = listColumn.getListFieldKey();
            visibleValue = listColumn.getVisible();
        }
        Boolean bl = configColumnVisible = userConfigColumnSettings != null ? userConfigColumnSettings.get(listFieldKey) : null;
        if (configColumnVisible != null) {
            return configColumnVisible;
        }
        boolean listColumnVisible = ViewCommonUtil.getListColumnVisible((boolean)true, (boolean)false, (int)visibleValue);
        if (!listColumnVisible) {
            return false;
        }
        boolean lisColumnHidden = false;
        if (listColumn instanceof IListColumn) {
            lisColumnHidden = listColumn.isListColumnHidden(entityType, true, false);
        } else if (listColumn instanceof MergeListColumn) {
            lisColumnHidden = ((MergeListColumn)listColumn).isListColumnHidden(entityType, true, false);
        } else if (listColumn instanceof ListColumnGroup) {
            // empty if block
        }
        return listColumnVisible && !lisColumnHidden;
    }

    private ByteArrayOutputStream createPdf(List<IListColumn> columns, QueryResult queryReslt, Map<String, Object> columnSetting, PaperSetting pSetting, Map<String, Object> customParams) throws IOException, DocumentException {
        float top;
        int i;
        float[] newRelativeWidths;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityId);
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        Map columnWidth = (Map)columnSetting.get("cw");
        Map columnVisible = (Map)columnSetting.get("cv");
        Map userConfigColumnSettings = columnSetting.getOrDefault("userConfigColumnSettings", new HashMap());
        for (int i2 = 0; i2 < columns.size(); ++i2) {
            IListColumn column = columns.get(i2);
            boolean visible = this.isListColumnVisible((EntityType)dataEntityType, userConfigColumnSettings, column);
            if (visible) {
                column.setVisible(1);
                continue;
            }
            column.setVisible(0);
        }
        List rowDatas = queryReslt.getFormatRowDatas();
        Rectangle pz = PageSize.A4;
        String paperType = pSetting.getPaperType();
        if (B5.equals(paperType)) {
            pz = PageSize.B5;
        }
        Rectangle rotatePage = new Rectangle(pz);
        String orentation = pSetting.getOrentation();
        if (!VERTICAL.equals(orentation)) {
            rotatePage = pz.rotate();
        }
        float marginLeft = ListPdfExporter.lom2Pixel(pSetting.getMarginLeft() * 10.0f);
        float marginRight = ListPdfExporter.lom2Pixel(pSetting.getMarginRight() * 10.0f);
        float marginTop = ListPdfExporter.lom2Pixel(pSetting.getMarginTop() * 10.0f);
        float marginBottom = ListPdfExporter.lom2Pixel(pSetting.getMarginBottom() * 10.0f);
        float usableWidth = rotatePage.getWidth() - marginLeft - marginRight;
        float[] relativeWidths = this.getrelativeWidths(usableWidth, columns, columnWidth);
        if (PAGEWIDE.equals(pSetting.getWideType())) {
            float allRelativeWidths = 0.0f;
            for (float relativeWidth : relativeWidths) {
                allRelativeWidths += relativeWidth;
            }
            newRelativeWidths = new float[relativeWidths.length];
            for (i = 0; i < relativeWidths.length; ++i) {
                newRelativeWidths[i] = relativeWidths[i] * (usableWidth / allRelativeWidths);
            }
            relativeWidths = newRelativeWidths;
        } else if (CUSTOMWIDE.equals(pSetting.getWideType())) {
            float wideProportion = pSetting.getWideProportion();
            newRelativeWidths = new float[relativeWidths.length];
            for (i = 0; i < relativeWidths.length; ++i) {
                newRelativeWidths[i] = relativeWidths[i] * (wideProportion / 100.0f);
            }
            relativeWidths = newRelativeWidths;
        }
        Document document = new Document(rotatePage, marginLeft, marginRight, marginTop, marginBottom);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
        BaseFont bfChinese = null;
        try {
            bfChinese = ListPdfExporter.createBaseFont(pSetting.getListFont());
        }
        catch (Exception ex) {
            LOG.error("\u5217\u8868\u6253\u5370--\u521b\u5efa\u6253\u5370\u5b57\u4f53\u5931\u8d25, \u5c06\u5c1d\u8bd5\u4f7f\u7528\u5b57\u4f53\u5305\u521b\u5efa\u5b57\u4f53\u3002 --- " + ex.getCause());
            bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        PdfHeaderFooter headerFooter = new PdfHeaderFooter(bfChinese, 16, 12, rotatePage);
        headerFooter.setHeaderText(pSetting.getTitle());
        headerFooter.setFormId(this.entityId);
        headerFooter.setCustomParams(customParams);
        writer.setPageEvent((PdfPageEvent)headerFooter);
        document.open();
        PdfPTable tbl = new PdfPTable(relativeWidths);
        this.createHead(columns, tbl, pSetting);
        this.createDetailRow(columns, rowDatas, tbl, pSetting);
        com.lowagie.text.Font summaryfont = null;
        try {
            int fontSize = (int)pSetting.getListFieldFont();
            if (CUSTOMWIDE.equals(pSetting.getWideType())) {
                fontSize = (int)(pSetting.getListFieldFont() * pSetting.getWideProportion() / 100.0f);
            }
            summaryfont = this.getPdfChineseFont(pSetting.getListFont(), fontSize);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        List summayDatas = queryReslt.getSummaryResults();
        if (!summayDatas.isEmpty()) {
            this.createSummaryRow(summaryfont, columns, summayDatas, tbl, pSetting);
        }
        int count = rowDatas.size() + 1;
        if (!summayDatas.isEmpty()) {
            ++count;
        }
        float totalWidth = 0.0f;
        float tempWidth = 0.0f;
        int numCols = relativeWidths.length;
        ArrayList<Integer> splitColIndex = new ArrayList<Integer>(10);
        for (int k = 0; k < numCols; ++k) {
            totalWidth += relativeWidths[k];
            if (!((tempWidth += relativeWidths[k]) > rotatePage.getWidth() - marginLeft - marginRight) || PAGEWIDE.equals(pSetting.getWideType())) continue;
            splitColIndex.add(k);
            tempWidth = relativeWidths[k];
        }
        tbl.setTotalWidth(totalWidth);
        PdfContentByte canvas = writer.getDirectContent();
        float yPos = top = document.top() - 20.0f - 15.0f - tbl.getRowHeight(0);
        int start = 1;
        int stop = 1;
        int pageTotal = 0;
        float tableAreaHeight = document.bottomMargin() + 20.0f;
        float splitColIndexSize = splitColIndex.size();
        pageTotal = this.getPageTotal(tbl, count, top, tableAreaHeight, splitColIndexSize);
        headerFooter.setPageNumber(pageTotal);
        float largeRowHeight = top - tableAreaHeight;
        int pageNumber = 0;
        yPos = top;
        for (int i3 = 1; i3 < count; ++i3) {
            int index;
            int endIndex;
            int startIndex;
            if (tbl.getRowHeight(i3) > largeRowHeight) {
                tbl.getRow(i3).setMaxHeights(largeRowHeight);
                yPos = start == i3 ? tableAreaHeight : (yPos -= tbl.getRowHeight(i3));
            } else {
                yPos -= tbl.getRowHeight(i3);
            }
            if (yPos < tableAreaHeight) {
                stop = i3;
                startIndex = 0;
                endIndex = -1;
                for (index = 0; index < splitColIndex.size(); ++index) {
                    endIndex = (Integer)splitColIndex.get(index);
                    tbl.writeSelectedRows(startIndex, endIndex, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                    tbl.writeSelectedRows(startIndex, endIndex, start, stop, document.leftMargin(), top, canvas);
                    document.newPage();
                    ++pageNumber;
                    startIndex = endIndex;
                    if (index != splitColIndex.size() - 1) continue;
                    tbl.writeSelectedRows(startIndex, -1, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                    tbl.writeSelectedRows(startIndex, -1, start, stop, document.leftMargin(), top, canvas);
                }
                if (splitColIndex.isEmpty()) {
                    tbl.writeSelectedRows(startIndex, -1, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                    tbl.writeSelectedRows(startIndex, -1, start, stop, document.leftMargin(), top, canvas);
                }
                start = stop;
                document.newPage();
                yPos = top - tbl.getRowHeight(i3);
                ++pageNumber;
            }
            if (i3 != count - 1) continue;
            stop = i3 + 2;
            startIndex = 0;
            endIndex = 0;
            for (index = 0; index < splitColIndex.size(); ++index) {
                endIndex = (Integer)splitColIndex.get(index);
                tbl.writeSelectedRows(startIndex, endIndex, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                tbl.writeSelectedRows(startIndex, endIndex, start, stop, document.leftMargin(), top, canvas);
                document.newPage();
                ++pageNumber;
                startIndex = endIndex;
                if (index != splitColIndex.size() - 1) continue;
                tbl.writeSelectedRows(startIndex, -1, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                tbl.writeSelectedRows(startIndex, -1, start, stop, document.leftMargin(), top, canvas);
            }
            if (splitColIndex.isEmpty()) {
                tbl.writeSelectedRows(startIndex, -1, 0, 1, document.leftMargin(), top + tbl.getRowHeight(0), canvas);
                tbl.writeSelectedRows(startIndex, -1, start, stop, document.leftMargin(), top, canvas);
            }
            ++pageNumber;
        }
        document.addTitle(pSetting.getTitle() + ".pdf");
        document.close();
        return fos;
    }

    private int getPageTotal(PdfPTable tbl, int count, float top, float tableAreaHeight, float splitColIndexSize) {
        int pageTotal = 0;
        float yPos = top;
        for (int i = 1; i < count; ++i) {
            if ((yPos -= tbl.getRowHeight(i)) < tableAreaHeight) {
                ++pageTotal;
                pageTotal = (int)((float)pageTotal + splitColIndexSize);
                yPos = top - tbl.getRowHeight(i);
            }
            if (i != count - 1) continue;
            ++pageTotal;
            pageTotal = (int)((float)pageTotal + splitColIndexSize);
        }
        return pageTotal;
    }

    private void createSummaryRow(com.lowagie.text.Font font, List<IListColumn> columns, List<SummaryResult> summayDatas, PdfPTable tbl, PaperSetting pSetting) {
        MainEntityType mainEntityType = this.getMainEntityType();
        if (mainEntityType == null) {
            return;
        }
        Map allFields = mainEntityType.getAllFields();
        for (int i = 0; i < columns.size(); ++i) {
            IListColumn lstColumn = columns.get(i);
            if (lstColumn.getVisible() == 0) continue;
            PdfPCell pdfCell = new PdfPCell();
            pdfCell.setHorizontalAlignment(this.setHorizontalAlignment(lstColumn));
            pdfCell.setVerticalAlignment(5);
            pdfCell.setBackgroundColor(Color.WHITE);
            pdfCell.setBorder(0);
            pdfCell.setBorderWidthTop(0.1f);
            pdfCell.setBorderWidthBottom(0.1f);
            pdfCell.setBorderWidthLeft(0.1f);
            pdfCell.setBorderWidthRight(0.1f);
            pdfCell.setFixedHeight(20.0f);
            String text = EMPTY_LINE;
            if (i == 0) {
                text = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ListPdfExporter_0", (String)"bos-noteprint", (Object[])new Object[0]);
            } else {
                for (int r = 0; r < summayDatas.size(); ++r) {
                    SummaryResult row = summayDatas.get(r);
                    String fieldName = row.getFieldName();
                    if (lstColumn.getListFieldKey().contentEquals(fieldName)) {
                        Object desensitizeObj;
                        text = row.toString();
                        String[] fieldArr = fieldName.split("\\.");
                        IDataEntityProperty fieldProp = (IDataEntityProperty)allFields.get(fieldArr[0]);
                        if (fieldProp instanceof BasedataProp) {
                            desensitizeObj = PrintDesensitive.desensitize((String)mainEntityType.getName(), (String)fieldName, (Object)text);
                            if (desensitizeObj == null) break;
                            text = desensitizeObj.toString();
                            break;
                        }
                        desensitizeObj = PrintDesensitive.desensitize((IDataEntityProperty)fieldProp, (Object)text);
                        if (desensitizeObj == null) break;
                        text = desensitizeObj.toString();
                        break;
                    }
                    text = EMPTY_LINE;
                }
            }
            Paragraph paragraph = new Paragraph(text, font);
            pdfCell.setPhrase((Phrase)paragraph);
            if (pSetting.isWrap()) {
                pdfCell.setMinimumHeight(pSetting.getListLineHeight());
                pdfCell.setNoWrap(false);
            }
            tbl.addCell(pdfCell);
        }
    }

    private MainEntityType getMainEntityType() {
        if (this.mainEntityType != null) {
            return this.mainEntityType;
        }
        try {
            this.mainEntityType = EntityMetadataCache.getDataEntityType((String)this.entityId);
        }
        catch (Exception e) {
            String entityTypeId = FormMetadataCache.getFormConfig((String)this.entityId).getEntityTypeId();
            this.mainEntityType = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        }
        return this.mainEntityType;
    }

    private float[] getrelativeWidths(float usableWidth, List<IListColumn> columns, Map<String, Object> columnWidth) {
        int length = 0;
        for (int i = 0; i < columns.size(); ++i) {
            IListColumn column = columns.get(i);
            if (column.getVisible() == 0) continue;
            ++length;
        }
        float[] relativeWidths = new float[length];
        int j = 0;
        for (int i = 0; i < columns.size(); ++i) {
            IListColumn column = columns.get(i);
            if (column.getVisible() == 0) continue;
            String replaceName = column.getListFieldKey();
            if (column.getListFieldKey() != null && column.getListFieldKey().contains(".")) {
                replaceName = column.getListFieldKey().replace('.', '_');
            }
            float width = 0.0f;
            if (columnWidth.containsKey(replaceName)) {
                width = Float.parseFloat(String.valueOf(columnWidth.get(replaceName))) - (float)((Integer)columnWidth.get(replaceName) / 4);
            } else if (column.getWidth() == null) {
                width = 30.0f;
            } else {
                String w = column.getWidth().toString();
                width = Float.parseFloat(w.substring(0, w.length() - 2));
            }
            if (width >= usableWidth) {
                width /= 2.0f;
            }
            relativeWidths[j] = width;
            ++j;
        }
        return relativeWidths;
    }

    private void createHead(List<IListColumn> columns, PdfPTable table, PaperSetting pSetting) {
        com.lowagie.text.Font font = null;
        try {
            int fontSize = (int)pSetting.getListFieldFont();
            if (CUSTOMWIDE.equals(pSetting.getWideType())) {
                fontSize = (int)(pSetting.getListFieldFont() * pSetting.getWideProportion() / 100.0f);
            }
            font = this.getPdfChineseFont(pSetting.getListFont(), Math.max(fontSize, 1));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        for (int i = 0; i < columns.size(); ++i) {
            IListColumn lstColumn = columns.get(i);
            if (lstColumn.getVisible() == 0) continue;
            PdfPCell pdfCell = new PdfPCell();
            pdfCell.setMinimumHeight(30.0f);
            pdfCell.setHorizontalAlignment(this.setHorizontalAlignment(lstColumn));
            pdfCell.setVerticalAlignment(5);
            pdfCell.setBackgroundColor(Color.WHITE);
            pdfCell.setBorder(0);
            pdfCell.setBorderWidthTop(0.1f);
            pdfCell.setBorderWidthBottom(0.1f);
            pdfCell.setBorderWidthLeft(0.1f);
            pdfCell.setBorderWidthRight(0.1f);
            Paragraph paragraph = "fseq".equals(lstColumn.getListFieldKey()) || "seq".equals(lstColumn.getListFieldKey()) ? new Paragraph("#", font) : new Paragraph(lstColumn.getCaption().toString(), font);
            pdfCell.setPhrase((Phrase)paragraph);
            table.addCell(pdfCell);
        }
    }

    private void createDetailRow(List<IListColumn> columns, List<FormatRowData> rowDatas, PdfPTable table, PaperSetting setting) {
        com.lowagie.text.Font font = null;
        try {
            int fontSize = (int)setting.getListFieldFont();
            if (CUSTOMWIDE.equals(setting.getWideType())) {
                fontSize = (int)(setting.getListFieldFont() * setting.getWideProportion() / 100.0f);
            }
            font = this.getPdfChineseFont(setting.getListFont(), Math.max(fontSize, 1));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        MainEntityType mainEntityType = this.getMainEntityType();
        if (mainEntityType == null) {
            return;
        }
        Map allFields = mainEntityType.getAllFields();
        String mainOrg = mainEntityType.getMainOrg();
        for (int r = 0; r < rowDatas.size(); ++r) {
            FormatFieldData formatFieldData;
            FormatRowData row = rowDatas.get(r);
            long mainOrgId = 0L;
            if (StringUtils.isNotBlank((CharSequence)mainOrg) && (formatFieldData = row.get(mainOrg + ".id")) != null && formatFieldData.getFieldValue() != null) {
                mainOrgId = Long.parseLong(formatFieldData.getFieldValue().toString());
            }
            FieldControlRule fieldControlRule = this.getFieldControlRule(mainOrgId);
            for (int i = 0; i < columns.size(); ++i) {
                Object desensitizeObj;
                String[] fieldArr;
                IDataEntityProperty fieldProp;
                IListColumn lstColumn = columns.get(i);
                if (lstColumn.getVisible() == 0) continue;
                PdfPCell pdfCell = new PdfPCell();
                pdfCell.setHorizontalAlignment(this.setHorizontalAlignment(lstColumn));
                pdfCell.setVerticalAlignment(5);
                pdfCell.setBackgroundColor(Color.WHITE);
                pdfCell.setBorder(0);
                pdfCell.setBorderWidthTop(0.1f);
                pdfCell.setBorderWidthBottom(0.1f);
                pdfCell.setBorderWidthLeft(0.1f);
                pdfCell.setBorderWidthRight(0.1f);
                if (setting.isWrap()) {
                    pdfCell.setMinimumHeight(setting.getListLineHeight());
                    pdfCell.setNoWrap(false);
                } else {
                    pdfCell.setFixedHeight(setting.getListLineHeight());
                }
                if (lstColumn instanceof MergeListColumn) {
                    List items = ((MergeListColumn)lstColumn).getItems();
                    int itemsSize = 1;
                    if (!items.isEmpty()) {
                        itemsSize = items.size();
                    }
                    PdfPTable t = new PdfPTable(itemsSize);
                    for (Control item : items) {
                        Object desensitizeObj2;
                        String[] fieldArr2;
                        IDataEntityProperty fieldProp2;
                        String fieldKey = ((ListColumn)item).getListFieldKey();
                        FormatFieldData fieldData = row.get(fieldKey);
                        Object text = null;
                        if (fieldData != null) {
                            Object[] objArry;
                            Object value;
                            if (item instanceof DecimalListColumn) {
                                value = fieldData.getFieldValueDesc();
                                if (value instanceof Object[]) {
                                    objArry = (Object[])value;
                                    if (objArry[0] != null) {
                                        text = objArry[0].toString().replace('\uffe5', '\u00a5');
                                    } else if (objArry[1] != null) {
                                        int cp;
                                        BigDecimal ret = null;
                                        if (objArry[1] instanceof BigDecimal) {
                                            ret = (BigDecimal)objArry[1];
                                        }
                                        text = ret != null ? ((cp = ret.compareTo(BigDecimal.ZERO)) > 0 ? ret.toString() : EMPTY_LINE) : EMPTY_LINE;
                                    } else {
                                        text = EMPTY_LINE;
                                    }
                                } else {
                                    text = EMPTY_LINE;
                                }
                            } else if (item instanceof DateListColumn) {
                                value = fieldData.getFieldValueDesc();
                                if (value instanceof Object[]) {
                                    objArry = (Object[])value;
                                    if (objArry[0] != null) {
                                        if (objArry[0] instanceof Object[]) {
                                            Object[] subArry = (Object[])objArry[0];
                                            String dd = subArry[0].toString();
                                            String zone = subArry[1].toString();
                                            text = dd + "," + zone;
                                        } else {
                                            text = objArry[0].toString();
                                        }
                                    } else {
                                        text = objArry[1] != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(objArry[1]) : EMPTY_LINE;
                                    }
                                } else {
                                    text = EMPTY_LINE;
                                }
                            } else if (item instanceof TimeListColumn) {
                                value = fieldData.getFieldValue();
                                text = !ObjectUtils.isEmpty((Object)value) ? this.formatTime((Integer)value) : EMPTY_LINE;
                            } else if (item instanceof ComboListColumn || lstColumn instanceof CheckBoxListColumn) {
                                value = fieldData.getFieldValueDesc();
                                text = !ObjectUtils.isEmpty((Object)value) ? value : EMPTY_LINE;
                            } else if (item instanceof FlexListColumn) {
                                StringBuilder flexText = new StringBuilder();
                                if (StringUtils.isNotBlank((Object)fieldData.getFieldValue())) {
                                    ArrayList values = (ArrayList)fieldData.getFieldValue();
                                    for (Object it : values) {
                                        Map mp = (Map)it;
                                        if (StringUtils.isBlank((CharSequence)flexText)) {
                                            flexText.append((String)mp.get(ALIAS));
                                            continue;
                                        }
                                        if (!StringUtils.isNotBlank(mp.get(ALIAS))) continue;
                                        flexText.append("; ");
                                        flexText.append((String)mp.get(ALIAS));
                                    }
                                }
                                text = flexText.length() > 0 ? flexText.toString() : EMPTY_LINE;
                            } else {
                                value = fieldData.getFieldValueDesc();
                                text = !ObjectUtils.isEmpty((Object)value) ? (value instanceof Object[] ? ((objArry = (Object[])value)[1] != null ? objArry[1].toString() : (objArry[0] != null ? objArry[0].toString() : EMPTY_LINE)) : value) : EMPTY_LINE;
                            }
                        }
                        String fieldResult = EMPTY_LINE;
                        if (text != null) {
                            fieldResult = !this.isCanPrint(fieldControlRule, fieldKey) ? REPLACE_CHARS_FOR_ENCRYPTION : text.toString();
                        }
                        if ("fseq".equals(((ListColumn)item).getFieldName()) || "seq".equals(((ListColumn)item).getFieldName())) {
                            fieldResult = String.valueOf(r + 1);
                        }
                        if ((fieldProp2 = (IDataEntityProperty)allFields.get((fieldArr2 = fieldKey.split("\\."))[0])) instanceof BasedataProp) {
                            desensitizeObj2 = PrintDesensitive.desensitize((String)mainEntityType.getName(), (String)fieldKey, (Object)fieldResult);
                            if (desensitizeObj2 != null) {
                                fieldResult = desensitizeObj2.toString();
                            }
                        } else {
                            desensitizeObj2 = PrintDesensitive.desensitize((IDataEntityProperty)fieldProp2, (Object)fieldResult);
                            if (desensitizeObj2 != null) {
                                fieldResult = desensitizeObj2.toString();
                            }
                        }
                        PdfPCell c = new PdfPCell(new Phrase(fieldResult, font));
                        c.setHorizontalAlignment(this.setHorizontalAlignment((IListColumn)((ListColumn)item)));
                        c.setVerticalAlignment(5);
                        c.setBackgroundColor(Color.WHITE);
                        c.disableBorderSide(15);
                        t.addCell(c);
                    }
                    pdfCell.addElement((Element)t);
                    table.addCell(pdfCell);
                    continue;
                }
                String fieldKey = lstColumn.getListFieldKey();
                FormatFieldData fieldData = row.get(fieldKey);
                Object text = null;
                if (fieldData != null) {
                    Object[] objArry;
                    Object value;
                    if (lstColumn instanceof DecimalListColumn) {
                        value = fieldData.getFieldValueDesc();
                        if (value instanceof Object[]) {
                            objArry = (Object[])value;
                            if (objArry[0] != null) {
                                text = objArry[0].toString().replace('\uffe5', '\u00a5');
                            } else if (objArry[1] != null) {
                                int cp;
                                BigDecimal ret = null;
                                if (objArry[1] instanceof BigDecimal) {
                                    ret = (BigDecimal)objArry[1];
                                }
                                text = ret != null ? ((cp = ret.compareTo(BigDecimal.ZERO)) > 0 ? ret.toString() : EMPTY_LINE) : EMPTY_LINE;
                            } else {
                                text = EMPTY_LINE;
                            }
                        } else {
                            text = EMPTY_LINE;
                        }
                    } else if (lstColumn instanceof DateListColumn) {
                        value = fieldData.getFieldValueDesc();
                        if (value instanceof Object[]) {
                            objArry = (Object[])value;
                            if (objArry[0] != null) {
                                if (objArry[0] instanceof Object[]) {
                                    Object[] subArry = (Object[])objArry[0];
                                    String dd = subArry[0].toString();
                                    String zone = subArry[1].toString();
                                    text = dd + "," + zone;
                                } else {
                                    text = objArry[0].toString();
                                }
                            } else {
                                text = objArry[1] != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(objArry[1]) : EMPTY_LINE;
                            }
                        } else {
                            text = EMPTY_LINE;
                        }
                    } else if (lstColumn instanceof TimeListColumn) {
                        value = fieldData.getFieldValueDesc();
                        text = !ObjectUtils.isEmpty((Object)value) ? this.formatTime((Integer)value) : EMPTY_LINE;
                    } else if (lstColumn instanceof ComboListColumn || lstColumn instanceof CheckBoxListColumn) {
                        value = fieldData.getFieldValueDesc();
                        text = !ObjectUtils.isEmpty((Object)value) ? value : EMPTY_LINE;
                    } else if (lstColumn instanceof FlexListColumn) {
                        StringBuilder flexText = new StringBuilder();
                        if (StringUtils.isNotBlank((Object)fieldData.getFieldValue())) {
                            ArrayList values = (ArrayList)fieldData.getFieldValue();
                            for (Object item : values) {
                                Map mp = (Map)item;
                                if (StringUtils.isBlank((CharSequence)flexText)) {
                                    flexText.append((String)mp.get(ALIAS));
                                    continue;
                                }
                                if (!StringUtils.isNotBlank(mp.get(ALIAS))) continue;
                                flexText.append("; ");
                                flexText.append((String)mp.get(ALIAS));
                            }
                        }
                        text = flexText.length() > 0 ? flexText.toString() : EMPTY_LINE;
                    } else {
                        value = fieldData.getFieldValueDesc();
                        text = !ObjectUtils.isEmpty((Object)value) ? (value instanceof Object[] ? ((objArry = (Object[])value)[1] != null ? objArry[1].toString() : (objArry[0] != null ? objArry[0].toString() : EMPTY_LINE)) : value) : EMPTY_LINE;
                    }
                }
                String fieldResult = EMPTY_LINE;
                if (text != null) {
                    fieldResult = !this.isCanPrint(fieldControlRule, fieldKey) ? REPLACE_CHARS_FOR_ENCRYPTION : text.toString();
                }
                if ("fseq".equals(lstColumn.getFieldName()) || "seq".equals(lstColumn.getFieldName())) {
                    fieldResult = String.valueOf(r + 1);
                }
                if ((fieldProp = (IDataEntityProperty)allFields.get((fieldArr = fieldKey.split("\\."))[0])) instanceof BasedataProp) {
                    desensitizeObj = PrintDesensitive.desensitize((String)mainEntityType.getName(), (String)fieldKey, (Object)fieldResult);
                    if (desensitizeObj != null) {
                        fieldResult = desensitizeObj.toString();
                    }
                } else {
                    desensitizeObj = PrintDesensitive.desensitize((IDataEntityProperty)fieldProp, (Object)fieldResult);
                    if (desensitizeObj != null) {
                        fieldResult = desensitizeObj.toString();
                    }
                }
                Paragraph paragraph = new Paragraph(fieldResult, font);
                pdfCell.setPhrase((Phrase)paragraph);
                table.addCell(pdfCell);
            }
        }
    }

    private com.lowagie.text.Font getPdfChineseFont(String fontName, int size) throws Exception {
        BaseFont bfChinese = null;
        try {
            bfChinese = ListPdfExporter.createBaseFont(fontName);
        }
        catch (Exception ex) {
            LOG.error("\u5217\u8868\u6253\u5370--\u521b\u5efa\u6253\u5370\u5b57\u4f53\u5931\u8d25, \u5c06\u5c1d\u8bd5\u4f7f\u7528\u5b57\u4f53\u5305\u521b\u5efa\u5b57\u4f53\u3002 --- " + ex.getCause());
            bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        return new com.lowagie.text.Font(bfChinese, (float)size, 0);
    }

    private static BaseFont createBaseFont(String fontName) {
        Font kf;
        if (fontName == null || (kf = KDFont.loadFontFromJAR((String)fontName, (int)0, (float)12.0f)) == null) {
            kf = KDFont.loadFontFromJAR((String)"\u601d\u6e90\u5b8b\u4f53 CN", (int)0, (float)12.0f);
        }
        return PrintFontMapper.createInstance().awtToPdf(kf);
    }

    private FieldControlRule getFieldControlRule(long orgId) {
        if (this.fieldControlRules == null) {
            return null;
        }
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        if (orgId != 0L) {
            for (FieldControlRuleDto listField : this.fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                if (!Objects.equals(listField.getMainOrgId(), orgId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(orgId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        } else {
            for (FieldControlRuleDto listField : this.fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp = listField.getFieldControlRule();
                if (temp == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        }
        return fieldControlRule;
    }

    private boolean isCanPrint(FieldControlRule fieldControlRule, String field) {
        if (fieldControlRule == null) {
            return true;
        }
        Set canNotReadFields = fieldControlRule.getCanNotReadFields();
        if (canNotReadFields == null || canNotReadFields.isEmpty()) {
            return true;
        }
        String[] fieldArr = field.split("\\.");
        return !canNotReadFields.contains(fieldArr[0]);
    }

    private String getTime(Integer time) {
        if (time != null && time >= 0) {
            Integer hour = time / 3600;
            time = time % 3600;
            Integer minutes = time / 60;
            Integer second = time % 60;
            String result = (hour < 10 ? "0" : "") + hour + ":" + (minutes < 10 ? "0" : "") + minutes + ":" + (second < 10 ? "0" : "") + second;
            return result;
        }
        return "0";
    }

    private String formatTime(Integer time) {
        if (time != null && time >= 0) {
            String result = this.getTime(time);
            IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
            Long userId = RequestContext.get().getCurrUserId();
            Map timeFormat = inteService.getTimeFormat(userId);
            try {
                Date data = new SimpleDateFormat("HH:mm:ss").parse(result);
                return new SimpleDateFormat((String)timeFormat.get("timeFormat")).format(data);
            }
            catch (ParseException e) {
                return "";
            }
        }
        return "";
    }

    private int setHorizontalAlignment(IListColumn lstColumn) {
        String tAlign;
        int hAlignment = 0;
        switch (tAlign = lstColumn.getTextAlign()) {
            case "right": {
                hAlignment = 2;
                break;
            }
            case "left": {
                hAlignment = 0;
                break;
            }
            case "center": {
                hAlignment = 1;
                break;
            }
            default: {
                if (!(lstColumn instanceof ListColumn)) break;
                hAlignment = ((ListColumn)lstColumn).getSrcFieldProp() instanceof IntegerProp || ((ListColumn)lstColumn).getSrcFieldProp() instanceof DecimalProp || ((ListColumn)lstColumn).getSrcFieldProp() instanceof BigIntProp || ((ListColumn)lstColumn).getSrcFieldProp() instanceof AmountProp || ((ListColumn)lstColumn).getSrcFieldProp() instanceof PriceProp ? 2 : ("fseq".equals(((ListColumn)lstColumn).getFieldName()) || "seq".equals(((ListColumn)lstColumn).getFieldName()) ? 1 : 0);
            }
        }
        return hAlignment;
    }
}

