/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.kingdee.bos.ctrl.print.io.PrintFontMapper;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.lowagie.text.Document;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.print.util.PdfWaterMarkUtil;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class PdfHeaderFooter
extends PdfPageEventHelper {
    private static final Log log = LogFactory.getLog(PdfHeaderFooter.class);
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private String headerText = "";
    private int headerFontSize = 12;
    private int footerFontSize = 12;
    private PdfTemplate footerTmp;
    private BaseFont bf = null;
    private com.lowagie.text.Font fontDetail = null;
    private int pageNumber = 1;
    private String formId;
    private Map<String, Object> customParams = new HashMap<String, Object>(2);

    public void setCustomParams(Map<String, Object> customParams) {
        this.customParams = customParams;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public PdfHeaderFooter() {
    }

    public PdfHeaderFooter(BaseFont bf, int headerFontSize, int footerFontSize, Rectangle pageSize) {
        this.bf = bf;
        this.headerFontSize = headerFontSize;
        this.footerFontSize = footerFontSize;
    }

    public PdfHeaderFooter(String title, int headerFontSize, int footerFontSize, Rectangle pageSize) {
        this.headerText = title;
        this.headerFontSize = headerFontSize;
        this.footerFontSize = footerFontSize;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public void setHeaderText(String text) {
        this.headerText = text;
    }

    public void setPresentFontSize(int presentFontSize) {
        this.footerFontSize = presentFontSize;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.footerTmp = writer.getDirectContent().createTemplate(50.0f, 50.0f);
    }

    public void onEndPage(PdfWriter writer, Document document) {
        float oneLen;
        try {
            if (this.fontDetail == null) {
                this.fontDetail = new com.lowagie.text.Font(this.bf, (float)this.footerFontSize, 0);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        com.lowagie.text.Font titleFont = new com.lowagie.text.Font(this.bf, (float)this.headerFontSize, 0);
        if (!StringUtils.isEmpty((CharSequence)this.headerText)) {
            float titleLen = this.bf.getWidthPoint(this.headerText, (float)this.headerFontSize);
            float titleHeight = this.bf.getAscentPoint(this.headerText, (float)this.headerFontSize) + this.bf.getDescentPoint(this.headerText, (float)this.headerFontSize);
            ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)0, (Phrase)new Phrase(this.headerText, titleFont), (float)((document.rightMargin() + document.right() - titleLen) / 2.0f), (float)(document.top() - titleHeight / 2.0f - 15.0f), (float)0.0f);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = sdf.format(new Date());
        String printDate = String.format(ResManager.loadKDString((String)"\u6253\u5370\u65e5\u671f\uff1a%s", (String)"PdfHeaderFooter_0", (String)"bos-noteprint", (Object[])new Object[0]), date);
        String printer = String.format(ResManager.loadKDString((String)"\u6253\u5370\u4eba\uff1a%s", (String)"PdfHeaderFooter_1", (String)"bos-noteprint", (Object[])new Object[0]), RequestContext.get().getUserName());
        int pageS = writer.getPageNumber();
        String pageNum = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u9875/\u5171 %2$s \u9875", (String)"PdfHeaderFooter_2", (String)"bos-noteprint", (Object[])new Object[0]), pageS, this.pageNumber);
        boolean hidePrintUser = "true".equals(String.valueOf(this.customParams.getOrDefault("hidePrintUser", "false")));
        boolean hidePrintTime = "true".equals(String.valueOf(this.customParams.getOrDefault("hidePrintTime", "false")));
        boolean hidePrintPageNum = "true".equals(String.valueOf(this.customParams.getOrDefault("hidePrintPageNum", "false")));
        ArrayList<String> printTextList = new ArrayList<String>(3);
        if (!hidePrintUser) {
            printTextList.add(printer);
        }
        if (!hidePrintTime) {
            printTextList.add(printDate);
        }
        if (!hidePrintPageNum) {
            printTextList.add(pageNum);
        }
        ArrayList<Float> printTextLenList = new ArrayList<Float>(3);
        float textLen = 0.0f;
        for (String printText : printTextList) {
            float len = this.bf.getWidthPoint(printText, (float)this.footerFontSize);
            printTextLenList.add(Float.valueOf(len));
            textLen += len;
        }
        float freeLen = document.right() + document.rightMargin() - textLen;
        float startX = oneLen = freeLen / (float)(printTextList.size() + 1);
        for (int index = 0; index < printTextList.size(); ++index) {
            String printText = (String)printTextList.get(index);
            Float printTextLen = (Float)printTextLenList.get(index);
            ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)0, (Phrase)new Phrase(printText, this.fontDetail), (float)startX, (float)document.bottom(), (float)0.0f);
            startX = startX + oneLen + printTextLen.floatValue();
        }
        if (this.canDrawWaterMark() || PdfWaterMarkUtil.checkIsTempLicense()) {
            WaterMark waterMark = PdfWaterMarkUtil.getWaterMark((String)this.formId);
            if (waterMark == null) {
                return;
            }
            com.lowagie.text.Font font = PdfHeaderFooter.getFont(waterMark);
            PdfWaterMarkUtil.addWaterMark((PdfWriter)writer, (Document)document, (com.lowagie.text.Font)font, (WaterMark)waterMark);
        }
    }

    private static com.lowagie.text.Font getFont(WaterMark waterMark) {
        com.lowagie.text.Font textFont = null;
        BaseFont bfChinese = null;
        try {
            bfChinese = PdfHeaderFooter.createBaseFont();
        }
        catch (Exception ex) {
            log.error("\u6c34\u5370\u6253\u5370--\u521b\u5efa\u6253\u5370\u5b57\u4f53\u5931\u8d25, \u5c06\u5c1d\u8bd5\u4f7f\u7528\u5b57\u4f53\u5305\u521b\u5efa\u5b57\u4f53\u3002 --- " + ex.getCause());
            try {
                bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (bfChinese != null) {
            textFont = PdfHeaderFooter.createFont(bfChinese, waterMark);
        }
        return textFont;
    }

    private static com.lowagie.text.Font createFont(BaseFont bfChinese, WaterMark waterMark) {
        int fontSize = 12;
        String size = waterMark.getFontSize();
        if (StringUtils.isNotBlank((CharSequence)size)) {
            try {
                size = size.replace("px", "");
                fontSize = Integer.parseInt(size);
            }
            catch (Exception ignore) {
                log.error("watermark font transfer error\uff1afontSize=%s", (Object)size);
                fontSize = 12;
            }
            return new com.lowagie.text.Font(bfChinese, (float)fontSize, 0);
        }
        return new com.lowagie.text.Font(bfChinese, (float)fontSize, 0, (Color)new GrayColor(0.85f));
    }

    private static BaseFont createBaseFont() {
        String fontName = "\u601d\u6e90\u5b8b\u4f53 CN";
        Font kf = KDFont.loadFontFromJAR((String)fontName, (int)0, (int)12);
        return PrintFontMapper.createInstance().awtToPdf(kf);
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.footerTmp.beginText();
        this.footerTmp.setFontAndSize(this.bf, (float)this.footerFontSize);
        this.footerTmp.showText(String.valueOf(this.getPageNumber()));
        this.footerTmp.endText();
        this.footerTmp.closePath();
    }

    private boolean canDrawWaterMark() {
        Map<String, Object> listSetting = this.loadListSetting();
        Object enableWatermark = listSetting.get("enablewatermark");
        return StringUtils.equals((CharSequence)"true", (CharSequence)String.valueOf(enableWatermark));
    }

    private Map<String, Object> loadListSetting() {
        String userId = RequestContext.get().getUserId();
        String key = this.formId + "_listprintsetting";
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        Map<String, Object> setting = new HashMap<String, Object>(16);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            setting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return setting;
    }
}

