/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.entity;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.mvc.export.entity.TreeNode;
import org.apache.commons.collections4.CollectionUtils;

public class TreeNodeUtil {
    public static TreeNode buildTree(ReportColumnGroup columnGroup, boolean isOnlyVisible) {
        if (columnGroup == null) {
            return null;
        }
        TreeNode rootNode = new TreeNode();
        rootNode.setRoot(true);
        TreeNode<ReportColumnGroup> firstLeaf = new TreeNode<ReportColumnGroup>();
        firstLeaf.setValue(columnGroup);
        firstLeaf.setParent(rootNode);
        rootNode.getChildren().add(firstLeaf);
        for (AbstractReportColumn abstractReportColumn : columnGroup.getChildren()) {
            TreeNode<AbstractReportColumn> leaf;
            if (!(!(abstractReportColumn instanceof ReportColumn) || isOnlyVisible && ((ReportColumn)abstractReportColumn).isHide())) {
                leaf = new TreeNode<AbstractReportColumn>();
                leaf.setValue(abstractReportColumn);
                leaf.setParent(firstLeaf);
                firstLeaf.getChildren().add(leaf);
                continue;
            }
            if (!(abstractReportColumn instanceof ReportColumnGroup)) continue;
            leaf = new TreeNode();
            leaf.setValue(abstractReportColumn);
            leaf.setParent(firstLeaf);
            firstLeaf.getChildren().add(leaf);
            if (!CollectionUtils.isNotEmpty((Collection)((ReportColumnGroup)abstractReportColumn).getChildren())) continue;
            TreeNodeUtil.buildTree(leaf, ((ReportColumnGroup)abstractReportColumn).getChildren(), isOnlyVisible);
        }
        return rootNode;
    }

    public static TreeNode buildTree(List<AbstractReportColumn> data, boolean isOnlyVisible) {
        if (data == null || data.size() <= 0) {
            return null;
        }
        TreeNode rootNode = new TreeNode();
        rootNode.setRoot(true);
        for (AbstractReportColumn abstractReportColumn : data) {
            TreeNode<AbstractReportColumn> leaf;
            if (!(!(abstractReportColumn instanceof ReportColumn) || isOnlyVisible && ((ReportColumn)abstractReportColumn).isHide())) {
                leaf = new TreeNode<AbstractReportColumn>();
                leaf.setValue(abstractReportColumn);
                leaf.setParent(rootNode);
                rootNode.getChildren().add(leaf);
                continue;
            }
            if (!(abstractReportColumn instanceof ReportColumnGroup)) continue;
            leaf = new TreeNode();
            leaf.setValue(abstractReportColumn);
            leaf.setParent(rootNode);
            rootNode.getChildren().add(leaf);
            if (!CollectionUtils.isNotEmpty((Collection)((ReportColumnGroup)abstractReportColumn).getChildren())) continue;
            TreeNodeUtil.buildTree(leaf, ((ReportColumnGroup)abstractReportColumn).getChildren(), isOnlyVisible);
        }
        return rootNode;
    }

    private static void buildTree(TreeNode rootNode, List<AbstractReportColumn> data, boolean isOnlyVisible) {
        for (AbstractReportColumn abstractReportColumn : data) {
            TreeNode<AbstractReportColumn> leaf;
            if (!(!(abstractReportColumn instanceof ReportColumn) || isOnlyVisible && ((ReportColumn)abstractReportColumn).isHide())) {
                leaf = new TreeNode<AbstractReportColumn>();
                leaf.setValue(abstractReportColumn);
                leaf.setParent(rootNode);
                rootNode.getChildren().add(leaf);
                continue;
            }
            if (!(abstractReportColumn instanceof ReportColumnGroup)) continue;
            leaf = new TreeNode();
            leaf.setValue(abstractReportColumn);
            leaf.setParent(rootNode);
            rootNode.getChildren().add(leaf);
            if (!CollectionUtils.isNotEmpty((Collection)((ReportColumnGroup)abstractReportColumn).getChildren())) continue;
            TreeNodeUtil.buildTree(leaf, ((ReportColumnGroup)abstractReportColumn).getChildren(), isOnlyVisible);
        }
    }

    public static int getNodeAllLeaf(TreeNode node) {
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            return 1;
        }
        int colspan = 0;
        List children = node.getChildren();
        for (TreeNode treeNode : children) {
            if (treeNode.haveChildren()) {
                colspan += TreeNodeUtil.getNodeAllLeaf(treeNode);
                continue;
            }
            ++colspan;
        }
        return colspan;
    }

    public static void setChildrenParent(TreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getChildren() == null || root.getChildren().isEmpty()) {
            root.setParent(null);
            return;
        }
        TreeNodeUtil.setChildrenParent(root, root.getChildren());
    }

    public static void setChildrenParent(TreeNode parent, List<TreeNode> children) {
        if (children != null && !children.isEmpty()) {
            for (TreeNode treeNode : children) {
                treeNode.setParent(parent);
                if (treeNode.getChildren() == null || treeNode.getChildren().isEmpty()) continue;
                TreeNodeUtil.setChildrenParent(treeNode, treeNode.getChildren());
            }
        }
    }

    public static int getDepth(TreeNode root) {
        if (root == null) {
            return 0;
        }
        if (root.getChildren() == null || root.getChildren().isEmpty()) {
            return 1;
        }
        int max = 0;
        List children = root.getChildren();
        for (TreeNode treeNode : children) {
            int degree = TreeNodeUtil.getDepth(treeNode);
            if (degree <= max) continue;
            max = degree;
        }
        return max + 1;
    }

    public static int getNodeLevel(TreeNode node) {
        if (node == null) {
            return 0;
        }
        if (node.getParent() == null) {
            return 1;
        }
        return 1 + TreeNodeUtil.getNodeLevel(node.getParent());
    }

    public static List<TreeNode> breadthFirst(TreeNode root) {
        if (root == null) {
            return Collections.emptyList();
        }
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        int treeHeight = TreeNodeUtil.getDepth(root);
        ArrayDeque nodeDeque = new ArrayDeque();
        TreeNode node = root;
        nodeDeque.offer(node);
        while (!nodeDeque.isEmpty()) {
            List children;
            int rowspan;
            node = (TreeNode)nodeDeque.poll();
            int level = TreeNodeUtil.getNodeLevel(node);
            if (node == null) continue;
            if (!node.isRoot()) {
                rowspan = node.getChildren() != null && !node.getChildren().isEmpty() ? 1 : treeHeight - level + 1;
                node.setRowspan(rowspan);
                int colspan = TreeNodeUtil.getNodeAllLeaf(node);
                node.setColspan(colspan);
                node.setDegree(level);
                treeNodes.add(node);
            } else {
                rowspan = TreeNodeUtil.getNodeAllLeaf(node);
            }
            if ((children = node.getChildren()) == null || children.isEmpty()) continue;
            for (TreeNode child : children) {
                nodeDeque.offer(child);
            }
        }
        return treeNodes;
    }
}

