/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.print.OldPrintOperationHelper;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintWork;
import kd.bos.schedule.executor.AbstractTask;

public class PrintTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PrintTask.class);

    public void execute(RequestContext rc, Map<String, Object> map) throws KDBizException {
        StringBuilder builder;
        long start;
        HashMap<String, Object> result;
        block5: {
            result = new HashMap<String, Object>(2);
            result.put("nlocalpreview", map.get("nlocalpreview"));
            this.feedbackProgress(50, ResManager.loadKDString((String)"\u6253\u5370\u5df2\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\u3002", (String)"PrintTask_0", (String)"bos-noteprint", (Object[])new Object[0]), null);
            start = System.currentTimeMillis();
            builder = new StringBuilder();
            String fullPath = (String)map.get("fullPath");
            RequestContext.get().setClientFullContextPath(fullPath);
            String printTaskId = String.valueOf(map.get("printTaskId"));
            try {
                List<Object> newPkIds = this.printNewTpl(printTaskId, map);
                List<Object> oldPkIds = this.printOldTpl(printTaskId, map);
                newPkIds.addAll(oldPkIds);
                if (!"EXP_XLS".equals(map.get("expType"))) {
                    List<Object> allPkIds = newPkIds.stream().distinct().collect(Collectors.toList());
                    PrintOperationHelper.updatePrintCountField(String.valueOf(map.get("entityTypeId")), allPkIds);
                }
                result.put("taskId", printTaskId);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                builder.append(e.getMessage());
                if (!(e instanceof KDBizException)) break block5;
                result.put("msgType", "tip");
            }
        }
        String errMsg = builder.toString();
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            result.put("error", errMsg);
            result.put("success", "false");
        } else {
            result.put("success", "true");
        }
        long end = System.currentTimeMillis();
        log.debug(String.format("\u5de5\u53f7%s\u8fdb\u884c\u6253\u5370\u6240\u9700\u65f6\u95f4\uff1a%sms", rc.getUserId(), end - start));
        this.feedbackCustomdata(result);
    }

    private List<Object> printNewTpl(String printTaskId, Map<String, Object> param) {
        Object expType;
        Object extParams;
        List<Object> pkIdList = new ArrayList<Object>(10);
        List printJobs = null;
        String defaultTplId = (String)param.get("newDefaultTplId");
        String printType = "";
        List<Object> pkIds = new ArrayList<Object>(10);
        String pageId = String.valueOf(param.get("pageid"));
        String formId = String.valueOf(param.get("formid"));
        String lang = (String)param.get("lang");
        Map extParam = null;
        Object printjobs = param.get("newPrintJobs");
        if (StringUtils.isNotBlank((Object)printjobs)) {
            printJobs = SerializationUtils.fromJsonStringToList((String)((String)printjobs), PrintJob.class);
            printType = "billForm";
        } else if (StringUtils.isNotBlank((CharSequence)defaultTplId)) {
            printType = (String)param.get("printdataprovidertype");
            pkIds = new ArrayList();
            Object pkids = param.get("pkids");
            if (StringUtils.isNotBlank((Object)pkids)) {
                pkIds = pkids instanceof List ? (List)pkids : (List)SerializationUtils.fromJsonString((String)pkids.toString(), List.class);
            }
            if (pkIds.isEmpty() && !"report".equals(printType) && !"dynamic".equals(printType) && !"querylist".equals(printType)) {
                return pkIdList;
            }
        }
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = RequestContext.get().getLang().toString();
        }
        if ((extParams = param.get("extParam")) instanceof Map && !((Map)extParams).isEmpty()) {
            extParam = (Map)extParams;
        }
        PrintOperationHelper.PrintOperateParam printOperateParam = new PrintOperationHelper.PrintOperateParam(pageId, formId, printTaskId, printType, defaultTplId, lang, pkIds, printJobs, extParam);
        Object previewType = param.get("previewtype");
        if ("1".equals(previewType)) {
            printOperateParam.setExpType(PrintWork.EXP_TYPE.EXP_SCPT);
        }
        if (StringUtils.isNotBlank((Object)(expType = param.get("expType")))) {
            printOperateParam.setExpType(PrintWork.EXP_TYPE.valueOf((String)((String)expType)));
        }
        if (printJobs != null) {
            pkIdList = printJobs.stream().flatMap(fMap -> fMap.getBillIds().stream()).collect(Collectors.toList());
        }
        PrintOperationHelper.printNewTpl(printOperateParam);
        return pkIdList;
    }

    private List<Object> printOldTpl(String printTaskId, Map<String, Object> map) {
        List<Object> pkIdList = new ArrayList<Object>(10);
        List printJobs = null;
        String defaultTplId = "";
        String printType = "";
        List<Object> pkIds = new ArrayList<Object>(10);
        String pageId = (String)map.get("pageid");
        String formId = (String)map.get("formid");
        Object printjobs = map.get("oldPrintJobs");
        if (StringUtils.isNotBlank((Object)printjobs)) {
            printJobs = SerializationUtils.fromJsonStringToList((String)((String)printjobs), PrintJob.class);
        } else {
            defaultTplId = (String)map.get("oldDefaultTplId");
            printType = (String)map.get("printdataprovidertype");
            if (StringUtils.isBlank((CharSequence)defaultTplId)) {
                return pkIdList;
            }
            if ("querylist".equals(printType)) {
                pkIds = SerializationUtils.fromJsonStringToList((String)((String)map.get("pkids")), Object.class);
            }
        }
        PrintOperationHelper.PrintOperateParam oldPrintParam = new PrintOperationHelper.PrintOperateParam(pageId, formId, printTaskId, printType, defaultTplId, pkIds, printJobs);
        if (printJobs != null) {
            pkIdList = printJobs.stream().flatMap(fMap -> fMap.getBillIds().stream()).collect(Collectors.toList());
        }
        OldPrintOperationHelper.printOldTpl(oldPrintParam);
        return pkIdList;
    }
}

