/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.matchtpl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.matchtpl.TplMatcherParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.template.orgctrl.utils.ParamUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TplMatcherContext {
    private static final String CFG_SUFFIX = "_printsetting";
    private static final String ENABLE = "enable";
    private static final String PRINTTPLIDID = "printtplid.id";
    private static final String BAS_MANAGEPRINTTPL = "bos_manageprinttpl";
    private static final String PRINTERID = "printerid";
    private String defaultTemplateId = null;
    private String defaultPrinter = null;
    private Map<String, Object> printSetting = null;
    private Map<String, String> hasPermTemplateMap = null;
    private Map<String, Integer> templateStatusMap = null;
    private Map<Long, DynamicObject> billTypeObjCache = null;
    private Map<Object, DynamicObject> billDataMap = null;
    private Map<Object, Long> billIdToBillTypeId = null;
    private Map<Object, String> billPkAndStatusMap = null;
    private Set<String> unEnableBillType = null;
    private Map<String, DynamicObject> enableSchemeMap = new HashMap<String, DynamicObject>(1);
    private Map<String, DynamicObject> billParameterMap = new HashMap<String, DynamicObject>(1);
    private Map<String, String> defaultTplInManangeToolMap = new HashMap<String, String>(1);
    private Map<String, Object> wfParams = null;
    private TplMatcherParam param;
    private boolean psHeightPrioriy;

    public Map<String, Object> getWfParams() {
        if (this.wfParams != null) {
            return this.wfParams;
        }
        DynamicObject preferenceScheme = this.getEnableScheme();
        if (preferenceScheme == null) {
            this.wfParams = new HashMap<String, Object>(0);
            return this.wfParams;
        }
        HashMap<String, Object> wfParams = new HashMap<String, Object>();
        wfParams.put("approveline", preferenceScheme.get("approveline"));
        wfParams.put("ordertype", preferenceScheme.get("ordertype"));
        wfParams.put("includesubmit", preferenceScheme.get("includesubmit"));
        wfParams.put("includeimage", preferenceScheme.get("includeimage"));
        return wfParams;
    }

    public Map<String, Object> getPrintSetting() {
        if (this.printSetting == null) {
            String configKey = this.param.getEntityId() + CFG_SUFFIX;
            long currUserId = RequestContext.get().getCurrUserId();
            String settingData = UserConfigServiceHelper.getSetting((long)currUserId, (String)configKey);
            this.printSetting = StringUtils.isBlank((CharSequence)settingData) ? new HashMap<String, Object>(0) : (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return this.printSetting;
    }

    public String getDefaultPrinter() {
        if (this.defaultPrinter != null) {
            return this.defaultPrinter;
        }
        Map<String, Object> printSetting = this.getPrintSetting();
        if (!printSetting.isEmpty()) {
            Object pd = printSetting.get(PRINTERID);
            String string = this.defaultPrinter = pd == null ? "" : String.valueOf(pd);
        }
        if (this.defaultPrinter == null) {
            this.defaultPrinter = "";
        }
        return this.defaultPrinter;
    }

    public Map<String, String> getHasPermTemplateMap() {
        if (this.hasPermTemplateMap == null) {
            this.hasPermTemplateMap = PrintTemplateServiceFactory.getService().getUserPermPrintTemplateMap(this.param.getEntityId(), this.param.getAppId());
        }
        return this.hasPermTemplateMap;
    }

    private Map<String, Integer> getTemplateStatusMap() {
        if (this.templateStatusMap == null) {
            this.templateStatusMap = new HashMap<String, Integer>(16);
            String selectFields = "id,printtplid.id,enable";
            String entityId = this.param.getEntityId();
            QFilter billFilter = new QFilter("billformid", "=", (Object)entityId);
            DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)BAS_MANAGEPRINTTPL, (String)selectFields, (QFilter[])new QFilter[]{billFilter});
            if (dataArray == null || dataArray.length == 0) {
                return this.templateStatusMap;
            }
            for (DynamicObject dynamicObject : dataArray) {
                String tplId = dynamicObject.getString(PRINTTPLIDID);
                String enable = dynamicObject.getString(ENABLE);
                if ("0".equals(enable)) {
                    this.templateStatusMap.put(tplId, 2);
                    continue;
                }
                if (ParamUtils.isTemplateOrgIsolated() && !this.getHasPermTemplateMap().containsKey(tplId)) {
                    this.templateStatusMap.put(tplId, 3);
                    continue;
                }
                this.templateStatusMap.put(tplId, 1);
            }
        }
        return this.templateStatusMap;
    }

    public Integer getTplStatus(String tplId) {
        Map<String, Integer> templateStatusMap = this.getTemplateStatusMap();
        if (templateStatusMap.containsKey(tplId)) {
            return templateStatusMap.get(tplId);
        }
        templateStatusMap.put(tplId, 0);
        return 0;
    }

    public Map<Object, String> getBillPkAndStatusMap() {
        if (this.billPkAndStatusMap == null) {
            this.cacheBillTypeData();
        }
        return this.billPkAndStatusMap;
    }

    public Map<Long, DynamicObject> getBillTypeObjCache() {
        if (this.billTypeObjCache == null) {
            this.cacheBillTypeData();
        }
        return this.billTypeObjCache;
    }

    public Map<Object, Long> getBillIdToBillTypeId() {
        if (this.billIdToBillTypeId == null) {
            this.cacheBillTypeData();
        }
        return this.billIdToBillTypeId;
    }

    public Set<String> getUnEnableBillType() {
        if (this.unEnableBillType == null) {
            this.unEnableBillType = new HashSet<String>(16);
            Map<Long, DynamicObject> billTypeObjCache = this.getBillTypeObjCache();
            for (DynamicObject billTypeObj : billTypeObjCache.values()) {
                if (!"0".equals(billTypeObj.get(ENABLE))) continue;
                this.unEnableBillType.add(billTypeObj.get("name").toString());
            }
        }
        return this.unEnableBillType;
    }

    private void cacheBillTypeData() {
        this.billTypeObjCache = new HashMap<Long, DynamicObject>(16);
        this.billIdToBillTypeId = new HashMap<Object, Long>(16);
        this.billPkAndStatusMap = new HashMap<Object, String>(16);
        if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
            return;
        }
        String entityId = this.param.getEntityId();
        BillEntityType billDT = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
        String billTypeFieldKey = billDT.getBillType();
        if (StringUtils.isBlank((CharSequence)billTypeFieldKey)) {
            return;
        }
        String billStatusFieldKey = billDT.getBillStatus();
        Map<Object, DynamicObject> billDataMap = this.getBillDataMap();
        Iterator<Map.Entry<Object, DynamicObject>> billDataIt = billDataMap.entrySet().iterator();
        HashSet<Long> billTypeIdSet = new HashSet<Long>(16);
        while (billDataIt.hasNext()) {
            DynamicObject billType;
            Map.Entry<Object, DynamicObject> it = billDataIt.next();
            Object pk = it.getKey();
            DynamicObject dynamicObject = it.getValue();
            this.billPkAndStatusMap.put(pk, dynamicObject.getString(billStatusFieldKey));
            if (!StringUtils.isNotBlank((CharSequence)billTypeFieldKey) || (billType = dynamicObject.getDynamicObject(billTypeFieldKey)) == null) continue;
            long billTypeId = Long.parseLong(billType.getPkValue().toString());
            this.billIdToBillTypeId.put(pk, billTypeId);
            billTypeIdSet.add(billTypeId);
        }
        if (!billTypeIdSet.isEmpty()) {
            Map billTypeMap = BusinessDataServiceHelper.loadFromCache((Object[])billTypeIdSet.toArray(), (String)"bos_billtype");
            for (Map.Entry entry : billTypeMap.entrySet()) {
                Long pk = Long.valueOf(String.valueOf(entry.getKey()));
                DynamicObject value = (DynamicObject)entry.getValue();
                this.billTypeObjCache.put(pk, value);
            }
        }
    }

    public String getDefaultTemplateId() {
        DynamicObject preferenceScheme;
        if (this.defaultTemplateId != null) {
            return this.defaultTemplateId;
        }
        Map<String, Object> printSetting = this.getPrintSetting();
        if (!printSetting.isEmpty()) {
            this.defaultTemplateId = (String)printSetting.get("templateid");
        }
        if (StringUtils.isEmpty((CharSequence)this.defaultTemplateId) && (preferenceScheme = this.getEnableScheme()) != null) {
            this.defaultTemplateId = (String)preferenceScheme.get("defaulttemplate");
        }
        if (StringUtils.isEmpty((CharSequence)this.defaultTemplateId)) {
            this.defaultTemplateId = this.getDefaultTplInManangeTool();
        }
        if (this.defaultTemplateId == null) {
            this.defaultTemplateId = "";
        }
        return this.defaultTemplateId;
    }

    public DynamicObject getEnableScheme() {
        String cacheKey = "enableScheme";
        if (this.enableSchemeMap.containsKey(cacheKey)) {
            return this.enableSchemeMap.get(cacheKey);
        }
        DynamicObject scheme = null;
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)this.param.getEntityId()), new QFilter("ispreference", "=", (Object)Boolean.TRUE), new QFilter(ENABLE, "=", (Object)"1")};
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)"bos_printingscheme", (QFilter[])filters);
        if (!schemes.isEmpty()) {
            Optional firstScheme = schemes.values().stream().findFirst();
            scheme = (DynamicObject)firstScheme.get();
        }
        this.enableSchemeMap.put(cacheKey, scheme);
        return this.enableSchemeMap.get(cacheKey);
    }

    public DynamicObject getBillParameter() {
        String cacheKey = "billParameter";
        if (this.billParameterMap.containsKey(cacheKey)) {
            return this.billParameterMap.get(cacheKey);
        }
        DynamicObject obj = ParameterReader.getBillParameter((String)this.param.getEntityId());
        this.billParameterMap.put(cacheKey, obj);
        return this.billParameterMap.get(cacheKey);
    }

    public String getDefaultTplInManangeTool() {
        String entityId = this.param.getEntityId();
        String key = "defaultTplInManangeTool";
        if (this.defaultTplInManangeToolMap.containsKey(key)) {
            return this.defaultTplInManangeToolMap.get(key);
        }
        String tplId = "";
        QFilter[] qFilters = new QFilter[]{new QFilter("billformid", "=", (Object)entityId), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)BAS_MANAGEPRINTTPL, (String)PRINTTPLIDID, (QFilter[])qFilters);
        if (defaultObj != null) {
            tplId = (String)defaultObj.get(PRINTTPLIDID);
        }
        this.defaultTplInManangeToolMap.put(key, tplId);
        return this.defaultTplInManangeToolMap.get(key);
    }

    public void setParam(TplMatcherParam param) {
        this.param = param;
    }

    public Map<Object, DynamicObject> getBillDataMap() {
        if (this.billDataMap == null) {
            this.billDataMap = BusinessDataServiceHelper.loadFromCache((Object[])this.param.getPkIds().toArray(), (String)this.param.getEntityId());
        }
        return this.billDataMap;
    }

    public String getDefaultTemplateByBillType(Object pkId) {
        String templateId = null;
        if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
            return null;
        }
        Long billTypeId = this.getBillIdToBillTypeId().get(pkId);
        DynamicObject billTypeObj = this.getBillTypeObjCache().get(billTypeId);
        if (billTypeObj == null) {
            return templateId;
        }
        String templateNumber = billTypeObj.getString("defprinttemplate");
        if (StringUtils.isBlank((CharSequence)templateNumber)) {
            return "";
        }
        String idByNumber = MetadataDao.getIdByNumber((String)templateNumber, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isNotBlank((CharSequence)idByNumber)) {
            templateId = idByNumber;
        }
        return templateId;
    }

    public boolean isPsHeightPrioriy() {
        return this.psHeightPrioriy;
    }

    public void setPsHeightPrioriy(boolean psHeightPrioriy) {
        this.psHeightPrioriy = psHeightPrioriy;
    }
}

