/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.matchtpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.operate.printop.PrintTemplateMatcher;
import kd.bos.form.plugin.print.ComplexSettingItem;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.PrintJob;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.business.scheme.dao.PrintConditionDao;
import kd.bos.print.business.scheme.util.PrintConditionHelpUtils;
import kd.bos.print.matchtpl.MatcherResult;
import kd.bos.print.matchtpl.MatcherTpl;
import kd.bos.print.matchtpl.TplMatcherContext;
import kd.bos.print.matchtpl.TplMatcherParam;
import kd.bos.print.matchtpl.TplMatcherResult;
import kd.bos.print.matchtpl.ViewType;
import kd.bos.report.IReportView;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TplMatcherUtil {
    private static final String AUDIT = "C";
    private static final String FORMID_PRINTLOG = "bos_print_logs";
    private static final String PRINTERID = "printerid";
    private static final String TEMPLATEID = "templateid";
    private static final String TEMPLATE = "template";
    private static final String BASESETTING = "basesetting";
    private static final String COMPLEXSETTING = "complexsetting";
    private static final String BOS_NOTEPRINT = "bos-noteprint";
    private static final Log log = LogFactory.getLog(TplMatcherUtil.class);
    private TplMatcherContext context = new TplMatcherContext();
    private TplMatcherParam param = new TplMatcherParam();
    private TplMatcherResult result = new TplMatcherResult();
    Map<String, Set<String>> billTypeErrMsgMap = new HashMap<String, Set<String>>(10);
    private Set<String> errorMsgSet = new HashSet<String>(16);

    public TplMatcherUtil(TplMatcherParam param) {
        this.param = param;
        this.context.setParam(param);
    }

    public TplMatcherResult runTplMatcher() {
        String entityId = this.param.getEntityId();
        Map printConditionMap = PrintConditionDao.getPrintConditionByBillNumber((String)entityId);
        boolean psHiPriority = !CollectionUtils.isEmpty((Map)printConditionMap) && "1".equals(printConditionMap.get("priority"));
        this.context.setPsHeightPrioriy(psHiPriority);
        if (CollectionUtils.isEmpty((Map)printConditionMap) || psHiPriority) {
            this.defaultMatcher(printConditionMap);
        } else {
            this.prtSPriorityMatcher(printConditionMap);
        }
        return this.result;
    }

    private void prtSPriorityMatcher(Map<String, Object> printConditionMap) {
        this.buildResultByPrintSetting();
        this.buildResultByNewPrintCondition(printConditionMap);
        this.buildResultByScheme();
        this.buildResultByDefault();
    }

    private void defaultMatcher(Map<String, Object> printConditionMap) {
        this.buildResultByNewPrintCondition(printConditionMap);
        this.buildResultByPrintSetting();
        this.buildResultByScheme();
        this.buildResultByDefault();
    }

    public MatcherResult runMatcher() {
        TplMatcherResult result = this.runTplMatcher();
        return this.getMatcherResult(result);
    }

    public MatcherResult buildMatcherResultByNewPrintCondition() {
        String entityId = this.param.getEntityId();
        Map printConditionMap = PrintConditionDao.getPrintConditionByBillNumber((String)entityId);
        TplMatcherResult result = this.buildResultByNewPrintCondition(printConditionMap);
        return this.getMatcherResult(result);
    }

    public MatcherResult buildMatcherResultByPrintSetting() {
        TplMatcherResult result = this.buildResultByPrintSetting();
        return this.getMatcherResult(result);
    }

    public MatcherResult buildMatcherResultByScheme() {
        TplMatcherResult result = this.buildResultByScheme();
        return this.getMatcherResult(result);
    }

    public MatcherResult buildMatcherResultByDefault() {
        TplMatcherResult result = this.buildResultByDefault();
        return this.getMatcherResult(result);
    }

    private MatcherResult getMatcherResult(TplMatcherResult result) {
        MatcherResult matcherResult = new MatcherResult();
        matcherResult.setEndMatchLevel(result.getEndMatchLevel());
        List<PrintJob> matchPrintJobs = result.getMatchPrintJob();
        HashSet<Object> unMatchPkIdSet = new HashSet<Object>(16);
        matcherResult.setUnMatchPkIdSet(unMatchPkIdSet);
        if (CollectionUtils.isEmpty(matchPrintJobs)) {
            unMatchPkIdSet.addAll(this.param.getPkIds());
            return matcherResult;
        }
        List tplIds = matchPrintJobs.stream().map(item -> item.getTemplateId()).collect(Collectors.toList());
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_manageprinttpl", (String)"id,type,printtplid_id", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "in", tplIds)});
        HashMap<String, String> config = new HashMap<String, String>(16);
        for (DynamicObject obj : dynamicObjectMap.values()) {
            String type = obj.getString("type");
            String tplId = obj.getString("printtplid_id");
            config.put(tplId, type);
        }
        LinkedHashMap<Object, Set<MatcherTpl>> pkTplMap = new LinkedHashMap<Object, Set<MatcherTpl>>(16);
        LinkedHashMap<MatcherTpl, Set<Object>> tplPkMap = new LinkedHashMap<MatcherTpl, Set<Object>>(16);
        for (PrintJob printJob : matchPrintJobs) {
            Object templateId = printJob.getTemplateId();
            if (ObjectUtils.isEmpty((Object)templateId)) continue;
            List<Object> billIds = printJob.getBillIds();
            String tplId = String.valueOf(templateId);
            MatcherTpl matcherTpl = new MatcherTpl();
            matcherTpl.setTplId(tplId);
            matcherTpl.setTplType((String)config.get(tplId));
            for (Object billId : billIds) {
                Set matcherTpls = pkTplMap.getOrDefault(billId, new LinkedHashSet(1));
                matcherTpls.add(matcherTpl);
                pkTplMap.put(billId, matcherTpls);
            }
            Set pkIdSet = tplPkMap.getOrDefault(matcherTpl, new LinkedHashSet(16));
            pkIdSet.addAll(billIds);
            tplPkMap.put(matcherTpl, pkIdSet);
        }
        for (Object pkId : this.param.getPkIds()) {
            if (pkTplMap.containsKey(pkId)) continue;
            unMatchPkIdSet.add(pkId);
        }
        matcherResult.setPkTplMap(pkTplMap);
        matcherResult.setTplPkMap(tplPkMap);
        matcherResult.setUnMatchPkIdSet(unMatchPkIdSet);
        return matcherResult;
    }

    public TplMatcherParam resolveView(IFormView view) {
        String entityId = TplMatcherUtil.getEntityTypeId(view);
        String pageId = view.getPageId();
        List<Object> pkIds = this.getPKIds(view);
        String pdfName = this.getPdfName(view);
        String appId = view.getFormShowParameter().getAppId();
        this.param.setEntityId(entityId);
        this.param.setPageId(pageId);
        this.param.setPkIds(pkIds);
        this.param.setPdfName(pdfName);
        this.param.setAppId(appId);
        this.context.setParam(this.param);
        ViewType viewType = this.getViewType(view);
        this.param.setViewType(viewType);
        return this.param;
    }

    public TplMatcherContext getContext() {
        return this.context;
    }

    private ViewType getViewType(IFormView view) {
        ViewType viewType = ViewType.OTHER;
        if (view instanceof IMobileView) {
            return ViewType.MOBILE;
        }
        if (view instanceof IReportView) {
            return ViewType.REPORT;
        }
        if (view instanceof IMobileListView) {
            return ViewType.MOBILE_LIST;
        }
        if (view instanceof IBillView) {
            return ViewType.BILL;
        }
        if (view instanceof IListView) {
            return ViewType.LIST;
        }
        return viewType;
    }

    private String getPdfName(IFormView view) {
        String caption = "";
        FormShowParameter formShowParameter = view.getFormShowParameter();
        FormConfig fc = formShowParameter.getFormConfig();
        if (fc != null && fc.getCaption() != null) {
            caption = fc.getCaption().getLocaleValue();
        }
        return caption;
    }

    private List<Object> getPKIds(IFormView view) {
        PKFieldProp pkProp;
        Object pkValue;
        String printPkIds;
        if (this.param.getOption().containsVariable("printPkIds") && StringUtils.isNotBlank((CharSequence)(printPkIds = this.param.getOption().getVariableValue("printPkIds")))) {
            try {
                return SerializationUtils.fromJsonStringToList((String)printPkIds, Object.class);
            }
            catch (Exception e) {
                log.error("printPkIds\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)e);
            }
        }
        LinkedHashSet<Object> pkIdSet = new LinkedHashSet<Object>(16);
        if (view instanceof IMobileView) {
            if (!(view instanceof IMobileListView)) {
                Object pkValue2 = view.getModel().getDataEntity().getPkValue();
                PKFieldProp pkProp2 = (PKFieldProp)view.getModel().getDataEntityType().getPrimaryKey();
                if (!pkProp2.getValueComparator().compareValue(pkValue2)) {
                    pkIdSet.add(pkValue2);
                }
            }
        } else if (view instanceof IListView) {
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)view).getSelectedRows();
            if (!listSelectedRowCollection.isEmpty()) {
                for (ListSelectedRow listSelectedRowValue : listSelectedRowCollection) {
                    Object pkv = listSelectedRowValue.getPrimaryKeyValue();
                    pkIdSet.add(pkv);
                }
            }
        } else if (!(view instanceof IReportView) && (pkValue = view.getModel().getDataEntity().getPkValue()) != null && !(pkProp = (PKFieldProp)view.getModel().getDataEntityType().getPrimaryKey()).getValueComparator().compareValue(pkValue)) {
            pkIdSet.add(pkValue);
        }
        return new ArrayList<Object>(pkIdSet);
    }

    public static String getEntityTypeId(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String entityTypeId = formShowParameter.getFormConfig().getEntityTypeId();
        if (view instanceof AbstractListView) {
            return ((AbstractListView)view).getEntityTypeId();
        }
        if (view instanceof IMobileView) {
            entityTypeId = formShowParameter.getFormConfig().getEntityTypeId();
        }
        return entityTypeId;
    }

    private TplMatcherResult buildResultByDefault() {
        PrintJob jb;
        if (this.checkMatcherEnd()) {
            return this.result;
        }
        this.result.setEndMatchLevel(4);
        ArrayList<PrintJob> printJobs = new ArrayList<PrintJob>(10);
        boolean isContainBillType = this.isContainBillType();
        if (!isContainBillType) {
            String tplId = this.context.getDefaultTemplateId();
            String caption = "";
            PrintJob jb2 = new PrintJob(this.param.getPageId(), this.param.getEntityId());
            jb2.setBillIds(this.param.getPkIds());
            jb2.setPrinterId(this.context.getDefaultPrinter());
            jb2.setTemplateId(tplId);
            jb2.setName(caption);
            printJobs.add(jb2);
            return this.setResult(printJobs);
        }
        List<Object> printablePKIIds = this.getPrintEnablePKIds();
        if (CollectionUtils.isEmpty(printablePKIIds)) {
            this.result.setMatchPrintJob(printJobs);
            return this.result;
        }
        HashMap tplBillIdMap = new HashMap(16);
        StringBuilder errorMsg = this.result.getErrorMsg();
        for (Object object : printablePKIIds) {
            String templateId = this.context.getDefaultTemplateByBillType(object);
            if (StringUtils.isBlank((CharSequence)templateId)) continue;
            int tplStatus = this.context.getTplStatus(templateId);
            if (tplStatus != 1) {
                this.addErrMsgByTplStatus(tplStatus, errorMsg);
                continue;
            }
            if (tplBillIdMap.containsKey(templateId)) {
                ((List)tplBillIdMap.get(templateId)).add(object);
                continue;
            }
            ArrayList<Object> pks = new ArrayList<Object>(1);
            pks.add(object);
            tplBillIdMap.put(templateId, pks);
        }
        for (Map.Entry entry : tplBillIdMap.entrySet()) {
            jb = new PrintJob(this.param.getPageId(), this.param.getEntityId());
            jb.setBillIds((List)entry.getValue());
            jb.setTemplateId(entry.getKey());
            jb.setName(this.param.getPdfName());
            jb.setPrinterId(this.context.getDefaultPrinter());
            printJobs.add(jb);
        }
        if (printJobs.isEmpty()) {
            String tplId = this.context.getDefaultTemplateId();
            String string = "";
            jb = new PrintJob(this.param.getPageId(), this.param.getEntityId());
            jb.setBillIds(this.param.getPkIds());
            jb.setPrinterId(this.context.getDefaultPrinter());
            jb.setTemplateId(tplId);
            jb.setName(string);
            printJobs.add(jb);
        }
        return this.setResult(printJobs);
    }

    private void addErrMsgByTplStatus(int tplStatus, StringBuilder errorMsg) {
        if (0 == tplStatus) {
            this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7c7b\u578b\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_22", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return;
        }
        if (2 == tplStatus) {
            this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7c7b\u578b\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_23", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return;
        }
        if (3 == tplStatus) {
            this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u65e0\u6743\u9650\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_40", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
        }
    }

    private void errorMsgAppend(StringBuilder errorMsgBuilder, String errorMsg) {
        if (this.errorMsgSet.contains(errorMsg)) {
            return;
        }
        this.errorMsgSet.add(errorMsg);
        errorMsgBuilder.append(errorMsg);
    }

    private TplMatcherResult buildResultByPrintSetting() {
        if (this.checkMatcherEnd()) {
            return this.result;
        }
        Map<String, Object> printSetting = this.context.getPrintSetting();
        if (printSetting.isEmpty()) {
            return this.result;
        }
        ViewType viewType = this.param.getViewType();
        if (viewType == ViewType.MOBILE) {
            return this.buildResultForMobile();
        }
        if (viewType == ViewType.REPORT) {
            return this.buildResultForRpt();
        }
        boolean isExistUserSetting = this.isExistUserSetting(printSetting);
        if (isExistUserSetting) {
            return this.buildResultForPC();
        }
        return this.result;
    }

    private boolean checkMatcherEnd() {
        return this.result.getEndMatchLevel() != 0;
    }

    private TplMatcherResult buildResultByNewPrintCondition(Map<String, Object> printConditionMap) {
        int result;
        ArrayList<Object> unMatchBillIds;
        Object psDefPrinter;
        Object psDefTplId;
        ArrayList<String> unUseTemplateIds;
        ArrayList<PrintJob> jobs;
        block11: {
            Set<Object> matchBillIds;
            List<Object> pkIds;
            block10: {
                if (this.checkMatcherEnd()) {
                    return this.result;
                }
                String entityId = this.param.getEntityId();
                Tuple validateResult = PrintConditionHelpUtils.validateCondition(printConditionMap);
                if (!((Boolean)validateResult.item1).booleanValue()) {
                    return this.result;
                }
                List objs = (List)validateResult.item2;
                Tuple checkResult = PrintConditionHelpUtils.checkCondition((List)objs);
                List enableTemplates = PrintConditionHelpUtils.checkTemplatePerm((String)entityId, (List)((List)checkResult.item2));
                List availableFilterSetting = objs.stream().filter(p -> p.isEnable() && StringUtils.isNotBlank((CharSequence)p.getFiltertemplateid()) && enableTemplates.contains(p.getFiltertemplateid())).collect(Collectors.toList());
                jobs = new ArrayList<PrintJob>(10);
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityId);
                unUseTemplateIds = new ArrayList<String>(10);
                pkIds = this.param.getPkIds();
                String pageId = this.param.getPageId();
                String printerId = this.context.getDefaultPrinter();
                String pdfName = this.param.getPdfName();
                Map<String, Object> printSetting = this.context.getPrintSetting();
                psDefTplId = printSetting.get(TEMPLATEID);
                Object psDefTpl = printSetting.get(TEMPLATE);
                Object psSeleTpl = printSetting.get("selecttpl");
                psDefPrinter = printSetting.get(PRINTERID);
                Map<String, Object> wfParams = this.context.getWfParams();
                if (StringUtils.isBlank((Object)psDefTplId)) {
                    if (StringUtils.isBlank((Object)psDefTpl)) {
                        psDefTpl = psSeleTpl;
                    }
                    if (StringUtils.isNotBlank((Object)psDefTpl)) {
                        Object templateId;
                        psDefTplId = templateId = MetadataDao.getIdByNumber((String)psDefTpl.toString(), (MetaCategory)MetaCategory.Form);
                    }
                }
                for (kd.bos.print.business.scheme.entity.ComplexSettingItem item : availableFilterSetting) {
                    FilterCondition filterCondition;
                    Object filterConditionJson = item.getFiltercondition();
                    if (StringUtils.isBlank((Object)filterConditionJson) || item.getFiltertype() != 1 || null == (filterCondition = this.getFilterCondition(filterConditionJson)) || CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow())) continue;
                    FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
                    filterBuilder.setTimeService((ITimeService)new TimeService());
                    filterBuilder.setUserService((IUserService)new UserService());
                    filterBuilder.buildFilter(true);
                    String pkName = dt.getPrimaryKey().getName();
                    QFilter[] filters = new QFilter[]{filterBuilder.getQFilter(), new QFilter(pkName, "in", pkIds)};
                    Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)entityId, (QFilter[])filters);
                    if (filterObjs.size() > 0) {
                        ArrayList<Object> billIds = new ArrayList<Object>(filterObjs.keySet());
                        PrintJob job = new PrintJob();
                        job.setPageId(pageId);
                        job.setFormId(entityId);
                        job.setBillIds(billIds);
                        job.setPrinterId(printerId);
                        job.setTemplateId(item.getFiltertemplateid());
                        job.setName(pdfName);
                        job.setWorkFlowParams(wfParams);
                        jobs.add(job);
                    }
                    unUseTemplateIds.add(item.getFiltertemplateid());
                }
                Optional<kd.bos.print.business.scheme.entity.ComplexSettingItem> other = availableFilterSetting.stream().filter(o -> o.getFiltertype() == 2).findFirst();
                unMatchBillIds = new ArrayList<Object>(10);
                matchBillIds = this.getMatchBillIds(jobs);
                if (!other.isPresent()) break block10;
                kd.bos.print.business.scheme.entity.ComplexSettingItem otherSetting = other.get();
                if (!enableTemplates.contains(otherSetting.getFiltertemplateid())) break block11;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object id : pkIds) {
                    boolean isMatch = matchBillIds.contains(id);
                    if (isMatch) continue;
                    arrayList.add(id);
                }
                if (arrayList.isEmpty()) break block11;
                PrintJob job = new PrintJob();
                job.setPageId(pageId);
                job.setFormId(entityId);
                job.setBillIds(arrayList);
                job.setPrinterId(printerId);
                job.setTemplateId(otherSetting.getFiltertemplateid());
                job.setName(pdfName);
                job.setWorkFlowParams(wfParams);
                jobs.add(job);
                break block11;
            }
            for (Object e : pkIds) {
                boolean isMatch = matchBillIds.contains(e);
                if (isMatch) continue;
                unMatchBillIds.add(e);
            }
        }
        if (!CollectionUtils.isEmpty(unMatchBillIds) && (result = this.context.getTplStatus((String)psDefTplId).intValue()) == 1) {
            PrintJob printJob = new PrintJob(this.param.getPageId(), this.param.getEntityId());
            printJob.setBillIds(unMatchBillIds);
            printJob.setPrinterId(psDefPrinter);
            printJob.setTemplateId(psDefTplId);
            printJob.setName(this.param.getPdfName());
            jobs.add(printJob);
            unMatchBillIds = new ArrayList(10);
        }
        this.result.setEndMatchLevel(1);
        this.setResult(jobs);
        this.result.setUnMatchBillIds(unMatchBillIds);
        this.result.setUnUseTempIds(unUseTemplateIds);
        return this.result;
    }

    private FilterCondition getFilterCondition(Object filterConditionJson) {
        FilterCondition filterCondition = filterConditionJson instanceof String ? (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionJson.toString(), FilterCondition.class) : (FilterCondition)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)filterConditionJson), FilterCondition.class);
        return filterCondition;
    }

    private TplMatcherResult buildResultForMobile() {
        this.result.setEndMatchLevel(2);
        Map<String, Object> printSetting = this.context.getPrintSetting();
        ArrayList<PrintJob> mjobs = new ArrayList<PrintJob>(10);
        List<Object> pkIds = this.param.getPkIds();
        Object defaultPrinter = printSetting.get(PRINTERID);
        String defaultTemplateId = this.context.getDefaultTemplateId();
        StringBuilder errorMsg = this.result.getErrorMsg();
        int tplStatus = this.context.getTplStatus(defaultTemplateId);
        if (tplStatus == 1) {
            PrintJob jb = new PrintJob(this.param.getPageId(), this.param.getEntityId());
            jb.setBillIds(pkIds);
            jb.setPrinterId(defaultPrinter);
            jb.setTemplateId(defaultTemplateId);
            jb.setName(this.param.getPdfName());
            mjobs.add(jb);
            this.setResult(mjobs);
        } else if (0 == tplStatus) {
            this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_10", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
        } else if (2 == tplStatus) {
            this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_11", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
        } else if (3 == tplStatus) {
            this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u65e0\u6743\u9650\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_40", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
        }
        return this.result;
    }

    private TplMatcherResult buildResultForRpt() {
        this.result.setEndMatchLevel(2);
        ArrayList<PrintJob> printJobs = new ArrayList<PrintJob>(10);
        Map<String, Object> printSetting = this.context.getPrintSetting();
        Object defaultPrinter = printSetting.get(PRINTERID);
        String defaultTemplateId = this.context.getDefaultTemplateId();
        if (StringUtils.isBlank((CharSequence)defaultTemplateId)) {
            return this.result;
        }
        int res = this.context.getTplStatus(defaultTemplateId);
        if (res == 1) {
            PrintJob jb = new PrintJob(this.param.getPageId(), this.param.getEntityId());
            jb.setPrinterId(defaultPrinter);
            jb.setTemplateId(defaultTemplateId);
            jb.setName(this.param.getPdfName());
            printJobs.add(jb);
            this.setResult(printJobs);
            return this.result;
        }
        StringBuilder errorMsg = this.result.getErrorMsg();
        if (0 == res) {
            this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_10", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
        } else if (2 == res) {
            this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_11", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
        } else if (3 == res) {
            this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u65e0\u6743\u9650\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_40", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
        }
        return this.result;
    }

    private TplMatcherResult buildResultForPC() {
        List<Object> printenablePKIds;
        boolean isContainBillType;
        Map<String, Object> printSetting = this.context.getPrintSetting();
        List<PrintJob> pcJobs = new ArrayList<PrintJob>(10);
        Object defaultPrinter = printSetting.get(PRINTERID);
        Object defaultTemplateId = printSetting.get(TEMPLATEID);
        Object defaultTemplate = printSetting.get(TEMPLATE);
        Object selectTpl = printSetting.get("selecttpl");
        Object complexSettingJson = printSetting.get(COMPLEXSETTING);
        Object baseSetting = printSetting.get(BASESETTING);
        boolean hasEnableComplexSetting = false;
        List<Object> objs = new ArrayList(10);
        StringBuilder errorMsg = this.result.getErrorMsg();
        if (!ObjectUtils.isEmpty((Object)complexSettingJson)) {
            objs = this.getComplexSettingItems(complexSettingJson);
            hasEnableComplexSetting = objs.stream().anyMatch(p -> p.isEnable());
        }
        if (hasEnableComplexSetting) {
            this.result.setEndMatchLevel(2);
            List<ComplexSettingItem> availableFilterSetting = objs.stream().filter(p -> p.isEnable() && StringUtils.isNotBlank((CharSequence)p.getFiltertemplateid())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(availableFilterSetting)) {
                this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5df2\u542f\u7528\u6253\u5370\u7684\u9ad8\u7ea7\u8bbe\u7f6e\uff0c\u4f46\u672a\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011-\u3010\u9ad8\u7ea7\u3011\u4e2d\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AbstractPrint_14", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                return this.errorResult();
            }
            pcJobs = this.getPrintJobByFilter(availableFilterSetting, null, defaultPrinter);
            if (!CollectionUtils.isEmpty(pcJobs) || errorMsg.length() != 0) {
                return this.setResult(pcJobs);
            }
            Optional<ComplexSettingItem> other = objs.stream().filter(o -> o.getFiltertype() == 2).findFirst();
            if (other.isPresent()) {
                ComplexSettingItem item = other.get();
                if (StringUtils.isBlank((CharSequence)item.getFiltertemplateid())) {
                    this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5e76\u4e14\u7c7b\u578b\u4e3a\u3010\u5176\u5b83\u3011\u7684\u6761\u4ef6\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u91cd\u65b0\u8bbe\u7f6e\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u3002", (String)"AbstractPrint_12", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                } else {
                    this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5df2\u88ab\u8fc7\u6ee4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u6253\u5370\u8bbe\u7f6e\u3002", (String)"AbstractPrint_13", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                }
            } else {
                this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5df2\u88ab\u8fc7\u6ee4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u6253\u5370\u8bbe\u7f6e\u3002", (String)"AbstractPrint_13", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            }
            return this.setResult(pcJobs);
        }
        if (!ObjectUtils.isEmpty((Object)baseSetting) && (isContainBillType = this.isContainBillType())) {
            printenablePKIds = this.getPrintEnablePKIds();
            if (errorMsg.length() != 0) {
                this.result.setEndMatchLevel(2);
                return this.result;
            }
            if (!printenablePKIds.isEmpty()) {
                pcJobs = this.getPrintJobByBillType(printenablePKIds);
            }
            if (errorMsg.length() != 0) {
                this.result.setEndMatchLevel(2);
                return this.result;
            }
            if (!pcJobs.isEmpty()) {
                this.result.setEndMatchLevel(2);
                this.setResult(pcJobs);
                return this.result;
            }
        }
        if (StringUtils.isBlank((Object)defaultTemplateId)) {
            if (StringUtils.isBlank((Object)defaultTemplate)) {
                defaultTemplate = selectTpl;
            }
            if (StringUtils.isNotBlank((Object)defaultTemplate)) {
                String templateId = MetadataDao.getIdByNumber((String)defaultTemplate.toString(), (MetaCategory)MetaCategory.Form);
                defaultTemplateId = templateId;
            }
        }
        if (StringUtils.isNotBlank((Object)defaultTemplateId)) {
            this.result.setEndMatchLevel(2);
            int result = this.context.getTplStatus((String)defaultTemplateId);
            if (result == 1) {
                printenablePKIds = this.getPrintEnablePKIds();
                PrintJob jb = new PrintJob(this.param.getPageId(), this.param.getEntityId());
                jb.setBillIds(printenablePKIds);
                jb.setPrinterId(defaultPrinter);
                jb.setTemplateId(defaultTemplateId);
                jb.setName(this.param.getPdfName());
                pcJobs.add(jb);
            } else if (result == 0) {
                if (errorMsg.length() == 0) {
                    this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_15", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                }
            } else if (3 == result) {
                this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u65e0\u6743\u9650\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_40", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            } else if (errorMsg.length() == 0) {
                this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_16", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            }
        }
        return this.setResult(pcJobs);
    }

    private void refreshUnMatchBillIds(List<Object> pkIds, Set<Object> matchBillIds, List<Object> unMatchBillIds) {
        for (Object id : pkIds) {
            boolean isMatch = matchBillIds.contains(id);
            if (!isMatch) {
                unMatchBillIds.add(id);
                continue;
            }
            if (CollectionUtils.isEmpty(unMatchBillIds) || !unMatchBillIds.contains(id)) continue;
            unMatchBillIds.remove(id);
        }
    }

    private List<PrintJob> getPrintJobByBillType(List<Object> pkids) {
        ArrayList<PrintJob> bJobs = new ArrayList<PrintJob>(10);
        Map<String, Object> printSetting = this.context.getPrintSetting();
        Map<Long, DynamicObject> billTypeObjCache = this.context.getBillTypeObjCache();
        Map<Object, Long> billidToBillTypeId = this.context.getBillIdToBillTypeId();
        PrintTemplateMatcher printTemplateMatcher = new PrintTemplateMatcher(printSetting, billTypeObjCache, billidToBillTypeId, true);
        HashMap tplBillIdMap = new HashMap(16);
        for (Object object : pkids) {
            String templateId = printTemplateMatcher.getTemplateBySetting(object);
            if (StringUtils.isBlank((Object)templateId)) {
                templateId = printTemplateMatcher.getTemplateByDefault(object);
            }
            if (StringUtils.isBlank((Object)templateId)) {
                templateId = this.context.getDefaultTemplateId();
            }
            if (!StringUtils.isNotBlank((Object)templateId)) continue;
            int tplStatus = this.context.getTplStatus(String.valueOf(templateId));
            StringBuilder errorMsg = this.result.getErrorMsg();
            if (tplStatus == 1) {
                if (tplBillIdMap.containsKey(templateId)) {
                    ((List)tplBillIdMap.get(templateId)).add(object);
                    continue;
                }
                ArrayList<Object> pks = new ArrayList<Object>(1);
                pks.add(object);
                tplBillIdMap.put(templateId, pks);
                continue;
            }
            this.addErrMsgByTplStatus(tplStatus, errorMsg);
        }
        for (Map.Entry entry : tplBillIdMap.entrySet()) {
            PrintJob jb = new PrintJob(this.param.getPageId(), this.param.getEntityId());
            jb.setBillIds((List)entry.getValue());
            jb.setTemplateId(entry.getKey());
            jb.setName(this.param.getPdfName());
            jb.setPrinterId(this.context.getDefaultPrinter());
            bJobs.add(jb);
        }
        return bJobs;
    }

    protected boolean isContainBillType() {
        ViewType viewType = this.param.getViewType();
        if (viewType == ViewType.BILL || viewType == ViewType.LIST) {
            BillEntityType billDT = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.param.getEntityId());
            return StringUtils.isNotBlank((CharSequence)billDT.getBillType());
        }
        return false;
    }

    public List<Object> filterByBillParameterCondition(String printCondition) {
        if (StringUtils.isBlank((CharSequence)printCondition)) {
            return this.param.getPkIds();
        }
        String entityId = this.param.getEntityId();
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)printCondition, FilterCondition.class);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityId);
        FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
        filterBuilder.buildFilter(true);
        QFilter qfFormBillParameter = filterBuilder.getQFilter();
        if (qfFormBillParameter != null) {
            QFilter[] filters = new QFilter[2];
            filters[0] = qfFormBillParameter;
            List<Object> pkIds = this.param.getPkIds();
            filters[1] = new QFilter(dt.getPrimaryKey().getName(), "in", pkIds);
            Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)entityId, (QFilter[])filters);
            ArrayList<Object> filterPkList = new ArrayList<Object>(10);
            Set idSet = filterObjs.keySet();
            for (Object pkId : pkIds) {
                if (!idSet.contains(pkId)) continue;
                filterPkList.add(pkId);
            }
            this.param.setPkIds(filterPkList);
        }
        return this.param.getPkIds();
    }

    public String getBillParameterCondition() {
        DynamicObject obj = this.context.getBillParameter();
        if (obj == null) {
            return null;
        }
        String printCondition = obj.getString("printconditionvalue");
        return printCondition;
    }

    private List<Object> getPrintEnablePKIds() {
        ViewType viewType = this.param.getViewType();
        String entityTypeId = this.param.getEntityId();
        BillEntityType billDT = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityTypeId);
        String billTypeFieldKey = billDT.getBillType();
        String billStatusFieldKey = billDT.getBillStatus();
        String printCondition = this.getBillParameterCondition();
        if (StringUtils.isNotBlank((CharSequence)printCondition)) {
            return this.filterByBillParameterCondition(printCondition);
        }
        if (StringUtils.isBlank((CharSequence)billStatusFieldKey) || StringUtils.isBlank((CharSequence)billTypeFieldKey)) {
            return this.param.getPkIds();
        }
        if (viewType == ViewType.LIST || viewType == ViewType.BILL) {
            return this.filterPkIdByBillType(billDT, billTypeFieldKey);
        }
        return this.param.getPkIds();
    }

    private List<Object> filterPkIdByBillType(BillEntityType billDT, String billTypeFieldKey) {
        if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
            return this.param.getPkIds();
        }
        ArrayList<Object> printEnableIds = new ArrayList<Object>(10);
        Map<Object, String> pkStatusMap = this.context.getBillPkAndStatusMap();
        Map<Object, DynamicObject> billDataMap = this.context.getBillDataMap();
        HashSet<Object> pks = new HashSet<Object>(10);
        for (Map.Entry<Object, DynamicObject> entry : billDataMap.entrySet()) {
            Object pkValue = entry.getKey();
            DynamicObject dynamicObject = entry.getValue();
            DynamicObject billTypeDy = dynamicObject.getDynamicObject(billTypeFieldKey);
            String billStatus = pkStatusMap.get(pkValue);
            String billNo = dynamicObject.getString(billDT.getBillNo());
            if (pks.contains(pkValue)) continue;
            pks.add(pkValue);
            if (billTypeDy != null && !StringUtils.isBlank((CharSequence)billStatus) && !this.isBillPrintEnable((Long)billTypeDy.getPkValue(), billStatus, pkValue, billNo) || printEnableIds.contains(pkValue)) continue;
            printEnableIds.add(pkValue);
        }
        this.addUnEnableBillTypeTips();
        this.buildBillTypeErrorMsg();
        return printEnableIds;
    }

    private void buildBillTypeErrorMsg() {
        if (!CollectionUtils.isEmpty(this.billTypeErrMsgMap)) {
            String msg;
            Set<String> billType = this.billTypeErrMsgMap.get("billType");
            Set<String> billNo = this.billTypeErrMsgMap.get("billNo");
            String billTypeS = "";
            String billNoS = "";
            if (!CollectionUtils.isEmpty(billType)) {
                msg = ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"AbstractPrint_46", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
                billTypeS = msg + "\u201c" + String.join((CharSequence)"\u3001", billType) + "\u201c";
            }
            if (!CollectionUtils.isEmpty(billNo)) {
                msg = ResManager.loadKDString((String)"\u5355\u636e", (String)"AbstractPrint_47", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
                billNoS = msg + "\u201c" + String.join((CharSequence)"\u3001", billNo) + "\u201c";
            }
            StringBuilder errorMsg = this.result.getErrorMsg();
            String str = String.format(ResManager.loadKDString((String)"%1$s\u8bbe\u7f6e\u4e86\u201c\u5ba1\u6838\u540e\u6253\u5370\u201d\uff0c\u800c%2$s\u672a\u5ba1\u6838\u3002", (String)"AbstractPrint_18", (String)BOS_NOTEPRINT, (Object[])new Object[0]), billTypeS, billNoS);
            if (errorMsg.toString().contains(str)) {
                return;
            }
            this.errorMsgAppend(errorMsg, str);
        }
    }

    private boolean isBillPrintEnable(Long billTypeId, String billStatus, Object pkId, String billNo) {
        Map<Long, DynamicObject> billTypeObjCache = this.context.getBillTypeObjCache();
        if (CollectionUtils.isEmpty(billTypeObjCache)) {
            return true;
        }
        DynamicObject billTypeObj = billTypeObjCache.get(billTypeId);
        if (billTypeObj == null) {
            log.error("\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\uff01 \u4e3b\u952e\uff1a" + billTypeId + " \u5bf9\u5e94\u7684\u5355\u636e\u7c7b\u578b\u5bf9\u8c61\u4e0d\u5b58\u5728");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)billStatus)) {
            return true;
        }
        boolean printAfterAudit = billTypeObj.getBoolean("printafteraudit");
        boolean controlPrintCount = billTypeObj.getBoolean("controlprintcount");
        int maxPrintCount = billTypeObj.getInt("maxprintcount");
        OperateOption option = this.param.getOption();
        String bosAuditOpencustomCheckAudit = option.getVariableValue("BOS_AUDIT_OPENCUSTOMCHECKAUDIT", "0");
        StringBuilder errorMsg = this.result.getErrorMsg();
        String name = "";
        ILocaleString localeString = billTypeObj.getLocaleString("name");
        if (localeString != null && localeString.getLocaleValue() != null) {
            name = localeString.getLocaleValue();
        }
        if ("0".equals(bosAuditOpencustomCheckAudit) && printAfterAudit) {
            boolean match;
            String customAuditValue = option.getVariableValue("BOS_AUDIT_CUSTOMAUDITVALUE", AUDIT);
            if (AUDIT.equalsIgnoreCase(customAuditValue)) {
                match = customAuditValue.equals(billStatus);
            } else {
                String[] customAuditArr = customAuditValue.split(",");
                match = TplMatcherUtil.isContainInCustomAuditArr(customAuditArr, billStatus);
            }
            if (!match) {
                Set<String> typeSet = this.billTypeErrMsgMap.get("billType");
                if (CollectionUtils.isEmpty(typeSet)) {
                    typeSet = new HashSet<String>(10);
                    typeSet.add(name);
                    this.billTypeErrMsgMap.put("billType", typeSet);
                } else {
                    typeSet.add(name);
                }
                Set<String> billNoSet = this.billTypeErrMsgMap.get("billNo");
                if (CollectionUtils.isEmpty(billNoSet)) {
                    billNoSet = new HashSet<String>(10);
                    billNoSet.add(billNo);
                    this.billTypeErrMsgMap.put("billNo", billNoSet);
                } else {
                    billNoSet.add(billNo);
                }
                return false;
            }
        }
        if (controlPrintCount && maxPrintCount <= this.currentPrintCount(pkId)) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u201c%1$s\u201d\u4e2d\u8bbe\u7f6e\u4e86\u201c\u6700\u5927\u6253\u5370\u6b21\u6570\u201d%2$s\u6b21\uff0c\u5f53\u524d\u5355\u636e\u201c%3$s\u201d\u5df2\u5230\u8fbe\u6700\u5927\u6253\u5370\u6b21\u6570\u3002", (String)"AbstractPrint_45", (String)BOS_NOTEPRINT, (Object[])new Object[0]), name, maxPrintCount, billNo);
            this.errorMsgAppend(errorMsg, msg);
            return false;
        }
        return true;
    }

    private void addUnEnableBillTypeTips() {
        Set<String> unEnableBillType = this.context.getUnEnableBillType();
        if (!unEnableBillType.isEmpty()) {
            this.result.getErrorMsg().append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b%s\u5df2\u7ecf\u88ab\u7981\u7528\u3002", (String)"AbstractPrint_42", (String)BOS_NOTEPRINT, (Object[])new Object[0]), StringUtils.join((Object[])unEnableBillType.toArray(), (String)"\uff0c")));
        }
    }

    private static boolean isContainInCustomAuditArr(String[] arr, String billStatus) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        for (String s : arr) {
            if (billStatus != null && billStatus.equals(s)) {
                return true;
            }
            if (s != null) continue;
            return true;
        }
        return false;
    }

    private int currentPrintCount(Object pkid) {
        QFilter[] qFilters = new QFilter[]{new QFilter("bizobjid", "=", (Object)pkid.toString())};
        DynamicObjectCollection printCount = QueryServiceHelper.query((String)FORMID_PRINTLOG, (String)"id", (QFilter[])qFilters);
        return printCount != null ? printCount.size() : 0;
    }

    private List<ComplexSettingItem> getComplexSettingItems(Object complexSettingJson) {
        List objs = complexSettingJson instanceof String ? SerializationUtils.fromJsonStringToList((String)complexSettingJson.toString(), ComplexSettingItem.class) : SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString((Object)complexSettingJson), ComplexSettingItem.class);
        return objs;
    }

    private List<PrintJob> getPrintJobByFilter(List<ComplexSettingItem> objs, Map<String, Object> wfParams, Object defaultPrinter) {
        String tplId;
        ArrayList<PrintJob> fJobs = new ArrayList<PrintJob>();
        String entityTypeId = this.param.getEntityId();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        Iterator<ComplexSettingItem> iterator = objs.iterator();
        List<Object> pkIds = this.param.getPkIds();
        StringBuilder errorMsg = this.result.getErrorMsg();
        while (iterator.hasNext()) {
            ComplexSettingItem item = iterator.next();
            Object filterConditionJson = item.getFiltercondition();
            if (!StringUtils.isNotBlank((Object)filterConditionJson) || item.getFiltertype() != 1) continue;
            tplId = item.getFiltertemplateid();
            int tplStatus = this.context.getTplStatus(tplId);
            if (0 == tplStatus) {
                this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_19", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                continue;
            }
            if (2 == tplStatus) {
                this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_21", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                continue;
            }
            if (3 == tplStatus) {
                this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u65e0\u6743\u9650\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_40", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                continue;
            }
            FilterCondition filterCondition = this.getFilterCondition(filterConditionJson);
            FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
            filterBuilder.setTimeService((ITimeService)new TimeService());
            filterBuilder.setUserService((IUserService)new UserService());
            filterBuilder.buildFilter(true);
            String pkName = dt.getPrimaryKey().getName();
            QFilter[] filters = new QFilter[]{filterBuilder.getQFilter(), new QFilter(pkName, "in", pkIds)};
            Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)entityTypeId, (QFilter[])filters);
            if (filterObjs.size() > 0) {
                PrintJob jb = new PrintJob(this.param.getPageId(), this.param.getEntityId());
                ArrayList<Object> billIds = new ArrayList<Object>(filterObjs.keySet());
                jb.setBillIds(billIds);
                jb.setPrinterId(defaultPrinter);
                jb.setTemplateId(tplId);
                jb.setName(this.param.getPdfName());
                jb.setWorkFlowParams(wfParams);
                fJobs.add(jb);
            }
            if (filterObjs.size() >= pkIds.size()) continue;
            this.result.getInvisibleFilterTemplateId().add(item.getFiltertemplateid());
        }
        Optional<ComplexSettingItem> other = objs.stream().filter(o -> o.getFiltertype() == 2).findFirst();
        if (other.isPresent()) {
            ComplexSettingItem item = other.get();
            tplId = item.getFiltertemplateid();
            if (StringUtils.isNotBlank((CharSequence)tplId)) {
                int result = this.context.getTplStatus(tplId);
                if (0 == result) {
                    this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_19", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                } else if (2 == result) {
                    this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_21", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                } else if (3 == result) {
                    this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u65e0\u6743\u9650\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractPrint_40", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                } else {
                    Set<Object> matchBillIds = this.getMatchBillIds(fJobs);
                    ArrayList<Object> otherMatchIds = new ArrayList<Object>();
                    for (Object id : pkIds) {
                        boolean isMatch = matchBillIds.contains(id);
                        if (isMatch) continue;
                        otherMatchIds.add(id);
                    }
                    if (!otherMatchIds.isEmpty()) {
                        PrintJob jb = new PrintJob(this.param.getPageId(), this.param.getEntityId());
                        jb.setBillIds(otherMatchIds);
                        jb.setPrinterId(defaultPrinter);
                        jb.setTemplateId(tplId);
                        jb.setName(this.param.getPdfName());
                        fJobs.add(jb);
                    }
                }
            }
        } else {
            Set<Object> matchBillIds = this.getMatchBillIds(fJobs);
            List<Object> unMatchBillIds = this.result.getUnMatchBillIds();
            this.refreshUnMatchBillIds(pkIds, matchBillIds, unMatchBillIds);
        }
        for (PrintJob fJob : fJobs) {
            String tplId2 = String.valueOf(fJob.getTemplateId());
            this.result.getMatchFilterTemplateId().add(tplId2);
        }
        this.result.getUnUseTempIds().addAll(this.result.getInvisibleFilterTemplateId());
        return fJobs;
    }

    public Set<Object> getMatchBillIds(List<PrintJob> fJobs) {
        HashSet<Object> matchBillIds = new HashSet<Object>(16);
        fJobs.forEach(job -> matchBillIds.addAll(job.getBillIds()));
        List<PrintJob> matchPrintJob = this.result.getMatchPrintJob();
        matchPrintJob.forEach(j -> matchBillIds.addAll(j.getBillIds()));
        return matchBillIds;
    }

    private TplMatcherResult buildResultByScheme() {
        if (this.checkMatcherEnd()) {
            return this.result;
        }
        if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
            return this.result;
        }
        DynamicObject preferenceScheme = this.context.getEnableScheme();
        if (preferenceScheme == null) {
            return this.errorResult();
        }
        this.result.setEndMatchLevel(3);
        List<Object> jobs = new ArrayList(10);
        Object printer = preferenceScheme.get("defaulcloudprinter_id");
        Object template = preferenceScheme.get("defaulttemplate");
        HashMap<String, Object> wfParams = new HashMap<String, Object>();
        wfParams.put("approveline", preferenceScheme.get("approveline"));
        wfParams.put("ordertype", preferenceScheme.get("ordertype"));
        wfParams.put("includesubmit", preferenceScheme.get("includesubmit"));
        wfParams.put("includeimage", preferenceScheme.get("includeimage"));
        StringBuilder errorMsg = this.result.getErrorMsg();
        DynamicObjectCollection complexSetting = preferenceScheme.getDynamicObjectCollection(COMPLEXSETTING);
        if (complexSetting.isEmpty()) {
            if (ObjectUtils.isEmpty((Object)template)) {
                this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u5df2\u914d\u7f6e\u6253\u5370\u65b9\u6848\uff0c\u4f46\u672a\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AbstractPrint_24", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                return this.errorResult();
            }
            int tplStatus = this.context.getTplStatus(template.toString());
            if (tplStatus != 1) {
                this.addErrMsgByTplStatus(tplStatus, errorMsg);
                return this.errorResult();
            }
            PrintJob jb = new PrintJob(this.param.getPageId(), this.param.getEntityId());
            jb.setBillIds(this.param.getPkIds());
            jb.setPrinterId(printer);
            jb.setTemplateId(template);
            jb.setName(this.param.getPdfName());
            jb.setWorkFlowParams(wfParams);
            jobs.add(jb);
            return this.setResult(jobs);
        }
        boolean isExistEnableFilter = false;
        ArrayList<ComplexSettingItem> filters = new ArrayList<ComplexSettingItem>(10);
        for (DynamicObject o : complexSetting) {
            String filterTemplateId = o.getString("filtertemplateid");
            boolean isEnable = o.getBoolean("ischecked");
            if (isEnable) {
                isExistEnableFilter = true;
            }
            if (!isEnable || !StringUtils.isNotBlank((CharSequence)filterTemplateId)) continue;
            ComplexSettingItem item = new ComplexSettingItem();
            item.setEnable(true);
            item.setFiltercondition(o.getString("filtercondition"));
            item.setFiltername(o.getString("filtername"));
            item.setFiltertemplateid(o.getString("filtertemplateid"));
            item.setFiltertype(o.getInt("filtertype"));
            filters.add(item);
        }
        if (!filters.isEmpty()) {
            jobs = this.getPrintJobByFilter(filters, wfParams, printer);
            if (jobs.isEmpty() && errorMsg.length() == 0) {
                this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5df2\u88ab\u8fc7\u6ee4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u6253\u5370\u65b9\u6848\u3002", (String)"AbstractPrint_32", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                return this.errorResult();
            }
            return this.setResult(jobs);
        }
        if (isExistEnableFilter) {
            this.errorMsgAppend(errorMsg, ResManager.loadKDString((String)"\u6253\u5370\u65b9\u6848\u4e2d\u5b58\u5728\u5df2\u542f\u7528\u4f46\u672a\u8bbe\u7f6e\u6a21\u677f\u7684\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\u5e76\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AbstractPrint_25", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return this.errorResult();
        }
        PrintJob jb = new PrintJob(this.param.getPageId(), this.param.getEntityId());
        jb.setBillIds(this.param.getPkIds());
        jb.setPrinterId(printer);
        jb.setTemplateId(template);
        jb.setName(this.param.getPdfName());
        jb.setWorkFlowParams(wfParams);
        jobs.add(jb);
        this.setResult(jobs);
        return this.result;
    }

    private TplMatcherResult setResult(List<PrintJob> jobs) {
        List<PrintJob> printJob = this.result.getMatchPrintJob();
        if (!CollectionUtils.isEmpty(printJob)) {
            printJob.addAll(jobs);
        } else {
            printJob = jobs;
        }
        this.result.setMatchPrintJob(printJob);
        return this.result;
    }

    private TplMatcherResult errorResult() {
        this.result.setMatchPrintJob(new ArrayList<PrintJob>(0));
        return this.result;
    }

    private boolean isExistUserSetting(Map<String, Object> printSetting) {
        boolean isExistUserSetting;
        boolean bl = isExistUserSetting = printSetting.containsKey(TEMPLATEID) && StringUtils.isNotBlank((Object)printSetting.get(TEMPLATEID));
        if (isExistUserSetting) {
            return true;
        }
        if (printSetting.containsKey(BASESETTING) && !ObjectUtils.isEmpty((Object)printSetting.get(BASESETTING))) {
            return true;
        }
        if (!printSetting.containsKey(COMPLEXSETTING)) {
            return false;
        }
        Object complexSetting = printSetting.get(COMPLEXSETTING);
        if (ObjectUtils.isEmpty((Object)complexSetting)) {
            return false;
        }
        List objs = complexSetting instanceof String ? SerializationUtils.fromJsonStringToList((String)complexSetting.toString(), ComplexSettingItem.class) : SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString((Object)complexSetting), ComplexSettingItem.class);
        isExistUserSetting = objs.stream().anyMatch(ComplexSettingItem::isEnable);
        return isExistUserSetting;
    }

    private boolean isExistDefTpl(Map<String, Object> printSetting) {
        return printSetting.containsKey(TEMPLATEID) && StringUtils.isNotBlank((Object)printSetting.get(TEMPLATEID));
    }

    public TplMatcherParam getParam() {
        return this.param;
    }

    public void setParam(TplMatcherParam param) {
        this.param = param;
    }

    public void reset() {
        this.result = new TplMatcherResult();
        this.context = new TplMatcherContext();
        this.context.setParam(this.param);
    }
}

