/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintDataProvider;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.print.IPrintService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.PrintJob;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.svc.acl.AclAdapter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PrintServiceHelper {
    private static final Log log = LogFactory.getLog(PrintServiceHelper.class);
    private static final String PRINT_SERVICE = "PrintService";
    private static final String FPRINTERID = "fprinterid";
    private static final String PACKAGE_NAME_KEY = "bos-servicehelper";
    private static final String SVC_PRINT = "svc-print";

    private static String getIdTemplatePkIdNotnull() {
        return ResManager.loadKDString((String)"\u6a21\u677fID[templatePkId]\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"PrintServiceHelper_0", (String)"bos-noteprint", (Object[])new Object[0]);
    }

    private static String getPrintIdTemplatePkId() {
        return ResManager.loadKDString((String)"\u6253\u5370\u673aID[templatePkId]\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"PrintServiceHelper_1", (String)"bos-noteprint", (Object[])new Object[0]);
    }

    private static IPrintService getService() {
        return (IPrintService)ServiceFactory.getService(IPrintService.class);
    }

    private PrintServiceHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static String execPrint(String taskId, String printType, List<PrintJob> jobs, Map<String, Object> extParam) {
        if (extParam == null) {
            extParam = new HashMap<String, Object>(4);
        }
        extParam.put("isBizOp", "true");
        return PrintServiceHelper.runPrint(taskId, printType, jobs, extParam);
    }

    @Deprecated
    public static String doPrint(String taskId, String printType, List<PrintJob> jobs) {
        log.info("\u8be5\u65b9\u6cd5\u5df2\u7ecf\u4e0d\u518d\u7ef4\u62a4\uff0c\u8bf7\u6539\u8c03\u7528execPrint\u65b9\u6cd5\u3002");
        return PrintServiceHelper.doPrint(taskId, printType, jobs, null);
    }

    @Deprecated
    public static String doPrint(String taskId, String printType, List<PrintJob> jobs, Map<String, Object> extParam) {
        log.info("\u8be5\u65b9\u6cd5\u5df2\u7ecf\u4e0d\u518d\u7ef4\u62a4\uff0c\u8bf7\u6539\u8c03\u7528execPrint\u65b9\u6cd5\u3002");
        return PrintServiceHelper.runPrint(taskId, printType, jobs, extParam);
    }

    private static String runPrint(String taskId, String printType, List<PrintJob> jobs, Map<String, Object> extParam) {
        String formId;
        if (extParam == null) {
            extParam = new HashMap<String, Object>(4);
        }
        String string = formId = CollectionUtils.isEmpty(jobs) ? "" : jobs.get(0).getFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String appId = SVC_PRINT;
            if (!PrintServiceHelper.hasDeployedAppId(appId)) {
                appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
            }
            taskId = (String)DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"doPrint", (Object[])new Object[]{taskId, printType, jobs, extParam});
        }
        return taskId;
    }

    public static String createSamplePdfUrl(String pageId, String formId, String templateFormId) {
        if (StringUtils.isBlank((CharSequence)templateFormId) || StringUtils.isBlank((CharSequence)formId)) {
            return "";
        }
        String tplId = MetadataDao.getIdByNumber((String)templateFormId, (MetaCategory)MetaCategory.Form);
        PrintJob job = new PrintJob(pageId, formId);
        job.setSample(true);
        job.setTemplateId(tplId);
        try {
            List pkids = QueryServiceHelper.queryPrimaryKeys((String)formId, null, null, (int)1);
            if (!CollectionUtils.isEmpty((Collection)pkids)) {
                Object firstPk = pkids.get(0);
                job.setBillId(firstPk);
            }
        }
        catch (Exception pkids) {
            // empty catch block
        }
        ArrayList<PrintJob> jobs = new ArrayList<PrintJob>(1);
        jobs.add(job);
        String appId = SVC_PRINT;
        if (!PrintServiceHelper.hasDeployedAppId(appId)) {
            appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        }
        Object url = DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"createPdfUrl", (Object[])new Object[]{jobs});
        return (String)url;
    }

    @Deprecated
    public static String createPdfUrl(String pageId, String formId, String templateFormId) {
        return PrintServiceHelper.createPdfUrl(pageId, formId, templateFormId, null);
    }

    @Deprecated
    public static String createPdfUrl(String pageId, String formId, String templateFormId, Object pkid) {
        IPrintDataProvider dataProvider = null;
        return PrintServiceHelper.createPdfUrl(pageId, formId, templateFormId, pkid, dataProvider);
    }

    @Deprecated
    public static String createPdfUrl(String pageId, String formId, String templateFormId, Object pkid, IPrintDataProvider dataProvider) {
        if (StringUtils.isBlank((CharSequence)templateFormId) || StringUtils.isBlank((CharSequence)formId)) {
            return "";
        }
        String tplId = MetadataDao.getIdByNumber((String)templateFormId, (MetaCategory)MetaCategory.Form);
        ArrayList<PrintJob> jobs = new ArrayList<PrintJob>();
        PrintJob job = new PrintJob(pageId, formId);
        job.setBillId(pkid);
        job.setTemplateId(tplId);
        job.setDataProvider(dataProvider);
        jobs.add(job);
        return PrintServiceHelper.createPdfUrl(jobs);
    }

    public static String createPdfUrl(String pageId, String formId, String templateFormId, Object[] pkids) {
        IPrintDataProvider dataProvider = null;
        return PrintServiceHelper.createPdfUrl(pageId, formId, templateFormId, pkids, dataProvider);
    }

    public static String createPdfUrl(String pageId, String formId, String templateFormId, Object[] pkids, IPrintDataProvider dataProvider) {
        if (StringUtils.isBlank((CharSequence)templateFormId) || StringUtils.isBlank((CharSequence)formId)) {
            return "";
        }
        String tplId = MetadataDao.getIdByNumber((String)templateFormId, (MetaCategory)MetaCategory.Form);
        ArrayList<PrintJob> jobs = new ArrayList<PrintJob>();
        if (pkids == null || pkids.length == 0) {
            PrintJob job = new PrintJob(pageId, formId);
            job.setTemplateId(tplId);
            job.setDataProvider(dataProvider);
            jobs.add(job);
        } else {
            for (int i = 0; i < pkids.length; ++i) {
                PrintJob job = new PrintJob(pageId, formId);
                job.setBillId(pkids[i]);
                job.setTemplateId(tplId);
                job.setDataProvider(dataProvider);
                jobs.add(job);
            }
        }
        return PrintServiceHelper.createPdfUrl(jobs);
    }

    public static String createPdfUrl(String pageId, String formId, Map<Object, String> btMap) {
        String url = "";
        ArrayList<PrintJob> jobs = new ArrayList<PrintJob>();
        if (btMap != null && btMap.size() > 0 && StringUtils.isNotBlank((CharSequence)formId)) {
            for (Map.Entry<Object, String> mp : btMap.entrySet()) {
                PrintJob job = new PrintJob(pageId, formId);
                job.setBillId(mp.getKey());
                job.setTemplateId(mp.getValue());
                jobs.add(job);
            }
            PrintServiceHelper.createPdfUrl(jobs);
        }
        return url;
    }

    public static String createPdfUrl(LocaleString fileName, List<PrintJob> jobs) {
        return PrintServiceHelper.createPdfUrl(jobs);
    }

    public static String createPdfUrl(List<PrintJob> jobs) {
        String formId = CollectionUtils.isEmpty(jobs) ? "" : jobs.get(0).getFormId();
        Object url = "";
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String appId = SVC_PRINT;
            if (!PrintServiceHelper.hasDeployedAppId(appId)) {
                appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
            }
            url = DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"createPdfUrl", (Object[])new Object[]{jobs});
        }
        return url.toString();
    }

    public static String createXlsUrl(List<PrintJob> jobs) {
        return PrintServiceHelper.createXlsUrl(jobs, null);
    }

    public static String createXlsUrl(List<PrintJob> jobs, Map<String, Object> para) {
        String formId = CollectionUtils.isEmpty(jobs) ? "" : jobs.get(0).getFormId();
        Object url = "";
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String appId = SVC_PRINT;
            if (!PrintServiceHelper.hasDeployedAppId(appId)) {
                appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
            }
            url = DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"createXlsUrl", (Object[])new Object[]{jobs, para});
        }
        return url.toString();
    }

    public static boolean createPrintJob(String pageId, String formId, String templateFormId, Object printerId) {
        return PrintServiceHelper.createPrintJob(pageId, formId, templateFormId, printerId, null);
    }

    public static boolean createPrintJob(String pageId, String formId, String templateFormId, Object printerId, Object pkid) {
        return PrintServiceHelper.createPrintJob(pageId, formId, templateFormId, printerId, pkid, null);
    }

    public static boolean createPrintJob(String pageId, String formId, String templateFormId, Object printerId, Object pkid, IPrintDataProvider dataProvider) {
        if (StringUtils.isBlank((CharSequence)templateFormId) || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((Object)printerId)) {
            return false;
        }
        String tplId = MetadataDao.getIdByNumber((String)templateFormId, (MetaCategory)MetaCategory.Form);
        ArrayList<PrintJob> jobs = new ArrayList<PrintJob>();
        PrintJob job = new PrintJob(pageId, formId);
        job.setBillId(pkid);
        job.setTemplateId(tplId);
        job.setPrinterId(printerId);
        job.setPageId(pageId);
        job.setFormId(formId);
        job.setDataProvider(dataProvider);
        jobs.add(job);
        return PrintServiceHelper.createPrintJob(jobs);
    }

    public static boolean createPrintJob(String pageId, String formId, String templateFormId, Object printerId, Object[] pkids) {
        if (pkids == null || pkids.length == 0 || StringUtils.isBlank((CharSequence)templateFormId) || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((Object)printerId)) {
            return false;
        }
        String tplId = MetadataDao.getIdByNumber((String)templateFormId, (MetaCategory)MetaCategory.Form);
        ArrayList<PrintJob> jobs = new ArrayList<PrintJob>(pkids.length);
        for (int i = 0; i < pkids.length; ++i) {
            PrintJob job = new PrintJob(pageId, formId);
            job.setBillId(pkids[i]);
            job.setTemplateId(tplId);
            job.setPrinterId(printerId);
            job.setPageId(pageId);
            job.setFormId(formId);
            jobs.add(job);
        }
        return PrintServiceHelper.createPrintJob(jobs);
    }

    public static boolean createPrintJob(List<PrintJob> jobs) {
        String formId = CollectionUtils.isEmpty(jobs) ? "" : jobs.get(0).getFormId();
        String appId = SVC_PRINT;
        if (!PrintServiceHelper.hasDeployedAppId(appId)) {
            appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        }
        Object result = DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"createPrintJob", (Object[])new Object[]{jobs});
        return (Boolean)result;
    }

    @Deprecated
    public static boolean createPrintJob(LocaleString fileName, List<PrintJob> jobs) {
        return PrintServiceHelper.createPrintJob(jobs);
    }

    public static byte[] createSinglePdf(String pageId, String formId, String templateFromId, Object pkId) {
        Object result = null;
        String appId = SVC_PRINT;
        if (!PrintServiceHelper.hasDeployedAppId(appId)) {
            appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        }
        return (result = DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"createSinglePdf", (Object[])new Object[]{pageId, formId, templateFromId, pkId})) == null ? null : (byte[])result;
    }

    public static byte[] createCrossPdf(List<PrintJob> jobs) {
        Object result;
        String formId = CollectionUtils.isEmpty(jobs) ? "" : jobs.get(0).getFormId();
        String appId = SVC_PRINT;
        if (!PrintServiceHelper.hasDeployedAppId(appId)) {
            appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        }
        return (result = DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"createCrossPdf", (Object[])new Object[]{jobs})) == null ? null : (byte[])result;
    }

    public static boolean createScriptPrintJob(String formId, Object billPkId, String templatePkId, String printerPkId) {
        if (ObjectUtils.isEmpty((Object)templatePkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{PrintServiceHelper.getIdTemplatePkIdNotnull()});
        }
        if (ObjectUtils.isEmpty((Object)printerPkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{PrintServiceHelper.getPrintIdTemplatePkId()});
        }
        return PrintServiceHelper.createScriptPrintJob(formId, billPkId, templatePkId, printerPkId, "", (Boolean)false);
    }

    public static boolean createScriptPrintJob(String formId, Object billPkId, Object templatePkId) {
        return PrintServiceHelper.createScriptPrintJob(formId, billPkId, templatePkId, "", false);
    }

    public static boolean createScriptPrintJob(String formId, Object billPkId, Object templatePkId, String separator, Boolean isShowLastSep) {
        if (ObjectUtils.isEmpty((Object)templatePkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{PrintServiceHelper.getIdTemplatePkIdNotnull()});
        }
        Object printerPkId = PrintServiceHelper.getPrinterIdByUserId();
        if (StringUtils.isBlank((Object)printerPkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u9ed8\u8ba4\u7684\u6253\u5370\u673a\u3002", (String)"PrintServiceHelper_1", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        return PrintServiceHelper.createScriptPrintJob(formId, billPkId, templatePkId.toString(), printerPkId.toString(), separator, isShowLastSep);
    }

    public static boolean createScriptPrintJob(String formId, Object billPkId, Object templatePkId, String separator, Boolean isShowLastSep, Boolean isSplitEntry) {
        if (ObjectUtils.isEmpty((Object)templatePkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{PrintServiceHelper.getIdTemplatePkIdNotnull()});
        }
        Object printerPkId = PrintServiceHelper.getPrinterIdByUserId();
        if (StringUtils.isBlank((Object)printerPkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u9ed8\u8ba4\u7684\u6253\u5370\u673a\u3002", (String)"PrintServiceHelper_1", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        return PrintServiceHelper.createScriptPrintJob(formId, billPkId, templatePkId.toString(), printerPkId.toString(), separator, isShowLastSep, isSplitEntry);
    }

    public static boolean createScriptPrintJob(String formId, Object billPkId, String templatePkId, String printerPkId, String separator, Boolean isShowLastSep) {
        if (ObjectUtils.isEmpty((Object)templatePkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{PrintServiceHelper.getIdTemplatePkIdNotnull()});
        }
        if (ObjectUtils.isEmpty((Object)printerPkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{PrintServiceHelper.getPrintIdTemplatePkId()});
        }
        return PrintServiceHelper.createScriptPrintJob(formId, billPkId, templatePkId, printerPkId, separator, isShowLastSep, false);
    }

    public static boolean createScriptPrintJob(String formId, Object billPkId, String templatePkId, String printerPkId, String separator, Boolean isShowLastSep, Boolean isSplitEntry) {
        Object result;
        if (ObjectUtils.isEmpty((Object)templatePkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{PrintServiceHelper.getIdTemplatePkIdNotnull()});
        }
        if (ObjectUtils.isEmpty((Object)printerPkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{PrintServiceHelper.getPrintIdTemplatePkId()});
        }
        String appId = SVC_PRINT;
        if (!PrintServiceHelper.hasDeployedAppId(appId)) {
            appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        }
        return (result = DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"createScriptPrintJob", (Object[])new Object[]{formId, billPkId, templatePkId, printerPkId, separator, isShowLastSep, isSplitEntry})) == null ? false : (Boolean)result;
    }

    public static boolean createScriptPrintJob(String formId, Object templatePkId, Object printerPkId, Map<String, String> values) {
        Object result;
        if (ObjectUtils.isEmpty((Object)templatePkId)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{PrintServiceHelper.getIdTemplatePkIdNotnull()});
        }
        Object printerPK = printerPkId;
        if (StringUtils.isBlank((Object)printerPkId)) {
            printerPK = PrintServiceHelper.getPrinterIdByUserId();
        }
        if (ObjectUtils.isEmpty((Object)printerPK)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{PrintServiceHelper.getPrintIdTemplatePkId()});
        }
        String appId = SVC_PRINT;
        if (!PrintServiceHelper.hasDeployedAppId(appId)) {
            appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        }
        return (result = DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"createEasyScriptPrintJob", (Object[])new Object[]{formId, templatePkId, printerPK, values})) == null ? false : (Boolean)result;
    }

    public static String createPrintCommand(String formId, Object printerPkId, Object pkId) {
        throw new IllegalStateException(ResManager.loadKDString((String)"\u8fd8\u6ca1\u652f\u6301", (String)"PrintServiceHelper_2", (String)"bos-noteprint", (Object[])new Object[0]));
    }

    public static Map<String, String> getPrinter(String formId) {
        throw new IllegalStateException(ResManager.loadKDString((String)"\u8fd8\u6ca1\u652f\u6301", (String)"PrintServiceHelper_2", (String)"bos-noteprint", (Object[])new Object[0]));
    }

    private static Object getPrinterIdByUserId() {
        Object[] params;
        String sql = String.format("select fprinterid,fid from %s where fuserid = ? ", "t_bas_userprintersetting");
        Map query = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])(params = new SqlParameter[]{new SqlParameter(":fuserid", -5, (Object)RequestContext.get().getUserId())}), (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> codeRuleMap = new HashMap<String, String>();
                if (rs.next()) {
                    String fprinterid = rs.getString(PrintServiceHelper.FPRINTERID);
                    String fid = rs.getString("fid");
                    codeRuleMap.put(PrintServiceHelper.FPRINTERID, fprinterid);
                    codeRuleMap.put("fid", fid);
                }
                return codeRuleMap;
            }
        });
        if (query != null && !StringUtils.isEmpty((CharSequence)((CharSequence)query.get("fid")))) {
            DynamicObject userprinter = BusinessDataServiceHelper.loadSingle(query.get("fid"), (String)"bos_userprinter");
            if (userprinter == null) {
                throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6253\u5370\u673a\uff0c\u8bf7\u68c0\u67e5\u6253\u5370\u673a\u662f\u5426\u914d\u7f6e\u6216\u7981\u7528\u3002", (String)"PrintServiceHelper_2", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
            }
            Object fenable = userprinter.get("enable");
            if ("1".equals(fenable.toString())) {
                return query.get(FPRINTERID);
            }
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6253\u5370\u673a\uff0c\u8bf7\u68c0\u67e5\u6253\u5370\u673a\u662f\u5426\u914d\u7f6e\u6216\u7981\u7528\u3002", (String)"PrintServiceHelper_2", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        return null;
    }

    public static Map<String, Object> copyPrintMetadata(String tplId, String bizAppId, String bizUnitId, String newNumber, LocaleString newName) {
        Throwable throwable;
        TXHandle h;
        PrintMetadata metadata = OldPrintTemplateUtil.findOldPrintMetadata((String)tplId);
        metadata.setKey(newNumber);
        metadata.setId(DBServiceHelper.genStringId());
        metadata.setName(newName);
        metadata.setBizappId(bizAppId);
        String currentIsv = ISVService.getISVInfo().getId();
        metadata.setIsv(currentIsv);
        Map<String, Object> saveResult = new HashMap(4);
        try {
            h = TX.required();
            throwable = null;
            try {
                MetadataWriter writer = new MetadataWriter("PrintModel");
                saveResult = writer.save(Boolean.FALSE, new AbstractMetadata[]{metadata});
                boolean isSuccess = (Boolean)saveResult.get("success");
                if (isSuccess) {
                    saveResult.put("id", metadata.getId());
                    DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                    if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
                        dObject.set("bizapp", (Object)bizAppId);
                    } else {
                        dObject.set("bizapp", (Object)metadata.getBizappId());
                    }
                    dObject.set("bizunit", (Object)bizUnitId);
                    dObject.set("form", (Object)metadata.getId());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                }
            }
            catch (Throwable writer) {
                throwable = writer;
                throw writer;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable writer) {
                            throwable.addSuppressed(writer);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            if (e instanceof OrmException) {
                throw (OrmException)e;
            }
            throw new KDException(e, BosErrorCode.bOS, new Object[]{String.format("Error:%s.", e.getMessage())});
        }
        if (saveResult.size() == 0) {
            saveResult.put("success", Boolean.FALSE);
            saveResult.put("message", ResManager.loadKDString((String)"\u590d\u5236\u6253\u5370\u6a21\u677f\u5143\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01", (String)"PrintServiceHelper_0", (String)PACKAGE_NAME_KEY, (Object[])new Object[0]));
        } else {
            try {
                h = TX.requiresNew();
                throwable = null;
                try {
                    String newTplId = String.valueOf(saveResult.get("id"));
                    PrintMetadata formMeta = metadata;
                    DynamicObject metaObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_print_meta");
                    String tplNum = formMeta.getKey();
                    boolean isExist = QueryServiceHelper.exists((String)"bos_print_meta", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)tplNum)});
                    if (isExist) {
                        tplNum = tplNum + "(old)";
                    }
                    String creator = RequestContext.get().getUserId();
                    metaObj.set("id", (Object)newTplId);
                    metaObj.set("masterid", (Object)newTplId);
                    metaObj.set("number", (Object)tplNum);
                    metaObj.set("name", (Object)formMeta.getName());
                    metaObj.set("formid", (Object)MetadataDao.getNumberById((String)formMeta.getEntityId()));
                    metaObj.set("creator", (Object)creator);
                    metaObj.set("modifier", (Object)creator);
                    metaObj.set("type", (Object)"A");
                    metaObj.set("bizappid", (Object)formMeta.getBizappId());
                    metaObj.set("createtime", (Object)new Date());
                    metaObj.set("modifytime", (Object)new Date());
                    metaObj.set("status", (Object)"C");
                    metaObj.set("enable", (Object)"1");
                    metaObj.set("version", (Object)"1");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{metaObj});
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h != null) {
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.info("\u5f80bos_print_meta\u5199\u5165\u6570\u636e\u5931\u8d25:", (Object)e);
            }
        }
        return saveResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] mergeMultiPdf(List<byte[]> pdfPages) {
        ByteArrayOutputStream newOutput = new ByteArrayOutputStream();
        Document document = new Document();
        try {
            PdfCopy copy = new PdfCopy(document, (OutputStream)newOutput);
            document.open();
            for (int i = 0; i < pdfPages.size(); ++i) {
                try {
                    PdfReader reader = new PdfReader(pdfPages.get(i));
                    int n = reader.getNumberOfPages();
                    int page = 0;
                    while (page < n) {
                        try {
                            copy.addPage(copy.getImportedPage(reader, ++page));
                        }
                        catch (BadPdfFormatException e) {
                            log.error(e.getMessage());
                        }
                    }
                    copy.freeReader(reader);
                    reader.close();
                    continue;
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        catch (DocumentException e) {
            log.error(e.getMessage());
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (newOutput != null) {
                    newOutput.close();
                }
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage());
            }
        }
        return newOutput.toByteArray();
    }

    public static byte[] createPdfBytes(String pageId, String formId, String templateFromId, Object billPkId, Map<String, List<String>> entryFilterExp) {
        Object result = null;
        String appId = SVC_PRINT;
        if (!PrintServiceHelper.hasDeployedAppId(appId)) {
            appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        }
        return (result = DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"createPdfBytes", (Object[])new Object[]{pageId, formId, templateFromId, billPkId, entryFilterExp})) == null ? null : (byte[])result;
    }

    public static String createPdfUrl(String pageId, String formId, String templateFromId, Object billPkId, Map<String, List<String>> entryFilterExp) {
        Object result = null;
        String appId = SVC_PRINT;
        if (!PrintServiceHelper.hasDeployedAppId(appId)) {
            appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        }
        result = DispatchServiceHelper.invokeBOSService((String)appId, (String)PRINT_SERVICE, (String)"createPdfUrl", (Object[])new Object[]{pageId, formId, templateFromId, billPkId, entryFilterExp});
        return result.toString();
    }

    public static Map<Object, List<Object>> readPrintSetting(String formId, String userId, List<Object> pks) {
        return PrintServiceHelper.getService().readPrintSetting(formId, userId, pks);
    }

    public static String getRealBillFormId(String formId) {
        try {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
            return formConfig.getEntityTypeId();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return formId;
        }
    }

    private static boolean hasDeployedAppId(String appId) {
        return AclAdapter.getAclServiceLookup().hasDeployedAppId(appId);
    }
}

