/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.print;

import com.kingdee.bos.ctrl.helper.ExportContext;
import com.kingdee.bos.ctrl.helper.ExportService;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintDataProvider;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.PrintServicePluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.print.OldPrintOperationHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.print.PrintJob;
import kd.bos.print.api.FileStorageType;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.print.validation.FieldScanner;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.print.dataprovider.BaseDataProvider;
import kd.bos.servicehelper.print.dataprovider.QueryDataProvider;
import kd.bos.servicehelper.print.dataprovider.ReportDataProvider;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.url.UrlService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class NotePrintService {
    public static final String CLASS_NAME = "className";
    public static final String CONFIG_KEY = "configKey";
    public static final String CONFIGKEY = "configkey";
    private static Log log = LogFactory.getLog(NotePrintService.class);
    private Map<String, PrintMetadata> metaMap = new HashMap<String, PrintMetadata>();
    private static final DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");

    public String doPrint(String taskId, String printType, List<PrintJob> jobs, Map<String, Object> para) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("isNewPrint", false);
        params.put("printType", printType);
        params.put("jobs", jobs);
        params.put("extParam", para);
        PrtFacadeFactory.getAllPrtServiceFacades().forEach(prtService -> prtService.beforeDoPrint(params));
        ArrayList<PrintMetadata> metas = new ArrayList<PrintMetadata>(jobs.size());
        ArrayList<IPrintDataProvider> providers = new ArrayList<IPrintDataProvider>(jobs.size());
        for (PrintJob pj : jobs) {
            String tplId = pj.getTemplateId().toString();
            String formId = pj.getFormId();
            String pageId = pj.getPageId();
            PrintMetadata meta = this.tryGetPrintMeta(tplId);
            metas.add(meta);
            IPrintDataProvider dataProvider = pj.getDataProvider();
            if (null == dataProvider) {
                String batchPrintProp = System.getProperty(RequestContext.get().getTenantId() + "_bos.print.batch");
                if (StringUtils.isBlank((CharSequence)batchPrintProp)) {
                    batchPrintProp = System.getProperty("bos.print.batch");
                }
                if (!StringUtils.isBlank((CharSequence)batchPrintProp) && "false".equalsIgnoreCase(batchPrintProp.trim())) {
                    if (pj.getBillIds() != null && !pj.getBillIds().isEmpty()) {
                        for (int i = 0; i < pj.getBillIds().size(); ++i) {
                            Object p = pj.getBillIds().get(i);
                            if (i > 0) {
                                metas.add(meta);
                            }
                            dataProvider = NotePrintService.createDataProvider(pageId, formId, meta, Collections.singletonList(p));
                            dataProvider.setWorkFlowParams(pj.getWorkFlowParams());
                            providers.add(dataProvider);
                        }
                        continue;
                    }
                    dataProvider = NotePrintService.createDataProvider(pageId, formId, meta, Collections.singletonList(pj.getBillId()));
                    dataProvider.setWorkFlowParams(pj.getWorkFlowParams());
                    providers.add(dataProvider);
                    continue;
                }
                dataProvider = pj.getBillIds() != null && !pj.getBillIds().isEmpty() ? NotePrintService.createDataProvider(pageId, formId, meta, pj.getBillIds()) : NotePrintService.createDataProvider(pageId, formId, meta, Collections.singletonList(pj.getBillId()));
                dataProvider.setWorkFlowParams(pj.getWorkFlowParams());
                providers.add(dataProvider);
                continue;
            }
            ArrayList pluginMap = new ArrayList();
            for (Object p : meta.getRootAp().getPlugins()) {
                if (!p.isEnabled()) continue;
                HashMap<String, Object> mp = new HashMap<String, Object>(1);
                mp.put("type", p.getType());
                mp.put(CLASS_NAME, p.getClassName());
                pluginMap.add(mp);
            }
            PrintServicePluginProxy proxy = null;
            if (!pluginMap.isEmpty()) {
                proxy = new PrintServicePluginProxy(pluginMap);
                dataProvider.setPlunginProxy(proxy);
            }
            dataProvider.setWorkFlowParams(pj.getWorkFlowParams());
            providers.add(dataProvider);
        }
        ExportService expSrv = new ExportService();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
        }
        ExportContext.get().setTaskId(taskId);
        String maxPdfCount = SystemPropertyUtils.getProptyByTenant((String)"PRINT_PAGE_LIMIT", (String)RequestContext.get().getTenantId());
        if (StringUtils.isNotBlank((CharSequence)maxPdfCount) && StringUtils.isNumeric((CharSequence)maxPdfCount)) {
            ExportContext.get().setPdfMaxPageSize(Integer.parseInt(maxPdfCount));
        }
        PrintJob firstJob = jobs.get(0);
        String formId = firstJob.getFormId();
        ExportContext.get().setFormId(formId);
        ExportContext.get().setPreview(firstJob.isSample());
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(firstJob.getPageId());
        String appId = null;
        if (view != null) {
            appId = view.getFormShowParameter().getAppId();
        }
        ExportContext.get().setAppId(appId);
        String fileStorageType = ExportContext.get().getFileStorageType();
        if (para == null) {
            para = new HashMap<String, Object>(4);
        }
        if (!Boolean.parseBoolean(String.valueOf(para.get("isBizOp")))) {
            ExportContext.get().setFileStorageType("0");
        } else {
            String storageType = SystemPropertyUtils.getProptyByTenant((String)"PrintUseFileStorage", (String)RequestContext.get().getTenantId());
            if ("true".equals(storageType)) {
                ExportContext.get().setFileStorageType(FileStorageType.ATTACHMENT_FILE.getCode());
            } else {
                ExportContext.get().setFileStorageType(FileStorageType.TEMP_FILE.getCode());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            Map jsonData;
            String key = formId + "_printsetting";
            String settingData = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)key);
            if (StringUtils.isNotBlank((CharSequence)settingData) && (jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class)) != null && jsonData.get("pageSeparation") instanceof Boolean) {
                ExportContext.get().setPageSeparation(Boolean.parseBoolean(jsonData.get("pageSeparation").toString()));
            }
        }
        if ("xls".equals(printType)) {
            expSrv.setPara(para);
            expSrv.exportXls(metas, providers, null);
        } else {
            expSrv.exportPdf(metas, providers, null);
        }
        return ExportContext.get().getTaskId();
    }

    /*
     * Exception decompiling
     */
    private byte[] getFileBytesFromResult(String taskId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String createPdfUrl(LocaleString pdfName, List<PrintJob> jobs) {
        PrintJob printJob = jobs.get(0);
        String pageId = printJob.getPageId();
        String formId = null;
        String appId = null;
        if (!printJob.isSample()) {
            formId = printJob.getFormId();
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            if (view != null) {
                appId = view.getFormShowParameter().getAppId();
            }
        }
        this.changeDefaultPdfSize();
        String taskId = this.doPrint(null, "pdf", jobs, null);
        if (printJob.isSample()) {
            PrtTaskResult prtAttach = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
            List attachDetails = prtAttach.getAttach();
            return ((PrtTaskResult.Attach)attachDetails.get(0)).getFilePath();
        }
        byte[] bytes = this.getFileBytesFromResult(taskId);
        return PrintFileUtil.byteToTempUrl((String)(pdfName.getLocaleValue() + ".pdf"), (String)appId, (String)formId, (byte[])bytes);
    }

    public String createPdfUrl(LocaleString pdfName, byte[] pdfByte) {
        String downloadUrl = "";
        if (pdfByte != null && pdfByte.length > 0) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            Map cp = cache.save(pdfName.getLocaleValue() + ".pdf", pdfByte, 7200);
            distributeCache.put("PrintCheckId:" + (String)cp.get("id"), (Object)RequestContext.get().getUserId(), 7200);
            String url = String.format("tempfile/print.do?configKey=%s&id=%s", cp.get(CONFIG_KEY), cp.get("id"));
            String fullPath = RequestContext.get().getClientFullContextPath();
            if (fullPath == null) {
                fullPath = UrlService.getDomainContextUrlByTenantCode((String)RequestContext.get().getTenantCode());
            }
            downloadUrl = fullPath.endsWith("/") ? fullPath + url : fullPath + "/" + url;
        }
        return downloadUrl;
    }

    public String createXlsUrl(List<PrintJob> jobs) {
        return this.createXlsUrl(jobs, null);
    }

    public String createXlsUrl(List<PrintJob> jobs, Map<String, Object> para) {
        byte[] pdfByte = this.createCross(jobs, "xls", para);
        PrintJob firstJob = jobs.get(0);
        String formId = null;
        String appId = null;
        if (!firstJob.isSample()) {
            formId = firstJob.getFormId();
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(firstJob.getPageId());
            if (view != null) {
                appId = view.getFormShowParameter().getAppId();
            }
        }
        String downloadUrl = PrintFileUtil.byteToTempUrl((String)(firstJob.getName() + ".xlsx"), appId, (String)formId, (byte[])pdfByte);
        return downloadUrl;
    }

    public byte[] createCrossPdf(List<PrintJob> jobs) {
        return this.createCross(jobs, null);
    }

    private byte[] createCross(List<PrintJob> jobs, String printType) {
        return this.createCross(jobs, printType, null);
    }

    private byte[] createCross(List<PrintJob> jobs, String printType, Map<String, Object> para) {
        this.changeDefaultPdfSize();
        String taskId = this.doPrint(null, printType, jobs, para);
        return this.getFileBytesFromResult(taskId);
    }

    public byte[] createSinglePdf(String pageId, String formId, String templateId, Object pkId) {
        PrintMetadata meta = this.tryGetPrintMeta(templateId);
        List<Object> pks = null;
        if (!ObjectUtils.isEmpty((Object)pkId)) {
            pks = Collections.singletonList(pkId);
        }
        IPrintDataProvider dataProvider = NotePrintService.createDataProvider(pageId, formId, meta, pks);
        return this.createSinglePdf(templateId, dataProvider);
    }

    public byte[] createSinglePdf(String pageId, String formId, String templateId, Object pkId, Map<String, Object> workFlowParams) {
        PrintMetadata meta = this.tryGetPrintMeta(templateId);
        List<Object> pks = null;
        if (!ObjectUtils.isEmpty((Object)pkId)) {
            pks = Collections.singletonList(pkId);
        }
        IPrintDataProvider dataProvider = NotePrintService.createDataProvider(pageId, formId, meta, pks);
        dataProvider.setWorkFlowParams(workFlowParams);
        return this.createSinglePdf(templateId, dataProvider);
    }

    public byte[] createSinglePdf(String templateId, IPrintDataProvider dataProvider) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        PrintMetadata meta = this.tryGetPrintMeta(templateId);
        ExportService expSrv = new ExportService();
        String taskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
        ExportContext.get().setTaskId(taskId);
        this.changeDefaultPdfSize();
        expSrv.exportPdf(meta, dataProvider, (OutputStream)ps);
        return this.getFileBytesFromResult(taskId);
    }

    private void changeDefaultPdfSize() {
        String onePdfSize = SystemPropertyUtils.getProptyByTenant((String)"PRT_MAX_ONE_PDFSIZE", (String)RequestContext.get().getTenantId());
        if (StringUtils.isNumeric((CharSequence)onePdfSize)) {
            ExportContext.get().setMaxOnePdfSize(Integer.parseInt(onePdfSize));
        }
    }

    public String createPdfUrl(String pageId, String formId, String templateId, Object billPkId, Map<String, List<String>> entryFilterExp) {
        PrintMetadata meta = this.tryGetPrintMeta(templateId);
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
        String appId = view.getFormShowParameter().getAppId();
        List<Object> pks = null;
        if (!ObjectUtils.isEmpty((Object)billPkId)) {
            pks = Collections.singletonList(billPkId);
        }
        IPrintDataProvider dataProvider = NotePrintService.createDataProvider(pageId, formId, meta, pks);
        dataProvider.setFilterExps(entryFilterExp);
        byte[] pdfByte = this.createSinglePdf(templateId, dataProvider);
        return PrintFileUtil.byteToTempUrl((String)(meta.getName().getLocaleValue() + ".pdf"), (String)appId, (String)formId, (byte[])pdfByte);
    }

    public byte[] createPdfBytes(String pageId, String formId, String templateId, Object billPkId, Map<String, List<String>> entryFilterExp) {
        PrintMetadata meta = this.tryGetPrintMeta(templateId);
        List<Object> pks = null;
        if (!ObjectUtils.isEmpty((Object)billPkId)) {
            pks = Collections.singletonList(billPkId);
        }
        IPrintDataProvider dataProvider = NotePrintService.createDataProvider(pageId, formId, meta, pks);
        dataProvider.setFilterExps(entryFilterExp);
        return this.createSinglePdf(templateId, dataProvider);
    }

    public boolean createPrintJob(LocaleString pdfName, List<PrintJob> jobs) {
        boolean isSuccess = true;
        Map<Object, List<PrintJob>> groupByPrinterMap = jobs.stream().collect(Collectors.groupingBy(PrintJob::getPrinterId));
        for (Map.Entry<Object, List<PrintJob>> entry : groupByPrinterMap.entrySet()) {
            Object printerId = entry.getKey();
            List<PrintJob> printerJobs = entry.getValue();
            Map<Object, List<PrintJob>> grouByTplMap = printerJobs.stream().collect(Collectors.groupingBy(PrintJob::getTemplateId));
            for (Map.Entry<Object, List<PrintJob>> entry2 : grouByTplMap.entrySet()) {
                List<PrintJob> pjGroupByTpl = entry2.getValue();
                String taskId = OldPrintOperationHelper.doPrint(null, "pdf", pjGroupByTpl);
                PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
                List attachList = taskResult.getAttach();
                for (PrtTaskResult.Attach attachDetail : attachList) {
                    this.createPrintJob(attachDetail.getAttachId(), attachDetail.getAttachId(), attachDetail.getFilePath(), new LocaleString(attachDetail.getFileName()), printerId);
                }
            }
        }
        return isSuccess;
    }

    public boolean createPrintJob(String configKey, String cacheId, String filepath, LocaleString jobName, Object printerId) {
        return this.createPrintJob(configKey, cacheId, filepath, jobName, printerId, "pdf");
    }

    public boolean createPrintJob(String configKey, String cacheId, String filepath, LocaleString jobName, Object printerId, String printType) {
        return this.createPrintJob(configKey, cacheId, filepath, jobName, printerId, printType, new Date());
    }

    public boolean createPrintJob(String configKey, String cacheId, String filepath, LocaleString jobName, Object printerId, String printType, Date dateTime) {
        DynamicObject serviceObj;
        boolean isSuccess = false;
        if (StringUtils.isEmpty((CharSequence)configKey) && StringUtils.isEmpty((CharSequence)cacheId) && StringUtils.isEmpty((CharSequence)filepath)) {
            return isSuccess;
        }
        QFilter[] filters = new QFilter[1];
        printerId = printerId != null ? Long.valueOf(printerId.toString()) : printerId;
        filters[0] = new QFilter("id", "=", printerId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_cloudprinter", (QFilter[])filters);
        String printerAddress = "";
        if (obj != null && obj.get("printeraddress") != null) {
            printerAddress = obj.get("printeraddress").toString();
        }
        DynamicObject dynamicObject = serviceObj = null == obj ? null : (DynamicObject)obj.get("serviceid");
        if (null == serviceObj) {
            log.debug("\u521b\u5efa\u6253\u5370\u4efb\u52a1\u5931\u8d25:\u6253\u5370\u670d\u52a1\u4e3a\u7a7a");
            return isSuccess;
        }
        if (StringUtils.isNotBlank((CharSequence)printerAddress)) {
            Object serviceId = serviceObj.getPkValue();
            ORM orm = ORM.create();
            DynamicObject dynamicObject2 = orm.newDynamicObject("bos_printtask");
            dynamicObject2.set("id", (Object)orm.genLongId("bos_printtask"));
            dynamicObject2.set("name", (Object)jobName);
            dynamicObject2.set("number", (Object)UUID.randomUUID());
            dynamicObject2.set("accountid", (Object)String.valueOf(RequestContext.get().getAccountId()));
            dynamicObject2.set("serviceId", serviceId);
            dynamicObject2.set("bsdprinter", (Object)obj);
            dynamicObject2.set("printeraddress", (Object)printerAddress);
            dynamicObject2.set(CONFIGKEY, (Object)configKey);
            dynamicObject2.set("cacheid", (Object)cacheId);
            dynamicObject2.set("printstatus", (Object)Character.valueOf('1'));
            dynamicObject2.set("filepath", (Object)filepath);
            dynamicObject2.set("modifytime", (Object)dateTime);
            dynamicObject2.set("createtime", (Object)dateTime);
            dynamicObject2.set("enable", (Object)Character.valueOf('1'));
            dynamicObject2.set("printtype", (Object)printType);
            dynamicObject2.set("creator", (Object)RequestContext.get().getUserId());
            dynamicObject2.set("createtimestamp", (Object)System.currentTimeMillis());
            Object[] insertObj = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject2});
            if (!ObjectUtils.isEmpty((Object[])insertObj)) {
                isSuccess = true;
                String key = "PrintServiceId:" + serviceId;
                if (distributeCache.get(key) != "true") {
                    distributeCache.put(key, (Object)"true", 7200);
                }
            } else {
                log.debug("\u521b\u5efa\u6253\u5370\u4efb\u52a1\u5931\u8d25\u3002");
            }
        } else {
            log.debug("\u521b\u5efa\u6253\u5370\u4efb\u52a1\u5931\u8d25, \u6253\u5370\u673a\u5730\u5740\u4e3a\u7a7a\u3002");
        }
        return isSuccess;
    }

    public static IPrintDataProvider createDataProvider(String pageId, String formId, PrintMetadata printMeta, List<Object> pkids) {
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        BaseDataProvider provider = null;
        ArrayList pluginMap = new ArrayList();
        for (Plugin p : printMeta.getRootAp().getPlugins()) {
            if (!p.isEnabled()) continue;
            HashMap<String, Object> mp = new HashMap<String, Object>(1);
            mp.put("type", p.getType());
            mp.put(CLASS_NAME, p.getClassName());
            pluginMap.add(mp);
        }
        PrintServicePluginProxy proxy = null;
        Map customFields = null;
        if (!pluginMap.isEmpty()) {
            proxy = new PrintServicePluginProxy(pluginMap);
            FieldScanner fieldScanner = new FieldScanner(printMeta);
            customFields = fieldScanner.scanCustomFields();
        }
        Map dtMaps = printMeta.getDynamicObjectTypes();
        MainEntityType cloneNewType = entityType;
        try {
            cloneNewType = (MainEntityType)entityType.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error("\u3010\u6253\u5370\u3011\u514b\u9686\u5931\u8d25\uff1a" + e);
        }
        dtMaps.putAll(cloneNewType.getAllEntities());
        String modelType = formMeta.getModelType();
        if ("ReportFormModel".equalsIgnoreCase(modelType)) {
            provider = new ReportDataProvider(pageId, entityType, customFields, proxy, dtMaps);
        } else {
            provider = new QueryDataProvider(pageId, entityType, customFields, proxy, dtMaps);
            provider.setPkIds(pkids);
        }
        provider.setModelType(modelType);
        String inteValue = printMeta.getRootAp().getInteFormat();
        Long pkid = 0L;
        if (inteValue != null) {
            Map inteFormat = (Map)SerializationUtils.fromJsonString((String)inteValue, Map.class);
            pkid = Long.valueOf((String)inteFormat.get("id"));
            provider.setInteFormatId(pkid);
        } else {
            provider.setInteFormatId(pkid);
        }
        return provider;
    }

    private PrintMetadata tryGetPrintMeta(String templateId) {
        PrintMetadata meta = this.metaMap.get(templateId);
        if (null == meta) {
            meta = OldPrintTemplateUtil.findOldPrintMetadata((String)templateId);
            this.metaMap.put(templateId, meta);
        }
        return meta;
    }
}

