/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.print.dataprovider;

import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.PrintServicePluginProxy;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.lang.Lang;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.userconfig.UserConfigQuery;

public class BaseDataProvider
extends AbstractPrintDataProvider {
    private static final long serialVersionUID = 1L;
    private Long inteFormatId;
    private String pageId;
    private List<Object> pkIds;
    private String modelType;
    private MainEntityType mainEntityType;
    private DynamicObjectCollection dataEntities;
    private Map<String, Set<String>> customFieldsMap;
    private PrintServicePluginProxy pluginProxy;
    private Map<String, DynamicObjectType> customDynamicObjectTypes;
    private Map<String, Object> workFlowParams;
    private ReportQueryParam queryParam;
    private DynamicObject dataEntity;
    private Map<String, FieldControlRules> fieldControlRulesMap = new HashMap<String, FieldControlRules>(16);
    private Map<String, FieldControlRule> fieldControlRuleMap = new HashMap<String, FieldControlRule>(16);

    public Long getInteFormatId() {
        return this.inteFormatId;
    }

    public void setInteFormatId(Long inteFormatId) {
        this.inteFormatId = inteFormatId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public List<Object> getPkIds() {
        return this.pkIds;
    }

    public void setPkIds(List<Object> pk) {
        this.pkIds = pk;
    }

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String type) {
        this.modelType = type;
    }

    public MainEntityType getMainEntityType() {
        return this.mainEntityType;
    }

    public DynamicObjectCollection getDataEntities() {
        return this.dataEntities;
    }

    public void setDataEntities(DynamicObjectCollection value) {
        this.dataEntities = value;
    }

    public Map<String, Set<String>> getCustomFieldsMap() {
        return this.customFieldsMap;
    }

    public PrintServicePluginProxy getPluginProxy() {
        return this.pluginProxy;
    }

    public Map<String, DynamicObjectType> getCustomDynamicObjectTypes() {
        return this.customDynamicObjectTypes;
    }

    public BaseDataProvider() {
    }

    public BaseDataProvider(String pageId, MainEntityType mainEntityType, Map<String, Set<String>> customFieldsMap, PrintServicePluginProxy pluginProxy) {
        this(pageId, mainEntityType, customFieldsMap, pluginProxy, null);
    }

    public BaseDataProvider(String pageId, MainEntityType mainEntityType, Map<String, Set<String>> customFieldsMap, PrintServicePluginProxy pluginProxy, Map<String, DynamicObjectType> customDynamicObjectTypes) {
        this.pageId = pageId;
        this.mainEntityType = mainEntityType;
        this.customFieldsMap = customFieldsMap;
        this.pluginProxy = pluginProxy;
        this.customDynamicObjectTypes = customDynamicObjectTypes;
    }

    public List<DynamicObject> getData(R1PrintDataSource ds) throws Exception {
        return new ArrayList<DynamicObject>();
    }

    public static DynamicObjectType createEntityType(String name, Set<String> selectFields) {
        DynamicObjectType dt = new DynamicObjectType(name);
        DynamicSimpleProperty property = new DynamicSimpleProperty("Id", String.class, null);
        property.setPrimaryKey(true);
        dt.registerSimpleProperty(property);
        for (String f : selectFields) {
            property = new DynamicSimpleProperty(f.toLowerCase(), String.class, null);
            dt.registerSimpleProperty(property);
        }
        return dt;
    }

    public List<DynamicObject> convertToDynamicObject(DynamicObjectType dt, List<Map<String, String>> wfObjs) {
        ArrayList<DynamicObject> lst = new ArrayList<DynamicObject>(wfObjs.size());
        for (Map<String, String> wf : wfObjs) {
            DynamicObject dynWf = new DynamicObject(dt);
            for (Map.Entry<String, String> entry : wf.entrySet()) {
                DynamicProperty prop = dt.getProperty(entry.getKey());
                if (prop == null) continue;
                prop.setValue((Object)dynWf, (Object)entry.getValue());
            }
            lst.add(dynWf);
        }
        return lst;
    }

    public Map<String, Object> getWorkFlowParams() {
        return this.workFlowParams;
    }

    public void setWorkFlowParams(Map<String, Object> arg) {
        this.workFlowParams = arg;
    }

    public void setCustomDynamicObjectTypes(Map<String, DynamicObjectType> value) {
        this.customDynamicObjectTypes = value;
    }

    public void setCustomFieldsMap(Map<String, Set<String>> value) {
        this.customFieldsMap = value;
    }

    public void setMainEntityType(MainEntityType value) {
        this.mainEntityType = value;
    }

    public void setPlunginProxy(PrintServicePluginProxy value) {
        this.pluginProxy = value;
    }

    public void setPageId(String value) {
        this.pageId = value;
    }

    public ReportQueryParam getQueryParam() {
        return this.queryParam;
    }

    public void setQueryParam(ReportQueryParam queryParam) {
        this.queryParam = queryParam;
    }

    public DynamicObject getDataEntity() {
        return this.dataEntity;
    }

    public void setDataEntity(DynamicObject dataEntity) {
        this.dataEntity = dataEntity;
    }

    public Map<String, List<String>> getFilterExps() {
        return Collections.emptyMap();
    }

    private FieldControlRules getFieldControlRules(String formId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (this.fieldControlRulesMap.containsKey(formId)) {
            return this.fieldControlRulesMap.get(formId);
        }
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, appId, formId);
        if (fieldControlRules == null) {
            return null;
        }
        this.fieldControlRulesMap.put(formId, fieldControlRules);
        return fieldControlRules;
    }

    private FieldControlRule getFieldControlRule(String formId, long orgId) {
        FieldControlRule fieldControlRule = new FieldControlRule();
        String cacheKey = formId + "@_" + orgId;
        if (this.fieldControlRuleMap.containsKey(cacheKey)) {
            return this.fieldControlRuleMap.get(cacheKey);
        }
        FieldControlRules fieldControlRules = this.getFieldControlRules(formId);
        if (fieldControlRules == null) {
            return fieldControlRule;
        }
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        if (orgId != 0L) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                if (!Objects.equals(listField.getMainOrgId(), orgId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(orgId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        } else {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp = listField.getFieldControlRule();
                if (temp == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        }
        this.fieldControlRuleMap.put(cacheKey, fieldControlRule);
        return fieldControlRule;
    }

    public boolean isCanPrint(String formId, long orgId, String field) {
        FieldControlRule fieldControlRule = this.getFieldControlRule(formId, orgId);
        if (fieldControlRule.getCanNotReadFields().contains(field)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Lang getPrintLang(String formId) {
        String userId = RequestContext.get().getUserId();
        String key = formId + "_printsetting";
        String settingData = this.getSetting(Long.parseLong(userId), key);
        if (StringUtils.isBlank((CharSequence)settingData)) {
            return RequestContext.get().getLang();
        }
        Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        Object printLang = jsonData.get("printlang");
        if (StringUtils.isNotBlank(printLang)) {
            return Lang.from((String)((String)printLang));
        }
        return RequestContext.get().getLang();
    }

    private String getSetting(long userID, String key) {
        UserConfig userConfig = this.getUserConfigByCache(userID, key);
        return userConfig != null ? userConfig.getSetting() : "";
    }

    private UserConfig getUserConfigByCache(long userID, String key) {
        return BaseDataProvider.getUserConfig(userID, key);
    }

    private static UserConfig getUserConfig(long userID, String key) {
        UserConfigQuery userConfigQuery = new UserConfigQuery();
        return userConfigQuery.getUserConfig(key, userID);
    }
}

