/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.print.dataprovider;

import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.PrintServicePluginProxy;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.servicehelper.print.dataprovider.BaseDataProvider;

public class ListDataProvider
extends BaseDataProvider {
    private static final long serialVersionUID = 1L;

    public ListDataProvider() {
    }

    public ListDataProvider(String pageId, MainEntityType mainEntityType, Map<String, Set<String>> customFieldsMap, PrintServicePluginProxy pluginProxy) {
        super(pageId, mainEntityType, customFieldsMap, pluginProxy);
    }

    @Override
    public List<DynamicObject> getData(R1PrintDataSource dataSource) throws Exception {
        List<Object> dataEntities = new ArrayList();
        dataEntities = dataSource.getId().equals("common") ? this.getCommonData(dataSource) : this.getEntities(dataSource);
        if (this.getPluginProxy() != null) {
            Set<String> customFields = this.getCustomFieldsMap().get(dataSource.getId());
            Map<String, DynamicObjectType> customDynamicObjectTypes = this.getCustomDynamicObjectTypes();
            DynamicObjectType dynamicObjectType = null;
            if (customDynamicObjectTypes != null) {
                dynamicObjectType = customDynamicObjectTypes.get(dataSource.getId());
            }
            CustomPrintDataEntitiesArgs customArgs = new CustomPrintDataEntitiesArgs((Object)this, this.getPageId(), null, dataSource.getId(), customFields, null, false, dynamicObjectType);
            customArgs.setPkIds(this.getPkIds());
            customArgs.setDataEntities(dataEntities);
            this.getPluginProxy().fireCustomPrintDataEntities(customArgs);
            if (customArgs.getDataEntities() != null && customArgs.getDataEntities().isEmpty()) {
                dataEntities = customArgs.getDataEntities();
            }
        }
        return dataEntities;
    }

    private List<DynamicObject> getEntities(R1PrintDataSource dataSource) {
        List<Object> dataEntities = new ArrayList<DynamicObject>();
        if (this.getDataEntities() != null && !this.getDataEntities().isEmpty()) {
            dataEntities = this.getDataEntities().stream().collect(Collectors.toList());
        }
        return dataEntities;
    }

    private List<DynamicObject> getCommonData(R1PrintDataSource dataSource) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        DynamicObjectType dataEntityType = new DynamicObjectType("common");
        DynamicSimpleProperty idProp = new DynamicSimpleProperty("id", Integer.class, (Object)"1");
        dataEntityType.registerSimpleProperty(idProp);
        DynamicSimpleProperty numberProp = new DynamicSimpleProperty("number", String.class, (Object)"number");
        dataEntityType.registerSimpleProperty(numberProp);
        DynamicObject newObject = new DynamicObject(dataEntityType);
        newObject.set((IDataEntityProperty)idProp, (Object)1);
        newObject.set((IDataEntityProperty)numberProp, (Object)"fake");
        result.add(newObject);
        return result;
    }
}

