/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.print.dataprovider;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.plugin.PrintServicePluginProxy;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.list.query.Mapper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.print.dataprovider.BaseDataProvider;
import org.apache.commons.lang.StringUtils;

public class MultiEntityQueryDataProvider
extends BaseDataProvider {
    private static final long serialVersionUID = 1L;

    public MultiEntityQueryDataProvider() {
    }

    public MultiEntityQueryDataProvider(String pageId, MainEntityType mainEntityType, Map<String, Set<String>> customFieldsMap, PrintServicePluginProxy pluginProxy) {
        super(pageId, mainEntityType, customFieldsMap, pluginProxy);
    }

    public MultiEntityQueryDataProvider(String pageId, MainEntityType mainEntityType, Map<String, Set<String>> customFieldsMap, PrintServicePluginProxy pluginProxy, Map<String, DynamicObjectType> customDynamicObjectTypes) {
        super(pageId, mainEntityType, customFieldsMap, pluginProxy, customDynamicObjectTypes);
    }

    @Override
    public List<DynamicObject> getData(R1PrintDataSource dataSource) throws Exception {
        List<Object> dataEntities = new ArrayList<DynamicObject>();
        if (this.getPkIds() != null && !this.getPkIds().isEmpty()) {
            String entityName = this.getMainEntityType().getName();
            if (entityName.equals(dataSource.getId())) {
                dataEntities = this.getQueryEntityObjs(dataSource);
            } else if ("7".equals(dataSource.getDsType())) {
                dataEntities = this.getRelateEntityObjs(dataSource);
            } else if ("9".equals(dataSource.getDsType())) {
                dataEntities = this.getRefImportEntityObjs(dataSource);
            }
        }
        if (this.getPluginProxy() != null) {
            Set<String> customFields = this.getCustomFieldsMap().get(dataSource.getId());
            Map<String, DynamicObjectType> customDynamicObjectTypes = this.getCustomDynamicObjectTypes();
            DynamicObjectType dynamicObjectType = null;
            if (customDynamicObjectTypes != null) {
                dynamicObjectType = customDynamicObjectTypes.get(dataSource.getId());
            }
            CustomPrintDataEntitiesArgs customArgs = new CustomPrintDataEntitiesArgs((Object)this, this.getPageId(), null, dataSource.getId(), customFields, null, false, dynamicObjectType);
            customArgs.setPkIds(this.getPkIds());
            customArgs.setDataEntities(dataEntities);
            this.getPluginProxy().fireCustomPrintDataEntities(customArgs);
            if (customArgs.getDataEntities() != null && !customArgs.getDataEntities().isEmpty()) {
                dataEntities = customArgs.getDataEntities();
            }
        }
        return dataEntities;
    }

    public List<DynamicObject> getQueryEntityObjs(R1PrintDataSource dataSource) {
        QFilter filter;
        ArrayList<DynamicObject> results = new ArrayList();
        QueryEntityType queryEntity = (QueryEntityType)this.getMainEntityType();
        QueryBuilder qBuilder = new QueryBuilder();
        QFilter[] filters = new QFilter[1];
        int bdType = queryEntity.getPrimaryKey().getDbType();
        Number fkValue = null;
        if (bdType == -5) {
            Long bigValue;
            fkValue = bigValue = Long.valueOf((String)this.getPkIds().get(0));
        } else if (bdType == 4) {
            fkValue = Integer.valueOf((String)this.getPkIds().get(0));
        }
        filters[0] = filter = new QFilter(queryEntity.getPrimaryKey().getName(), "=", (Object)fkValue);
        qBuilder.setFilters(filters);
        qBuilder.setEntityName(queryEntity.getEditEntityName());
        HashSet<String> newUsedField = new HashSet<String>(dataSource.getUsedFields().size());
        newUsedField.add(queryEntity.getPrimaryKey().getName());
        for (String uf : dataSource.getUsedFields()) {
            newUsedField.add(uf);
        }
        String selectFields = String.join((CharSequence)",", newUsedField);
        Set unionFilterFields = dataSource.getUnionFields();
        if (unionFilterFields != null) {
            String unionSelectFields;
            unionFilterFields.addAll(newUsedField);
            selectFields = unionSelectFields = unionFilterFields.stream().collect(Collectors.joining(","));
        }
        ORM orm = ORM.create();
        orm.setDataEntityType(queryEntity.getEditEntityName(), (IDataEntityType)queryEntity);
        DynamicObjectCollection queryDatas = orm.query(queryEntity.getEditEntityName(), selectFields, filters);
        results = queryDatas.stream().collect(Collectors.toList());
        return results;
    }

    public List<DynamicObject> getRelateEntityObjs(R1PrintDataSource dataSource) {
        QFilter filter;
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>();
        QueryEntityType queryEntity = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)dataSource.getQueryEntityId());
        QueryBuilder qBuilder = new QueryBuilder();
        QFilter[] filters = new QFilter[1];
        R1PrintDataParameter parms = dataSource.getAssociateParameter();
        int bdType = queryEntity.getPrimaryKey().getDbType();
        Object fkValue = "";
        if (bdType == -5) {
            Long bigValue = Long.valueOf(parms.getValue().toString());
            fkValue = bigValue;
        } else {
            fkValue = bdType == 4 ? Integer.valueOf(parms.getValue().toString()) : parms.getValue().toString();
        }
        filters[0] = filter = new QFilter(parms.getAssociateField(), "=", fkValue);
        qBuilder.setFilters(filters);
        qBuilder.setEntityType((IDataEntityType)queryEntity);
        HashSet<String> newUsedField = new HashSet<String>();
        newUsedField.add(queryEntity.getPrimaryKey().getName());
        for (String uf : dataSource.getUsedFields()) {
            if (!uf.contains(".")) continue;
            newUsedField.add(StringUtils.substringAfter((String)uf, (String)"."));
        }
        String selectFields = String.join((CharSequence)",", newUsedField);
        qBuilder.setSelectFields(selectFields);
        DynamicObjectType dt = MultiEntityQueryDataProvider.createEntityType("queryet", newUsedField);
        try (DataSet ds = this.queryData(qBuilder);){
            RowMeta rowMeta = ds.getRowMeta();
            int n = rowMeta.getFieldCount();
            ArrayList<Mapper> mappers = new ArrayList<Mapper>(n);
            for (int i = 0; i < n; ++i) {
                DynamicProperty property = dt.getProperty(rowMeta.getField(i).getName());
                if (property == null) continue;
                Mapper mapper = new Mapper();
                mapper.index = i;
                mapper.property = property;
                mappers.add(mapper);
            }
            for (Row row : ds) {
                DynamicObject obj = new DynamicObject(dt);
                for (Mapper mp : mappers) {
                    mp.property.setValueFast((Object)obj, row.get(mp.index));
                }
                results.add(obj);
            }
        }
        return results;
    }

    public DataSet queryData(QueryBuilder queryBuilder) {
        QueryEntityType qet = (QueryEntityType)queryBuilder.getEntityType();
        List filters = qet.getQFilter();
        for (QFilter qFilter : queryBuilder.getFilters()) {
            filters.add(qFilter);
        }
        ORM orm = ORM.create();
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), qet.getName(), queryBuilder.getSelectFields(), filters.toArray(new QFilter[0]), queryBuilder.getOrderBys());
    }

    private List<DynamicObject> getRefImportEntityObjs(R1PrintDataSource dataSource) {
        Object bigValue;
        int bdType;
        String dataSourceId = dataSource.getId();
        if (dataSource.getId().contains(":")) {
            dataSourceId = StringUtils.substringBefore((String)dataSource.getId(), (String)":");
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dataSourceId);
        R1PrintDataParameter parms = dataSource.getAssociateParameter();
        Object fkValue = parms.getAssociateField().equals("id") ? ((bdType = entityType.getPrimaryKey().getDbType()) == -5 ? (bigValue = Long.valueOf(parms.getValue().toString())) : (bdType == 4 ? Integer.valueOf(parms.getValue().toString()) : parms.getValue().toString())) : parms.getValue();
        if (fkValue instanceof Variant) {
            if ((fkValue = ((Variant)fkValue).getValue()) instanceof DynamicObject) {
                fkValue = ((DynamicObject)fkValue).getPkValue();
            }
        } else {
            fkValue = fkValue.toString();
        }
        HashSet<String> newUsedFields = new HashSet<String>();
        for (String uf : dataSource.getUsedFields()) {
            if (!uf.contains(".")) continue;
            newUsedFields.add(StringUtils.substringAfter((String)uf, (String)"."));
        }
        String selectFields = String.join((CharSequence)",", newUsedFields);
        String associateField = parms.getAssociateField();
        if (associateField.contains("&")) {
            associateField = StringUtils.substringAfter((String)associateField, (String)"&");
        }
        ORM orm = ORM.create();
        FilterCondition filterCondition = dataSource.getFilterCondition();
        QFilter[] filters = new QFilter[2];
        filters[0] = new QFilter(associateField, "in", fkValue);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition, true);
        filterBuilder.buildFilter(true);
        filters[1] = filterBuilder.getQFilter();
        return orm.query(entityType.getName(), selectFields, filters);
    }
}

