/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.print.dataprovider;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.plugin.PrintServicePluginProxy;
import kd.bos.entity.plugin.args.BeforeLoadDataArgs;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.PrintCountProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.list.query.Mapper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.print.typeparse.AbstractTypeParser;
import kd.bos.print.typeparse.TypeParserFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.print.dataprovider.BaseDataProvider;
import kd.bos.servicehelper.print.dataprovider.QueryDataProviderHelper;
import kd.bos.servicehelper.print.dataprovider.WorkflowParser;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.workflow.api.IWorkflowService;

public class QueryDataProvider
extends BaseDataProvider {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(QueryDataProvider.class);
    private Map<String, List<AbstractTypeParser>> parserMap = new HashMap<String, List<AbstractTypeParser>>(16);
    private QueryDataProviderHelper queryDataProviderHelper = QueryDataProviderHelper.getInstance();

    public QueryDataProvider() {
    }

    public QueryDataProvider(String pageId, MainEntityType mainEntityType, Map<String, Set<String>> customFieldsMap, PrintServicePluginProxy pluginProxy) {
        super(pageId, mainEntityType, customFieldsMap, pluginProxy);
    }

    public QueryDataProvider(String pageId, MainEntityType mainEntityType, Map<String, Set<String>> customFieldsMap, PrintServicePluginProxy pluginProxy, Map<String, DynamicObjectType> customDynamicObjectTypes) {
        super(pageId, mainEntityType, customFieldsMap, pluginProxy, customDynamicObjectTypes);
    }

    @Override
    public List<DynamicObject> getData(R1PrintDataSource dataSource) throws Exception {
        List<Object> dataEntities = new ArrayList<DynamicObject>();
        boolean isCancelLoadData = false;
        if (this.getPluginProxy() != null) {
            BeforeLoadDataArgs bargs = new BeforeLoadDataArgs((Object)false, dataSource.getId());
            this.getPluginProxy().fireBeforeLoadData(bargs);
            isCancelLoadData = bargs.isCancel();
        }
        if (!isCancelLoadData) {
            if (dataSource.getId().equals("workflow.approveline")) {
                if (this.getMainEntityType() != null) {
                    dataSource.setQueryEntityId(this.getMainEntityType().getName());
                }
                dataEntities = this.getApproveLineObjs(dataSource);
            } else if (dataSource.getId().equals("attachpanel")) {
                dataEntities = this.getAttachPanelObjs(dataSource);
            } else if (dataSource.getId().equals("workflow.activity")) {
                dataEntities = this.getWorkflowActivityObjs(dataSource);
            } else if ("7".equals(dataSource.getDsType())) {
                dataEntities = this.getQueryEntityObjs(dataSource);
            } else if ("9".equals(dataSource.getDsType())) {
                dataEntities = this.getRefEntityObjs(dataSource);
            } else if (this.getPkIds() != null && !this.getPkIds().isEmpty() && StringUtils.isNotEmpty((CharSequence)this.getMainEntityType().getAlias())) {
                if (this.getMainEntityType().getName().equals(dataSource.getId())) {
                    if (this.getMainEntityType() instanceof QueryEntityType) {
                        try {
                            dataEntities = this.getMainEntityObjs(dataSource);
                        }
                        catch (Exception e) {
                            log.warn("\u67e5\u8be2\u5b9e\u4f53\u52a0\u8f7d\u6570\u636e\u5f02\u5e38", (Throwable)e);
                        }
                    } else {
                        dataEntities = this.getMainEntityObjs(dataSource);
                    }
                } else {
                    IDataEntityProperty prop = this.getMainEntityType().findProperty(dataSource.getId());
                    if (prop != null) {
                        dataEntities = prop instanceof SubEntryProp ? this.getSubEntityObjs(dataSource, (SubEntryProp)prop) : this.getEntityObjs(dataSource, (EntryProp)prop);
                    }
                }
            }
        }
        if (this.getPluginProxy() != null) {
            boolean isMainDs = false;
            if ("1".equals(dataSource.getDsType())) {
                isMainDs = true;
            }
            QFilter filter = null;
            R1PrintDataParameter parms = dataSource.getAssociateParameter();
            if (parms != null) {
                String fkValue = parms.getValue() == null ? null : parms.getValue().toString();
                filter = new QFilter(parms.getAssociateField(), "=", (Object)fkValue);
            }
            Set<String> customFields = this.getCustomFieldsMap().get(dataSource.getId());
            Map<String, DynamicObjectType> customDynamicObjectTypes = this.getCustomDynamicObjectTypes();
            DynamicObjectType dynamicObjectType = null;
            if (customDynamicObjectTypes != null) {
                dynamicObjectType = customDynamicObjectTypes.get(dataSource.getId());
            }
            CustomPrintDataEntitiesArgs customArgs = null;
            Object pkId = null;
            if (this.getPkIds() != null && !this.getPkIds().isEmpty()) {
                pkId = this.getPkIds().get(0);
            }
            customArgs = new CustomPrintDataEntitiesArgs((Object)this, this.getPageId(), pkId, dataSource.getId(), customFields, filter, isMainDs, dynamicObjectType);
            customArgs.setPkIds(this.getPkIds());
            customArgs.setDataEntities(dataEntities);
            this.getPluginProxy().setContext(this.getMainEntityType());
            this.getPluginProxy().fireCustomPrintDataEntities(customArgs);
            dataEntities = customArgs.getDataEntities();
        }
        return dataEntities;
    }

    private List<DynamicObject> getRefEntityObjs(R1PrintDataSource dataSource) throws Exception {
        FilterCondition filterCondition;
        String versionControl;
        Object fkValue;
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        String dataSourceId = dataSource.getId();
        if (dataSource.getId().contains(":")) {
            dataSourceId = StringUtils.substringBefore((String)dataSource.getId(), (String)":");
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dataSourceId);
        R1PrintDataParameter parms = dataSource.getAssociateParameter();
        if (parms.getAssociateField().equals("id")) {
            int bdType = entityType.getPrimaryKey().getDbType();
            if (bdType == -5) {
                Long bigValue = Long.valueOf(parms.getValue().toString());
                fkValue = bigValue;
            } else {
                fkValue = bdType == 4 ? Integer.valueOf(parms.getValue().toString()) : parms.getValue().toString();
            }
        } else {
            fkValue = parms.getValue();
        }
        if (fkValue instanceof Variant) {
            if ((fkValue = ((Variant)fkValue).getRealValue()) instanceof DynamicObject) {
                fkValue = ((DynamicObject)fkValue).getPkValue();
            }
        } else if (fkValue != null) {
            fkValue = fkValue.toString();
        }
        HashMap<String, IDataEntityProperty> propertyMap = this.queryDataProviderHelper.getAllProperties((DynamicObjectType)entityType);
        HashSet<String> newUsedFields = new HashSet<String>();
        HashSet<String> queryFieldSet = new HashSet<String>();
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>();
        for (String uf : dataSource.getUsedFields()) {
            if (!uf.contains(".")) continue;
            String str = StringUtils.substringAfter((String)uf, (String)".");
            newUsedFields.add(str);
            if (!propertyMap.containsKey(str) && str.contains(".") && !propertyMap.containsKey(str = str.substring(0, str.lastIndexOf("."))) && str.contains(".")) {
                str = str.substring(0, str.lastIndexOf(".") + 1);
            }
            if (propertyMap.containsKey(str)) {
                queryFieldSet.add(str);
                IDataEntityProperty property = propertyMap.get(str);
                if (property instanceof DecimalProp && !(property instanceof PrintCountProp)) {
                    DecimalProp decimalProp = (DecimalProp)property;
                    FmtField fmtField = new FmtField(property, property.getName(), decimalProp.getControlPropName());
                    fmtFields.add(fmtField);
                    if (StringUtils.isNotBlank((CharSequence)decimalProp.getControlPropName())) {
                        queryFieldSet.add(decimalProp.getControlPropName());
                    }
                }
                if (property instanceof ItemClassProp) {
                    ItemClassProp itemClassProp = (ItemClassProp)property;
                    String typePropName = itemClassProp.getTypePropName();
                    if (property.getParent() != null) {
                        typePropName = property.getParent().getName() + "." + typePropName;
                    }
                    queryFieldSet.add(typePropName);
                }
            }
            if (!uf.contains(".seq") || !propertyMap.containsKey(uf)) continue;
            queryFieldSet.add(uf);
        }
        String associateField = parms.getAssociateField();
        if (associateField.contains("&")) {
            associateField = StringUtils.substringAfter((String)associateField, (String)"&");
        }
        DynamicProperty associate = entityType.getProperty(associateField);
        try {
            if (associate instanceof FieldProp) {
                int dbType = ((FieldProp)associate).getDbType();
                if (dbType == -5) {
                    Long bigValue = Long.valueOf(fkValue.toString());
                    fkValue = bigValue;
                } else {
                    fkValue = dbType == 4 ? Integer.valueOf(fkValue.toString()) : (dbType == 3 ? new BigDecimal(fkValue.toString()) : fkValue.toString());
                }
            }
        }
        catch (Exception e) {
            fkValue = null;
            log.error(e.getMessage());
        }
        if (fkValue == null) {
            return new ArrayList<DynamicObject>();
        }
        String mainOrg = entityType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrg)) {
            queryFieldSet.add(mainOrg);
            String key = mainOrg + ".id";
            if (newUsedFields.add(key)) {
                newUsedFields.add(mainOrg);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(versionControl = AclAdapter.getBasedataVersionService().getVersionControl(entityType)))) {
            queryFieldSet.add(versionControl);
        }
        if ((filterCondition = dataSource.getFilterCondition()) != null) {
            QFilter[] filters = new QFilter[2];
            filters[0] = new QFilter(associateField, "in", fkValue);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition, true);
            filterBuilder.buildFilter(true);
            filters[1] = filterBuilder.getQFilter();
            String queryFields = String.join((CharSequence)",", queryFieldSet);
            Map dataMap = BusinessDataServiceHelper.loadFromCache((String)entityType.getName(), (String)queryFields, (QFilter[])filters);
            Lang printLang = this.getPrintLang(this.getMainEntityType().getName());
            for (DynamicObject dynamicObject : dataMap.values()) {
                List<DynamicObject> list = this.queryDataProviderHelper.toListDynamicObject(dynamicObject);
                DynamicObjectCollection collection = new DynamicObjectCollection((DynamicObjectType)list.get(0).getDynamicObjectType().clone(), null);
                collection.addAll(list);
                NumberFormatProvider numberFormatProvider = new NumberFormatProvider(fmtFields, collection, dynamicObject);
                list = this.queryDataProviderHelper.buildRefEntityResult(list, newUsedFields, printLang, numberFormatProvider);
                this.parseSpecialField(queryFieldSet, list, entityType);
                result.addAll(list);
            }
        }
        return result;
    }

    private List<DynamicObject> getMainEntityObjs(R1PrintDataSource dataSource) throws R1PrintDataException {
        DynamicObjectCollection col;
        String versionControl;
        ORM orm = ORM.create();
        Lang printLang = this.getPrintLang(this.getMainEntityType().getName());
        orm.hint().setLang(printLang);
        DynamicObjectCollection objs = new ArrayList();
        Set tempField = dataSource.getUsedFields();
        tempField.addAll(dataSource.getUnionFields());
        Set<String> filterFields = this.extendFilterFields(tempField);
        String mainOrg = this.getMainEntityType().getMainOrg();
        if (StringUtils.isNotEmpty((CharSequence)mainOrg) && !filterFields.contains(mainOrg)) {
            filterFields.add(this.getMainEntityType().getMainOrg());
        }
        if (StringUtils.isNotBlank((CharSequence)(versionControl = AclAdapter.getBasedataVersionService().getVersionControl(this.getMainEntityType())))) {
            filterFields.add(versionControl);
        }
        if (this.getPkIds() != null && !this.getPkIds().isEmpty()) {
            QFilter[] filters = new QFilter("id", "in", this.getPkIds()).toArray();
            filterFields.add("id");
            String selectFields = filterFields.stream().collect(Collectors.joining(","));
            objs = orm.query(this.getMainEntityType().getName(), selectFields, filters);
        } else {
            String selectFields = filterFields.stream().collect(Collectors.joining(","));
            DynamicObject oneObject = orm.queryOne(this.getMainEntityType().getName(), selectFields, null);
            objs.add(oneObject);
        }
        try {
            final List<Object> idList = this.getPkIds();
            Collections.sort(objs, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    int s2index;
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    int s1index = idList.indexOf(o1.getPkValue());
                    return s1index > (s2index = idList.indexOf(o2.getPkValue())) ? 1 : -1;
                }
            });
        }
        catch (Exception ex) {
            log.error("\u5217\u8868\u6253\u5370\u6392\u5e8f\u9519\u8bef\uff1a" + ex);
        }
        try {
            col = new DynamicObjectCollection((DynamicObjectType)this.getMainEntityType().clone(), null);
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
        col.addAll((Collection)objs);
        this.parseSpecialField(dataSource.getUsedFields(), (List<DynamicObject>)col, this.getMainEntityType());
        Object results = col;
        if (!col.isEmpty()) {
            List<FmtField> fmtFields = this.getFmtFields(col.getDynamicObjectType(), filterFields);
            try {
                results = this.rebuildFormatedObjects((DynamicObject)col.get(0), (DynamicObject)col.get(0), col, (DynamicObjectType)col.getDynamicObjectType().clone(), fmtFields);
            }
            catch (CloneNotSupportedException e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[0]);
            }
            this.setDataEntities(col);
        }
        return results;
    }

    private List<DynamicObject> getEntityObjs(R1PrintDataSource dataSource, EntryProp entryProp) throws SyntaxErrorException {
        String versionControl;
        Object fkValue;
        List<DynamicObject> results = new ArrayList<DynamicObject>();
        if (dataSource.getUsedFields().size() == 2) {
            return results;
        }
        R1PrintDataParameter parms = dataSource.getAssociateParameter();
        if (parms.getValue() == null) {
            log.error("\u6253\u5370\uff1a\u67e5\u8be2\u5355\u636e\u4f53\u65f6\u4f20\u5165\u53c2\u6570\u4e3anull\uff0c\u76f4\u63a5\u8fd4\u56de\u7a7a\u6570\u636e\u5305");
            return results;
        }
        int bdType = this.getMainEntityType().getPrimaryKey().getDbType();
        if (bdType == -5) {
            Long bigValue = Long.valueOf(parms.getValue().toString());
            fkValue = bigValue;
        } else {
            fkValue = bdType == 4 ? Integer.valueOf(parms.getValue().toString()) : parms.getValue().toString();
        }
        EntityType curEntryType = (EntityType)this.getMainEntityType().getAllEntities().get(dataSource.getId());
        ArrayList<String> orderBys = new ArrayList<String>();
        Set<String> filterFields = this.extendFilterFields(dataSource.getUsedFields(), entryProp);
        R1PrintDataSortItem[] sortItems = dataSource.getSortFields();
        for (int i = 0; i < sortItems.length; ++i) {
            R1PrintDataSortItem item = sortItems[i];
            if (!StringUtils.isNotBlank((CharSequence)item.getSortField())) continue;
            String seqFullName = dataSource.getId() + ".seq";
            String sortFld = item.getSortField().equalsIgnoreCase(seqFullName) ? item.getSortField() : dataSource.getId() + "." + item.getSortField();
            String sortType = item.getSortType() == 0 ? "asc" : "desc";
            String by = sortFld + " " + sortType;
            orderBys.add(by);
            filterFields.add(sortFld);
        }
        DynamicProperty seqProp = curEntryType.getProperty("seq");
        String bySeq = "";
        if (seqProp != null) {
            String orderStr = dataSource.getId() + ".seq";
            bySeq = orderStr + " asc";
            filterFields.add(orderStr);
        }
        String orderByStr = bySeq;
        if (!orderBys.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)bySeq)) {
                orderBys.add(bySeq);
            }
            orderByStr = StringUtils.join((Object[])orderBys.toArray(), (String)",");
        }
        if (StringUtils.isNotBlank((CharSequence)(versionControl = AclAdapter.getBasedataVersionService().getVersionControl(this.getMainEntityType())))) {
            filterFields.add(versionControl);
        }
        ORM orm = ORM.create();
        Lang printLang = this.getPrintLang(this.getMainEntityType().getName());
        orm.hint().setLang(printLang);
        QFilter filter = new QFilter(parms.getAssociateField(), "=", fkValue);
        String selectFields = filterFields.stream().collect(Collectors.joining(","));
        String mainOrg = this.getMainEntityType().getMainOrg();
        if (StringUtils.isNotEmpty((CharSequence)mainOrg) && !filterFields.contains(mainOrg)) {
            selectFields = selectFields + "," + this.getMainEntityType().getMainOrg();
        }
        QFilter[] filters = null;
        QFilter[] customFilters = this.getCustomFilters(dataSource.getId());
        if (customFilters != null && customFilters.length > 0) {
            QFilter[] arr1 = new QFilter[]{filter};
            filters = (QFilter[])Stream.concat(Arrays.stream(arr1), Arrays.stream(customFilters)).toArray(QFilter[]::new);
        } else {
            filters = new QFilter[]{filter};
        }
        DynamicObjectCollection objs = orm.query(this.getMainEntityType().getName(), selectFields, filters, orderByStr);
        this.parseSpecialField(dataSource.getUsedFields(), (List<DynamicObject>)objs, this.getMainEntityType());
        if (objs != null && !objs.isEmpty()) {
            DynamicObjectCollection entryObjs = ((DynamicObject)objs.get(0)).getDynamicObjectCollection(dataSource.getId());
            List<FmtField> fmtFields = this.getFmtFields(entryObjs.getDynamicObjectType(), filterFields);
            try {
                results = this.rebuildFormatedObjects((DynamicObject)objs.get(0), (DynamicObject)objs.get(0), entryObjs, (DynamicObjectType)entryObjs.getDynamicObjectType().clone(), fmtFields);
            }
            catch (CloneNotSupportedException e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[0]);
            }
            this.setDataEntities(entryObjs);
            this.setDataEntity((DynamicObject)objs.get(0));
        }
        return results;
    }

    private QFilter[] getCustomFilters(String dsName) {
        List<String> filterExps;
        QFilter[] qFilters = null;
        if (this.getFilterExps() != null && (filterExps = this.getFilterExps().get(dsName)) != null && filterExps.size() > 0) {
            List<QFilter> customFilters = filterExps.stream().map(str -> QFilter.of((String)str, (Object[])new Object[0])).collect(Collectors.toList());
            qFilters = customFilters.toArray(new QFilter[customFilters.size()]);
        }
        return qFilters;
    }

    private List<DynamicObject> getApproveLineObjs(R1PrintDataSource dataSource) {
        List<DynamicObject> results = new ArrayList<DynamicObject>();
        R1PrintDataParameter parms = dataSource.getAssociateParameter();
        if (parms != null && parms.getValue() != null) {
            List<Map<String, String>> lstWfData = new ArrayList<Map<String, String>>();
            if (parms != null && parms.getValue() != null) {
                String type = "all";
                String orderType = "default";
                boolean includeSubmit = false;
                boolean includeImage = true;
                Map<String, Object> wfParams = this.getWorkFlowParams();
                if (wfParams != null && !wfParams.isEmpty()) {
                    Object value;
                    Object temp;
                    if (StringUtils.isNotBlank((Object)wfParams.get("approveline"))) {
                        type = wfParams.get("approveline").toString();
                    }
                    if (StringUtils.isNotBlank((Object)wfParams.get("ordertype"))) {
                        orderType = wfParams.get("ordertype").toString();
                    }
                    if ((temp = wfParams.get("includesubmit")) != null) {
                        includeSubmit = Boolean.parseBoolean(String.valueOf(temp));
                    }
                    if ((value = wfParams.get("includeimage")) != null) {
                        includeImage = Boolean.parseBoolean(String.valueOf(value));
                    }
                }
                try {
                    HashMap<String, Object> printParam = new HashMap<String, Object>(3);
                    printParam.put("order", orderType);
                    printParam.put("includeUserTask", includeSubmit);
                    printParam.put("includeSSCImageUpload", includeImage);
                    String entityNumber = dataSource.getQueryEntityId();
                    if (StringUtils.isBlank((CharSequence)entityNumber)) {
                        entityNumber = dataSource.getReference();
                    }
                    printParam.put("entityNumber", entityNumber);
                    lstWfData = (List)this.getWFService().getPrintCommentWithParam(parms.getValue().toString(), type, printParam);
                    StringBuilder requestParams = new StringBuilder();
                    requestParams.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\uff1a\u3010businessKey:", (String)"QueryDataProvider_0", (String)"bos-noteprint", (Object[])new Object[0])).append(parms.getValue().toString()).append(",type:").append(type).append(",printParam:").append(JSON.toJSONString(printParam)).append("\u3011");
                    StringBuilder logMsg = new StringBuilder();
                    logMsg = lstWfData != null ? logMsg.append(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba1\u6279\u8def\u7ebf\u6570\u636e\uff1a", (String)"QueryDataProvider_1", (String)"bos-noteprint", (Object[])new Object[0])).append(requestParams.toString()).append(JSON.toJSONString(lstWfData)) : logMsg.append(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba1\u6279\u8def\u7ebf\u6570\u636e\uff1a", (String)"QueryDataProvider_1", (String)"bos-noteprint", (Object[])new Object[0])).append(requestParams.toString()).append(ResManager.loadKDString((String)"---\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"QueryDataProvider_2", (String)"bos-noteprint", (Object[])new Object[0]));
                    log.info(logMsg.toString());
                }
                catch (Exception e) {
                    StringBuilder errorLogMsg = new StringBuilder();
                    errorLogMsg = errorLogMsg.append(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5ba1\u6279\u7ebf\u8def\u6570\u636e\uff0c businessKey\uff1a", (String)"QueryDataProvider_3", (String)"bos-noteprint", (Object[])new Object[0])).append(e.getCause()).append(Arrays.toString(e.getStackTrace()));
                    log.error(errorLogMsg.toString());
                }
            }
            if (lstWfData != null && !lstWfData.isEmpty()) {
                IWorkflowService workflowService = this.getWFService();
                Map aproveLine = workflowService.getApprovalRecordMeta();
                if (aproveLine != null && aproveLine.size() > 0) {
                    DynamicObjectType dt = WorkflowParser.createEntityType("ApproveLine", aproveLine.keySet());
                    results = WorkflowParser.convertToDynamicObject(dt, lstWfData);
                }
            } else {
                log.debug(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5ba1\u6279\u7ebf\u8def\u6570\u636e\uff0c businessKey\uff1a", (String)"QueryDataProvider_3", (String)"bos-noteprint", (Object[])new Object[0]) + parms.getValue().toString());
            }
        } else {
            log.debug(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5ba1\u6279\u7ebf\u8def\u6570\u636e\uff0c parms\u4e3a\u7a7a\u3002", (String)"QueryDataProvider_4", (String)"bos-noteprint", (Object[])new Object[0]));
        }
        return results;
    }

    private List<DynamicObject> getAttachPanelObjs(R1PrintDataSource dataSource) {
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>();
        R1PrintDataParameter parms = dataSource.getAssociateParameter();
        Object pkIdObj = parms.getValue();
        if (pkIdObj == null) {
            return results;
        }
        String pkId = pkIdObj.toString();
        String formKey = parms.getAssociateSource();
        Set usedFields = dataSource.getUsedFields();
        String prefix = "attachpanel.";
        HashSet<String> attachKeys = new HashSet<String>(16);
        for (String usefield : usedFields) {
            String attachKey = usefield.replace(prefix, "");
            if ("id".equals(attachKey)) continue;
            attachKeys.add(attachKey);
        }
        if (attachKeys.isEmpty()) {
            return results;
        }
        QFilter[] filters = new QFilter[]{new QFilter("FBillType", "=", (Object)formKey), new QFilter("FInterID", "=", (Object)pkId), new QFilter("fattachmentpanel", "in", attachKeys)};
        HashMap dataMap = new HashMap(16);
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("getAttachPanelObjs", "bos_attachment", "fattachmentpanel,fattachmentname,fextname,ffileid", filters);){
            for (Row row : ds) {
                String attachName = row.getString("fattachmentname");
                String attachPanel = row.getString("fattachmentpanel");
                if (!dataMap.containsKey(attachPanel)) {
                    dataMap.put(attachPanel, new ArrayList());
                }
                ((List)dataMap.get(attachPanel)).add(attachName);
            }
        }
        DynamicObjectType dt = new DynamicObjectType("PlainObject");
        DynamicObject dynamicObject = new DynamicObject(dt);
        for (String attachKey : attachKeys) {
            TextProp prop = new TextProp();
            prop.setName(attachKey);
            dt.registerSimpleProperty((DynamicSimpleProperty)prop);
            if (dataMap.containsKey(attachKey)) {
                String attachName = StringUtils.join((Object[])((List)dataMap.get(attachKey)).toArray(), (String)"\n");
                prop.setValue((Object)dynamicObject, (Object)attachName);
                continue;
            }
            prop.setValue((Object)dynamicObject, (Object)"");
        }
        results.add(dynamicObject);
        return results;
    }

    private List<DynamicObject> getWorkflowActivityObjs(R1PrintDataSource dataSource) {
        List<DynamicObject> results = new ArrayList<DynamicObject>();
        R1PrintDataParameter parms = dataSource.getAssociateParameter();
        if (parms != null && parms.getValue() != null) {
            Collection lstWfData = null;
            if (parms != null && parms.getValue() != null) {
                try {
                    String type = "lastedConsent";
                    Map<String, Object> wfParams = this.getWorkFlowParams();
                    if (wfParams != null && !wfParams.isEmpty() && StringUtils.isNotBlank((Object)wfParams.get("singleactivity"))) {
                        type = wfParams.get("singleactivity").toString();
                    }
                    log.debug("\u6253\u5370\uff1a\u8c03\u7528\u5de5\u4f5c\u6d41\u63a5\u53e3\u83b7\u53d6\u8282\u70b9\u6570\u636e--type = " + type + "businesskey =" + parms.getValue());
                    lstWfData = this.getWFService().getCommentForPrintByType(parms.getValue().toString(), type);
                }
                catch (Exception e) {
                    log.error("\u6253\u5370\uff1a\u6309\u5ba1\u6279\u8282\u70b9\u6253\u5370\u62a5\u9519, businessKey:" + parms.getValue().toString() + ",error:" + e.getMessage());
                }
            }
            if (lstWfData != null && lstWfData.size() > 0) {
                log.debug("\u6253\u5370\uff1a\u6309\u5ba1\u6279\u8282\u70b9\u6253\u5370\u83b7\u53d6\u5ba1\u6279\u6570\u636e\u4e3a\uff1a" + lstWfData);
                results = WorkflowParser.convertToDynamicObject(lstWfData);
                if (results == null) {
                    log.debug("\u6253\u5370\uff1a\u6309\u5ba1\u6279\u8282\u70b9\u6253\u5370-\u8f6c\u6362\u6210\u6570\u636e\u5305\u5931\u8d25");
                }
            } else {
                log.debug("\u6253\u5370\uff1a\u6309\u5ba1\u6279\u8282\u70b9\u6253\u5370\u6ca1\u6709\u83b7\u53d6\u5230\u6570\u636e, businessKey:" + parms.getValue().toString());
            }
        } else {
            log.debug("\u6253\u5370\uff1a\u6309\u5ba1\u6279\u8282\u70b9\u6253\u5370\u6ca1\u6709\u8fdb\u884c\u67e5\u8be2,\uff0c parms\u4e3a\u7a7a\u3002");
        }
        return results;
    }

    public List<DynamicObject> getQueryEntityObjs(R1PrintDataSource dataSource) {
        QFilter filter;
        Object fkValue;
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>();
        QueryEntityType queryEntity = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)dataSource.getQueryEntityId());
        QueryBuilder qBuilder = new QueryBuilder();
        QFilter[] filters = new QFilter[1];
        R1PrintDataParameter parms = dataSource.getAssociateParameter();
        int bdType = queryEntity.getPrimaryKey().getDbType();
        if (bdType == -5) {
            Long bigValue = Long.valueOf(parms.getValue().toString());
            fkValue = bigValue;
        } else {
            fkValue = bdType == 4 ? Integer.valueOf(parms.getValue().toString()) : parms.getValue().toString();
        }
        String associateField = parms.getAssociateField();
        if (associateField.contains("&")) {
            associateField = StringUtils.substringAfter((String)associateField, (String)"&");
        }
        filters[0] = filter = new QFilter(associateField, "=", fkValue);
        qBuilder.setFilters(filters);
        qBuilder.setEntityType((IDataEntityType)queryEntity);
        HashSet<String> newUsedField = new HashSet<String>();
        newUsedField.add(queryEntity.getPrimaryKey().getName());
        for (String uf : dataSource.getUsedFields()) {
            if (!uf.contains(".")) continue;
            newUsedField.add(StringUtils.substringAfter((String)uf, (String)"."));
        }
        String selectFields = String.join((CharSequence)",", newUsedField);
        qBuilder.setSelectFields(selectFields);
        DynamicObjectType dt = QueryDataProvider.createEntityType("queryet", newUsedField);
        try (DataSet ds = this.queryData(qBuilder);){
            RowMeta rowMeta = ds.getRowMeta();
            int n = rowMeta.getFieldCount();
            ArrayList<Mapper> mappers = new ArrayList<Mapper>(n);
            for (int i = 0; i < n; ++i) {
                DynamicProperty property = dt.getProperty(rowMeta.getField(i).getName());
                if (property == null) continue;
                Mapper mapper = new Mapper();
                mapper.index = i;
                mapper.property = property;
                mappers.add(mapper);
            }
            for (Row row : ds) {
                DynamicObject obj = new DynamicObject(dt);
                for (Mapper mp : mappers) {
                    mp.property.setValueFast((Object)obj, row.get(mp.index));
                }
                results.add(obj);
            }
        }
        return results;
    }

    public DataSet queryData(QueryBuilder queryBuilder) {
        QueryEntityType qet = (QueryEntityType)queryBuilder.getEntityType();
        List filters = qet.getQFilter();
        for (QFilter qFilter : queryBuilder.getFilters()) {
            filters.add(qFilter);
        }
        ORM orm = ORM.create();
        Lang printLang = this.getPrintLang(this.getMainEntityType().getName());
        orm.hint().setLang(printLang);
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), qet.getName(), queryBuilder.getSelectFields(), filters.toArray(new QFilter[0]), queryBuilder.getOrderBys());
    }

    private List<DynamicObject> getSubEntityObjs(R1PrintDataSource dataSource, SubEntryProp entryProp) {
        R1PrintDataParameter parms = dataSource.getAssociateParameter();
        List<DynamicObject> results = new ArrayList<DynamicObject>();
        if (parms.getValue() != null && ((Variant)parms.getValue()).getValue() != null) {
            QFilter filter = new QFilter(parms.getAssociateSource() + ".id", "=", ((Variant)parms.getValue()).getValue());
            List pks = QueryServiceHelper.queryPrimaryKeys((String)this.getMainEntityType().getName(), (QFilter[])new QFilter[]{filter}, null, (int)1);
            if (!pks.isEmpty()) {
                DynamicObject headObj;
                Object pk = pks.get(0);
                try {
                    headObj = BusinessDataReader.loadSingle(pk, (DynamicObjectType)((DynamicObjectType)this.getMainEntityType().clone()));
                }
                catch (CloneNotSupportedException e) {
                    throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
                }
                DynamicObject parentObj = null;
                DynamicObjectCollection subObjs = null;
                DynamicObjectCollection parentObjects = headObj.getDynamicObjectCollection(parms.getAssociateSource());
                for (DynamicObject parentItem : parentObjects) {
                    if (!((Variant)parms.getValue()).getValue().equals(parentItem.getPkValue())) continue;
                    subObjs = (DynamicObjectCollection)parentItem.get(dataSource.getId());
                    parentObj = parentItem;
                    break;
                }
                if (subObjs != null && !subObjs.isEmpty()) {
                    this.parseSpecialField(dataSource.getUsedFields(), (List<DynamicObject>)parentObjects, this.getMainEntityType());
                    List<FmtField> fmtFields = this.getFmtFields(subObjs.getDynamicObjectType());
                    results = this.rebuildFormatedObjects(headObj, parentObj, subObjs, subObjs.getDynamicObjectType(), fmtFields);
                    this.setDataEntities(subObjs);
                    this.setDataEntity(headObj);
                }
            }
        } else {
            List<FmtField> fmtFields = null;
            DynamicObject headObj = null;
            try {
                if (this.getPkIds() != null && !this.getPkIds().isEmpty() && this.getPkIds().get(0) != null) {
                    headObj = BusinessDataReader.loadSingle((Object)this.getPkIds().get(0), (DynamicObjectType)((DynamicObjectType)this.getMainEntityType().clone()));
                }
            }
            catch (CloneNotSupportedException e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
            }
            if (headObj != null) {
                DynamicObjectCollection entryObjects = headObj.getDynamicObjectCollection(parms.getAssociateSource());
                this.parseSpecialField(dataSource.getUsedFields(), (List<DynamicObject>)entryObjects, this.getMainEntityType());
                for (DynamicObject parentItem : entryObjects) {
                    DynamicObjectCollection subObjs = (DynamicObjectCollection)parentItem.get(dataSource.getId());
                    if (fmtFields == null) {
                        fmtFields = this.getFmtFields(subObjs.getDynamicObjectType());
                    }
                    List<DynamicObject> subResults = this.rebuildFormatedObjects(headObj, parentItem, subObjs, subObjs.getDynamicObjectType(), fmtFields);
                    results.addAll(subResults);
                }
                this.setDataEntity(headObj);
            }
        }
        return results;
    }

    private void parseSpecialField(Set<String> useFields, List<DynamicObject> objs, MainEntityType mainEntityType) {
        List<AbstractTypeParser> parsers = this.parserMap.get(mainEntityType.getName());
        if (parsers == null) {
            parsers = new ArrayList<AbstractTypeParser>();
            AbstractTypeParser enumParser = TypeParserFactory.getTypeParser((int)1, useFields, (DynamicObjectType)mainEntityType);
            enumParser.scanTypeFields();
            AbstractTypeParser printCountParser = TypeParserFactory.getTypeParser((int)4, useFields, (DynamicObjectType)mainEntityType);
            printCountParser.scanTypeFields();
            parsers.add(enumParser);
            parsers.add(printCountParser);
            this.parserMap.put(mainEntityType.getName(), parsers);
        }
        parsers.forEach(parser -> parser.processTypeField(objs, useFields));
    }

    private IWorkflowService getWFService() {
        return (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
    }

    private Set<String> extendFilterFields(Set<String> usedFields) {
        return this.extendFilterFields(usedFields, null);
    }

    private Set<String> extendFilterFields(Set<String> usedFields, EntryProp entryProp) {
        HashSet<String> newFields = new HashSet<String>(usedFields.size());
        for (String usedKey : usedFields) {
            MainEntityType dataEntityType;
            DynamicProperty endProp;
            DynamicProperty prop;
            newFields.add(usedKey);
            String fkey = usedKey;
            String otherkey = "";
            MainEntityType dt = this.getMainEntityType();
            if (fkey.contains(".")) {
                String[] strs = fkey.split("\\.");
                if (entryProp != null) {
                    fkey = strs[1];
                    dt = entryProp.getDynamicCollectionItemPropertyType();
                } else {
                    fkey = strs[0];
                    otherkey = strs[1];
                }
            }
            if ((prop = dt.getProperty(fkey)) == null) continue;
            if (prop instanceof DecimalProp) {
                boolean isControled;
                String controlPropName = ((DecimalProp)prop).getControlPropName();
                DynamicProperty controlProp = dt.getProperty(controlPropName);
                if (controlProp == null) {
                    controlProp = this.getMainEntityType().getProperty(controlPropName);
                }
                if (!(isControled = controlProp != null && controlProp.getAlias() != null && (controlProp instanceof CurrencyProp || controlProp instanceof UnitProp))) continue;
                BasedataProp bsdProp = (BasedataProp)controlProp;
                MainEntityType bdType2 = (MainEntityType)bsdProp.getComplexType();
                for (IDataEntityProperty pop : bdType2.getProperties()) {
                    if (StringUtils.isBlank((CharSequence)pop.getAlias())) continue;
                    String bsdKey = "";
                    bsdKey = controlProp.getParent() instanceof BillEntityType ? bsdProp.getName() + "." + pop.getName() : entryProp.getName() + "." + bsdProp.getName() + "." + pop.getName();
                    newFields.add(bsdKey);
                }
                continue;
            }
            if (prop instanceof DateTimeProp) {
                boolean isControled;
                DynamicProperty relateOrgProp;
                String relateOrgKey = ((DateTimeProp)prop).getRelateOrg();
                if (StringUtils.isBlank((CharSequence)relateOrgKey)) {
                    relateOrgKey = this.getMainEntityType().getMainOrg();
                }
                if ((relateOrgProp = dt.getProperty(relateOrgKey)) == null) {
                    relateOrgProp = this.getMainEntityType().getProperty(relateOrgKey);
                }
                if (!(isControled = relateOrgProp != null && relateOrgProp.getAlias() != null)) continue;
                String orgKey = "";
                orgKey = relateOrgProp.getParent() instanceof BillEntityType ? relateOrgProp.getName() : entryProp.getName() + "." + relateOrgProp.getName();
                newFields.add(orgKey);
                continue;
            }
            if (prop instanceof MulBasedataProp) {
                RefEntityType basedataDT = (RefEntityType)((MulBasedataProp)prop).getComplexType();
                String nameProperty = basedataDT.getNameProperty();
                if (entryProp != null) {
                    newFields.add(entryProp.getName() + "." + prop.getName() + ".fbasedataid." + nameProperty);
                    continue;
                }
                newFields.add(prop.getName() + ".fbasedataid." + nameProperty);
                continue;
            }
            if (prop instanceof FlexProp) {
                FlexProp flexP = (FlexProp)prop;
                String refBsdKey = flexP.getBasePropertyKey();
                if (entryProp != null) {
                    newFields.add(entryProp.getName() + "." + prop.getName() + ".value");
                    if (!StringUtils.isNotBlank((CharSequence)refBsdKey) || newFields.contains(refBsdKey)) continue;
                    newFields.add(entryProp.getName() + "." + refBsdKey);
                    continue;
                }
                newFields.add(prop.getName() + ".value");
                if (!StringUtils.isNotBlank((CharSequence)refBsdKey)) continue;
                newFields.add(refBsdKey);
                continue;
            }
            if (prop instanceof ItemClassProp) {
                String typePropName = ((ItemClassProp)prop).getTypePropName();
                IDataEntityProperty po = this.getMainEntityType().getAllFields().values().stream().filter(p -> p.getName().equalsIgnoreCase(typePropName)).findFirst().get();
                String typeFiled = "";
                if (po != null && po.getParent() instanceof BillEntityType) {
                    typeFiled = typePropName;
                    newFields.add(prop.getName());
                } else {
                    typeFiled = entryProp.getName() + "." + typePropName;
                    newFields.add(entryProp.getName() + "." + prop.getName());
                }
                newFields.add(typeFiled);
                newFields.remove(usedKey);
                continue;
            }
            if (!(prop instanceof BasedataProp) || !(((BasedataProp)prop).getDynamicComplexPropertyType().getProperty(otherkey) instanceof MulBasedataProp)) continue;
            BasedataProp basedataProp = (BasedataProp)prop;
            DynamicObjectType complexType = basedataProp.getDynamicComplexPropertyType();
            DynamicProperty property = complexType.getProperty(otherkey);
            String name = complexType.getName();
            if (property instanceof MulBasedataProp) {
                RefEntityType basedataDT = (RefEntityType)((MulBasedataProp)property).getComplexType();
                String nameProperty = basedataDT.getNameProperty();
                String suffix = ".fbasedataid." + nameProperty;
                newFields.add(usedKey + suffix);
                continue;
            }
            if (property != null || !((endProp = (dataEntityType = EntityMetadataCache.getDataEntityType((String)name)).getProperty(otherkey)) instanceof MulBasedataProp)) continue;
            RefEntityType basedataDT = (RefEntityType)((MulBasedataProp)endProp).getComplexType();
            String nameProperty = basedataDT.getNameProperty();
            String suffix = ".fbasedataid." + nameProperty;
            newFields.add(usedKey + suffix);
        }
        return newFields;
    }

    /*
     * WARNING - void declaration
     */
    private List<DynamicObject> rebuildFormatedObjects(DynamicObject headDyObj, DynamicObject parentObj, DynamicObjectCollection entryDatas, DynamicObjectType objectType, List<FmtField> fmtFields) {
        ArrayList<DynamicObject> newDataEntities = new ArrayList<DynamicObject>();
        NumberFormatProvider subNumberFormatProvider = new NumberFormatProvider(fmtFields, entryDatas);
        NumberFormatProvider mainNumberFormatProvider = new NumberFormatProvider(fmtFields, entryDatas, headDyObj);
        for (DynamicObject data : entryDatas) {
            HashMap<String, String> symbolMap = new HashMap<String, String>(16);
            HashMap<String, String> codeMap = new HashMap<String, String>(16);
            HashMap<String, BigDecimal> oriPropMap = new HashMap<String, BigDecimal>(16);
            for (FmtField fmtField : fmtFields) {
                void var17_23;
                String oriKey;
                void var17_21;
                String controlFieldName = fmtField.getControlFieldName();
                Object var17_18 = null;
                DynamicObjectType parentType = objectType;
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)parentType.getProperties().get((Object)controlFieldName);
                if (iDataEntityProperty == null && (parentType = parentType.getParent()) != null) {
                    IDataEntityProperty iDataEntityProperty2 = (IDataEntityProperty)parentType.getProperties().get((Object)controlFieldName);
                }
                if (var17_21 == null && parentType != null && (parentType = parentType.getParent()) != null) {
                    IDataEntityProperty iDataEntityProperty3 = (IDataEntityProperty)parentType.getProperties().get((Object)controlFieldName);
                }
                if (objectType.getProperty(oriKey = fmtField.getFieldName() + "_ori_") == null) {
                    DecimalProp oriProp = new DecimalProp();
                    oriProp.setName(oriKey);
                    objectType.registerSimpleProperty((DynamicSimpleProperty)oriProp);
                }
                if (var17_23 != null) {
                    String symbolKey = fmtField.getControlFieldName() + "_symbol";
                    String codeKey = fmtField.getControlFieldName() + "_code";
                    DynamicProperty controlFiledProp = objectType.getProperty(symbolKey);
                    DynamicProperty controlFiledProp1 = objectType.getProperty(codeKey);
                    if (controlFiledProp == null) {
                        DynamicSimpleProperty symbolProp = new DynamicSimpleProperty(symbolKey, String.class, (Object)"");
                        objectType.registerSimpleProperty(symbolProp);
                    }
                    if (controlFiledProp1 == null) {
                        DynamicSimpleProperty codeProp = new DynamicSimpleProperty(codeKey, String.class, (Object)"");
                        objectType.registerSimpleProperty(codeProp);
                    }
                    DynamicProperty prop = objectType.getProperty(fmtField.getFieldName());
                    NumberFormatProvider numberFormatProvider = null;
                    NumberPrecision formatPrecision = null;
                    numberFormatProvider = objectType instanceof SubEntryType ? (var17_23.getParent() instanceof SubEntryType ? subNumberFormatProvider : mainNumberFormatProvider) : (var17_23.getParent() instanceof EntryType ? subNumberFormatProvider : mainNumberFormatProvider);
                    try {
                        Map colInfo;
                        formatPrecision = numberFormatProvider.getFormatPrecision(prop.getName(), data);
                        if (formatPrecision == null) {
                            prop.setValue((Object)data, null);
                            continue;
                        }
                        String code = "";
                        Map colfmt = numberFormatProvider.getColfmt();
                        if (colfmt != null && (colInfo = (Map)colfmt.get(fmtField.getControlFieldName())) != null) {
                            code = (String)colInfo.get("cn");
                        }
                        oriPropMap.put(oriKey, data.getBigDecimal((IDataEntityProperty)prop));
                        formatPrecision.setResult(data.getBigDecimal((IDataEntityProperty)prop));
                        if (formatPrecision.getPrecision() >= 0) {
                            BigDecimal newResult = formatPrecision.getResult().setScale(formatPrecision.getPrecision(), 4);
                            formatPrecision.setResult(newResult);
                        }
                        prop.setValue((Object)data, null);
                        prop.setValue((Object)data, (Object)formatPrecision.getResult());
                        symbolMap.put(symbolKey, formatPrecision.getSign());
                        codeMap.put(codeKey, code);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                    continue;
                }
                IDataEntityProperty fieldProp = fmtField.getFieldProp();
                DecimalProp decimalProp = (DecimalProp)fieldProp;
                int scale = 2;
                if (fieldProp instanceof PriceProp) {
                    scale = (Integer)FmtInfoUtils.getMainCurrencyFmt().get("pp");
                } else if (fieldProp instanceof AmountProp) {
                    scale = (Integer)FmtInfoUtils.getMainCurrencyFmt().get("ap");
                } else if (fieldProp instanceof DecimalProp) {
                    scale = decimalProp.getScale();
                }
                oriPropMap.put(oriKey, data.getBigDecimal((IDataEntityProperty)decimalProp));
                BigDecimal bigDecimal = data.getBigDecimal((IDataEntityProperty)decimalProp);
                if (bigDecimal == null) continue;
                BigDecimal decimal = bigDecimal.setScale(scale, 4);
                decimalProp.setValue((Object)data, null);
                decimalProp.setValue((Object)data, (Object)decimal);
            }
            DynamicObject newObj = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)objectType, (Object)data);
            for (IComplexProperty iComplexProperty : objectType.getProperties().getComplexProperties(false)) {
                newObj.set(iComplexProperty.getName(), data.get(iComplexProperty.getName()));
            }
            for (Map.Entry entry : symbolMap.entrySet()) {
                newObj.set((String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : codeMap.entrySet()) {
                newObj.set((String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : oriPropMap.entrySet()) {
                newObj.set((String)entry.getKey(), entry.getValue());
            }
            newDataEntities.add(newObj);
        }
        if (!newDataEntities.isEmpty()) {
            return newDataEntities;
        }
        return entryDatas;
    }

    private List<FmtField> getFmtFields(DynamicObjectType objectType, Set<String> usedFields) {
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>();
        Iterator<String> it = usedFields.iterator();
        while (it.hasNext()) {
            DynamicProperty prop;
            String oldFieldKey;
            String newFieldKey = oldFieldKey = it.next();
            if (oldFieldKey.contains(".") && objectType instanceof EntryType) {
                String[] split = StringUtils.split((String)oldFieldKey, (String)".");
                newFieldKey = split[1];
            }
            if (!((prop = objectType.getProperty(newFieldKey)) instanceof DecimalProp) || prop instanceof PrintCountProp) continue;
            DecimalProp decimalProp = (DecimalProp)prop;
            FmtField fmtField = new FmtField((IDataEntityProperty)prop, prop.getName(), decimalProp.getControlPropName());
            fmtFields.add(fmtField);
        }
        return fmtFields;
    }

    private List<FmtField> getFmtFields(DynamicObjectType objectType) {
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>();
        for (IDataEntityProperty prop : objectType.getProperties()) {
            if (!(prop instanceof DecimalProp) || prop instanceof PrintCountProp) continue;
            DecimalProp decimalProp = (DecimalProp)prop;
            FmtField fmtField = new FmtField(prop, prop.getName(), decimalProp.getControlPropName());
            fmtFields.add(fmtField);
        }
        return fmtFields;
    }
}

