/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.print.dataprovider;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.lang.Lang;

public class QueryDataProviderHelper {
    private static volatile QueryDataProviderHelper _queryDataProviderHelper;

    private QueryDataProviderHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QueryDataProviderHelper getInstance() {
        if (_queryDataProviderHelper != null) return _queryDataProviderHelper;
        Class<QueryDataProviderHelper> clazz = QueryDataProviderHelper.class;
        synchronized (QueryDataProviderHelper.class) {
            if (_queryDataProviderHelper != null) return _queryDataProviderHelper;
            _queryDataProviderHelper = new QueryDataProviderHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _queryDataProviderHelper;
        }
    }

    public HashMap<String, IDataEntityProperty> getAllProperties(DynamicObjectType prop) {
        HashMap<String, IDataEntityProperty> propertyMap = new HashMap<String, IDataEntityProperty>();
        this.getAllProperties(propertyMap, prop);
        return propertyMap;
    }

    private void getAllProperties(HashMap<String, IDataEntityProperty> hm, DynamicObjectType prop) {
        DataEntityPropertyCollection properties = prop.getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)property;
                this.getAllProperties(hm, entryProp.getDynamicCollectionItemPropertyType());
                continue;
            }
            IDataEntityType parent = property.getParent();
            if (parent instanceof EntryType) {
                hm.put(parent.getName() + "." + property.getName(), property);
                continue;
            }
            hm.put(property.getName(), property);
        }
    }

    public DynamicObjectValue getDynamicObjectValue(DynamicObject originObj, String key) {
        String[] arr = key.split("\\.");
        Object[] record = new Object[2];
        this.getDynamicObjectValue(originObj, record, arr, 0);
        DynamicObjectValue obj = new DynamicObjectValue();
        obj.setType((DynamicProperty)record[1]);
        obj.setValue(record[0]);
        return obj;
    }

    private void getDynamicObjectValue(DynamicObject originObj, Object[] result, String[] arr, int i) {
        if (i >= arr.length) {
            return;
        }
        DynamicProperty property = originObj.getDynamicObjectType().getProperty(arr[i]);
        if (property == null) {
            this.getDynamicObjectValue(originObj, result, arr, ++i);
        } else {
            Object tempObj = originObj.get(arr[i]);
            if (tempObj instanceof DynamicObject) {
                this.getDynamicObjectValue((DynamicObject)tempObj, result, arr, ++i);
            } else {
                if (tempObj == null) {
                    result[0] = null;
                    if (i == arr.length - 1) {
                        result[1] = property;
                    } else if (property instanceof DynamicComplexProperty && i == arr.length - 2) {
                        DynamicComplexProperty dynamicComplexProperty = (DynamicComplexProperty)property;
                        String key = arr[i + 1];
                        DynamicProperty prop = dynamicComplexProperty.getDynamicComplexPropertyType().getProperty(key);
                        result[1] = prop;
                    } else {
                        result[1] = new TextProp();
                    }
                    return;
                }
                result[0] = tempObj;
                result[1] = originObj.getDynamicObjectType().getProperty(arr[i]);
            }
        }
    }

    public List<DynamicObject> toListDynamicObject(DynamicObject originObj) throws CloneNotSupportedException {
        BillEntityType billEntityType = (BillEntityType)originObj.getDynamicObjectType();
        BillEntityType subEntityType = (BillEntityType)billEntityType.clone();
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        Map allEntities = subEntityType.getAllEntities();
        DynamicObjectType dt = new DynamicObjectType("PlainObject");
        DynamicObject sampleObj = new DynamicObject(dt);
        for (EntityType entityType : allEntities.values()) {
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty prop : properties) {
                if (prop instanceof EntryProp) continue;
                if (prop instanceof DynamicSimpleProperty) {
                    dt.registerSimpleProperty((DynamicSimpleProperty)prop);
                    continue;
                }
                if (prop instanceof DynamicComplexProperty) {
                    dt.registerComplexProperty((DynamicComplexProperty)prop);
                    continue;
                }
                if (!(prop instanceof DynamicCollectionProperty)) continue;
                dt.registerCollectionProperty((DynamicCollectionProperty)prop);
            }
            if (entityType instanceof BillEntityType) {
                for (IDataEntityProperty billProp : entityType.getProperties()) {
                    if (billProp instanceof EntryProp) continue;
                    sampleObj.set(billProp, originObj.get(billProp.getName()));
                }
                DynamicObject dynamicObject = (DynamicObject)OrmUtils.clone((IDataEntityBase)sampleObj, (boolean)false, (boolean)false);
                resultList.add(dynamicObject);
            }
            if (!(entityType instanceof EntryType)) continue;
            DynamicObjectCollection collection = originObj.getDynamicObjectCollection(entityType.getName());
            int i = 0;
            for (DynamicObject dyObj : collection) {
                DynamicObject dynamicObject;
                if (resultList.size() > i) {
                    dynamicObject = (DynamicObject)resultList.get(i);
                } else {
                    dynamicObject = (DynamicObject)OrmUtils.clone((IDataEntityBase)sampleObj, (boolean)false, (boolean)false);
                    resultList.add(dynamicObject);
                }
                for (IDataEntityProperty p : entityType.getProperties()) {
                    if (p instanceof SubEntryProp) continue;
                    dynamicObject.set(p, dyObj.get(p.getName()));
                }
                ++i;
            }
        }
        return resultList;
    }

    public List<DynamicObject> buildRefEntityResult(List<DynamicObject> objs, Set<String> usedFields) throws CloneNotSupportedException {
        return this.buildRefEntityResult(objs, usedFields, RequestContext.get().getLang(), null);
    }

    public List<DynamicObject> buildRefEntityResult(List<DynamicObject> objs, Set<String> usedFields, Lang printLang, NumberFormatProvider numberFormatProvider) throws CloneNotSupportedException {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        for (DynamicObject obj : objs) {
            DynamicObjectType dt2 = new DynamicObjectType("PlainObject");
            DynamicObject newObj = new DynamicObject(dt2);
            for (String str : usedFields) {
                DynamicSimpleProperty cpProp;
                TextProp textProp;
                DynamicObjectValue objValue = this.getDynamicObjectValue(obj, str);
                if (objValue == null) continue;
                DynamicProperty property = objValue.getType();
                if (property instanceof MuliLangTextProp) {
                    textProp = new TextProp();
                    textProp.setName(str);
                    textProp.setAlias(str);
                    dt2.registerSimpleProperty((DynamicSimpleProperty)textProp);
                    Object value = objValue.getValue();
                    if (value != null) {
                        OrmLocaleValue localeValue = (OrmLocaleValue)value;
                        newObj.set(str, (Object)localeValue.get((Object)printLang.name()));
                        continue;
                    }
                    newObj.set(str, (Object)"");
                    continue;
                }
                if (property instanceof DecimalProp && !(property instanceof IntegerProp)) {
                    cpProp = (DynamicSimpleProperty)property.clone();
                    cpProp.setName(str);
                    cpProp.setAlias(str);
                    dt2.registerSimpleProperty(cpProp);
                    DecimalProp decimalProp = (DecimalProp)cpProp;
                    String controlPropName = decimalProp.getControlPropName();
                    if (numberFormatProvider == null) {
                        newObj.set(str, objValue.getValue());
                        continue;
                    }
                    BigDecimal decimalVal = (BigDecimal)objValue.getValue();
                    NumberPrecision formatPrecision = numberFormatProvider.getFormatPrecision(property.getName(), obj);
                    if (formatPrecision == null) {
                        newObj.set(str, objValue.getValue());
                        continue;
                    }
                    formatPrecision.setResult(decimalVal);
                    if (formatPrecision.getPrecision() >= 0) {
                        cpProp.setValue((Object)newObj, (Object)formatPrecision.getResult());
                    }
                    if (StringUtils.isBlank((CharSequence)controlPropName)) continue;
                    String codeKey = controlPropName + "_code";
                    String code = "";
                    String symbolKey = controlPropName + "_symbol";
                    String symbol = formatPrecision.getSign();
                    DynamicObject controlObj = obj.getDynamicObject(controlPropName);
                    if (controlObj != null) {
                        code = controlObj.getString("number");
                    }
                    if (dt2.getProperty(codeKey) == null) {
                        DynamicSimpleProperty codeProp = new DynamicSimpleProperty(codeKey, String.class, (Object)"");
                        dt2.registerSimpleProperty(codeProp);
                        codeProp.setValue((Object)newObj, (Object)code);
                    }
                    if (dt2.getProperty(codeKey) != null) continue;
                    DynamicSimpleProperty symbolProp = new DynamicSimpleProperty(symbolKey, String.class, (Object)"");
                    dt2.registerSimpleProperty(symbolProp);
                    symbolProp.setValue((Object)newObj, (Object)symbol);
                    continue;
                }
                if (property instanceof DynamicCollectionProperty) {
                    cpProp = (DynamicCollectionProperty)property.clone();
                    cpProp.setName(str);
                    cpProp.setAlias(str);
                    dt2.registerCollectionProperty((DynamicCollectionProperty)cpProp);
                    newObj.set(str, objValue.getValue());
                    continue;
                }
                if (property instanceof DynamicSimpleProperty) {
                    cpProp = (DynamicSimpleProperty)property.clone();
                    cpProp.setName(str);
                    cpProp.setAlias(str);
                    dt2.registerSimpleProperty(cpProp);
                    newObj.set(str, objValue.getValue());
                    continue;
                }
                textProp = new TextProp();
                textProp.setName(str);
                textProp.setAlias(str);
                dt2.registerSimpleProperty((DynamicSimpleProperty)textProp);
                newObj.set(str, (Object)"");
            }
            result.add(newObj);
        }
        return result;
    }

    public static class DynamicObjectValue {
        private DynamicProperty type;
        private Object value;

        public DynamicProperty getType() {
            return this.type;
        }

        public void setType(DynamicProperty type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

