/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.print.dataprovider;

import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.plugin.PrintServicePluginProxy;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryBuilder;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.queryds.ReportFilterField;
import kd.bos.entity.report.queryds.ReportFilterFieldConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.list.query.Mapper;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.print.dataprovider.BaseDataProvider;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportDataProvider
extends BaseDataProvider {
    public ReportDataProvider() {
    }

    public ReportDataProvider(String pageId, MainEntityType mainEntityType, Map<String, Set<String>> customFieldsMap, PrintServicePluginProxy pluginProxy) {
        super(pageId, mainEntityType, customFieldsMap, pluginProxy);
    }

    public ReportDataProvider(String pageId, MainEntityType mainEntityType, Map<String, Set<String>> customFieldsMap, PrintServicePluginProxy pluginProxy, Map<String, DynamicObjectType> customDynamicObjectTypes) {
        super(pageId, mainEntityType, customFieldsMap, pluginProxy, customDynamicObjectTypes);
    }

    @Override
    public List<DynamicObject> getData(R1PrintDataSource dataSource) throws Exception {
        List<Object> dataEntities = new ArrayList();
        if ("7".equals(dataSource.getDsType())) {
            dataEntities = this.getQueryEntityObjs(dataSource);
        }
        if (this.getPluginProxy() != null) {
            boolean isMainDs = false;
            if ("1".equals(dataSource.getDsType())) {
                isMainDs = true;
            }
            QFilter filter = null;
            R1PrintDataParameter parms = dataSource.getAssociateParameter();
            if (parms != null) {
                String fkValue = parms.getValue() == null ? null : parms.getValue().toString();
                filter = new QFilter(parms.getAssociateField(), "=", (Object)fkValue);
            }
            Set<String> customFields = this.getCustomFieldsMap().get(dataSource.getId());
            Map<String, DynamicObjectType> customDynamicObjectTypes = this.getCustomDynamicObjectTypes();
            DynamicObjectType dynamicObjectType = null;
            if (customDynamicObjectTypes != null) {
                dynamicObjectType = customDynamicObjectTypes.get(dataSource.getId());
            }
            Object pkId = null;
            if (this.getPkIds() != null && !this.getPkIds().isEmpty()) {
                pkId = this.getPkIds().get(0);
            }
            CustomPrintDataEntitiesArgs customArgs = new CustomPrintDataEntitiesArgs((Object)this, this.getPageId(), pkId, dataSource.getId(), customFields, filter, isMainDs, dynamicObjectType);
            customArgs.setPkIds(this.getPkIds());
            customArgs.setDataEntities(dataEntities);
            this.getPluginProxy().setContext(this.getMainEntityType());
            this.getPluginProxy().fireCustomPrintDataEntities(customArgs);
            dataEntities = customArgs.getDataEntities();
        }
        return dataEntities;
    }

    private List<DynamicObject> getQueryEntityObjs(R1PrintDataSource dataSource) {
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>();
        if (this.getQueryParam() != null) {
            ReportQueryBuilder reportQueryBuilder = new ReportQueryBuilder();
            MainEntityType qyeryEntityType = EntityMetadataCache.getDataEntityType((String)dataSource.getId());
            String queryEntityId = MetadataDao.getIdByNumber((String)dataSource.getId(), (MetaCategory)MetaCategory.Form);
            List<QFilter> queryDataSourceFilter = this.getQueryDataSourceFilter(this.getQueryParam(), queryEntityId, qyeryEntityType);
            reportQueryBuilder.setFilters(queryDataSourceFilter.toArray(new QFilter[0]));
            reportQueryBuilder.setEntityType((IDataEntityType)qyeryEntityType);
            HashSet<String> newUsedField = new HashSet<String>();
            for (String uf : dataSource.getUsedFields()) {
                if (!uf.contains(".")) continue;
                newUsedField.add(StringUtils.substringAfter((String)uf, (String)"."));
            }
            String fieldStr = String.join((CharSequence)",", newUsedField);
            reportQueryBuilder.setSelectFields(fieldStr);
            DynamicObjectType dt = ReportDataProvider.createEntityType("queryet", newUsedField);
            try (DataSet ds = this.queryData(reportQueryBuilder);){
                RowMeta rowMeta = ds.getRowMeta();
                int n = rowMeta.getFieldCount();
                ArrayList<Mapper> mappers = new ArrayList<Mapper>(n);
                for (int i = 0; i < n; ++i) {
                    DynamicProperty property = dt.getProperty(rowMeta.getField(i).getName());
                    if (property == null) continue;
                    Mapper mapper = new Mapper();
                    mapper.index = i;
                    mapper.property = property;
                    mappers.add(mapper);
                }
                for (Row row : ds) {
                    DynamicObject obj = new DynamicObject(dt);
                    for (Mapper mp : mappers) {
                        mp.property.setValueFast((Object)obj, row.get(mp.index));
                    }
                    results.add(obj);
                }
            }
        }
        return results;
    }

    public DataSet queryData(ReportQueryBuilder queryBuilder) {
        QueryEntityType qet = (QueryEntityType)queryBuilder.getEntityType();
        List filters = qet.getQFilter();
        for (QFilter qFilter : queryBuilder.getFilters()) {
            filters.add(qFilter);
        }
        ORM orm = ORM.create();
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), qet.getName(), queryBuilder.getSelectFields(), filters.toArray(new QFilter[0]), queryBuilder.getOrderBys());
    }

    private List<QFilter> getQueryDataSourceFilter(ReportQueryParam queryParam, String entityId, MainEntityType entityType) {
        List<QFilter> qfilters = this.getQFilter(queryParam, entityType, entityId);
        QFilter commFilter = queryParam.getFilter().getCommFilter(entityId);
        if (commFilter != null) {
            qfilters.add(commFilter);
        }
        return qfilters;
    }

    private List<QFilter> getQFilter(ReportQueryParam queryParam, MainEntityType entityType, String entityId) {
        ArrayList<QFilter> qfilter = new ArrayList<QFilter>();
        FilterInfo filter = queryParam.getFilter();
        if (filter.getFilterItems().isEmpty()) {
            return qfilter;
        }
        FilterBuilder filterBuilder = new FilterBuilder(entityType);
        for (FilterItemInfo f : filter.getFilterItems()) {
            ReportFilterField reportFilterField = this.findDataSourceField(f.getPropName(), entityId, queryParam.getReportFilterFieldConfig());
            if (reportFilterField == null || StringUtils.isEmpty((CharSequence)reportFilterField.getFieldName())) continue;
            this.setFilterField(f, filterBuilder, entityType, reportFilterField);
        }
        filterBuilder.buildFilter();
        return filterBuilder.getQFilters();
    }

    private ReportFilterField findDataSourceField(String fieldKey, String entityId, ReportFilterFieldConfig reportFilterFieldConfig) {
        for (ReportFilterField reportFilterField : reportFilterFieldConfig.getReportFilterFields()) {
            if (!fieldKey.equals(reportFilterField.getKey()) || !entityId.equals(reportFilterField.getDataSourceId())) continue;
            return reportFilterField;
        }
        return null;
    }

    private void setFilterField(FilterItemInfo filterItemInfo, FilterBuilder filterBuilder, MainEntityType entityType, ReportFilterField reportFilterField) {
        String fieldName = reportFilterField.getFieldName();
        FilterField filterField = FilterField.create((MainEntityType)entityType, (String)fieldName);
        if (filterField == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{fieldName});
        }
        String compareTypeId = StringUtils.isNotEmpty((CharSequence)reportFilterField.getCompareTypeId()) ? reportFilterField.getCompareTypeId() : filterItemInfo.getCompareType();
        Object filterVal = filterItemInfo.getValue();
        if (filterVal == null) {
            return;
        }
        if (filterVal instanceof DynamicObject) {
            filterVal = ((DynamicObject)filterVal).getPkValue();
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add(filterVal.toString());
            filterBuilder.addFilterField(fieldName, compareTypeId, "", "", valueList, "");
        } else if (filterVal instanceof DynamicObjectCollection) {
            ArrayList<String> pkValues = new ArrayList<String>();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)filterVal) {
                pkValues.add(dynamicObject.getPkValue().toString());
            }
            filterBuilder.addFilterField(fieldName, CompareTypeEnum.IN.getId(), "", "", pkValues, "");
        } else if (filterVal instanceof String && !StringUtils.isEmpty((CharSequence)((String)filterVal)) || !(filterVal instanceof String)) {
            ArrayList<Object> valueList = new ArrayList<Object>();
            valueList.add(filterVal);
            List<Object> filterValueList = this.getFilterValueList(filterField, valueList);
            filterBuilder.addFilterField(fieldName, compareTypeId, "", "", filterValueList, "");
        }
    }

    private List<Object> getFilterValueList(FilterField filterField, List<Object> valueList) {
        ArrayList<Object> newValueList = new ArrayList<Object>();
        if (filterField.getFieldProp() instanceof DateTimeProp && !(filterField.getFieldProp() instanceof DateProp)) {
            SimpleDateFormat longTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (Object value : valueList) {
                newValueList.add(longTimeFormat.format(value));
            }
        } else if (filterField.getFieldProp() instanceof DateTimeProp) {
            SimpleDateFormat shortTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
            for (Object value : valueList) {
                newValueList.add(shortTimeFormat.format(value));
            }
        } else {
            for (Object value : valueList) {
                newValueList.add(value.toString());
            }
        }
        return newValueList;
    }
}

