/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.print.dataprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;

public class WorkflowParser {
    public static DynamicObject[] convertToDynamicObject(Set<String> propKeys, List<Map<String, String>> wfObjs) {
        ArrayList<DynamicObject> lst = new ArrayList<DynamicObject>(wfObjs.size());
        DynamicObjectType dt = WorkflowParser.createEntityType("ApproveLine", propKeys);
        for (Map<String, String> wf : wfObjs) {
            DynamicObject dynWf = new DynamicObject(dt);
            for (Map.Entry<String, String> entry : wf.entrySet()) {
                dynWf.set(entry.getKey(), (Object)entry.getValue());
            }
            lst.add(dynWf);
        }
        return lst.toArray(new DynamicObject[lst.size()]);
    }

    public static List<DynamicObject> convertToDynamicObject(DynamicObjectType dt, List<Map<String, String>> wfObjs) {
        ArrayList<DynamicObject> lst = new ArrayList<DynamicObject>(wfObjs.size());
        for (Map<String, String> wf : wfObjs) {
            DynamicObject dynWf = new DynamicObject(dt);
            for (Map.Entry<String, String> entry : wf.entrySet()) {
                DynamicProperty prop = dt.getProperty(entry.getKey());
                if (prop == null) continue;
                prop.setValue((Object)dynWf, (Object)entry.getValue());
            }
            lst.add(dynWf);
        }
        return lst;
    }

    public static List<DynamicObject> convertToDynamicObject(Collection<Map<String, String>> wfObjs) {
        DynamicObjectType dt = WorkflowParser.createEntityType(wfObjs);
        DynamicObject dynWf = new DynamicObject(dt);
        for (Map<String, String> activity : wfObjs) {
            String bizKey = activity.get("bizIdentifyKey");
            for (Map.Entry<String, String> entry : activity.entrySet()) {
                String propKey = bizKey.toLowerCase() + "_" + entry.getKey().toLowerCase();
                DynamicProperty prop = dt.getProperty(propKey);
                if (prop == null) continue;
                Object oldValue = prop.getValue((Object)dynWf);
                String propName = prop.getName().toLowerCase();
                if (propName.contains("resultname")) {
                    prop.setValue((Object)dynWf, (Object)ResManager.loadKDString((String)"\u540c\u610f", (String)"WorkflowParser_0", (String)"bos-servicehelper", (Object[])new Object[0]));
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    prop.setValue((Object)dynWf, (Object)entry.getValue());
                    continue;
                }
                if (!propName.contains("assignee") && !propName.contains("message") && !propName.contains("usernameformatter") && !propName.toLowerCase().contains("activityname") && !propName.contains("time")) continue;
                String newValue = oldValue + "\n" + entry.getValue();
                prop.setValue((Object)dynWf, (Object)newValue);
            }
        }
        ArrayList<DynamicObject> lst = new ArrayList<DynamicObject>();
        lst.add(dynWf);
        return lst;
    }

    public static DynamicObjectType createEntityType(String name, Set<String> keys) {
        DynamicObjectType dt = new DynamicObjectType(name);
        DynamicSimpleProperty property = new DynamicSimpleProperty("Id", String.class, null);
        property.setPrimaryKey(true);
        dt.registerSimpleProperty(property);
        for (String k : keys) {
            property = new DynamicSimpleProperty(k.toLowerCase(), String.class, null);
            dt.registerSimpleProperty(property);
        }
        return dt;
    }

    public static DynamicObjectType createEntityType(Collection<Map<String, String>> wfObjs) {
        DynamicObjectType dt = new DynamicObjectType("activity");
        DynamicSimpleProperty property = new DynamicSimpleProperty("Id", String.class, null);
        property.setPrimaryKey(true);
        dt.registerSimpleProperty(property);
        for (Map<String, String> activity : wfObjs) {
            String bizKey = activity.get("bizIdentifyKey");
            for (String k : activity.keySet()) {
                String fullKey = bizKey.toLowerCase() + "_" + k.toLowerCase();
                DynamicProperty prop = dt.getProperty(fullKey);
                if (prop != null) continue;
                DynamicSimpleProperty prot = new DynamicSimpleProperty(fullKey, String.class, null);
                dt.registerSimpleProperty(prot);
            }
        }
        return dt;
    }
}

