/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;
import kd.bos.template.orgctrl.utils.SearchResult;

public abstract class AbstractTemplateAllocateTreePlugin
extends AbstractListPlugin
implements SearchEnterListener,
TreeNodeCheckListener,
TreeNodeQueryListener {
    public abstract String getTreePluginKey();

    public abstract String getTreeSearchPluginKey();

    public abstract String getTreeIncludeChildPluginKey();

    public void initialize() {
        super.initialize();
        TreeView tvLeft = (TreeView)this.getControl(this.getTreePluginKey());
        tvLeft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tvLeft.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search searchTree = (Search)this.getControl(this.getTreeSearchPluginKey());
        searchTree.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject e) {
        List<TreeNode> rootList = PrintTemplateDataService.getAllUserPermOrgTreeRootList();
        this.getView().getPageCache().putBigObject("org_nodeList", SerializationUtils.toJsonString(rootList));
        if (rootList.isEmpty()) {
            return;
        }
        TreeView tvLeft = (TreeView)this.getControl(this.getTreePluginKey());
        tvLeft.setRootVisible(true);
        tvLeft.deleteAllNodes();
        tvLeft.addNodes(rootList);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap<String, Boolean> treeParams = new HashMap<String, Boolean>();
        treeParams.put("cpn", Boolean.FALSE);
        treeParams.put("bigDataRender", Boolean.TRUE);
        this.getView().updateControlMetadata(this.getTreePluginKey(), treeParams);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeView treeView = (TreeView)this.getView().getControl(this.getTreePluginKey());
        String searchText = searchEnterEvent.getText();
        String searchResultJson = this.getView().getPageCache().get("searchResult");
        SearchResult preSearchResult = null;
        if (StringUtils.isNotBlank((CharSequence)searchResultJson)) {
            preSearchResult = (SearchResult)SerializationUtils.fromJsonString((String)searchResultJson, SearchResult.class);
        }
        if (preSearchResult != null && StringUtils.equals((CharSequence)searchText, (CharSequence)preSearchResult.searchText)) {
            List<TreeNode> preResult = preSearchResult.result;
            if (CollectionUtils.isEmpty(preResult)) {
                return;
            }
            ++preSearchResult.index;
            if (preSearchResult.index >= preResult.size()) {
                preSearchResult.index = 0;
            }
            TreeNode treeNode = preResult.get(preSearchResult.index);
            treeView.focusNode(treeNode);
            this.getView().getPageCache().put("searchResult", SerializationUtils.toJsonString((Object)preSearchResult));
            return;
        }
        List checkNodes = treeView.getTreeState().getCheckedNodeIds();
        treeView.uncheckNodes(checkNodes);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            String jsonString = this.getView().getPageCache().getBigObject("org_nodeList");
            List rootList = SerializationUtils.fromJsonStringToList((String)jsonString, TreeNode.class);
            List<TreeNode> result = this.searchNode(searchText, rootList);
            if (!CollectionUtils.isEmpty(result)) {
                this.getView().getPageCache().put("searchResult", SerializationUtils.toJsonString((Object)new SearchResult(0, searchText, result)));
                this.checkAndExpendTreeView(result, rootList, treeView);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u6570\u636e\u3002", (String)"AbstractTemplateAllocateTreePlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
            }
        }
    }

    private List<TreeNode> searchNode(String text, List<TreeNode> treeNodes) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(10);
        for (TreeNode node : treeNodes) {
            this.searchNode(text, result, node);
        }
        return result;
    }

    private void searchNode(String text, List<TreeNode> result, TreeNode node) {
        List children;
        String number = String.valueOf(node.getData());
        String name = String.valueOf(node.getText());
        if (name.contains(text) || number.contains(text)) {
            result.add(node);
        }
        if ((children = node.getChildren()) == null || children.isEmpty()) {
            return;
        }
        for (TreeNode child : children) {
            this.searchNode(text, result, child);
        }
    }

    private void checkAndExpendTreeView(List<TreeNode> result, List<TreeNode> rootList, TreeView treeView) {
        for (TreeNode resNode : result) {
            for (TreeNode root : rootList) {
                List pathNodes = root.getChildPathNodes(resNode.getId());
                for (TreeNode pathNode : pathNodes) {
                    treeView.expand(pathNode.getId());
                }
            }
        }
        treeView.checkNodes(result);
        treeView.focusNode(result.get(0));
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        String jsonString;
        boolean includeChild = (Boolean)this.getModel().getValue(this.getTreeIncludeChildPluginKey());
        TreeView tvLeft = (TreeView)this.getControl(this.getTreePluginKey());
        String checkedNodeId = event.getNodeId().toString();
        TreeNode currentNode = this.getCurrentNode(checkedNodeId, jsonString = this.getView().getPageCache().getBigObject("org_nodeList"));
        if (currentNode == null) {
            return;
        }
        boolean isChecked = event.getChecked();
        if (isChecked) {
            if (includeChild) {
                List<TreeNode> checkNodes = this.getCheckNodes(currentNode.getChildren());
                if (!CollectionUtils.isEmpty(checkNodes)) {
                    tvLeft.checkNodes(checkNodes);
                }
            } else {
                tvLeft.checkNode(currentNode);
            }
        } else if (includeChild) {
            List<TreeNode> checkNodes = this.getCheckNodes(currentNode.getChildren());
            if (!CollectionUtils.isEmpty(checkNodes)) {
                List idList = checkNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
                tvLeft.uncheckNodes(idList);
            }
        } else {
            tvLeft.uncheckNode(checkedNodeId);
        }
    }

    private List<TreeNode> getCheckNodes(List<TreeNode> children) {
        if (CollectionUtils.isEmpty(children)) {
            return new ArrayList<TreeNode>(0);
        }
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(10);
        checkNodes.addAll(children);
        for (TreeNode child : children) {
            checkNodes.addAll(this.getCheckNodes(child.getChildren()));
        }
        return checkNodes;
    }

    private TreeNode getCurrentNode(String checkedNodeId, String jsonString) {
        TreeNode treeNode;
        List rootList = SerializationUtils.fromJsonStringToList((String)jsonString, TreeNode.class);
        TreeNode currentNode = null;
        Iterator iterator = rootList.iterator();
        while (iterator.hasNext() && (currentNode = (treeNode = (TreeNode)iterator.next()).getTreeNode(checkedNodeId, 100)) == null) {
        }
        return currentNode;
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }
}

