/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;

public class OrgChangeFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(OrgChangeFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("oriorg", this.getView().getFormShowParameter().getCustomParam("createOrg"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
        OrgEdit orgEdit = (OrgEdit)this.getControl("targetorg");
        if (orgEdit != null) {
            orgEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    evt.getFormShowParameter().setCustomParam("isAddUserPermOrgFilter", (Object)true);
                    evt.getFormShowParameter().setCustomParam("islockfunc", (Object)true);
                    evt.getFormShowParameter().setCustomParam("orgFuncId", (Object)"15");
                }
            });
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("save".equals(control.getKey())) {
            Object newOrg = this.getModel().getValue("targetorg");
            if (newOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u76ee\u6807\u521b\u5efa\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgChangeFormPlugin_2", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            String oldOrg = this.getView().getFormShowParameter().getCustomParam("createOrg").toString();
            if (oldOrg.equals(((DynamicObject)newOrg).getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u76ee\u6807\u521b\u5efa\u7ec4\u7ec7\u201d\u4e0d\u80fd\u548c\u201c\u539f\u521b\u5efa\u7ec4\u7ec7\u201d\u4e00\u81f4\u3002", (String)"OrgChangeFormPlugin_3", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
            Tuple<Boolean, String> result = this.changeCreateOrg(ids, Long.parseLong(((DynamicObject)newOrg).getPkValue().toString()), Long.parseLong(oldOrg));
            if (((Boolean)result.item1).booleanValue()) {
                this.getView().returnDataToParent((Object)Boolean.TRUE);
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                parentView.showSuccessNotification((String)result.item2);
                this.getView().sendFormAction(parentView);
                this.getView().close();
            } else {
                this.getView().showTipNotification((String)result.item2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Tuple<Boolean, String> changeCreateOrg(List<Long> ids, Long newOrgId, Long oldOrgId) {
        try (TXHandle h = TX.requiresNew();){
            PrintTemplateDataService.batchUpdateCreateOrg(ids, newOrgId);
            PrintTemplateDataService.removeUsage(ids, oldOrgId, "0");
            HashSet<Long> orgs = new HashSet<Long>(1);
            orgs.add(newOrgId);
            PrintTemplateDataService.batchAllocate(ids, orgs, "0");
            this.addLog(oldOrgId, newOrgId);
            Tuple tuple = new Tuple((Object)true, (Object)ResManager.loadKDString((String)"\u53d8\u66f4\u521b\u5efa\u7ec4\u7ec7\u6210\u529f\u3002", (String)"OrgChangeFormPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]));
            return tuple;
        }
        catch (Exception e) {
            logger.error("\u53d8\u66f4\u521b\u5efa\u7ec4\u7ec7\u5931\u8d25", (Throwable)e);
            return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u53d8\u66f4\u521b\u5efa\u7ec4\u7ec7\u5931\u8d25\u3002", (String)"OrgChangeFormPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
        }
    }

    private void addLog(Long oldOrgId, Long newOrgId) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        BillList billList = (BillList)parentView.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            String number = selectedRow.getNumber();
            PrintOpLogUtils.addLog((IFormView)parentView, (String)(number + "-" + oldOrgId + "-->" + newOrgId), (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_CHANGE_ORG);
        }
    }
}

