/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;

public class StrategyChangeFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(StrategyChangeFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("oribdctrl", this.getView().getFormShowParameter().getCustomParam("ctrlStrategy"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("save".equals(control.getKey())) {
            Object newCtrlStrategy = this.getModel().getValue("targetbdctrl");
            if (newCtrlStrategy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u65b0\u63a7\u5236\u7b56\u7565\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StrategyChangeFormPlugin_2", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            String oldCtrlStrategy = this.getView().getFormShowParameter().getCustomParam("ctrlStrategy").toString();
            if (oldCtrlStrategy.equals(newCtrlStrategy.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u65b0\u63a7\u5236\u7b56\u7565\u201d\u4e0d\u80fd\u548c\u201c\u539f\u63a7\u5236\u7b56\u7565\u201d\u4e00\u81f4\u3002", (String)"StrategyChangeFormPlugin_3", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
            Tuple<Boolean, String> result = this.changeStrategy(ids, newCtrlStrategy.toString());
            if (((Boolean)result.item1).booleanValue()) {
                this.getView().returnDataToParent((Object)Boolean.TRUE);
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                parentView.showSuccessNotification((String)result.item2);
                this.addLog(oldCtrlStrategy, String.valueOf(newCtrlStrategy));
                this.getView().sendFormAction(parentView);
                this.getView().close();
            } else {
                this.getView().showTipNotification((String)result.item2);
            }
        }
    }

    private Tuple<Boolean, String> changeStrategy(List<Long> dataIds, String newStrategy) {
        try {
            PrintTemplateDataService.batchUpdateCtrlStrategy(dataIds, newStrategy);
            return new Tuple((Object)true, (Object)ResManager.loadKDString((String)"\u53d8\u66f4\u7ba1\u63a7\u7b56\u7565\u6210\u529f\u3002", (String)"StrategyChangeFormPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("\u53d8\u66f4\u7ba1\u63a7\u7b56\u7565\u5931\u8d25", (Throwable)e);
            return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u53d8\u66f4\u7ba1\u63a7\u7b56\u7565\u5931\u8d25\u3002", (String)"StrategyChangeFormPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
        }
    }

    private void addLog(String oldCtrlStrategy, String newCtrlStrategy) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        BillList billList = (BillList)parentView.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            String number = selectedRow.getNumber();
            PrintOpLogUtils.addLog((IFormView)parentView, (String)number, (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_CHANGE_STRATEGY);
        }
    }
}

