/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;

public class TemplateAllocateFormPlugin
extends AbstractListPlugin
implements SearchEnterListener,
CreateListDataProviderListener {
    private static Log logger = LogFactory.getLog(TemplateAllocateFormPlugin.class);
    private static final String TREE_VIEW = "treeviewap";
    private static final String BILL_LIST = "billlistap";
    private static final String INTEL_FLAG_KEY = "bos-noteprint";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btn_assign", "btn_assign_query"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        BillList billList = (BillList)this.getControl(BILL_LIST);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        billList.setBillFormId(entityNumber);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs evt) {
        evt.setListDataProvider((IListDataProvider)new InnerListDataProvider());
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        List searchFields = searchEnterEvent.getSearchFields();
        BillList billList = (BillList)this.getControl(BILL_LIST);
        if (searchFields == null) {
            this.getPageCache().remove("search");
        } else {
            this.getPageCache().put("search", SerializationUtils.toJsonString((Object)searchFields));
        }
        billList.refresh();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btn_assign".equals(control.getKey())) {
            this.allocate();
        }
    }

    private void allocate() {
        BillList billList = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection col = billList.getSelectedRows();
        if (col.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6570\u636e\u3002", (String)"TemplateAllocateFormPlugin_0", (String)INTEL_FLAG_KEY, (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> dataIDs = new ArrayList<Long>();
        for (ListSelectedRow row : col) {
            dataIDs.add(Long.valueOf(String.valueOf(row.getPrimaryKeyValue())));
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        List orgIDs = treeView.getTreeState().getCheckedNodeIds();
        if (orgIDs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"TemplateAllocateFormPlugin_1", (String)INTEL_FLAG_KEY, (Object[])new Object[0]));
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(orgIDs.size());
        for (String orgID : orgIDs) {
            orgIds.add(Long.valueOf(orgID));
        }
        try {
            PrintTemplateDataService.batchAllocate(dataIDs, orgIds);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5206\u914d\u6570\u636e\u5f02\u5e38", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5206\u914d\u5931\u8d25\u3002", (String)"TemplateAllocateFormPlugin_2", (String)INTEL_FLAG_KEY, (Object[])new Object[0]));
            return;
        }
        PrintOpLogUtils.addLog((IFormView)this.getView().getParentView(), (ListSelectedRowCollection)col, (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_ALLOCATE);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5206\u914d\u6210\u529f\u3002", (String)"TemplateAllocateFormPlugin_3", (String)INTEL_FLAG_KEY, (Object[])new Object[0]));
    }

    class InnerListDataProvider
    extends ListDataProvider {
        InnerListDataProvider() {
        }

        public int getRealCount() {
            return super.getRealCount();
        }

        public List<QFilter> getQFilters() {
            List ids = (List)TemplateAllocateFormPlugin.this.getView().getFormShowParameter().getCustomParam("ids");
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(idFilter);
            String searchCondition = TemplateAllocateFormPlugin.this.getPageCache().get("search");
            if (StringUtils.isNotBlank((CharSequence)searchCondition)) {
                List searchFields = SerializationUtils.fromJsonStringToList((String)searchCondition, Map.class);
                for (Map field : searchFields) {
                    List filedList = (List)field.get("fieldName");
                    List text = (List)field.get("value");
                    StringBuilder likeValue = new StringBuilder();
                    likeValue.append(String.join((CharSequence)",", filedList));
                    likeValue.append("#");
                    likeValue.append(String.join((CharSequence)" ", text));
                    QFilter likeFilter = new QFilter("1", "ftlike", (Object)likeValue.toString());
                    qFilters.add(likeFilter);
                }
            }
            return qFilters;
        }
    }
}

