/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.lang.reflect.Field;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.form.AbstractFormView;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.print.business.designer.plugin.NewPrintTplGuidePlugin;
import kd.bos.template.orgctrl.plugin.TemplateBaseFormPlugin;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;
import kd.bos.template.orgctrl.utils.CtrlStrategy;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class TemplateCopyFormPlugin
extends TemplateBaseFormPlugin {
    private static final Log log = LogFactory.getLog(TemplateCopyFormPlugin.class);
    private static final String CREATE_ORG_KEY = "createorg";
    private static final String SOURCE_TEMPLATE_KEY = "oritpl";
    private static final String NEW_FLAG_KEY = "new";

    public void afterCreateNewData(EventObject e) {
        DynamicObject orgObj;
        String createOrg;
        if (!ParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String newOrgValue = this.getPageCache().get("newOrgValue");
        if (parentView != null) {
            if (StringUtils.isEmpty((CharSequence)newOrgValue)) {
                IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
                createOrg = pageCache.get("createOrg");
            } else {
                createOrg = newOrgValue;
                this.getPageCache().put(NEW_FLAG_KEY, null);
            }
        } else {
            createOrg = this.getModel().getValue(CREATE_ORG_KEY) instanceof DynamicObject ? ((DynamicObject)this.getModel().getValue(CREATE_ORG_KEY)).getPkValue().toString() : Long.toString(RequestContext.getOrCreate().getOrgId());
        }
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            createOrg = Long.toString(RequestContext.getOrCreate().getOrgId());
        }
        long createOrgId = Long.parseLong(createOrg);
        if (this.getPageCache().get(NEW_FLAG_KEY) == null) {
            this.getPageCache().put(NEW_FLAG_KEY, "true");
            this.getModel().setValue(CREATE_ORG_KEY, (Object)createOrgId);
        }
        if ((orgObj = this.getModel().getDataEntity().getDynamicObject(CREATE_ORG_KEY)) != null && !NewPrintTplGuidePlugin.checkTplPermission((long)orgObj.getLong("id"), (String)"47156aff000000ac")) {
            this.getModel().setValue(CREATE_ORG_KEY, null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{SOURCE_TEMPLATE_KEY});
        if (!ParamUtils.isTemplateOrgIsolated()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CREATE_ORG_KEY, "ctrlstrategy"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        block23: {
            Object formView;
            super.beforeClosed(e);
            if (!ParamUtils.isTemplateOrgIsolated()) {
                return;
            }
            Object strategyValue = this.getModel().getValue("ctrlstrategy");
            Object orgValue = this.getModel().getValue(CREATE_ORG_KEY);
            String ctrlStrategy = CtrlStrategy.GLOBAL.getValue();
            long createOrg = RequestContext.get().getOrgId();
            if (strategyValue != null) {
                ctrlStrategy = strategyValue.toString();
            }
            if (orgValue != null) {
                createOrg = Long.parseLong(((DynamicObject)orgValue).getPkValue().toString());
            }
            if ((formView = e.getSource()) instanceof FormView) {
                try {
                    FormView view = (FormView)formView;
                    Class<?> parent = view.getClass().getSuperclass();
                    if (parent != AbstractFormView.class) break block23;
                    Field field = parent.getDeclaredField("returnToParentData");
                    ReflectionUtils.makeAccessible((Field)field);
                    Map returnParentData = (Map)field.get(view);
                    if (returnParentData == null) break block23;
                    Object formId = returnParentData.get("id");
                    if (StringUtils.isBlank(formId)) {
                        formId = returnParentData.get("bizpageid");
                    }
                    if (StringUtils.isBlank(formId)) {
                        formId = returnParentData.get("tplId");
                    }
                    if (StringUtils.isBlank(formId)) {
                        return;
                    }
                    try (TXHandle h = TX.requiresNew();){
                        PrintTemplateDataService.updateByFormId(formId.toString(), createOrg, ctrlStrategy);
                        PrintTemplateDataService.addAllocateData(formId.toString(), ctrlStrategy, createOrg);
                    }
                    catch (Exception error) {
                        log.error("\u590d\u5236\u6253\u5370\u6a21\u7248\u6570\u636e\u53d1\u751f\u5f02\u5e38\u56de\u6eda", (Throwable)error);
                    }
                }
                catch (Exception err) {
                    log.error("\u590d\u5236\u6253\u5370\u6a21\u7248\u6570\u636e\u53d1\u751f\u5f02\u5e38", (Throwable)err);
                }
            }
        }
    }
}

