/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.lang.reflect.Field;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.form.AbstractFormView;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.business.designer.plugin.NewPrintTplGuidePlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.template.orgctrl.plugin.TemplateBaseFormPlugin;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;
import kd.bos.template.orgctrl.utils.CtrlStrategy;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class TemplateDataFormPlugin
extends TemplateBaseFormPlugin {
    private static final Log log = LogFactory.getLog(TemplateDataFormPlugin.class);
    private static final String CREATE_ORG_KEY = "createorg";
    private static final String NEW_FLAG_KEY = "new";

    public void afterCreateNewData(EventObject e) {
        DynamicObject orgObj;
        Map data;
        long createOrgId;
        String createOrg;
        if (!ParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            String newOrgValue = this.getPageCache().get("newOrgValue");
            if (StringUtils.isEmpty((CharSequence)newOrgValue)) {
                IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
                String useOrg = createOrg = pageCache.get("createOrg");
            } else {
                String useOrg = createOrg = newOrgValue;
                this.getPageCache().put(NEW_FLAG_KEY, null);
            }
        } else if (this.getModel().getValue(CREATE_ORG_KEY) instanceof DynamicObject) {
            String useOrg = createOrg = ((DynamicObject)this.getModel().getValue(CREATE_ORG_KEY)).getPkValue().toString();
        } else {
            String useOrg = createOrg = Long.toString(RequestContext.getOrCreate().getOrgId());
        }
        if (StringUtils.isNotBlank((CharSequence)createOrg)) {
            createOrgId = Long.parseLong(createOrg);
            if (this.getPageCache().get(NEW_FLAG_KEY) == null) {
                this.getPageCache().put(NEW_FLAG_KEY, "true");
                this.getModel().setValue(CREATE_ORG_KEY, (Object)createOrgId);
            }
        } else {
            createOrgId = RequestContext.getOrCreate().getOrgId();
            this.getModel().setValue(CREATE_ORG_KEY, (Object)createOrgId);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String formId = (String)customParams.get("formId");
        String tplId = (String)customParams.get("tplId");
        if (StringUtils.isNotBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)tplId) && (data = BusinessDataServiceHelper.loadFromCache((String)"bas_manageprinttpl", (String)"createorg.id,ctrlstrategy", (QFilter[])new QFilter[]{new QFilter("printtplid.id", "=", (Object)tplId)})) != null && !data.isEmpty() && !CollectionUtils.isEmpty(data.values())) {
            DynamicObject value = (DynamicObject)data.values().iterator().next();
            Object createOrgId2 = value.get("createorg.id");
            String strategy = value.getString("ctrlstrategy");
            if (createOrgId2 instanceof Long) {
                this.getModel().setValue(CREATE_ORG_KEY, createOrgId2);
            }
            if (StringUtils.isNotBlank((CharSequence)strategy)) {
                this.getModel().setValue("ctrlstrategy", (Object)strategy);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{CREATE_ORG_KEY, "ctrlstrategy"});
        }
        if ((orgObj = this.getModel().getDataEntity().getDynamicObject(CREATE_ORG_KEY)) != null && !NewPrintTplGuidePlugin.checkTplPermission((long)orgObj.getLong("id"), (String)"47156aff000000ac")) {
            this.getModel().setValue(CREATE_ORG_KEY, null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CREATE_ORG_KEY, "ctrlstrategy"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        block35: {
            Object formView;
            super.beforeClosed(e);
            if (!ParamUtils.isTemplateOrgIsolated()) {
                return;
            }
            String ctrlStrategy = CtrlStrategy.GLOBAL.getValue();
            Object strategyValue = this.getModel().getValue("ctrlstrategy");
            Object orgValue = this.getModel().getValue(CREATE_ORG_KEY);
            if (strategyValue != null) {
                ctrlStrategy = strategyValue.toString();
            }
            long createOrg = RequestContext.get().getOrgId();
            if (orgValue != null) {
                createOrg = Long.parseLong(((DynamicObject)orgValue).getPkValue().toString());
            }
            if ((formView = e.getSource()) instanceof FormView) {
                try {
                    FormView view = (FormView)formView;
                    Class<?> parent = view.getClass().getSuperclass();
                    if (parent != AbstractFormView.class) break block35;
                    Field field = parent.getDeclaredField("returnToParentData");
                    ReflectionUtils.makeAccessible((Field)field);
                    Map returnParentData = (Map)field.get(view);
                    if (returnParentData != null && returnParentData.get("formid") != null) {
                        String formId = returnParentData.get("formid").toString();
                        try (TXHandle h = TX.requiresNew();){
                            PrintTemplateDataService.updateByFormId(formId, createOrg, ctrlStrategy);
                            PrintTemplateDataService.addAllocateData(formId, ctrlStrategy, createOrg);
                            break block35;
                        }
                        catch (Exception error) {
                            log.error("\u66f4\u65b0\u6253\u5370\u6a21\u7248\u6570\u636e\u53d1\u751f\u5f02\u5e38\u56de\u6eda", (Throwable)error);
                        }
                        break block35;
                    }
                    if (returnParentData == null || returnParentData.get("tplId") == null) break block35;
                    String formId = returnParentData.get("tplId").toString();
                    try (TXHandle h = TX.requiresNew();){
                        PrintTemplateDataService.updateByFormId(formId, createOrg, ctrlStrategy);
                        PrintTemplateDataService.addAllocateData(formId, ctrlStrategy, createOrg);
                    }
                    catch (Exception error) {
                        log.error("\u66f4\u65b0\u6253\u5370\u6a21\u7248\u6570\u636e\u53d1\u751f\u5f02\u5e38\u56de\u6eda", (Throwable)error);
                    }
                }
                catch (Exception err) {
                    log.error("\u66f4\u65b0\u6253\u5370\u6a21\u7248\u6570\u636e\u53d1\u751f\u5f02\u5e38", (Throwable)err);
                }
            }
        }
    }
}

