/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.template.orgctrl.plugin.TemplateBaseFormPlugin;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;
import kd.bos.template.orgctrl.utils.CtrlStrategy;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class TemplateDataLayoutFormPlugin
extends TemplateBaseFormPlugin {
    private static final Log log = LogFactory.getLog(TemplateDataLayoutFormPlugin.class);
    private static final String CREATE_ORG_KEY = "createorg";

    public void afterCreateNewData(EventObject e) {
        if (!ParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        this.getModel().setValue(CREATE_ORG_KEY, (Object)RequestContext.get().getOrgId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CREATE_ORG_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ctrlstrategy"});
            return;
        }
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        if (configInfo != null) {
            Object modelType = configInfo.get("modeltype");
            if (!"PrintModel".equals(modelType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CREATE_ORG_KEY});
                this.getView().setVisible(Boolean.FALSE, new String[]{"ctrlstrategy"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CREATE_ORG_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ctrlstrategy"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        Object strategyValue = this.getModel().getValue("ctrlstrategy");
        Object orgValue = this.getModel().getValue(CREATE_ORG_KEY);
        String ctrlStrategy = CtrlStrategy.GLOBAL.getValue();
        long createOrg = RequestContext.get().getOrgId();
        if (strategyValue != null) {
            ctrlStrategy = strategyValue.toString();
        }
        if (orgValue != null) {
            createOrg = Long.parseLong(((DynamicObject)orgValue).getPkValue().toString());
        }
        String number = this.getModel().getValue("number").toString();
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("modeltype", "=", (Object)"PrintModel")};
        DynamicObject meta = OldPrintTemplateUtil.queryOne((String)"id", (QFilter[])qFilters);
        if (meta != null) {
            String id = meta.getString("id");
            try (TXHandle h = TX.requiresNew();){
                PrintTemplateDataService.updateByFormId(id, createOrg, ctrlStrategy);
                PrintTemplateDataService.addAllocateData(id, ctrlStrategy, createOrg);
            }
            catch (Exception error) {
                log.error("\u5f00\u53d1\u5e73\u53f0\u66f4\u65b0\u6253\u5370\u6a21\u7248\u6570\u636e\u53d1\u751f\u5f02\u5e38\u56de\u6eda", (Throwable)error);
            }
        }
    }
}

